# Swift Mobile GraphQL Schema

This Framework contains autogenerated code that is generated from running Apollo iOS graphQL codegen. This code is not checked in, but the generated files are referenced for the Xcode build process.

## Generating the Swift GraphQL Schema

They run automatically as part of WidgetsCore build phases.

If you encounter build errors after updating the GraphQL schema:

1. **Missing file references**: If Xcode complains about missing files, run `yarn mobile ios:prebuild` again to ensure all files are properly added to the project.

2. **Script failures**: If the automatic file addition fails, you may see a warning. In this case, try running the script manually:

   ```
   cd apps/mobile && ruby ./scripts/update_apollo_files_in_xcode.rb
   ```

3. **Manual file addition**: If the script consistently fails, you can add files manually (see the "Adding Generated Files Manually" section below).

4. **Clean build**: Sometimes a clean build helps resolve reference issues:

   ```
   cd apps/mobile/ios && xcodebuild clean
   ```

5. **Check for schema errors**: Ensure there are no errors in your GraphQL schema or queries.

## Adding Generated Files Manually

If you need to manually add new GraphQL queries or fragments to Swift:

1. Ensure the file is listed in `apps/mobile/ios/apollo-codegen-config.json`'s `"operationSearchPaths"` and `"schemaSearchPaths"`
2. Add the needed generated files to the XCode project. To add new files:
   1. Right-click the `WidgetsCore` folder in XCode
   2. Select `add files to "Uniswap"...`
   3. Select the `MobileSchema` folder
   4. Keep `Action: Reference files in place` selected
   5. Keep `Groups: Create Groups` selected
   6. Keep `WidgetsCore` checked
   7. Click Finish

## Implementation Details

The automation for adding generated files to Xcode uses a Ruby script (`scripts/update_apollo_files_in_xcode.rb`) that:

1. Removes any existing MobileSchema group from the Xcode project
2. Creates a new MobileSchema group with the proper structure
3. Scans the MobileSchema directory for Swift files
4. Adds files to the appropriate groups in the Xcode project
5. Updates the build phases to include the new files

### Requirements

The script requires the `xcodeproj` Ruby gem:

```
gem install xcodeproj
```

Note: This should already have been installed via the `mobile` app's setup instructions.

### Debugging

If the script fails, you can run it with debugging output:

```
DEBUG=1 ruby ./scripts/update_apollo_files_in_xcode.rb
```
