import clsx from 'clsx'
import React from 'react'

import { themeVars, vars } from '../css/sprinkles.css'
import * as styles from './icons.css'

type SVGProps = React.SVGProps<SVGSVGElement>

export const LogoIcon = (props: SVGProps) => (
  <svg
    role="img"
    width="151"
    height="43"
    viewBox="0 0 151 43"
    xmlns="http://www.w3.org/2000/svg"
    fill={themeVars.colors.blackBlue}
    color={themeVars.colors.blackBlue}
    {...props}
  >
    <path
      d="M21.9903 5.90848C22.1529 6.87834 22.3704 7.83294 22.6186 8.78971C22.6471 8.90522 22.6779 9.02073 22.7065 9.13625C22.8668 9.72906 23.0425 10.3371 23.2315 10.9321C23.254 11.0073 23.2834 11.0802 23.3193 11.1501C23.4072 11.371 23.5247 11.5792 23.6686 11.769C23.684 11.7843 23.684 11.7974 23.6994 11.7974C23.9224 12.087 24.1936 12.3368 24.5011 12.5362H24.5165L24.5605 12.5645L24.589 12.5798L26.2827 13.5496L26.2958 13.5649L26.3398 13.5932L26.3551 13.6085L26.4123 13.6368L26.4276 13.6521L26.4716 13.6651C26.5091 13.6841 26.5451 13.706 26.5792 13.7305L26.6671 13.7741C26.711 13.7872 26.7396 13.8024 26.7835 13.8177C26.8165 13.8316 26.8512 13.8411 26.8867 13.846L26.9878 13.8744L27.1042 13.9049L27.2206 13.9332L27.2646 13.9485C27.6281 14.0157 28.0014 14.0105 28.3629 13.9332V13.9332C28.989 13.8024 29.6172 13.6433 30.2301 13.4842C30.3485 13.4571 30.4651 13.4229 30.5794 13.3818C32.1366 12.9535 33.663 12.422 35.1485 11.7908C35.4846 11.6448 35.8338 11.5009 36.1699 11.3418C37.075 10.9205 37.9536 10.4715 38.8059 9.99495C38.1351 8.93687 37.3729 7.93856 36.528 7.01128L36.5148 6.99821L36.4994 6.98295V6.97423L36.4841 6.96116L36.4555 6.91757L36.4401 6.90231C36.3523 6.81513 36.2666 6.72796 36.1787 6.65603C35.8375 6.3686 35.4325 6.16545 34.9969 6.06322C34.561 5.95691 34.1062 5.95169 33.6679 6.04797H33.6393L33.4636 6.09156L33.4351 6.10681C33.3911 6.11989 33.3318 6.13515 33.2879 6.1504L33.0265 6.26591L32.9232 6.3095C32.0446 6.68655 31.1659 7.01782 30.2543 7.30769C29.6699 7.4973 29.0702 7.66948 28.4727 7.82858C28.297 7.23577 28.1506 6.64223 28.0334 6.04797V6.01964C28.018 5.97605 28.018 5.93246 28.0049 5.88887C27.8291 5.01709 27.6819 4.14531 27.5809 3.25392C27.5655 3.12315 27.5523 2.99456 27.537 2.86379C27.4983 2.60358 27.4198 2.35075 27.3041 2.11406C27.1131 1.7109 26.8339 1.35502 26.4869 1.07229C26.1418 0.793638 25.7379 0.595513 25.3051 0.492555V0.492555C25.114 0.448966 24.9251 0.405377 24.7494 0.377045C23.6621 0.164709 22.5596 0.0386288 21.4521 0V0C21.4653 1.23139 21.54 2.4606 21.6718 3.69199C21.7729 4.44607 21.8739 5.16965 21.9903 5.90848Z"
      fill="#4673FA"
    />
    <path
      d="M19.8465 0.0146484C18.5497 0.0620033 17.26 0.226874 15.9935 0.507204C15.43 0.636401 14.9175 0.927919 14.5204 1.34515C14.1233 1.76237 13.8594 2.2867 13.7617 2.85229C13.7463 2.95254 13.7463 3.03972 13.7309 3.14216C13.7309 3.18575 13.7177 3.22933 13.7177 3.25767C13.7024 3.38843 13.687 3.51702 13.6738 3.64779C13.5706 4.40188 13.4541 5.15379 13.2938 5.89262C13.2767 5.94403 13.2671 5.99761 13.2652 6.05172C13.1334 6.64453 12.9884 7.25259 12.8259 7.84758C12.2284 7.68848 11.6309 7.51413 11.0466 7.3267L10.9301 7.28311C10.3173 7.08042 9.7044 6.86247 9.1047 6.6162L9.03221 6.58786C8.94254 6.55526 8.85521 6.51667 8.77081 6.47235C8.639 6.41351 8.5072 6.36992 8.3754 6.31325C8.25612 6.26581 8.13953 6.21197 8.02613 6.15197C7.99379 6.13625 7.95877 6.12664 7.92289 6.12364L7.8504 6.10185C7.80836 6.08519 7.76381 6.07561 7.71859 6.07351L7.66148 6.05826C7.60217 6.043 7.55824 6.043 7.50112 6.02993H7.46817C7.05883 5.97291 6.64214 5.99736 6.24242 6.10185C5.84202 6.21543 5.46858 6.40736 5.14408 6.66632C5.05265 6.7438 4.96539 6.82601 4.88268 6.9126L4.8673 6.92786L4.85192 6.94093L4.83215 6.97363L4.8036 7.01722C3.95843 7.94094 3.19553 8.93558 2.52344 9.98998C3.38454 10.4666 4.26321 10.9155 5.15946 11.3369C5.49555 11.496 5.83164 11.6398 6.18092 11.7858C7.66203 12.4146 9.18322 12.9461 10.7346 13.3768C10.8528 13.405 10.9694 13.4391 11.0839 13.4793L11.2443 13.5229C11.8132 13.6667 12.3844 13.8127 12.9533 13.9282C13.3156 13.9981 13.6875 14.0032 14.0516 13.9435C14.0802 13.9435 14.1087 13.9282 14.1395 13.9282L14.212 13.913L14.357 13.8694L14.4448 13.8411L14.5613 13.7975L14.6799 13.7539L14.7656 13.7103C14.8095 13.6972 14.8534 13.6667 14.8974 13.6536L14.9259 13.6384L14.9413 13.6231L14.9852 13.5948H15.0006L15.0731 13.5512L16.7228 12.6097L16.8524 12.5378H16.8678C17.1835 12.3433 17.4605 12.0928 17.6849 11.7989V11.7989C17.888 11.5579 18.0377 11.2772 18.1243 10.9751C18.1682 10.8443 18.199 10.7288 18.2429 10.598C18.3879 10.1055 18.5329 9.61294 18.6647 9.13564C18.6932 9.02013 18.724 8.90462 18.7525 8.78693C19.0008 7.83233 19.2051 6.86247 19.3808 5.9057C19.5104 5.18212 19.6136 4.44547 19.6861 3.72625C19.774 2.49704 19.8465 1.26565 19.8619 0.0211868L19.8465 0.0146484Z"
      fill="#4673FA"
    />
    <path
      d="M6.46484 28.0166C7.23807 27.3802 8.00251 26.698 8.72742 25.9897C8.81529 25.9025 8.90096 25.8306 8.98883 25.7434C9.14918 25.5843 9.30954 25.4252 9.45672 25.2661C9.52921 25.1789 9.61708 25.107 9.68957 25.0198L10.2453 24.4248C10.7266 23.8997 11.0051 23.2227 11.0317 22.5135V22.3108C11.0334 22.248 11.029 22.1853 11.0186 22.1233H11.0317V20.6457H11.0186C11.0186 20.589 11.0317 20.5171 11.0317 20.4582V20.2556C11.0089 19.582 10.7511 18.9373 10.3024 18.4314C10.2739 18.403 10.2585 18.3725 10.23 18.3442L10.1706 18.2875C9.98173 18.0848 9.80599 17.8821 9.61708 17.6925L9.58852 17.6642C9.38423 17.4463 9.17994 17.2436 8.97565 17.0409C8.88778 16.9537 8.79991 16.8687 8.71204 16.7946C7.98274 16.0863 7.23807 15.4063 6.44946 14.7677C6.01012 14.4059 5.5598 14.0441 5.09411 13.6976C4.20225 13.0307 3.26866 12.3899 2.3197 11.8146C2.10003 11.6707 1.86718 11.5399 1.64971 11.4092C1.57463 11.5407 1.50644 11.676 1.44542 11.8146C0.963123 12.7672 0.553395 13.7544 0.219668 14.7677H0.232848C0.107317 15.1022 0.0382915 15.4549 0.0285569 15.8117V15.9097C0.0425832 16.6655 0.351218 17.3865 0.889657 17.9214L0.93359 17.965C0.976228 18.0003 1.01523 18.0397 1.05001 18.0827C1.10932 18.1241 1.18182 18.1829 1.24113 18.2265C1.30044 18.2701 1.32899 18.2984 1.37073 18.3267C1.94187 18.7474 2.49543 19.1985 3.03582 19.6606C3.21155 19.8197 3.40046 19.9788 3.5762 20.1379L3.7058 20.2534C3.80905 20.3558 3.9101 20.4408 4.01334 20.5432L4.15832 20.674C4.40655 20.9203 4.67015 21.1666 4.91837 21.4128C4.67015 21.6569 4.42192 21.9032 4.15832 22.1495C3.96941 22.3391 3.76511 22.5113 3.5762 22.6856C2.86008 23.322 2.13078 23.917 1.37952 24.4815L1.20598 24.6123C1.15591 24.6552 1.10226 24.6938 1.04562 24.7278C0.726177 24.9906 0.47147 25.3223 0.300946 25.6976C0.122208 26.0706 0.0199144 26.4751 0 26.8876L0 26.9879C0.00130044 27.3498 0.0705809 27.7082 0.204291 28.0449H0.188915C0.52453 29.0576 0.934201 30.0446 1.41466 30.9981C1.48935 31.1288 1.54646 31.2748 1.61896 31.4034C1.83862 31.2748 2.07147 31.1288 2.29114 30.9981C3.24011 30.4205 4.15832 29.7819 5.06335 29.1172C5.57518 28.7402 6.01232 28.3936 6.46484 28.0166Z"
      fill="#4673FA"
    />
    <path
      d="M41.2553 26.9166V26.8882C41.24 26.1321 40.9316 25.4108 40.3942 24.8744L40.3503 24.8308C40.3063 24.7872 40.2624 24.7589 40.2185 24.7153L40.0295 24.5715L39.8977 24.469C39.3288 24.0506 38.773 23.5973 38.2327 23.1374C38.0591 22.9783 37.868 22.8192 37.6945 22.6601L37.5627 22.5446C37.4594 22.4422 37.3584 22.355 37.2551 22.2547L37.1102 22.124C36.8619 21.8777 36.5983 21.6314 36.3501 21.3851C36.5983 21.1388 36.8466 20.8926 37.1102 20.6463C37.2991 20.4589 37.5034 20.2845 37.6945 20.1123C38.4084 19.4737 39.1377 18.8809 39.8912 18.3165L40.0669 18.1857C40.1162 18.1418 40.1699 18.1031 40.2272 18.0702C40.5462 17.8074 40.8002 17.4756 40.9697 17.1003C41.1487 16.7275 41.2503 16.3229 41.2685 15.9103V15.8101C41.2643 15.4504 41.1997 15.0939 41.0774 14.7552H41.0927C40.7567 13.742 40.3471 12.7543 39.867 11.7999C39.7923 11.6713 39.7352 11.5253 39.6627 11.3945C39.443 11.5253 39.2102 11.6713 38.9905 11.7999C38.0415 12.3796 37.1233 13.016 36.2183 13.683C35.7658 14.0295 35.3133 14.3782 34.8608 14.7552C34.0875 15.3916 33.3231 16.0629 32.5982 16.7821C32.5103 16.8693 32.4224 16.9412 32.3368 17.0284C32.1764 17.1875 32.0138 17.3597 31.8535 17.5188C31.781 17.5929 31.7085 17.6648 31.6338 17.752L31.0649 18.36C30.5841 18.8844 30.3063 19.5609 30.2807 20.2692V20.4719C30.2787 20.5348 30.2839 20.5977 30.296 20.6594H30.2807V22.137H30.296C30.296 22.1937 30.2807 22.2656 30.2807 22.3245V22.5272C30.3031 23.2007 30.561 23.8456 31.01 24.3513C31.0385 24.3797 31.0539 24.4102 31.0825 24.4385L31.1418 24.4974C31.3307 24.7001 31.5064 24.9027 31.6953 25.0902L31.7261 25.1185C31.9304 25.3365 32.1347 25.5391 32.339 25.7418C32.4217 25.8284 32.5089 25.9106 32.6004 25.9881C33.3297 26.6964 34.0743 27.3786 34.8629 28.015C35.3023 28.3768 35.7416 28.7386 36.2205 29.0851C37.1102 29.752 38.0437 30.3928 38.9927 30.9682C39.2124 31.1142 39.4452 31.2428 39.6649 31.3735C39.7374 31.2428 39.8099 31.0989 39.8692 30.9682C40.3497 30.0147 40.7593 29.0277 41.0949 28.015H41.0774C41.2038 27.6815 41.2728 27.3294 41.2817 26.9732C41.2723 26.9672 41.2649 26.9587 41.2603 26.9486C41.2556 26.9386 41.2539 26.9275 41.2553 26.9166V26.9166Z"
      fill="#4673FA"
    />
    <path
      d="M19.3066 36.8782C19.1462 35.9062 18.9265 34.9516 18.6783 33.997L18.5927 33.6483C18.4301 33.0555 18.2566 32.4474 18.0655 31.8524C18.0428 31.7776 18.0141 31.7048 17.9798 31.6345C17.8923 31.4115 17.774 31.2017 17.6283 31.0112C17.6129 30.9959 17.6129 30.9828 17.5998 30.9828C17.3759 30.6931 17.104 30.4433 16.7958 30.244H16.7826L16.7387 30.2157L16.7101 30.2004L15.0165 29.2305L15.0011 29.2153L14.9571 29.187L14.944 29.1717L14.8847 29.1434L14.8693 29.1281L14.8275 29.115C14.7836 29.0998 14.7397 29.0714 14.6957 29.0562L14.6079 29.0126C14.5639 28.9995 14.5354 28.9843 14.4914 28.969L14.3882 28.9407L14.2872 28.9123L14.1707 28.8818L14.0587 28.8557L14.017 28.8426C13.6537 28.7736 13.2801 28.778 12.9186 28.8557C12.2926 28.9864 11.6643 29.1456 11.0514 29.3047C10.9324 29.332 10.815 29.3662 10.7 29.4071C9.14359 29.8357 7.61787 30.3672 6.13306 30.9981C5.79697 31.1441 5.4477 31.2879 5.11161 31.447C4.20657 31.8684 3.3279 32.3174 2.47559 32.7939C3.14591 33.8524 3.90813 34.8507 4.75355 35.7776L4.76673 35.7907L4.7821 35.8059V35.8212L4.79748 35.8343L4.82604 35.8779L4.84141 35.8931C4.92413 35.9797 5.01138 36.0619 5.10282 36.1394C5.44404 36.4268 5.84904 36.63 6.28464 36.7322C6.72057 36.8385 7.17533 36.8437 7.61363 36.7475H7.62681L7.80254 36.7039L7.8311 36.6886C7.87503 36.6755 7.93434 36.6603 7.97828 36.645L8.23968 36.5295L8.34293 36.4859C9.2216 36.1111 10.112 35.7783 11.0141 35.4877C11.5962 35.2981 12.1959 35.126 12.7934 34.9669C12.9538 35.5597 13.1009 36.1677 13.2327 36.7605V36.7911C13.2481 36.8346 13.2481 36.8782 13.2635 36.9218C13.437 37.8045 13.5842 38.6654 13.6853 39.5568C13.7006 39.6854 13.716 39.8161 13.7292 39.9469C13.769 40.2036 13.8483 40.4528 13.9642 40.6857C14.1527 41.088 14.4304 41.4429 14.7765 41.7237C15.1227 42.0045 15.5284 42.204 15.9632 42.3072V42.3072C16.1521 42.3508 16.3433 42.3944 16.5168 42.4227C17.6045 42.6274 18.7057 42.7534 19.8118 42.7998V42.7998C19.7972 41.5677 19.7239 40.337 19.5921 39.1078C19.5365 38.3602 19.4411 37.6159 19.3066 36.8782Z"
      fill="#4673FA"
    />
    <path
      d="M35.1839 30.9702C33.7024 30.3417 32.1813 29.8095 30.6301 29.377C30.5118 29.3507 30.3951 29.3172 30.2809 29.2768L30.1205 29.2332C29.5516 29.0872 28.9826 28.9433 28.4137 28.8278C28.0514 28.7582 27.6795 28.7531 27.3153 28.8125C27.2868 28.8125 27.2582 28.8278 27.2275 28.8278L27.155 28.8431L27.01 28.8845L26.9221 28.915L26.8057 28.9586C26.7618 28.9716 26.7332 28.9869 26.6893 29.0022L26.6014 29.0457C26.5575 29.0588 26.5135 29.0871 26.4696 29.1024L26.4411 29.1177L26.4257 29.1307L26.3817 29.1613H26.3598L26.2873 29.2048L24.6398 30.1594L24.508 30.2466H24.4926C24.1734 30.4366 23.8956 30.6877 23.6754 30.9854C23.6601 30.9985 23.6601 31.0138 23.6469 31.0138C23.4582 31.2696 23.31 31.5526 23.2075 31.8529V31.8529C23.179 31.9553 23.135 32.0708 23.1065 32.1732C22.9615 32.6636 22.8143 33.1431 22.6825 33.6335C22.654 33.7512 22.6254 33.8667 22.5947 33.9822C22.3486 34.9368 22.1443 35.9066 21.9686 36.8634C21.8368 37.587 21.7336 38.3258 21.6611 39.0429C21.5293 40.2735 21.4561 41.5042 21.4414 42.7348C22.7374 42.6864 24.0262 42.5216 25.2922 42.2423V42.2423C25.8557 42.1127 26.3682 41.8211 26.7656 41.404C27.163 40.9868 27.4275 40.4627 27.5262 39.8972C27.5416 39.797 27.5416 39.7098 27.5548 39.6073C27.5548 39.5638 27.5702 39.5202 27.5702 39.4918C27.5833 39.3611 27.5987 39.2303 27.6141 39.1017C27.7151 38.3476 27.8338 37.5957 27.9919 36.8569C28.0093 36.8055 28.0197 36.7519 28.0227 36.6978C28.1545 36.1028 28.2995 35.4947 28.462 34.9019C29.0595 35.061 29.6592 35.2354 30.2435 35.4228L30.3599 35.4664C30.9728 35.6691 31.5857 35.887 32.1832 36.1333L32.2557 36.1616L32.5193 36.2771C32.6511 36.336 32.7807 36.3796 32.9125 36.4362C33.0443 36.4929 33.1475 36.5387 33.264 36.5953C33.2951 36.6124 33.3295 36.6228 33.365 36.6259L33.4375 36.6542C33.4795 36.6709 33.5241 36.6804 33.5693 36.6825L33.6286 36.6978C33.6857 36.713 33.7297 36.713 33.789 36.7261H33.8285C34.2385 36.7879 34.6571 36.7631 35.0568 36.6535C35.4565 36.5438 35.8284 36.3517 36.1482 36.0897C36.2361 36.0178 36.3239 35.9306 36.4118 35.8434L36.4272 35.8282L36.4404 35.8151L36.4711 35.7846L36.4997 35.741C37.3406 34.8172 38.1019 33.825 38.7754 32.7748C37.9143 32.2953 37.0357 31.8463 36.1394 31.4279C35.8292 31.2588 35.5102 31.106 35.1839 30.9702V30.9702Z"
      fill="#4673FA"
    />
    <path
      d="M89.511 23.9735H94.9192C94.815 25.3018 94.3605 26.5796 93.6012 27.6785C92.8675 28.729 91.7933 29.5485 90.3743 30.1217C88.9552 30.6949 87.1671 30.9477 84.9924 30.9477C82.6859 30.9477 80.6913 30.6535 79.0086 30.065C77.4232 29.5391 76.0657 28.4929 75.16 27.0988C74.2572 25.7061 73.8047 23.8296 73.8047 21.4693C73.8047 19.1089 74.244 17.2651 75.1227 15.8746C76.0118 14.4705 77.3546 13.4071 78.9317 12.8583C80.599 12.2567 82.609 11.9473 84.977 11.9473C87.2989 11.9473 89.199 12.272 90.6884 12.9367C92.1416 13.5713 93.3072 14.7161 93.9615 16.1514C94.6622 17.6204 95.0049 19.9088 94.9741 22.4282H79.3996C79.4765 23.0625 79.7028 23.4526 80.0455 23.9931C80.4622 24.5881 81.036 25.0579 81.704 25.3509C82.4684 25.6604 83.4811 25.8303 84.7442 25.8303C86.0512 25.8303 87.1276 25.6909 87.9689 25.3945C88.8102 25.0981 89.3396 24.5052 89.511 23.9735ZM84.7508 17.0995C83.1296 17.0995 81.8951 17.3785 81.0406 17.9342C80.186 18.49 79.7006 19.5274 79.5446 20.0831H89.6274C89.5176 19.4489 89.098 18.4137 88.3489 17.9037C87.5999 17.3937 86.3961 17.0995 84.7508 17.0995Z"
      fill="currentColor"
    />
    <path
      d="M120.854 12.4836C120.854 12.4836 121.974 12.4466 123.861 12.5555C125.748 12.6645 126.354 13.5973 126.354 15.1534V30.4096H120.862V12.4836H120.854Z"
      fill="currentColor"
    />
    <path
      d="M144.538 23.9735H149.947C149.842 25.3018 149.388 26.5796 148.629 27.6785C147.895 28.729 146.821 29.5485 145.402 30.1217C143.983 30.6949 142.201 30.9477 140.02 30.9477C137.713 30.9477 135.719 30.6535 134.036 30.065C132.45 29.5397 131.093 28.4934 130.187 27.0988C129.285 25.7061 128.832 23.8296 128.832 21.4693C128.832 19.1089 129.271 17.2651 130.15 15.8746C131.039 14.4709 132.381 13.4076 133.957 12.8583C135.624 12.2567 137.634 11.9473 140.002 11.9473C142.324 11.9473 144.224 12.272 145.714 12.9367C147.167 13.5713 148.332 14.7161 148.987 16.1514C149.687 17.6204 150.03 19.9088 149.999 22.4282H134.427C134.504 23.0625 134.73 23.4526 135.073 23.9931C135.49 24.5881 136.063 25.0579 136.731 25.3509C137.496 25.6604 138.508 25.8303 139.772 25.8303C141.079 25.8303 142.155 25.6909 142.996 25.3945C143.838 25.0981 144.367 24.5052 144.538 23.9735ZM139.772 17.0929C138.15 17.0929 136.916 17.3719 136.061 17.9277C135.207 18.4834 134.721 19.5208 134.565 20.0766H144.648C144.538 19.4424 144.119 18.4072 143.37 17.8972C142.621 17.3872 141.426 17.0995 139.772 17.0995V17.0929Z"
      fill="currentColor"
    />
    <path
      d="M72.788 11.9375H61.7364C59.4695 11.9375 57.6169 12.2862 56.1788 12.9836C54.7554 13.6963 53.701 14.664 53.031 15.915C52.361 17.166 52.0205 18.5783 52.0205 20.2695C52.0205 22.0763 52.372 23.5649 53.0595 24.7701C53.7471 25.9753 54.8169 26.8297 56.2535 27.4312C57.6901 28.0327 59.5288 28.2877 61.7452 28.2877C64.0122 28.2877 65.8486 28.0196 67.2875 27.4639C68.7263 26.9081 69.7477 26.069 70.4024 24.9924C71.0614 23.8831 71.4084 22.5667 71.4084 21.0127C71.4371 20.1505 71.2749 19.2925 70.9333 18.4991C70.5918 17.7057 70.0791 16.9963 69.4314 16.4206H70.5693C71.8544 16.4206 72.6254 15.939 72.7155 14.3937C72.8055 12.8485 72.788 11.9375 72.788 11.9375ZM65.6399 21.891C65.3021 22.389 64.816 22.77 64.2495 22.9808C63.4511 23.264 62.6057 23.3935 61.7584 23.3622C60.704 23.3622 59.8561 23.2358 59.2344 22.9808C58.6725 22.7547 58.1856 22.3772 57.8285 21.891C57.554 21.4361 57.4104 20.9153 57.4134 20.385C57.391 19.8142 57.5442 19.2502 57.8527 18.7679C58.1996 18.282 58.6913 17.9161 59.2586 17.7218C60.8922 17.2162 62.6422 17.2162 64.2758 17.7218C64.8273 17.9213 65.302 18.2871 65.6334 18.7679C65.9155 19.2602 66.0589 19.8188 66.0485 20.385C66.0629 20.9158 65.9209 21.4392 65.6399 21.891V21.891Z"
      fill="currentColor"
    />
    <path
      d="M71.6097 31.5277C71.2129 30.861 70.5686 30.3751 69.815 30.1742C68.9627 29.917 67.8072 29.9846 66.3311 29.9846H60.8485C60.6094 29.9862 60.3715 29.9509 60.1433 29.88C59.9712 29.8174 59.8194 29.7097 59.704 29.5683C59.6165 29.4397 59.5705 29.2876 59.5722 29.1324C59.5669 28.9683 59.6172 28.8072 59.715 28.6748C59.8281 28.5344 59.9812 28.4311 60.1543 28.3784C60.4048 28.2993 60.6669 28.2625 60.9297 28.2694H62.6717L60.7518 27.9229C59.2295 27.9229 56.622 28.0035 55.6335 28.1931C54.645 28.3827 53.9135 28.6944 53.4369 29.1542C52.9602 29.6141 52.7207 30.2091 52.7207 30.9937C52.7191 31.4153 52.77 32.0046 52.8723 32.4138C53.0014 32.8125 53.2322 33.1714 53.5423 33.4556C53.9734 33.8078 54.4774 34.0615 55.0185 34.1987C55.8598 34.3985 56.7237 34.4893 57.5886 34.469H67.3437C68.2838 34.469 69.6469 34.285 69.7908 35.4606L69.9029 36.376H72.1347V34.8221C72.1413 33.7062 71.9743 32.1771 71.6097 31.5277Z"
      fill="currentColor"
    />
    <path
      d="M117.057 16.9451C116.717 15.8388 116.142 14.8172 115.372 13.9483C114.803 13.2633 114.063 12.7375 113.226 12.4227C112.431 12.1029 111.58 11.9407 110.722 11.9454C109.336 11.9454 108.159 12.2222 107.159 12.7954C106.212 13.3081 105.373 13.9953 104.686 14.8201C104.139 15.5371 103.67 16.3084 103.284 17.1216V15.1536C103.284 13.5974 102.662 12.6646 100.666 12.5557C98.6689 12.4467 97.5068 12.4837 97.5068 12.4837V30.4097H103.284V22.738C103.284 20.0791 104.011 17.6577 107.423 17.6577H107.985C111.396 17.6577 112.124 20.0791 112.124 22.738V30.4097H117.615V21.7377C117.624 19.8045 117.431 18.2135 117.057 16.9451Z"
      fill="currentColor"
    />
  </svg>
)

export const UniIcon = (props: SVGProps) => (
  <svg {...props} fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M20.3526 19.9242C20.2928 20.1549 20.1885 20.3715 20.0455 20.5618C19.7793 20.9088 19.427 21.1794 19.0239 21.3466C18.6614 21.5035 18.2774 21.605 17.8849 21.6475C17.8042 21.6578 17.7206 21.6641 17.6395 21.6703L17.6263 21.6713C17.3777 21.6808 17.1387 21.77 16.9442 21.9258C16.7497 22.0817 16.61 22.296 16.5455 22.5373C16.516 22.6574 16.494 22.7792 16.4798 22.9021C16.4572 23.0874 16.4456 23.2771 16.433 23.4823C16.424 23.6295 16.4144 23.7848 16.4 23.9521C16.3156 24.6337 16.1193 25.2965 15.8192 25.9136C15.7579 26.0433 15.6954 26.1691 15.6339 26.2926C15.3049 26.9546 15.0076 27.5526 15.0929 28.3535C15.1597 28.9706 15.4744 29.3841 15.8925 29.8106C16.0911 30.0146 16.3544 30.1889 16.6277 30.3699C17.3927 30.8763 18.2361 31.4347 17.9582 32.8415C17.7308 33.9814 15.8494 35.1776 13.205 35.5954C13.4615 35.5563 12.8965 34.5879 12.8338 34.4804L12.83 34.4739C12.7571 34.3592 12.6824 34.2462 12.6079 34.1334L12.6079 34.1334L12.6078 34.1334C12.3926 33.8076 12.1783 33.4835 12.0111 33.1241C11.5693 32.1856 11.3645 31.0998 11.5455 30.0714C11.7095 29.1407 12.3221 28.3972 12.9118 27.6813L12.9118 27.6813C13.008 27.5646 13.1035 27.4487 13.1964 27.3328C13.9852 26.3488 14.8128 25.0595 14.9959 23.7822C15.0114 23.6712 15.0252 23.5502 15.0397 23.4229L15.0397 23.4229L15.0397 23.4229C15.0657 23.195 15.0939 22.9469 15.1382 22.6997C15.2039 22.2728 15.3371 21.8591 15.5326 21.4743C15.666 21.222 15.8417 20.9946 16.052 20.8021C16.1616 20.6999 16.2339 20.5637 16.2574 20.4153C16.2808 20.267 16.254 20.115 16.1813 19.9837L11.9658 12.3673L18.0207 19.8733C18.0897 19.9603 18.1768 20.031 18.276 20.0803C18.3752 20.1296 18.484 20.1564 18.5946 20.1588C18.7053 20.1612 18.8151 20.1391 18.9163 20.094C19.0175 20.049 19.1076 19.9821 19.1802 19.8982C19.2569 19.8084 19.3004 19.6947 19.3033 19.5763C19.3063 19.458 19.2685 19.3423 19.1963 19.2487C18.9148 18.8873 18.6218 18.521 18.3302 18.1563L18.33 18.156C18.212 18.0085 18.0943 17.8613 17.9776 17.7148L16.4539 15.8205L13.3957 12.0382L10 8L13.788 11.6994L17.0433 15.3149L18.6673 17.127C18.8165 17.2958 18.9657 17.4631 19.1148 17.6303C19.5044 18.0671 19.894 18.5039 20.2836 18.9673L20.372 19.0755L20.3914 19.2433C20.4176 19.4708 20.4045 19.7012 20.3526 19.9242ZM35.9247 22.4697L35.9311 22.4795C35.93 21.6719 35.4322 20.3394 34.4247 19.0577L34.401 19.0263C34.0906 18.641 33.7524 18.2792 33.3891 17.9438C33.3212 17.8778 33.248 17.8128 33.1736 17.7479C32.7081 17.3401 32.1993 16.985 31.6564 16.6892L31.6176 16.6697C29.9118 15.7366 27.692 15.256 24.9549 15.7972C24.5873 15.3489 24.1914 14.9248 23.7696 14.5275C23.1236 13.9091 22.3632 13.4241 21.5315 13.0997C20.7072 12.7966 19.8244 12.6884 18.9517 12.7836C19.7929 12.8597 20.6123 13.0947 21.3666 13.4764C22.0951 13.8685 22.7512 14.3833 23.3062 14.9984C23.8688 15.6263 24.3976 16.2839 24.8903 16.9685L25.0139 17.1302C25.496 17.7609 25.9868 18.403 26.5982 18.9744C26.9348 19.2925 27.3103 19.5664 27.7157 19.7895C27.8234 19.8447 27.9323 19.8966 28.039 19.9421C28.1456 19.9876 28.2458 20.0298 28.3536 20.0688C28.5616 20.1499 28.7771 20.2171 28.9926 20.2788C29.8547 20.5256 30.7372 20.6143 31.5993 20.662C31.7192 20.6683 31.8389 20.6742 31.9581 20.6801L31.9583 20.6801C32.2662 20.6954 32.5713 20.7105 32.8719 20.7323C33.2837 20.7569 33.6922 20.8214 34.0917 20.925C34.6918 21.0822 35.2201 21.4413 35.5885 21.9425C35.7137 22.1095 35.8261 22.2857 35.9247 22.4697ZM33.4013 17.9451C33.358 17.9049 33.3139 17.8651 33.27 17.8254L33.27 17.8254C33.2418 17.7999 33.2136 17.7745 33.1858 17.7491C33.2073 17.7688 33.2288 17.7887 33.2503 17.8087C33.3009 17.8556 33.3514 17.9025 33.4013 17.9451ZM32.3238 25.9172C29.5516 24.7872 26.6518 23.6051 27.0835 20.2875C28.0091 21.2802 29.462 21.4884 31.0422 21.7149C32.4757 21.9203 34.0139 22.1407 35.3583 22.9753C38.5306 24.9433 38.0673 28.7666 36.9897 30.1739C37.0869 27.8587 34.7544 26.908 32.3238 25.9172ZM21.1551 24.2567C21.8868 24.1863 23.4461 23.8042 22.7489 22.5712C22.5989 22.3204 22.3815 22.1172 22.1217 21.9848C21.8619 21.8525 21.5702 21.7965 21.2801 21.8232C20.9858 21.855 20.7082 21.9769 20.4852 22.1725C20.2622 22.3681 20.1044 22.6278 20.0334 22.9165C19.8168 23.723 20.0463 24.3649 21.1551 24.2567ZM20.9448 14.5014C20.4858 13.9688 19.7735 13.6895 19.0752 13.5878C19.0491 13.7625 19.0326 13.9385 19.0257 14.115C18.9944 15.5687 19.5084 17.1654 20.503 18.275C20.8212 18.6337 21.2049 18.9276 21.6334 19.141C21.8812 19.2622 22.5386 19.5631 22.7821 19.2925C22.8006 19.2677 22.8123 19.2384 22.8159 19.2076C22.8195 19.1768 22.8149 19.1456 22.8026 19.1172C22.7622 19.0013 22.6843 18.8961 22.6069 18.7917C22.552 18.7177 22.4974 18.6441 22.4567 18.5672C22.4155 18.4898 22.3714 18.4142 22.3274 18.3388L22.3274 18.3388C22.2447 18.197 22.1622 18.0555 22.0989 17.9015C21.9319 17.4984 21.845 17.0698 21.7583 16.6425L21.7583 16.6424L21.7583 16.6424L21.7583 16.6423L21.7582 16.6422L21.7582 16.6421L21.7582 16.642C21.7409 16.5566 21.7236 16.4712 21.7056 16.386C21.5731 15.7268 21.4039 15.034 20.9448 14.5014ZM30.7524 26.098C30.0403 28.0943 31.1888 29.7804 32.3306 31.4566C33.6077 33.3315 34.8764 35.194 33.5228 37.4642C36.1532 36.3731 37.4021 33.0769 36.3105 30.4616C35.6227 28.8074 33.9649 27.9106 32.4261 27.0783L32.4261 27.0783L32.426 27.0782C31.829 26.7553 31.2499 26.4421 30.7524 26.098ZM23.0552 30.8633C22.5785 31.0587 22.129 31.3152 21.7179 31.6265C22.6527 31.2859 23.6339 31.0914 24.6274 31.0495C24.8074 31.0388 24.9887 31.0304 25.1715 31.0219L25.1717 31.0219L25.172 31.0219C25.4878 31.0073 25.8085 30.9925 26.136 30.9651C26.6729 30.9285 27.2025 30.8192 27.7103 30.6403C28.2425 30.4533 28.7268 30.1501 29.1284 29.7527C29.5342 29.3424 29.8188 28.8272 29.9506 28.2642C30.0666 27.7324 30.0503 27.1801 29.9032 26.6562C29.756 26.1322 29.4825 25.6528 29.1069 25.2603C29.2881 25.7221 29.3996 26.2084 29.4377 26.7033C29.4705 27.164 29.4081 27.6265 29.2545 28.0618C29.1045 28.4744 28.8593 28.8454 28.539 29.1443C28.2081 29.4462 27.825 29.6846 27.4086 29.8479C26.8299 30.0821 26.1755 30.1779 25.4939 30.2777C25.183 30.3232 24.8664 30.3696 24.5487 30.4303C24.0378 30.5243 23.5374 30.6694 23.0552 30.8633ZM31.3187 39.1046L31.273 39.1415L31.273 39.1416C31.1525 39.2389 31.0301 39.3379 30.8982 39.4268C30.7301 39.538 30.554 39.6365 30.3713 39.7212C29.9908 39.9077 29.5726 40.0029 29.1493 39.9994C28.0028 39.9778 27.1924 39.1205 26.7183 38.1516C26.594 37.8977 26.4845 37.6359 26.375 37.3741L26.375 37.3741C26.1997 36.9551 26.0244 36.5361 25.7883 36.149C25.2399 35.2495 24.3013 34.5253 23.2022 34.6595C22.7539 34.7158 22.3336 34.9182 22.0847 35.309C21.4295 36.3298 22.3703 37.7598 23.5696 37.5573C23.6716 37.5417 23.7714 37.5141 23.867 37.4751C23.9623 37.4343 24.0512 37.38 24.131 37.3138C24.2986 37.1736 24.4248 36.9903 24.4963 36.7834C24.5751 36.5676 24.5926 36.3341 24.547 36.109C24.4978 35.8736 24.3594 35.6668 24.1612 35.532C24.3917 35.6404 24.5713 35.8345 24.6623 36.0732C24.7566 36.319 24.7809 36.5862 24.7323 36.8451C24.6852 37.1147 24.5669 37.3667 24.3896 37.5747C24.2955 37.6816 24.1866 37.7746 24.0664 37.8507C23.9472 37.9259 23.8195 37.9866 23.686 38.0315C23.4153 38.1244 23.1272 38.1544 22.8433 38.1192C22.4447 38.0621 22.0688 37.8983 21.755 37.645C21.697 37.599 21.6414 37.5508 21.5875 37.5008C21.374 37.3158 21.1802 37.1087 21.0093 36.8829C20.9326 36.7981 20.8547 36.7144 20.7733 36.634C20.3891 36.229 19.9358 35.8965 19.4349 35.6522C19.0895 35.4998 18.728 35.3872 18.3574 35.3166C18.1709 35.2776 17.9824 35.2495 17.7938 35.2257C17.7733 35.2236 17.734 35.2167 17.685 35.2082L17.6847 35.2081L17.6846 35.2081L17.6846 35.2081L17.6846 35.2081L17.6845 35.2081C17.5271 35.1806 17.2711 35.136 17.2259 35.178C17.8088 34.639 18.4441 34.1603 19.1224 33.7491C19.8189 33.334 20.5667 33.0126 21.3466 32.7933C22.1551 32.5647 23.0009 32.4995 23.8347 32.6017C24.2639 32.6535 24.6843 32.7627 25.0847 32.9264C25.5042 33.0948 25.8914 33.3351 26.2291 33.6366C26.5632 33.9528 26.8333 34.3311 27.0243 34.7504C27.1968 35.1431 27.3254 35.5537 27.4079 35.9747C27.4521 36.2013 27.4855 36.4502 27.5199 36.7079L27.52 36.7079L27.52 36.708L27.52 36.708C27.6771 37.8823 27.8585 39.2372 29.2043 39.4733C29.2898 39.49 29.3761 39.5023 29.4629 39.5102L29.7312 39.5166C29.9157 39.5034 30.099 39.477 30.2797 39.4376C30.6541 39.3492 31.019 39.2241 31.3691 39.0642L31.3187 39.1046ZM21.0801 36.9619C21.1123 36.9989 21.1449 37.0355 21.1779 37.0718C21.1644 37.0567 21.151 37.0415 21.1375 37.0264L21.1375 37.0264L21.1375 37.0264L21.1375 37.0264C21.1184 37.0049 21.0993 36.9834 21.0801 36.9619Z"
      fill="currentColor"
    />
  </svg>
)

export const UniIconMobile = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M18.3526 17.9242C18.2928 18.1549 18.1885 18.3715 18.0455 18.5618C17.7793 18.9088 17.427 19.1794 17.0239 19.3466C16.6614 19.5035 16.2774 19.605 15.8849 19.6475C15.8042 19.6578 15.7206 19.6641 15.6395 19.6703L15.6263 19.6713C15.3777 19.6808 15.1387 19.77 14.9442 19.9258C14.7497 20.0817 14.61 20.296 14.5455 20.5373C14.516 20.6574 14.494 20.7792 14.4798 20.9021C14.4572 21.0874 14.4456 21.2771 14.433 21.4823C14.424 21.6295 14.4144 21.7848 14.4 21.9521C14.3156 22.6337 14.1193 23.2965 13.8192 23.9136C13.7579 24.0433 13.6954 24.1691 13.6339 24.2926C13.3049 24.9546 13.0076 25.5526 13.0929 26.3535C13.1597 26.9706 13.4744 27.3841 13.8925 27.8106C14.0911 28.0146 14.3544 28.1889 14.6277 28.3699C15.3927 28.8763 16.2361 29.4347 15.9582 30.8415C15.7308 31.9814 13.8494 33.1776 11.205 33.5954C11.4615 33.5563 10.8965 32.5879 10.8338 32.4804L10.83 32.4739C10.7571 32.3592 10.6824 32.2462 10.6079 32.1334L10.6079 32.1334L10.6078 32.1334C10.3926 31.8076 10.1783 31.4835 10.0111 31.1241C9.56926 30.1856 9.36451 29.0998 9.54555 28.0714C9.70954 27.1407 10.3221 26.3972 10.9118 25.6813L10.9118 25.6813C11.008 25.5646 11.1035 25.4487 11.1964 25.3328C11.9852 24.3488 12.8128 23.0595 12.9959 21.7822C13.0114 21.6712 13.0252 21.5502 13.0397 21.4229L13.0397 21.4229L13.0397 21.4229C13.0657 21.195 13.0939 20.9469 13.1382 20.6997C13.2039 20.2728 13.3371 19.8591 13.5326 19.4743C13.666 19.222 13.8417 18.9946 14.052 18.8021C14.1616 18.6999 14.2339 18.5637 14.2574 18.4153C14.2808 18.267 14.254 18.115 14.1813 17.9837L9.9658 10.3673L16.0207 17.8733C16.0897 17.9603 16.1768 18.031 16.276 18.0803C16.3752 18.1296 16.484 18.1564 16.5946 18.1588C16.7053 18.1612 16.8151 18.1391 16.9163 18.094C17.0175 18.049 17.1076 17.9821 17.1802 17.8982C17.2569 17.8084 17.3004 17.6947 17.3033 17.5763C17.3063 17.458 17.2685 17.3423 17.1963 17.2487C16.9148 16.8873 16.6218 16.521 16.3302 16.1563L16.33 16.156C16.212 16.0085 16.0943 15.8613 15.9776 15.7148L14.4539 13.8205L11.3957 10.0382L8 6L11.788 9.69942L15.0433 13.3149L16.6673 15.127C16.8165 15.2958 16.9657 15.4631 17.1148 15.6303C17.5044 16.0671 17.894 16.5039 18.2836 16.9673L18.372 17.0755L18.3914 17.2433C18.4176 17.4708 18.4045 17.7012 18.3526 17.9242ZM33.9247 20.4697L33.9311 20.4795C33.93 19.6719 33.4322 18.3394 32.4247 17.0577L32.401 17.0263C32.0906 16.641 31.7524 16.2792 31.3891 15.9438C31.3212 15.8778 31.248 15.8128 31.1736 15.7479C30.7081 15.3401 30.1993 14.985 29.6564 14.6892L29.6176 14.6697C27.9118 13.7366 25.692 13.256 22.9549 13.7972C22.5873 13.3489 22.1914 12.9248 21.7696 12.5275C21.1236 11.9091 20.3632 11.4241 19.5315 11.0997C18.7072 10.7966 17.8244 10.6884 16.9517 10.7836C17.7929 10.8597 18.6123 11.0947 19.3666 11.4764C20.0951 11.8685 20.7512 12.3833 21.3062 12.9984C21.8688 13.6263 22.3976 14.2839 22.8903 14.9685L23.0139 15.1302C23.496 15.7609 23.9868 16.403 24.5982 16.9744C24.9348 17.2925 25.3103 17.5664 25.7157 17.7895C25.8234 17.8447 25.9323 17.8966 26.039 17.9421C26.1456 17.9876 26.2458 18.0298 26.3536 18.0688C26.5616 18.1499 26.7771 18.2171 26.9926 18.2788C27.8547 18.5256 28.7372 18.6143 29.5993 18.662C29.7192 18.6683 29.8389 18.6742 29.9581 18.6801L29.9583 18.6801C30.2662 18.6954 30.5713 18.7105 30.8719 18.7323C31.2837 18.7569 31.6922 18.8214 32.0917 18.925C32.6918 19.0822 33.2201 19.4413 33.5885 19.9425C33.7137 20.1095 33.8261 20.2857 33.9247 20.4697ZM31.4013 15.9451C31.358 15.9049 31.3139 15.8651 31.27 15.8254L31.27 15.8254C31.2418 15.7999 31.2136 15.7745 31.1858 15.7491C31.2073 15.7688 31.2288 15.7887 31.2503 15.8087C31.3009 15.8556 31.3514 15.9025 31.4013 15.9451ZM30.3238 23.9172C27.5516 22.7872 24.6518 21.6051 25.0835 18.2875C26.0091 19.2802 27.462 19.4884 29.0422 19.7149C30.4757 19.9203 32.0139 20.1407 33.3583 20.9753C36.5306 22.9433 36.0673 26.7666 34.9897 28.1739C35.0869 25.8587 32.7544 24.908 30.3238 23.9172ZM19.1551 22.2567C19.8868 22.1863 21.4461 21.8042 20.7489 20.5712C20.5989 20.3204 20.3815 20.1172 20.1217 19.9848C19.8619 19.8525 19.5702 19.7965 19.2801 19.8232C18.9858 19.855 18.7082 19.9769 18.4852 20.1725C18.2622 20.3681 18.1044 20.6278 18.0334 20.9165C17.8168 21.723 18.0463 22.3649 19.1551 22.2567ZM18.9448 12.5014C18.4858 11.9688 17.7735 11.6895 17.0752 11.5878C17.0491 11.7625 17.0326 11.9385 17.0257 12.115C16.9944 13.5687 17.5084 15.1654 18.503 16.275C18.8212 16.6337 19.2049 16.9276 19.6334 17.141C19.8812 17.2622 20.5386 17.5631 20.7821 17.2925C20.8006 17.2677 20.8123 17.2384 20.8159 17.2076C20.8195 17.1768 20.8149 17.1456 20.8026 17.1172C20.7622 17.0013 20.6843 16.8961 20.6069 16.7917C20.552 16.7177 20.4974 16.6441 20.4567 16.5672C20.4155 16.4898 20.3714 16.4142 20.3274 16.3388L20.3274 16.3388C20.2447 16.197 20.1622 16.0555 20.0989 15.9015C19.9319 15.4984 19.845 15.0698 19.7583 14.6425L19.7583 14.6424L19.7583 14.6424L19.7583 14.6423L19.7582 14.6422L19.7582 14.6421L19.7582 14.642C19.7409 14.5566 19.7236 14.4712 19.7056 14.386C19.5731 13.7268 19.4039 13.034 18.9448 12.5014ZM28.7524 24.098C28.0403 26.0943 29.1888 27.7804 30.3306 29.4566C31.6077 31.3315 32.8764 33.194 31.5228 35.4642C34.1532 34.3731 35.4021 31.0769 34.3105 28.4616C33.6227 26.8074 31.9649 25.9106 30.4261 25.0783L30.4261 25.0783L30.426 25.0782C29.829 24.7553 29.2499 24.4421 28.7524 24.098ZM21.0552 28.8633C20.5785 29.0587 20.129 29.3152 19.7179 29.6265C20.6527 29.2859 21.6339 29.0914 22.6274 29.0495C22.8074 29.0388 22.9887 29.0304 23.1715 29.0219L23.1717 29.0219L23.172 29.0219C23.4878 29.0073 23.8085 28.9925 24.136 28.9651C24.6729 28.9285 25.2025 28.8192 25.7103 28.6403C26.2425 28.4533 26.7268 28.1501 27.1284 27.7527C27.5342 27.3424 27.8188 26.8272 27.9506 26.2642C28.0666 25.7324 28.0503 25.1801 27.9032 24.6562C27.756 24.1322 27.4825 23.6528 27.1069 23.2603C27.2881 23.7221 27.3996 24.2084 27.4377 24.7033C27.4705 25.164 27.4081 25.6265 27.2545 26.0618C27.1045 26.4744 26.8593 26.8454 26.539 27.1443C26.2081 27.4462 25.825 27.6846 25.4086 27.8479C24.8299 28.0821 24.1755 28.1779 23.4939 28.2777C23.183 28.3232 22.8664 28.3696 22.5487 28.4303C22.0378 28.5243 21.5374 28.6694 21.0552 28.8633ZM29.3187 37.1046L29.273 37.1415L29.273 37.1416C29.1525 37.2389 29.0301 37.3379 28.8982 37.4268C28.7301 37.538 28.554 37.6365 28.3713 37.7212C27.9908 37.9077 27.5726 38.0029 27.1493 37.9994C26.0028 37.9778 25.1924 37.1205 24.7183 36.1516C24.594 35.8977 24.4845 35.6359 24.375 35.3741L24.375 35.3741C24.1997 34.9551 24.0244 34.5361 23.7883 34.149C23.2399 33.2495 22.3013 32.5253 21.2022 32.6595C20.7539 32.7158 20.3336 32.9182 20.0847 33.309C19.4295 34.3298 20.3703 35.7598 21.5696 35.5573C21.6716 35.5417 21.7714 35.5141 21.867 35.4751C21.9623 35.4343 22.0512 35.38 22.131 35.3138C22.2986 35.1736 22.4248 34.9903 22.4963 34.7834C22.5751 34.5676 22.5926 34.3341 22.547 34.109C22.4978 33.8736 22.3594 33.6668 22.1612 33.532C22.3917 33.6404 22.5713 33.8345 22.6623 34.0732C22.7566 34.319 22.7809 34.5862 22.7323 34.8451C22.6852 35.1147 22.5669 35.3667 22.3896 35.5747C22.2955 35.6816 22.1866 35.7746 22.0664 35.8507C21.9472 35.9259 21.8195 35.9866 21.686 36.0315C21.4153 36.1244 21.1272 36.1544 20.8433 36.1192C20.4447 36.0621 20.0688 35.8983 19.755 35.645C19.697 35.599 19.6414 35.5508 19.5875 35.5008C19.374 35.3158 19.1802 35.1087 19.0093 34.8829C18.9326 34.7981 18.8547 34.7144 18.7733 34.634C18.3891 34.229 17.9358 33.8965 17.4349 33.6522C17.0895 33.4998 16.728 33.3872 16.3574 33.3166C16.1709 33.2776 15.9824 33.2495 15.7938 33.2257C15.7733 33.2236 15.734 33.2167 15.685 33.2082L15.6847 33.2081L15.6846 33.2081L15.6846 33.2081L15.6846 33.2081L15.6845 33.2081C15.5271 33.1806 15.2711 33.136 15.2259 33.178C15.8088 32.639 16.4441 32.1603 17.1224 31.7491C17.8189 31.334 18.5667 31.0126 19.3466 30.7933C20.1551 30.5647 21.0009 30.4995 21.8347 30.6017C22.2639 30.6535 22.6843 30.7627 23.0847 30.9264C23.5042 31.0948 23.8914 31.3351 24.2291 31.6366C24.5632 31.9528 24.8333 32.3311 25.0243 32.7504C25.1968 33.1431 25.3254 33.5537 25.4079 33.9747C25.4521 34.2013 25.4855 34.4502 25.5199 34.7079L25.52 34.7079L25.52 34.708L25.52 34.708C25.6771 35.8823 25.8585 37.2372 27.2043 37.4733C27.2898 37.49 27.3761 37.5023 27.4629 37.5102L27.7312 37.5166C27.9157 37.5034 28.099 37.477 28.2797 37.4376C28.6541 37.3492 29.019 37.2241 29.3691 37.0642L29.3187 37.1046ZM19.0801 34.9619C19.1123 34.9989 19.1449 35.0355 19.1779 35.0718C19.1644 35.0567 19.151 35.0415 19.1375 35.0264L19.1375 35.0264L19.1375 35.0264L19.1375 35.0264C19.1184 35.0049 19.0993 34.9834 19.0801 34.9619Z"
      fill="currentColor"
    />
  </svg>
)

export const UniIconSmall = (props: SVGProps) => (
  <svg {...props} fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M14.7645 13.9432C14.7197 14.1163 14.6414 14.2788 14.5342 14.4214C14.3346 14.6817 14.0704 14.8847 13.768 15.01C13.4961 15.1278 13.2081 15.2038 12.9138 15.2358C12.8532 15.2434 12.7905 15.2482 12.7298 15.2529L12.7198 15.2536C12.5334 15.2607 12.3541 15.3276 12.2082 15.4445C12.0623 15.5614 11.9576 15.7221 11.9092 15.9031C11.887 15.9932 11.8706 16.0846 11.8599 16.1767C11.8429 16.3157 11.8342 16.4579 11.8248 16.6118L11.8248 16.6118C11.818 16.7223 11.8109 16.8387 11.8001 16.9642C11.7368 17.4754 11.5896 17.9725 11.3645 18.4354C11.3185 18.5327 11.2716 18.627 11.2255 18.7196C10.9787 19.2161 10.7557 19.6646 10.8197 20.2653C10.8699 20.7281 11.1058 21.0382 11.4194 21.3581C11.5684 21.5111 11.7658 21.6419 11.9708 21.7776C12.5446 22.1575 13.1771 22.5762 12.9687 23.6314C12.7982 24.4863 11.3871 25.3834 9.40379 25.6968C9.59617 25.6675 9.17244 24.9412 9.12535 24.8605L9.12254 24.8557C9.06787 24.7697 9.01186 24.6849 8.95595 24.6003L8.95592 24.6003C8.79445 24.3559 8.63377 24.1128 8.50831 23.8433C8.17695 23.1394 8.0234 22.3251 8.15917 21.5538C8.28217 20.8557 8.74157 20.2981 9.1839 19.7612C9.256 19.6736 9.32766 19.5867 9.39732 19.4997C9.98892 18.7617 10.6096 17.7948 10.747 16.8368C10.7586 16.7535 10.7689 16.6628 10.7798 16.5673L10.7798 16.5673C10.7993 16.3964 10.8205 16.2103 10.8537 16.0249C10.903 15.7047 11.0029 15.3944 11.1495 15.1058C11.2496 14.9166 11.3813 14.746 11.539 14.6017C11.6212 14.525 11.6755 14.4229 11.6931 14.3116C11.7107 14.2003 11.6906 14.0863 11.636 13.9879L8.47437 8.27552L13.0156 13.9051C13.0673 13.9703 13.1327 14.0233 13.2071 14.0603C13.2815 14.0973 13.3631 14.1174 13.446 14.1192C13.529 14.121 13.6114 14.1044 13.6873 14.0706C13.7632 14.0369 13.8308 13.9867 13.8852 13.9238C13.9427 13.8564 13.9754 13.7711 13.9776 13.6824C13.9798 13.5936 13.9514 13.5068 13.8973 13.4366C13.6862 13.1656 13.4665 12.8908 13.2478 12.6174L13.2477 12.6173L13.2473 12.6168C13.1589 12.5063 13.0707 12.396 12.9833 12.2862L11.8405 10.8654L9.54684 8.02871L7 5L9.84102 7.7746L12.2826 10.4863L13.5005 11.8453C13.6124 11.9719 13.7243 12.0974 13.8362 12.2228L13.8363 12.2229C14.1284 12.5505 14.4206 12.878 14.7128 13.2255L14.7791 13.3067L14.7936 13.4326C14.8133 13.6032 14.8035 13.776 14.7645 13.9432ZM26.436 15.8524L26.4409 15.8597L26.4409 15.8577C26.4392 15.2518 26.0658 14.2536 25.311 13.2934L25.2932 13.2698C25.0605 12.9808 24.8068 12.7094 24.5344 12.4579C24.5238 12.4476 24.513 12.4374 24.5021 12.4272C24.5141 12.4379 24.5261 12.4483 24.538 12.4585C24.5055 12.4284 24.4725 12.3985 24.4395 12.3688C24.4183 12.3497 24.3972 12.3306 24.3763 12.3116C24.3924 12.3263 24.4085 12.3412 24.4245 12.3561L24.4247 12.3562L24.4247 12.3562L24.4383 12.3689C24.4167 12.3495 24.3948 12.3303 24.3727 12.311C24.0236 12.0051 23.642 11.7388 23.2348 11.517L23.2057 11.5024C21.9263 10.8025 20.2614 10.442 18.2086 10.848C17.9329 10.5117 17.636 10.1936 17.3196 9.89565C16.8352 9.43189 16.2649 9.06807 15.641 8.82479C15.0228 8.59745 14.3607 8.51633 13.7062 8.58772C14.3371 8.64478 14.9516 8.82107 15.5174 9.10732C16.0637 9.40137 16.5558 9.78748 16.9721 10.2488C17.394 10.7197 17.7906 11.213 18.1601 11.7264L18.2529 11.8477L18.2529 11.8477C18.6145 12.3208 18.9825 12.8023 19.4411 13.2308C19.6936 13.4695 19.9752 13.6749 20.2792 13.8422C20.36 13.8836 20.4417 13.9226 20.5217 13.9567C20.6017 13.9908 20.6768 14.0224 20.7577 14.0517C20.9136 14.1125 21.0753 14.1629 21.2369 14.2092C21.8835 14.3943 22.5454 14.4608 23.1919 14.4966C23.2817 14.5013 23.3713 14.5057 23.4605 14.5102L23.4612 14.5102C23.6922 14.5216 23.921 14.5329 24.1464 14.5493C24.4553 14.5678 24.7617 14.6162 25.0613 14.6938C25.5114 14.8117 25.9076 15.0811 26.1839 15.457C26.2778 15.5822 26.3621 15.7144 26.436 15.8524ZM23.7486 18.4393C21.6694 17.5918 19.4945 16.7053 19.8184 14.217C20.5125 14.9616 21.6022 15.1177 22.7874 15.2875C23.8625 15.4416 25.0162 15.6069 26.0245 16.2329C28.4038 17.7089 28.0563 20.5764 27.2481 21.6319C27.321 19.8955 25.5716 19.1824 23.7486 18.4393ZM15.3578 17.1936C15.9066 17.1408 17.076 16.8542 16.5531 15.9295C16.4406 15.7414 16.2776 15.5889 16.0827 15.4897C15.8879 15.3905 15.6691 15.3485 15.4516 15.3685C15.2308 15.3923 15.0227 15.4837 14.8554 15.6304C14.6881 15.7771 14.5698 15.9719 14.5165 16.1885C14.3541 16.7933 14.5262 17.2748 15.3578 17.1936ZM15.2132 9.87513C14.869 9.47569 14.3347 9.26622 13.811 9.18991C13.7914 9.32092 13.779 9.45291 13.7739 9.58529C13.7504 10.6756 14.1359 11.8732 14.8819 12.7053C15.1205 12.9744 15.4083 13.1948 15.7297 13.3548C15.9156 13.4458 16.4086 13.6715 16.5912 13.4685C16.6051 13.4499 16.6139 13.4279 16.6166 13.4048C16.6193 13.3817 16.6158 13.3583 16.6066 13.337C16.5763 13.2501 16.5178 13.1712 16.4598 13.0929C16.4186 13.0374 16.3777 12.9822 16.3471 12.9245C16.3162 12.8664 16.2832 12.8098 16.2502 12.7532C16.1882 12.6469 16.1263 12.5407 16.0788 12.4252C15.9536 12.1229 15.8884 11.8014 15.8234 11.481L15.8233 11.4809L15.8233 11.4808L15.8233 11.4807L15.8233 11.4806L15.8233 11.4805L15.8232 11.4804C15.8103 11.4164 15.7973 11.3524 15.7838 11.2886C15.6844 10.7942 15.5575 10.2746 15.2132 9.87513ZM22.5695 18.5739C22.0354 20.0711 22.8968 21.3357 23.7531 22.5929C24.711 23.9991 25.6625 25.396 24.6474 27.0986C26.6202 26.2802 27.5569 23.8081 26.7382 21.8466C26.2223 20.6059 24.9789 19.9334 23.8248 19.3091L23.8248 19.3091C23.377 19.0669 22.9427 18.8319 22.5695 18.5739ZM16.7849 22.1485C16.4274 22.295 16.0903 22.4874 15.7819 22.7208C16.483 22.4654 17.2189 22.3195 17.964 22.2881C18.0991 22.2801 18.235 22.2738 18.3722 22.2675L18.3722 22.2674L18.3723 22.2674L18.3724 22.2674L18.3725 22.2674L18.3726 22.2674C18.6095 22.2565 18.8499 22.2453 19.0955 22.2248C19.4982 22.1973 19.8954 22.1154 20.2763 21.9812C20.6754 21.8409 21.0386 21.6136 21.3399 21.3155C21.6442 21.0078 21.8576 20.6214 21.9565 20.1992C22.0435 19.8003 22.0313 19.386 21.9209 18.9931C21.8105 18.6001 21.6054 18.2405 21.3237 17.9462C21.4596 18.2925 21.5433 18.6573 21.5718 19.0284C21.5964 19.3739 21.5497 19.7208 21.4344 20.0473C21.3219 20.3568 21.138 20.635 20.8978 20.8592C20.6496 21.0856 20.3623 21.2644 20.05 21.3869C19.616 21.5625 19.1252 21.6344 18.614 21.7093C18.3808 21.7434 18.1433 21.7782 17.905 21.8237C17.5218 21.8942 17.1466 22.003 16.7849 22.1485ZM23.0217 28.2985C22.9977 28.3176 22.9737 28.337 22.9496 28.3565C22.8593 28.4295 22.7674 28.5038 22.6685 28.5705C22.5425 28.6539 22.4103 28.7277 22.2733 28.7913C21.988 28.9311 21.6743 29.0025 21.3568 28.9999C20.4969 28.9837 19.8891 28.3407 19.5335 27.6141C19.4403 27.4236 19.3582 27.2273 19.276 27.0309L19.276 27.0309C19.1446 26.7166 19.0131 26.4024 18.8361 26.1121C18.4247 25.4374 17.7208 24.8943 16.8964 24.995C16.5602 25.0372 16.245 25.189 16.0583 25.4821C15.5669 26.2477 16.2725 27.3202 17.172 27.1683C17.2485 27.1566 17.3234 27.1359 17.3951 27.1066C17.4665 27.0761 17.5332 27.0353 17.5931 26.9857C17.7187 26.8806 17.8134 26.743 17.867 26.5879C17.9261 26.4261 17.9393 26.2509 17.905 26.0821C17.8681 25.9056 17.7644 25.7504 17.6157 25.6493C17.7886 25.7306 17.9233 25.8762 17.9915 26.0553C18.0623 26.2396 18.0805 26.44 18.044 26.6341C18.0087 26.8364 17.92 27.0254 17.787 27.1813C17.7164 27.2616 17.6348 27.3313 17.5446 27.3884C17.4552 27.4448 17.3594 27.4903 17.2593 27.524C17.0563 27.5937 16.8402 27.6161 16.6273 27.5897C16.3283 27.5469 16.0464 27.4241 15.811 27.2341C15.7645 27.1972 15.72 27.1583 15.6769 27.118C15.5209 26.9819 15.3791 26.83 15.2537 26.6647C15.1956 26.6004 15.1365 26.5369 15.0747 26.4758C14.7866 26.1721 14.4466 25.9227 14.071 25.7394C13.8119 25.6251 13.5408 25.5407 13.2628 25.4878C13.123 25.4585 12.9815 25.4374 12.8401 25.4196C12.8247 25.418 12.7951 25.4128 12.7582 25.4064L12.7582 25.4064L12.7582 25.4064C12.6401 25.3858 12.448 25.3523 12.4142 25.3838C12.8513 24.9796 13.3279 24.6206 13.8366 24.3122C14.3589 24.0008 14.9198 23.7597 15.5047 23.5953C16.1111 23.4238 16.7454 23.3749 17.3708 23.4516C17.6927 23.4904 18.008 23.5723 18.3083 23.6951C18.623 23.8214 18.9134 24.0016 19.1666 24.2277C19.4172 24.4649 19.6198 24.7486 19.7631 25.0632C19.8924 25.3576 19.9889 25.6656 20.0508 25.9814C20.0839 26.1513 20.1089 26.3381 20.1348 26.5314C20.2527 27.4121 20.3887 28.4283 21.398 28.6054C21.4622 28.6179 21.5269 28.6271 21.592 28.633L21.7932 28.6378C21.9316 28.6279 22.0691 28.6081 22.2046 28.5786C22.4854 28.5122 22.7591 28.4184 23.0217 28.2985Z"
      fill="currentColor"
    />
  </svg>
)

export const ListBulletRectanglePortraitIcon = (props: SVGProps) => (
  <svg role="img" width="29" height="28" viewBox="0 0 29 28" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M6.74219 20.29C6.74219 22.1885 7.71777 23.1729 9.59863 23.1729H18.959C20.8398 23.1729 21.8154 22.1885 21.8154 20.29V7.02734C21.8154 5.1377 20.8398 4.14453 18.959 4.14453H9.59863C7.71777 4.14453 6.74219 5.1377 6.74219 7.02734V20.29ZM8.46484 20.1846V7.13281C8.46484 6.31543 8.88672 5.86719 9.73926 5.86719H18.8096C19.6621 5.86719 20.0928 6.31543 20.0928 7.13281V20.1846C20.0928 21.002 19.6621 21.4502 18.8096 21.4502H9.73926C8.88672 21.4502 8.46484 21.002 8.46484 20.1846ZM10.5391 9.16309C10.9961 9.16309 11.3564 8.79395 11.3564 8.3457C11.3564 7.88867 10.9961 7.52832 10.5391 7.52832C10.0908 7.52832 9.72168 7.89746 9.72168 8.3457C9.72168 8.79395 10.0908 9.16309 10.5391 9.16309ZM12.9561 8.91699H18.2646C18.5811 8.91699 18.8359 8.66211 18.8359 8.3457C18.8359 8.0293 18.5811 7.77441 18.2646 7.77441H12.9561C12.6396 7.77441 12.3848 8.0293 12.3848 8.3457C12.3848 8.66211 12.6396 8.91699 12.9561 8.91699ZM10.5391 11.7822C10.9961 11.7822 11.3564 11.4131 11.3564 10.9648C11.3564 10.5078 10.9961 10.1562 10.5391 10.1562C10.082 10.1562 9.72168 10.5166 9.72168 10.9648C9.72168 11.4131 10.082 11.7822 10.5391 11.7822ZM12.9561 11.5361H18.2646C18.5898 11.5361 18.8359 11.2812 18.8359 10.9648C18.8359 10.6484 18.5898 10.4023 18.2646 10.4023H12.9561C12.6309 10.4023 12.3848 10.6484 12.3848 10.9648C12.3848 11.2812 12.6309 11.5361 12.9561 11.5361ZM10.5391 14.5332C10.9961 14.5332 11.3564 14.1641 11.3564 13.7158C11.3564 13.2588 10.9961 12.8896 10.5391 12.8896C10.0908 12.8896 9.72168 13.2676 9.72168 13.7158C9.72168 14.1553 10.0908 14.5332 10.5391 14.5332ZM12.9561 14.2871H18.2646C18.5811 14.2871 18.8359 14.0234 18.8359 13.7158C18.8359 13.3994 18.5898 13.1445 18.2646 13.1445H12.9561C12.6309 13.1445 12.3848 13.3994 12.3848 13.7158C12.3848 14.0234 12.6396 14.2871 12.9561 14.2871Z"
      fill="currentColor"
    />
  </svg>
)

export const ChevronBackwardIcon = (props: SVGProps) => (
  <svg {...props} width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M12.7783 21.1514C12.9805 21.3447 13.2266 21.4502 13.5078 21.4502C14.0967 21.4502 14.5537 20.9932 14.5537 20.4131C14.5537 20.123 14.4395 19.8594 14.2373 19.6572L8.08496 13.6455L14.2373 7.65137C14.4395 7.44922 14.5537 7.17676 14.5537 6.89551C14.5537 6.31543 14.0967 5.8584 13.5078 5.8584C13.2266 5.8584 12.9805 5.96387 12.7871 6.15723L5.94922 12.8369C5.70312 13.0654 5.58008 13.3467 5.58008 13.6543C5.58008 13.9619 5.70312 14.2256 5.94043 14.4629L12.7783 21.1514ZM20.6357 21.1514C20.8379 21.3447 21.0752 21.4502 21.3652 21.4502C21.9541 21.4502 22.4111 20.9932 22.4111 20.4131C22.4111 20.123 22.2881 19.8594 22.0947 19.6572L15.9336 13.6455L22.0947 7.65137C22.2969 7.44922 22.4111 7.17676 22.4111 6.89551C22.4111 6.31543 21.9541 5.8584 21.3652 5.8584C21.0752 5.8584 20.8379 5.96387 20.6357 6.15723L13.7979 12.8369C13.5605 13.0654 13.4375 13.3467 13.4287 13.6543C13.4287 13.9619 13.5518 14.2256 13.7979 14.4629L20.6357 21.1514Z"
      fill={themeVars.colors.darkGray}
    />
  </svg>
)

export const ChevronUpIcon = ({
  secondaryColor,
  secondaryWidth,
  secondaryHeight,
  ...props
}: SVGProps & { secondaryWidth?: string; secondaryHeight?: string; secondaryColor?: string }) => (
  <svg
    {...props}
    width={secondaryWidth || '29'}
    height={secondaryHeight || '28'}
    viewBox="0 0 29 28"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <g clipPath="url(#clip0_564_11230)">
      <path
        d="M7.2207 16.0615L13.9092 9.22363C14.1377 8.97754 14.4102 8.86328 14.7178 8.86328C15.0254 8.86328 15.3066 8.98633 15.5352 9.22363L22.2148 16.0615C22.4082 16.2549 22.5137 16.501 22.5137 16.791C22.5137 17.3799 22.0566 17.8369 21.4766 17.8369C21.1953 17.8369 20.9229 17.7314 20.7207 17.5205L14.7266 11.3594L8.71484 17.5205C8.52148 17.7227 8.24902 17.8369 7.95898 17.8369C7.37891 17.8369 6.92188 17.3799 6.92188 16.791C6.92188 16.5098 7.02734 16.2549 7.2207 16.0615Z"
        fill={secondaryColor || themeVars.colors.darkGray}
      />
    </g>
    <defs>
      <clipPath id="clip0_564_11230">
        <rect width="28" height="28" fill="white" transform="translate(0.716797)" />
      </clipPath>
    </defs>
  </svg>
)

export const Eth2Icon = (props: SVGProps) => (
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path d="M4.85742 7.95904L8.00028 2.57129L11.1431 7.95904L8.00028 9.75496L4.85742 7.95904Z" fill="currentColor" />
    <path d="M4.85742 8.85742L8.00028 10.6533L11.1431 8.85742L8.00028 13.3472L4.85742 8.85742Z" fill="currentColor" />
  </svg>
)

export const BackArrowIcon = (props: SVGProps) => (
  <svg {...props} xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 28 28">
    <path d="M5.676 13.645c0 .263.114.527.316.72l5.801 5.792c.21.202.44.3.694.3.554 0 .958-.396.958-.933a.934.934 0 00-.29-.694l-1.977-2.004-2.55-2.329 2.049.123h10.652c.58 0 .985-.404.985-.975 0-.58-.405-.985-.985-.985H10.677l-2.04.123 2.54-2.329 1.978-2.004a.934.934 0 00.29-.694c0-.536-.404-.932-.958-.932-.255 0-.492.097-.72.317l-5.775 5.774a1.012 1.012 0 00-.316.73z" />
  </svg>
)

export const WarningIcon = (props: SVGProps) => (
  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none" viewBox="0 0 16 16" {...props}>
    <path
      fill="#0A0A3B"
      d="M7.994 12.995c2.848 0 5.198-2.35 5.198-5.193 0-2.842-2.356-5.193-5.203-5.193C5.146 2.61 2.8 4.96 2.8 7.802c0 2.843 2.35 5.194 5.193 5.194zm0-4.334c-.296 0-.467-.165-.477-.467l-.07-2.506c-.01-.311.21-.527.542-.527.321 0 .557.22.547.532l-.08 2.501c-.01.307-.176.467-.462.467zm0 1.738c-.342 0-.623-.246-.623-.578 0-.331.276-.577.623-.577.341 0 .618.246.618.577 0 .337-.282.578-.618.578z"
    />
  </svg>
)

export const VerifiedIcon = (props: SVGProps) => (
  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M4.52795 13.8056C4.52719 14.4043 4.6712 14.8474 4.95997 15.135C5.24798 15.4233 5.68496 15.5651 6.27091 15.5605H7.57497C7.62945 15.5585 7.68379 15.5676 7.73463 15.5873C7.78547 15.607 7.83176 15.6369 7.87062 15.6752L8.79884 16.5928C9.22054 17.0142 9.63382 17.2237 10.0387 17.2214C10.4436 17.2191 10.8569 17.0096 11.2786 16.5928L12.1954 15.6752C12.2356 15.6365 12.2832 15.6063 12.3354 15.5866C12.3876 15.5669 12.4433 15.558 12.499 15.5605H13.7951C14.3871 15.5613 14.8283 15.4171 15.1186 15.1281C15.4089 14.839 15.5541 14.3959 15.5541 13.7987V12.5014C15.5511 12.389 15.5923 12.2799 15.6687 12.1974L16.5854 11.2798C17.0125 10.86 17.2245 10.4467 17.2214 10.0399C17.2184 9.63305 17.0064 9.21935 16.5854 8.79878L15.6687 7.88115C15.592 7.79886 15.5509 7.68965 15.5541 7.57719V6.2799C15.5533 5.68191 15.4093 5.23878 15.1221 4.95049C14.8348 4.66221 14.3925 4.51806 13.7951 4.51806H12.499C12.4433 4.52036 12.3877 4.51138 12.3355 4.49168C12.2834 4.47197 12.2357 4.44193 12.1954 4.40336L11.2786 3.48574C10.8569 3.06439 10.4436 2.85487 10.0387 2.85717C9.63382 2.85946 9.22054 3.06898 8.79884 3.48574L7.87062 4.40336C7.83164 4.44148 7.78536 4.4713 7.73454 4.49101C7.68373 4.51072 7.62943 4.51993 7.57497 4.51806H6.27091C5.67961 4.51883 5.23995 4.66182 4.95194 4.94705C4.66393 5.23228 4.51992 5.67656 4.51992 6.2799V7.58063C4.52314 7.69309 4.48197 7.80229 4.40533 7.88459L3.48859 8.80222C3.06765 9.22203 2.85718 9.63572 2.85718 10.0433C2.85718 10.4509 3.07033 10.8653 3.49662 11.2867L4.41336 12.2043C4.48979 12.2867 4.53092 12.3958 4.52795 12.5083V13.8056Z"
      fill="#4673FA"
    />
    <path
      d="M9.99737 12.4943C9.86205 12.7005 9.6623 12.8164 9.43032 12.8164C9.19191 12.8164 9.00504 12.7198 8.83106 12.4943L7.31036 10.6385C7.20082 10.5032 7.14282 10.3614 7.14282 10.2068C7.14282 9.88458 7.38768 9.63327 7.70342 9.63327C7.89673 9.63327 8.05138 9.70415 8.20603 9.90391L9.40455 11.4311L11.9498 7.34577C12.0851 7.12669 12.2591 7.02359 12.4524 7.02359C12.7553 7.02359 13.0388 7.23623 13.0388 7.55197C13.0388 7.70017 12.9615 7.85482 12.8777 7.99014L9.99737 12.4943Z"
      fill="white"
    />
  </svg>
)

export const EthIcon = (props: SVGProps) => (
  <svg {...props} role="img" xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 16 16" fill="none">
    <path fill="currentColor" d="M4.85742 7.95904L8.00028 2.57129L11.1431 7.95904L8.00028 9.75496L4.85742 7.95904Z" />
    <path fill="currentColor" d="M4.85742 8.85742L8.00028 10.6533L11.1431 8.85742L8.00028 13.3472L4.85742 8.85742Z" />
  </svg>
)

export const PoolIcon = (props: SVGProps) => (
  <svg {...props} fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M3.13184 15.1834C3.13184 15.5098 3.34528 15.7233 3.67174 15.7233H16.2464C16.5854 15.7233 16.8679 15.4596 16.8679 15.108C16.8679 14.7565 16.5854 14.4928 16.2464 14.4928H4.53809C4.40625 14.4928 4.3623 14.4489 4.3623 14.317V10.9019L7.02414 9.35749C7.23758 9.55838 7.52009 9.68394 7.84026 9.68394C8.11021 9.68394 8.36761 9.58977 8.5685 9.43283L9.74874 10.4373C9.7048 10.5628 9.67969 10.701 9.67969 10.8391C9.67969 11.5045 10.2133 12.0382 10.8725 12.0382C11.5317 12.0382 12.0716 11.5045 12.0716 10.8391C12.0716 10.7889 12.0653 10.7324 12.059 10.6821L14.9343 8.96198C15.1226 9.09382 15.3549 9.16915 15.5998 9.16915C16.2589 9.16915 16.7988 8.62925 16.7988 7.97008C16.7988 7.3109 16.2589 6.771 15.5998 6.771C14.9406 6.771 14.4007 7.3109 14.4007 7.97008C14.4007 8.05169 14.4132 8.1333 14.4258 8.20864L11.607 9.89739C11.4061 9.74044 11.1487 9.64627 10.8725 9.64627C10.6779 9.64627 10.4895 9.69022 10.32 9.77811L9.02051 8.6732C9.02679 8.61042 9.03306 8.54764 9.03306 8.48486C9.03306 7.82568 8.49944 7.28578 7.84026 7.28578C7.17481 7.28578 6.64118 7.82568 6.64118 8.48486C6.64118 8.5037 6.64118 8.52253 6.64118 8.54136L4.3623 9.85972V4.44817C4.3623 4.10289 4.09863 3.82666 3.74707 3.82666C3.39551 3.82666 3.13184 4.10289 3.13184 4.44817V15.1834Z"
      fill="currentColor"
    />
  </svg>
)

export const SuspiciousIcon = (props: SVGProps) => (
  <svg {...props} fill="none" xmlns="http://www.w3.org/2000/svg">
    <rect x="6.85693" y="5.33325" width="2.28571" height="6.85714" fill="white" />
    <path
      d="M4.11238 12.5713H11.8782C12.6405 12.5713 13.1426 12.0254 13.1426 11.3581C13.1426 11.1501 13.0799 10.9507 12.9633 10.7601L9.08037 4.04377C8.83825 3.62779 8.41678 3.42847 7.99531 3.42847C7.57384 3.42847 7.1434 3.62779 6.91024 4.04377L3.02732 10.7601C2.91074 10.9507 2.85693 11.1501 2.85693 11.3581C2.85693 12.0254 3.35015 12.5713 4.11238 12.5713ZM7.99531 9.1395C7.65454 9.1395 7.40345 8.91418 7.39449 8.58486L7.32275 6.17566C7.31378 5.79434 7.59177 5.52569 7.99531 5.52569C8.40781 5.52569 8.6858 5.78568 8.67684 6.17566L8.6051 8.58486C8.58716 8.91418 8.34504 9.1395 7.99531 9.1395ZM7.99531 11.2541C7.54693 11.2541 7.18823 10.9161 7.18823 10.4828C7.18823 10.0581 7.54693 9.72014 7.99531 9.72014C8.45265 9.72014 8.81135 10.0668 8.81135 10.4828C8.80238 10.9161 8.45265 11.2541 7.99531 11.2541Z"
      fill="#FA2C38"
    />
  </svg>
)

export const ClockSpin = ({ loading, ...props }: SVGProps & { loading: boolean }) => (
  <svg width="33" height="32" viewBox="0 0 26 21" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M12.63 4.78906C12.1378 4.78906 11.7461 5.1808 11.7461 5.66295V11.1071C11.7461 11.3482 11.8265 11.5692 11.9972 11.8002L14.3979 14.9542C14.7494 15.4263 15.2718 15.5067 15.7037 15.1953C16.1155 14.904 16.1557 14.3717 15.8343 13.9397L13.5039 10.8058V5.66295C13.5039 5.1808 13.1122 4.78906 12.63 4.78906Z"
      fill="currentColor"
    />
    <path
      className={clsx(loading && styles.clockSpinArrows)}
      d="M24.5898 8.54576C25.3833 8.54576 25.5842 9.14844 25.1523 9.74107L22.6913 13.1362C22.3599 13.6083 21.8275 13.5982 21.5061 13.1362L19.0451 9.73103C18.6333 9.15848 18.8241 8.54576 19.6076 8.54576H21.0541C20.15 4.93973 16.9056 2.29799 12.9983 2.29799C10.3163 2.30804 7.96589 3.55357 6.45919 5.53237C6.04736 6.00447 5.44468 6.15513 4.95249 5.79353C4.49044 5.46205 4.40004 4.80915 4.85205 4.26674C6.70026 1.84598 9.75384 0.21875 12.9983 0.21875C17.9904 0.21875 22.2192 3.82478 23.1835 8.54576H24.5898ZM12.9983 20.9911C8.00607 20.9911 3.77727 17.385 2.81298 12.6641H1.40673C0.613207 12.6641 0.412315 12.0614 0.844234 11.4688L3.29513 8.07366C3.63665 7.61161 4.16901 7.61161 4.49044 8.07366L6.95138 11.4788C7.36321 12.0614 7.17236 12.6641 6.38888 12.6641H4.93241C5.84647 16.2701 9.09089 18.9219 12.9983 18.9219C15.6802 18.9118 18.0306 17.6563 19.5373 15.6775C19.9491 15.2054 20.5418 15.0547 21.044 15.4163C21.5061 15.7478 21.5965 16.4007 21.1445 16.9531C19.2962 19.3638 16.2427 20.9911 12.9983 20.9911Z"
      fill="currentColor"
    />
  </svg>
)

export const CheckmarkDiamondIcon = (props: SVGProps) => (
  <svg {...props} width="24" xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 0 24 24" fill="none">
    <path
      fill="currentColor"
      d="M16.7551 13.6782C16.6926 13.7435 16.6095 13.7851 16.5198 13.7959C15.631 13.8924 14.8823 14.0052 14.2736 14.1342C13.6649 14.2633 13.1672 14.442 12.7805 14.6703C12.3974 14.8958 12.0781 15.2151 11.8527 15.5983C11.6209 15.9879 11.4374 16.4904 11.302 17.1059C11.1667 17.7214 11.0444 18.4833 10.9349 19.3914C10.9208 19.4807 10.8785 19.5632 10.8143 19.6268C10.7466 19.6868 10.6582 19.7178 10.5678 19.7133C10.5254 19.7154 10.4829 19.7088 10.4431 19.6939C10.4032 19.679 10.3668 19.6562 10.336 19.6268C10.2748 19.5627 10.2373 19.4797 10.2296 19.3914C10.1119 18.4829 9.98307 17.7226 9.84305 17.1106C9.70303 16.4986 9.51614 15.9992 9.28239 15.6124C9.05693 15.231 8.73907 14.9124 8.35814 14.6862C7.97456 14.4571 7.48019 14.2766 6.87501 14.1448C6.26984 14.013 5.52249 13.8953 4.63297 13.7918C4.53831 13.7822 4.44973 13.7407 4.38176 13.6741C4.35012 13.6424 4.32525 13.6046 4.30866 13.5631C4.29208 13.5215 4.28411 13.477 4.28527 13.4322C4.28411 13.3875 4.29208 13.343 4.30866 13.3014C4.32525 13.2598 4.35012 13.222 4.38176 13.1904C4.44973 13.1238 4.53831 13.0823 4.63297 13.0727C5.38559 13.0029 6.13399 12.8933 6.87501 12.7443C7.48019 12.6153 7.97771 12.4387 8.36756 12.2147C8.75416 11.9923 9.07567 11.6723 9.30003 11.2868C9.53182 10.8945 9.71715 10.3902 9.85599 9.77387C9.99483 9.15757 10.1188 8.39259 10.2278 7.47893C10.2381 7.39379 10.2755 7.31419 10.3343 7.25178C10.3642 7.22097 10.4004 7.19686 10.4403 7.18104C10.4803 7.16522 10.5231 7.15804 10.5661 7.15999C10.6112 7.15781 10.6564 7.16483 10.6987 7.18061C10.7411 7.19638 10.7798 7.2206 10.8126 7.25178C10.8743 7.31395 10.9162 7.39298 10.9332 7.47893C11.0426 8.39376 11.165 9.15874 11.3003 9.77387C11.4356 10.389 11.6192 10.8933 11.8509 11.2868C12.0747 11.6712 12.3944 11.9909 12.7787 12.2147C13.1654 12.4399 13.6631 12.6164 14.2718 12.7443C15.0143 12.8931 15.7641 13.0027 16.518 13.0727C16.6077 13.0835 16.6909 13.1251 16.7533 13.1904C16.8145 13.2558 16.8475 13.3427 16.8451 13.4322C16.8471 13.4771 16.8401 13.522 16.8247 13.5642C16.8092 13.6064 16.7856 13.6452 16.7551 13.6782ZM19.5202 6.97522C19.1625 7.02163 18.8076 7.08764 18.4571 7.17293C18.1994 7.2408 18.0045 7.33888 17.8723 7.46716C17.7405 7.59661 17.6435 7.78786 17.5823 8.04265C17.5067 8.38227 17.4503 8.72588 17.4134 9.07185C17.4068 9.19425 17.3456 9.25544 17.2299 9.25544C17.1204 9.25544 17.0559 9.1966 17.0363 9.07891C16.995 8.73618 16.9361 8.3958 16.8598 8.05913C16.7982 7.81159 16.7031 7.62486 16.5745 7.49893C16.4459 7.373 16.2527 7.27493 15.995 7.20471C15.7373 7.1341 15.383 7.05681 14.9319 6.97286C14.8096 6.94697 14.7484 6.8793 14.7484 6.76985C14.7484 6.65216 14.8096 6.58763 14.9319 6.57625C15.2886 6.52514 15.6421 6.45422 15.9909 6.36382C16.2454 6.29321 16.4355 6.19003 16.561 6.0543C16.6865 5.91856 16.78 5.72536 16.8416 5.47468C16.9028 5.22361 16.9687 4.88211 17.0393 4.45019C17.0408 4.42656 17.0471 4.40348 17.0577 4.38232C17.0684 4.36117 17.0832 4.34237 17.1012 4.32705C17.1193 4.31173 17.1402 4.30021 17.1629 4.29316C17.1855 4.28611 17.2093 4.28368 17.2328 4.28602C17.3422 4.28602 17.4034 4.34486 17.4164 4.46255C17.487 4.89408 17.5546 5.23087 17.6193 5.47291C17.6662 5.68149 17.7661 5.87444 17.9094 6.03312C18.0384 6.16571 18.23 6.26732 18.4842 6.33793C18.7383 6.40854 19.0878 6.48896 19.5325 6.57919C19.6549 6.59214 19.7161 6.65667 19.7161 6.77279C19.7161 6.88165 19.6514 6.94932 19.5231 6.97757L19.5202 6.97522Z"
    />
  </svg>
)

export const XMarkIcon = (props: SVGProps) => (
  <svg width="40" height="40" viewBox="0 0 40 40" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      fill={themeVars.colors.darkGray}
      d="M10.2706 27.2148C9.74321 27.7421 9.7181 28.6838 10.2831 29.2362C10.8356 29.7887 11.7773 29.7761 12.3046 29.2488L19.9887 21.5521L27.6855 29.2488C28.2254 29.7887 29.1545 29.7887 29.7069 29.2362C30.2468 28.6712 30.2594 27.7547 29.7069 27.2148L22.0228 19.518L29.7069 11.8339C30.2594 11.294 30.2594 10.3649 29.7069 9.81241C29.1419 9.27251 28.2254 9.25995 27.6855 9.79985L19.9887 17.4966L12.3046 9.79985C11.7773 9.27251 10.823 9.2474 10.2831 9.81241C9.73066 10.3649 9.74321 11.3065 10.2706 11.8339L17.9673 19.518L10.2706 27.2148Z"
    />
  </svg>
)

export const ArrowRightIcon = (props: SVGProps) => (
  <svg width="16" height="16" viewBox="0 0 16 16" {...props} xmlns="http://www.w3.org/2000/svg">
    <path
      d="M12.7494 7.79771C12.7494 7.64202 12.6842 7.49135 12.5686 7.38086L9.26897 4.08119C9.13839 3.95564 9.00279 3.90039 8.86216 3.90039C8.54074 3.90039 8.30971 4.1264 8.30971 4.43276C8.30971 4.59347 8.375 4.72907 8.47545 4.82952L9.60547 5.97461L11.0619 7.30552L9.89676 7.23521H3.80971C3.47321 7.23521 3.24219 7.46624 3.24219 7.79771C3.24219 8.12416 3.47321 8.35519 3.80971 8.35519H9.89676L11.0619 8.28488L9.60547 9.61579L8.47545 10.7609C8.375 10.8613 8.30971 10.9969 8.30971 11.1576C8.30971 11.464 8.54074 11.69 8.86216 11.69C9.00279 11.69 9.13839 11.6348 9.25893 11.5193L12.5686 8.20954C12.6842 8.09905 12.7494 7.94838 12.7494 7.79771Z"
      fill="currentColor"
    />
  </svg>
)

export const MinusIcon = (props: SVGProps) => (
  <svg {...props} fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M6.54562 12.5699H17.4541C17.9136 12.5699 18.3054 12.1857 18.3054 11.7111C18.3054 11.244 17.9136 10.8523 17.4541 10.8523H6.54562C6.10114 10.8523 5.69434 11.244 5.69434 11.7111C5.69434 12.1857 6.10114 12.5699 6.54562 12.5699Z"
      fill="currentColor"
    />
  </svg>
)

export const PlusIcon = (props: SVGProps) => (
  <svg {...props} fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M6.54534 12.5625H11.1408V17.1579C11.1408 17.625 11.525 18.0167 11.9996 18.0167C12.4742 18.0167 12.8584 17.625 12.8584 17.1579V12.5625H17.4538C17.9209 12.5625 18.3126 12.1783 18.3126 11.7037C18.3126 11.2291 17.9209 10.8449 17.4538 10.8449H12.8584V6.24944C12.8584 5.78237 12.4742 5.39062 11.9996 5.39062C11.525 5.39062 11.1408 5.78237 11.1408 6.24944V10.8449H6.54534C6.07826 10.8449 5.68652 11.2291 5.68652 11.7037C5.68652 12.1783 6.07826 12.5625 6.54534 12.5625Z"
      fill="currentColor"
    />
  </svg>
)

export const MinusCircleIcon = (props: SVGProps) => (
  <svg {...props} width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M25.9972 16.101C25.9972 21.5098 21.5205 25.9872 16.101 25.9872C10.6919 25.9872 6.21484 21.5101 6.21484 16.101C6.21484 10.6913 10.6825 6.21484 16.091 6.21484C21.5111 6.21484 25.9972 10.6928 25.9972 16.101Z"
      fill="#F95E14"
      stroke="white"
    />
    <path
      d="M11.4277 16.0118C11.4277 16.716 11.9415 17.1431 12.6608 17.1431H19.349C20.0682 17.1431 20.5706 16.716 20.5706 16.0118C20.5706 15.3076 20.0911 14.8574 19.349 14.8574H12.6608C11.9187 14.8574 11.4277 15.3076 11.4277 16.0118Z"
      fill="white"
    />
  </svg>
)

export const ExternalIcon = (props: SVGProps) => (
  <svg {...props} viewBox="0 0 28 28" xmlns="http://www.w3.org/2000/svg">
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M4.91993 13.9991C4.91993 18.9722 9.03078 23.0758 13.9946 23.0782C13.9953 23.0782 13.9959 23.0782 13.9966 23.0782C13.997 23.0782 13.9974 23.0782 13.9978 23.0782C13.9982 23.0782 13.9986 23.0782 13.999 23.0782C13.9997 23.0782 14.0003 23.0782 14.001 23.0782C18.9648 23.0758 23.0757 18.9722 23.0757 13.9991C23.0757 9.43823 19.5985 5.59653 15.1841 5.00029C14.8058 4.94735 14.4136 4.92 14.0078 4.92C14.0045 4.92 14.0011 4.92 13.9978 4.92C13.9945 4.92 13.9911 4.92 13.9878 4.92C9.36477 4.92 5.49758 8.47078 4.97903 12.9708C4.97912 12.9708 4.97921 12.9707 4.9793 12.9707C4.94009 13.3086 4.91993 13.6518 4.91993 13.9991ZM18.4807 13.3839L18.4814 13.3663C18.4375 12.2764 18.2969 11.2745 18.0596 10.3692C18.7499 10.1516 19.3569 9.87637 19.8424 9.55441C19.9241 9.50192 20.0028 9.4483 20.0786 9.39363C20.9488 10.5186 21.52 11.8985 21.6343 13.3839H18.4807ZM17.2222 14.6143H14.6143V17.0928C14.6176 17.093 14.6211 17.0931 14.6245 17.0933C15.3934 17.1203 16.1361 17.2166 16.8267 17.3477C17.0464 16.5128 17.187 15.5899 17.2222 14.6143ZM14.6232 18.3238C14.6707 18.3262 14.7263 18.3287 14.7883 18.3313C15.3825 18.3611 15.9463 18.4207 16.4663 18.5167C15.9922 19.7809 15.3428 20.7031 14.6143 21.0468V18.3234C14.6172 18.3235 14.6202 18.3237 14.6232 18.3238ZM16.2881 21.304C16.2563 21.3075 16.2267 21.311 16.1996 21.3145C16.7877 20.7176 17.3063 19.8565 17.688 18.8155C18.3032 19.0089 18.8218 19.2462 19.2525 19.545C18.4189 20.3445 17.4042 20.9548 16.2881 21.304ZM13.3814 18.3234V21.0468C12.6529 20.7031 12.0034 19.7809 11.5293 18.5167C12.0999 18.4113 12.7231 18.3498 13.3814 18.3234ZM13.3814 14.6143H10.7734C10.8086 15.5899 10.9492 16.5128 11.1689 17.3477C11.8595 17.2166 12.6022 17.1203 13.3711 17.0933C13.3746 17.0931 13.378 17.093 13.3814 17.0928V14.6143ZM9.51492 13.3839H6.36133C6.47559 11.8985 7.04688 10.5186 7.917 9.39363C7.99279 9.4483 8.07156 9.50191 8.15322 9.5544C8.6387 9.87637 9.24574 10.1516 9.93606 10.3692C9.69875 11.2745 9.55813 12.2764 9.51418 13.3663L9.51492 13.3839ZM18.631 8.85777C18.8652 8.74186 19.0785 8.61524 19.27 8.47957C18.4126 7.63961 17.3548 7.0174 16.166 6.66499C16.7786 7.26197 17.3125 8.138 17.7069 9.22351C17.7978 9.1952 17.8866 9.16558 17.9734 9.13471C18.2063 9.04964 18.4255 8.95751 18.631 8.85777ZM10.2888 9.22351C10.6831 8.138 11.217 7.26197 11.8296 6.66499C10.6408 7.0174 9.58305 7.63961 8.72559 8.47957C8.91713 8.61524 9.13042 8.74186 9.36462 8.85777C9.57011 8.95752 9.78933 9.04965 10.0223 9.13472C10.109 9.16559 10.1979 9.1952 10.2888 9.22351ZM14.6143 6.96014V9.71873C15.2726 9.69231 15.9045 9.63081 16.4839 9.52547C16.0098 8.23491 15.3428 7.28636 14.6143 6.96014ZM13.3814 6.96014C12.6528 7.28636 11.9858 8.23491 11.5117 9.52547C12.0911 9.63081 12.7231 9.69231 13.3814 9.71873V6.96014ZM17.2222 13.3839C17.1871 12.4267 17.0467 11.5046 16.836 10.6878C16.1446 10.8272 15.3925 10.9231 14.6143 10.9493V13.3839H17.2222ZM13.3814 13.3839V10.9493C12.6031 10.9231 11.851 10.8272 11.1596 10.6878C10.949 11.5046 10.8086 12.4267 10.7734 13.3839H13.3814ZM9.52539 14.6143C9.56055 15.7218 9.70996 16.7501 9.94727 17.6641C9.14746 17.919 8.46192 18.2442 7.94336 18.6397C7.05567 17.5059 6.47559 16.1173 6.36133 14.6143H9.52539ZM10.3076 18.8155C10.6943 19.8702 11.2217 20.7403 11.8193 21.338C10.6592 20.9952 9.6045 20.3712 8.74317 19.545C9.17383 19.2462 9.69239 19.0089 10.3076 18.8155ZM18.4702 14.6143C18.4351 15.7218 18.2857 16.7501 18.0484 17.6641C18.8482 17.919 19.5337 18.2442 20.0523 18.6397C20.94 17.5059 21.52 16.1173 21.6343 14.6143H18.4702Z"
      fill={props.fill}
    />
  </svg>
)

export const InstagramIcon = (props: SVGProps) => (
  <svg role="img" viewBox="-3 -3 23 23" xmlns="http://www.w3.org/2000/svg" {...props} fill="none">
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M4.16295 0.285156H11.2695C13.5526 0.285156 15.4305 2.17023 15.4305 4.45603V11.5429C15.4305 13.8313 13.5499 15.7137 11.2695 15.7137H4.16295C1.87988 15.7137 0.00195312 13.8313 0.00195312 11.5429V4.45603C0.00195312 2.16754 1.87988 0.285156 4.16295 0.285156ZM11.859 2.97813C12.0924 2.98133 12.3154 3.0757 12.4804 3.24117C12.6455 3.40663 12.7397 3.63013 12.7429 3.86411C12.7395 4.098 12.6453 4.32136 12.4803 4.48671C12.3152 4.65206 12.0923 4.74636 11.859 4.74956C11.7425 4.75115 11.6269 4.72934 11.519 4.68542C11.4111 4.64149 11.313 4.57634 11.2306 4.49381C11.1482 4.41127 11.0832 4.31303 11.0393 4.20488C10.9954 4.09673 10.9736 3.98086 10.9751 3.86411C10.9735 3.74732 10.9953 3.63139 11.0391 3.52318C11.083 3.41497 11.148 3.31666 11.2304 3.23407C11.3128 3.15147 11.4109 3.08628 11.5188 3.04232C11.6268 2.99836 11.7425 2.97653 11.859 2.97813ZM7.69797 3.79409H7.73451C10.0176 3.79409 11.9326 5.71364 11.9326 8.00213C11.9326 10.3278 10.0176 12.2102 7.73451 12.2102H7.69797C5.4149 12.2102 3.53698 10.3278 3.53698 8.00213C3.53698 5.71364 5.4149 3.79409 7.69797 3.79409ZM7.69797 5.23376H7.73451C9.24438 5.23376 10.4963 6.48867 10.4963 8.00213C10.4963 9.5522 9.24438 10.8071 7.73451 10.8071H7.69797C6.1881 10.8071 4.93615 9.5522 4.93615 8.00213C4.93615 6.48867 6.1881 5.23376 7.69797 5.23376ZM4.19949 1.61386H11.233C11.9945 1.61486 12.7245 1.91856 13.2629 2.45834C13.8013 2.99811 14.1041 3.7299 14.105 4.49319V11.5062C14.104 12.2694 13.8011 13.0011 13.2627 13.5407C12.7243 14.0804 11.9944 14.384 11.233 14.385H4.19949C3.4381 14.384 2.70818 14.0804 2.1698 13.5407C1.63141 13.0011 1.32852 12.2694 1.32752 11.5062V4.49427C1.32837 3.73098 1.63121 2.99919 2.16961 2.45942C2.70801 1.91964 3.43801 1.61594 4.19949 1.61494V1.61386Z"
      fill={props.fill}
    />
  </svg>
)

export const EllipsisIcon = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M10 10.8334C10.4603 10.8334 10.8334 10.4603 10.8334 10C10.8334 9.53978 10.4603 9.16669 10 9.16669C9.5398 9.16669 9.16671 9.53978 9.16671 10C9.16671 10.4603 9.5398 10.8334 10 10.8334Z"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M15.8334 10.8334C16.2936 10.8334 16.6667 10.4603 16.6667 10C16.6667 9.53978 16.2936 9.16669 15.8334 9.16669C15.3731 9.16669 15 9.53978 15 10C15 10.4603 15.3731 10.8334 15.8334 10.8334Z"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M4.16671 10.8334C4.62694 10.8334 5.00004 10.4603 5.00004 10C5.00004 9.53978 4.62694 9.16669 4.16671 9.16669C3.70647 9.16669 3.33337 9.53978 3.33337 10C3.33337 10.4603 3.70647 10.8334 4.16671 10.8334Z"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
)

export const ChevronRightIcon = (props: SVGProps) => (
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" {...props} xmlns="http://www.w3.org/2000/svg">
    <path
      fill="currentColor"
      d="M11.2294 7.80246C11.2243 7.62667 11.159 7.476 11.0234 7.3404L7.11607 3.51842C7.00056 3.40792 6.86496 3.34766 6.69922 3.34766C6.36272 3.34766 6.10156 3.60882 6.10156 3.94531C6.10156 4.10603 6.16685 4.2567 6.28237 4.37221L9.79799 7.80246L6.28237 11.2327C6.16685 11.3482 6.10156 11.4939 6.10156 11.6596C6.10156 11.9961 6.36272 12.2573 6.69922 12.2573C6.85993 12.2573 7.00056 12.197 7.11607 12.0865L11.0234 8.25949C11.1641 8.12891 11.2294 7.97824 11.2294 7.80246Z"
    />
  </svg>
)

export const WalletChainIcon = (props: SVGProps) => (
  <svg {...props} width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M12.0008 19.4939C16.2573 19.4939 19.7829 15.9757 19.7829 11.7118C19.7829 7.45536 16.2573 3.92969 11.9933 3.92969C7.73689 3.92969 4.21875 7.45536 4.21875 11.7118C4.21875 15.9757 7.74442 19.4939 12.0008 19.4939ZM6.7952 10.9358C6.7952 9.65513 7.71429 8.72852 8.99498 8.72852H12.1892C13.4623 8.72852 14.3814 9.65513 14.3814 10.9358C14.3814 12.2165 13.4699 13.1281 12.1892 13.1281H11.2023C10.9537 12.9021 10.916 12.4877 11.014 12.2467H12.1515C12.9275 12.2467 13.4623 11.7193 13.4623 10.9358C13.4623 10.1523 12.9275 9.60993 12.1515 9.60993H9.04018C8.26423 9.60993 7.72182 10.1523 7.72182 10.9358C7.72182 11.7193 8.2567 12.2467 9.04018 12.2467H9.18332C9.14565 12.5179 9.16825 12.9021 9.22098 13.1281H8.99498C7.70675 13.1281 6.7952 12.2165 6.7952 10.9358ZM9.60519 12.5555C9.60519 11.2748 10.5167 10.3633 11.7974 10.3633H12.7843C13.0405 10.5742 13.0706 11.0112 12.9651 11.2447H11.8351C11.0592 11.2447 10.5243 11.772 10.5243 12.5555C10.5243 13.339 11.0592 13.8814 11.8351 13.8814H14.9464C15.7299 13.8814 16.2648 13.339 16.2648 12.5555C16.2648 11.772 15.7299 11.2447 14.9464 11.2447H14.8033C14.8485 10.853 14.8033 10.5818 14.7656 10.3633H14.9916C16.2799 10.3633 17.1914 11.2748 17.1914 12.5555C17.1914 13.8437 16.2723 14.7628 14.9916 14.7628H11.7974C10.5243 14.7628 9.60519 13.8437 9.60519 12.5555Z"
      fill="#70757A"
    />
  </svg>
)

export const NewTabIcon = (props: SVGProps) => (
  <svg {...props} width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M15.8828 8.50811C15.8828 8.9492 15.6132 9.25144 15.2048 9.25144C14.7964 9.25144 14.5268 8.96554 14.5268 8.51628V6.02762L14.6493 6.0494L13.5548 7.23383L10.704 10.0846C10.5569 10.2317 10.3772 10.3133 10.1485 10.3133C9.73192 10.3133 9.42969 10.0274 9.42969 9.58634C9.42969 9.3903 9.51954 9.20243 9.6584 9.06356L12.5174 6.20461L13.7181 5.10186L13.5758 5.23256H11.2349C10.7857 5.23256 10.4916 4.97117 10.4916 4.55458C10.4916 4.14616 10.7857 3.88477 11.2267 3.88477H15.0496C15.5642 3.88477 15.8828 4.13799 15.8828 4.70978V8.50811Z"
      fill={themeVars.colors.darkGray}
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M9.28446 3.89648H6.19434C4.83831 3.89648 4.12891 4.59333 4.12891 5.94308V13.5833C4.12891 14.9268 4.83831 15.6299 6.19434 15.6299H13.7969C15.1592 15.6299 15.8623 14.9268 15.8623 13.5833V10.4293H14.613V13.4703C14.613 14.0792 14.2866 14.3806 13.7153 14.3806H6.27595C5.69838 14.3806 5.37821 14.0792 5.37821 13.4703V6.05608C5.37821 5.44713 5.69838 5.14579 6.27595 5.14579H9.28446V3.89648Z"
      fill={themeVars.colors.darkGray}
    />
  </svg>
)

export const LightningBoltIcon = (props: SVGProps) => (
  <svg {...props} width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M6.51562 12.6003C6.51562 12.9092 6.7567 13.1427 7.08817 13.1427H11.4576L9.15988 19.3126C8.851 20.1338 9.70229 20.5707 10.2447 19.9078L17.281 11.1991C17.4166 11.0258 17.4844 10.8676 17.4844 10.6943C17.4844 10.3779 17.2433 10.1519 16.9118 10.1519H12.5424L14.8401 3.97447C15.149 3.15332 14.2977 2.71638 13.7553 3.38686L6.72656 12.0956C6.59096 12.2613 6.51562 12.4195 6.51562 12.6003Z"
      fill="#FB118E"
    />
    <defs>
      <linearGradient
        id="paint0_linear_1845_11847"
        x1="17.4844"
        y1="3.05859"
        x2="1.90385"
        y2="13.0107"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#4673FA" />
        <stop offset="1" stopColor="#9646FA" />
      </linearGradient>
    </defs>
  </svg>
)

export const DownloadIcon = (props: SVGProps) => (
  <svg {...props} width="26" height="26" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M23.5205 21.8955L23.5205 9.53516C23.5205 7.6543 22.5361 6.67871 20.6377 6.67871L16.6826 6.67871L16.6826 8.40137L20.5322 8.40137C21.3496 8.40137 21.7979 8.83203 21.7979 9.68457L21.7979 21.7549C21.7979 22.6074 21.3496 23.0293 20.5322 23.0293L7.48047 23.0293C6.66309 23.0293 6.21484 22.6074 6.21484 21.7549L6.21485 9.68457C6.21485 8.83203 6.66309 8.40137 7.48047 8.40137L11.3389 8.40137L11.3389 6.67871L7.375 6.67871C5.48535 6.67871 4.49219 7.6543 4.49219 9.53516L4.49219 21.8955C4.49219 23.7764 5.48535 24.752 7.375 24.752L20.6377 24.752C22.5361 24.752 23.5205 23.7764 23.5205 21.8955Z"
      fill="#4673FA"
    />
    <path
      d="M12.9352 3.03756L12.9352 14.5305L13.0162 16.218L12.2986 15.3856L10.6782 13.6868C10.4931 13.4816 10.2269 13.3675 9.96065 13.3675C9.43982 13.3675 9 13.7552 9 14.2797C9 14.5533 9.11574 14.7586 9.3125 14.9524L13.1898 18.6465C13.4676 18.9088 13.7222 19 14 19C14.2778 19 14.5324 18.9088 14.8102 18.6465L18.6991 14.9524C18.8958 14.7586 19 14.5533 19 14.2797C19 13.7552 18.5833 13.3675 18.0509 13.3675C17.7963 13.3675 17.5185 13.4816 17.3333 13.6868L15.7014 15.3856L14.9838 16.2294L15.0764 14.5305L15.0764 3.03756C15.0764 2.47887 14.5903 2 14 2C13.4097 2 12.9352 2.47887 12.9352 3.03756Z"
      fill="#4673FA"
    />
  </svg>
)

export const SweepIcon = (props: SVGProps) => (
  <svg {...props} width="23" height="23" viewBox="0 0 23 23" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M22.5957 4.81261C22.8834 5.10528 23.0178 5.41067 22.9989 5.72877C22.98 6.04687 22.8004 6.354 22.46 6.65017L15.1344 13.1029L13.2046 11.1637L19.6611 3.84484C19.9593 3.5078 20.2663 3.32781 20.5824 3.30487C20.8984 3.28194 21.2018 3.41655 21.4925 3.70872L22.5957 4.81261Z"
      fill="white"
    />
    <path
      d="M14.5252 14.1402C14.7538 14.3706 14.8683 14.6161 14.8688 14.8769C14.8693 15.1376 14.7582 15.3795 14.5356 15.6023L14.2375 15.8955C14.0118 16.1224 13.7723 16.2338 13.5189 16.2298C13.2655 16.2258 13.0227 16.1091 12.7907 15.8798L10.2564 13.3317C10.0238 13.0984 9.90678 12.8538 9.90529 12.5981C9.9038 12.3423 10.0156 12.1012 10.2407 11.8749L10.5277 11.5817C10.7498 11.3588 10.9901 11.2466 11.2485 11.2451C11.5069 11.2436 11.7523 11.3593 11.9849 11.5922L14.5252 14.1402Z"
      fill="white"
    />
    <path
      d="M6.54973 15.645C6.5695 15.6425 6.58747 15.6323 6.5997 15.6165C6.61193 15.6007 6.61742 15.5807 6.61495 15.5609C6.61248 15.541 6.60225 15.523 6.58653 15.5107C6.5708 15.4985 6.55086 15.493 6.53109 15.4954C6.35891 15.4954 5.1402 15.4954 4.15406 15.3773C3.30371 15.2745 2.46362 15.0994 1.64286 14.8538C1.60087 14.8372 1.56568 14.8069 1.54298 14.7677C1.25974 14.0415 1.17029 13.5225 1.02122 12.8547C0.982456 12.7215 0.978729 12.6011 1.08159 12.4949C1.18446 12.3887 1.31713 12.3925 1.45056 12.4343C3.00916 12.9197 4.42613 13.2428 6.05106 13.4171C7.49338 13.5719 8.92899 13.5614 10.3467 13.2084C10.4137 13.1821 10.4835 13.1636 10.5547 13.1531L13.0487 15.3922C13.0487 15.5126 13.0487 15.5111 13.0487 15.6301C13.0398 16.6272 12.9814 17.6244 12.8736 18.6216C12.8009 19.326 12.6853 20.0254 12.5277 20.7157C12.3943 21.2878 12.2296 21.928 11.9448 22.4478C11.7823 22.7425 11.5334 22.8479 11.2061 22.7814C10.6657 22.7118 10.0299 22.6273 9.66767 22.4471C10.2275 21.6655 10.6866 20.4988 10.9684 19.5266C11.0618 19.1816 11.1379 18.8321 11.1965 18.4795C11.2023 18.4604 11.2003 18.4397 11.1909 18.422C11.1816 18.4043 11.1656 18.3911 11.1465 18.3853C11.1274 18.3794 11.1068 18.3814 11.0892 18.3908C11.0716 18.4002 11.0584 18.4162 11.0526 18.4354C10.8469 18.9051 10.5308 19.5841 10.1976 20.1727C9.8488 20.7845 8.56674 22.1075 8.33418 21.9811C7.17659 21.501 6.26499 20.967 5.36755 20.1929C5.35488 20.1824 6.56836 19.5198 7.50084 18.9215C7.75278 18.7592 9.05496 17.6636 9.28976 17.3293C9.29671 17.3222 9.30221 17.3139 9.30595 17.3047C9.3097 17.2956 9.3116 17.2858 9.31157 17.2759C9.31153 17.266 9.30956 17.2562 9.30575 17.2471C9.30194 17.2379 9.29638 17.2296 9.28939 17.2227C9.28239 17.2157 9.27409 17.2102 9.26496 17.2064C9.25583 17.2027 9.24606 17.2008 9.2362 17.2008C9.22633 17.2008 9.21658 17.2028 9.20748 17.2066C9.19838 17.2105 9.19012 17.216 9.18317 17.2231L9.10863 17.2777C8.55034 17.674 7.2802 18.2858 6.14648 18.656C5.59735 18.8275 5.03372 18.9482 4.46265 19.0165C4.15183 19.0344 4.14288 19.0255 3.90659 18.7846C3.1141 17.9679 2.48015 17.0103 2.03717 15.9606C2.02152 15.9374 3.37886 16.0294 4.58862 15.9606C5.25025 15.913 5.90645 15.8074 6.54973 15.645Z"
      fill="currentColor"
    />
    <path
      d="M8.03215 3.20189C7.96945 2.92219 7.91547 2.70033 7.87341 2.53869C7.83915 2.39971 7.77253 2.27076 7.67895 2.16232C7.57558 2.06162 7.4479 1.98929 7.30829 1.95235C7.1432 1.90085 6.91144 1.84538 6.61856 1.78596C6.53919 1.76773 6.49633 1.72574 6.49633 1.65918C6.49528 1.64336 6.49773 1.62748 6.50349 1.6127C6.50925 1.59792 6.51818 1.58457 6.52966 1.5736C6.55489 1.55175 6.58564 1.53723 6.61856 1.53162C6.85148 1.48841 7.08176 1.43207 7.30829 1.36285C7.44771 1.32418 7.57517 1.25116 7.67895 1.15049C7.77253 1.04206 7.83915 0.913108 7.87341 0.774127C7.91944 0.611431 7.97236 0.391955 8.03215 0.11569C8.04723 0.0364546 8.08771 0 8.15438 0C8.22105 0 8.26312 0.0388317 8.28217 0.11569C8.3409 0.391955 8.39381 0.611431 8.44091 0.774127C8.47622 0.913188 8.54363 1.04208 8.63774 1.15049C8.74183 1.25117 8.86954 1.32418 9.0092 1.36285C9.23565 1.43236 9.46594 1.48871 9.69893 1.53162C9.73114 1.53346 9.76134 1.54787 9.78302 1.57173C9.80469 1.59559 9.81611 1.627 9.81481 1.65918C9.81481 1.72574 9.77592 1.76773 9.69893 1.78596C9.46636 1.8298 9.23616 1.88534 9.0092 1.95235C8.86936 1.9893 8.74142 2.06162 8.63774 2.16232C8.54363 2.27074 8.47622 2.39963 8.44091 2.53869C8.39249 2.69716 8.33931 2.92219 8.28217 3.20189C8.26312 3.28112 8.22105 3.31836 8.15438 3.31836C8.08771 3.31836 8.04564 3.27954 8.03215 3.20189Z"
      fill="currentColor"
    />
    <path
      d="M12.3409 5.87055C12.2751 5.52982 12.2134 5.25823 12.1576 5.05662C12.1161 4.88332 12.0332 4.72267 11.9161 4.58843C11.7866 4.46353 11.6275 4.37354 11.4538 4.32685C11.1741 4.24532 10.8898 4.18022 10.6025 4.1319C10.5017 4.1169 10.4509 4.06442 10.4509 3.97528C10.4498 3.955 10.4529 3.93472 10.4599 3.91566C10.4669 3.89661 10.4777 3.8792 10.4917 3.86448C10.5223 3.83612 10.5611 3.81806 10.6025 3.81283C10.8896 3.76432 11.1738 3.70007 11.4538 3.62038C11.6283 3.57572 11.7879 3.48545 11.9161 3.3588C12.0329 3.22336 12.1157 3.06199 12.1576 2.8881C12.2134 2.6865 12.2751 2.41491 12.3409 2.07334C12.3412 2.05339 12.3455 2.03371 12.3536 2.01549C12.3618 1.99727 12.3735 1.98089 12.3881 1.96734C12.4028 1.95378 12.42 1.94335 12.4388 1.93665C12.4576 1.92996 12.4776 1.92714 12.4975 1.92839C12.5808 1.92839 12.6349 1.9767 12.6549 2.07334C12.721 2.41491 12.7821 2.6865 12.8381 2.8881C12.8793 3.0616 12.9609 3.22289 13.0764 3.3588C13.204 3.4861 13.3638 3.57648 13.5386 3.62038C13.8198 3.69992 14.1051 3.76416 14.3933 3.81283C14.4144 3.81297 14.4352 3.8175 14.4545 3.82613C14.4738 3.83476 14.4911 3.84732 14.5053 3.86298C14.5194 3.87865 14.5302 3.89709 14.5369 3.91714C14.5436 3.93719 14.546 3.95841 14.544 3.97945C14.544 4.06859 14.494 4.12107 14.3933 4.13607C14.1049 4.18455 13.8195 4.24963 13.5386 4.33101C13.3646 4.37691 13.2053 4.46702 13.0764 4.5926C12.9606 4.72734 12.8789 4.88791 12.8381 5.06079C12.7826 5.2624 12.7215 5.53371 12.6549 5.87472C12.6349 5.97219 12.5833 6.02051 12.4975 6.02051C12.4772 6.02165 12.4568 6.0186 12.4378 6.01156C12.4187 6.00452 12.4013 5.99363 12.3866 5.97957C12.3719 5.9655 12.3603 5.94856 12.3524 5.92981C12.3445 5.91105 12.3406 5.89088 12.3409 5.87055Z"
      fill="currentColor"
    />
    <path
      d="M6.68457 11.7993C6.65283 11.8001 6.62123 11.7946 6.59165 11.783C6.56206 11.7715 6.53508 11.7541 6.51227 11.732C6.46495 11.6861 6.43286 11.6267 6.42032 11.5619C6.33379 11.0466 6.24828 10.6157 6.1638 10.2694C6.09886 9.97221 5.99165 9.68585 5.84546 9.41909C5.72369 9.205 5.5492 9.02565 5.3386 8.89806C5.08255 8.75332 4.80501 8.65049 4.51649 8.59348C4.17806 8.51773 3.75567 8.44583 3.24932 8.3778C3.18053 8.37018 3.11658 8.33874 3.06852 8.28891C3.02398 8.24144 2.99961 8.17853 3.00052 8.11343C2.99944 8.04831 3.02384 7.98533 3.06852 7.93795C3.11638 7.88786 3.18044 7.85636 3.24932 7.84905C3.75619 7.78412 4.17935 7.713 4.5188 7.63569C4.81087 7.57587 5.09204 7.47158 5.3525 7.32648C5.56664 7.20036 5.74549 7.02222 5.87251 6.80855C6.0212 6.54514 6.12856 6.26043 6.19084 5.9644C6.27171 5.61859 6.34898 5.18672 6.42264 4.66879C6.43207 4.60298 6.46337 4.54226 6.5115 4.49641C6.53457 4.47357 6.56197 4.45559 6.59209 4.4435C6.62221 4.43142 6.65444 4.42549 6.68689 4.42606C6.71949 4.4249 6.752 4.43026 6.78251 4.44181C6.81302 4.45335 6.84093 4.47086 6.8646 4.49331C6.9118 4.53934 6.94388 4.59867 6.95655 4.66338C7.04618 5.18132 7.13323 5.61318 7.21771 5.95899C7.28349 6.25595 7.39065 6.5422 7.53605 6.80933C7.65852 7.02267 7.83287 7.20162 8.04291 7.32958C8.29831 7.47496 8.57494 7.57931 8.86271 7.63879C9.19959 7.71609 9.6212 7.78721 10.1276 7.85215C10.1964 7.85945 10.2605 7.89095 10.3084 7.94105C10.3528 7.98851 10.3769 8.05149 10.3756 8.11652C10.3765 8.18217 10.3525 8.24572 10.3084 8.29432C10.2615 8.34542 10.1967 8.37643 10.1276 8.3809C9.7006 8.41009 9.27569 8.46403 8.85498 8.54246C8.56063 8.59403 8.27716 8.69518 8.01664 8.84162C7.79886 8.97348 7.61932 9.16002 7.49587 9.38275C7.34879 9.65617 7.24258 9.9497 7.18062 10.254C7.09924 10.6085 7.02454 11.0448 6.95655 11.5627C6.94854 11.6294 6.918 11.6913 6.87001 11.7382C6.8447 11.7602 6.81526 11.7769 6.78343 11.7874C6.75159 11.7978 6.71799 11.8019 6.68457 11.7993Z"
      fill="currentColor"
    />
  </svg>
)

export const RefreshIcon = (props: SVGProps) => (
  <svg {...props} width="22" height="19" viewBox="0 0 22 19" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M21.2734 8.59961H20.0429C19.5244 4.14355 15.6572 0.566406 10.999 0.566406C8.4238 0.566406 6.08591 1.69141 4.46872 3.44922C4.03805 3.87109 4.05563 4.43359 4.40719 4.75879C4.76755 5.09277 5.2861 5.09277 5.72555 4.68848C7.03512 3.27344 8.91598 2.38574 10.999 2.38574C14.708 2.38574 17.705 5.10156 18.206 8.59961H16.8613C16.1845 8.59961 16 9.10059 16.3955 9.64551L18.4961 12.6162C18.8213 13.0557 19.3134 13.0645 19.6299 12.6162L21.7392 9.6543C22.1347 9.10059 21.959 8.59961 21.2734 8.59961ZM0.724578 10.7178H1.96384C2.48239 15.1738 6.34958 18.751 10.999 18.751C13.5918 18.751 15.9297 17.6172 17.5468 15.8594C17.9687 15.4375 17.9511 14.875 17.5996 14.5498C17.2392 14.2158 16.7295 14.2158 16.2812 14.6289C14.9892 16.0439 13.1084 16.9316 10.999 16.9316C7.2988 16.9316 4.30173 14.2158 3.80075 10.7178H5.13669C5.80466 10.7178 5.99801 10.2168 5.60251 9.67188L3.49313 6.70117C3.17673 6.26172 2.68454 6.25293 2.36813 6.70117L0.258757 9.66309C-0.14554 10.2168 0.0390307 10.7178 0.724578 10.7178Z"
      fill={themeVars.colors.darkGray}
    />
  </svg>
)

export const CopyIcon = (props: SVGProps) => (
  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M9.97414 3.125C11.0259 3.125 11.842 3.24608 12.4397 3.83995C12.931 4.33285 13.0873 4.9837 13.125 5.80608H11.9822C11.9543 5.34283 11.8567 4.93753 11.6006 4.67599C11.2788 4.35887 10.7328 4.27815 10.1351 4.27815H6.76732C6.15811 4.27815 5.60637 4.35887 5.29027 4.67599C4.97417 4.9931 4.89371 5.54085 4.89371 6.15202V9.5003C4.89371 10.0999 4.97417 10.6419 5.29027 10.959C5.54809 11.2177 5.96268 11.3229 6.43111 11.3529V12.5C5.60751 12.4618 4.94982 12.3011 4.45117 11.8008C3.8592 11.2127 3.75 10.3998 3.75 9.33886V6.28463C3.75 5.24103 3.8592 4.42806 4.45117 3.83995C5.04314 3.24608 5.85925 3.125 6.89951 3.125H9.97414Z"
      fill={themeVars.colors.darkGray}
    />
    <path
      d="M16.186 7.58333C15.5939 6.99496 14.7853 6.875 13.7433 6.875H10.6203C9.5897 6.875 8.78115 6.99496 8.19467 7.58333C7.60819 8.16599 7.5 8.97144 7.5 10.0054V13.1082C7.5 14.1593 7.60819 14.9647 8.19467 15.5474C8.78115 16.1358 9.5897 16.25 10.6317 16.25H13.7433C14.7853 16.25 15.5995 16.1358 16.186 15.5474C16.7668 14.959 16.875 14.1593 16.875 13.1082V10.0225C16.875 8.97144 16.7668 8.16599 16.186 7.58333ZM15.7419 9.86257V13.2681C15.7419 13.8622 15.6679 14.3992 15.3547 14.7134C15.0358 15.0333 14.4949 15.1132 13.9027 15.1132H10.478C9.88578 15.1132 9.33916 15.0276 9.02599 14.7134C8.71282 14.3992 8.63311 13.8622 8.63311 13.2681V9.87399C8.63311 9.26848 8.71282 8.72581 9.02599 8.41163C9.33916 8.09745 9.88579 8.01747 10.4893 8.01747H13.9027C14.4949 8.01747 15.0358 8.09745 15.3547 8.41163C15.6679 8.73152 15.7419 9.26848 15.7419 9.86257Z"
      fill={themeVars.colors.darkGray}
    />
  </svg>
)

export const GenieIcon = (props: SVGProps) => (
  <svg width="26" height="27" viewBox="0 0 26 27" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M12.4139 22.6564C12.3136 22.0742 12.1897 21.4942 12.0423 20.9166C12.0246 20.8469 12.0064 20.7773 11.9877 20.7079C11.8917 20.346 11.7863 19.987 11.6717 19.6308C11.6574 19.5868 11.6417 19.5429 11.6225 19.4995C11.5676 19.366 11.4966 19.2397 11.4111 19.1235C11.4062 19.1166 11.4013 19.1097 11.3959 19.1033C11.2634 18.9273 11.0994 18.7777 10.9122 18.6622L10.9073 18.6592L10.8773 18.6419L10.8576 18.6306L9.84504 18.0434L9.83717 18.039L9.81358 18.0252L9.80522 18.0207L9.76786 17.999L9.75557 17.9921L9.72952 17.9798C9.70543 17.9669 9.68036 17.9551 9.65579 17.9438L9.60073 17.9201C9.57763 17.9107 9.55404 17.9013 9.53093 17.8929C9.50783 17.8845 9.48866 17.8781 9.46752 17.8712L9.40755 17.853L9.3348 17.8342L9.26598 17.8189L9.23551 17.8125C9.01919 17.7732 8.79745 17.7749 8.58174 17.8174C8.20619 17.8977 7.83425 17.9877 7.46591 18.0873C7.3966 18.1056 7.3273 18.1248 7.25848 18.1441C6.32927 18.403 5.41822 18.7237 4.53133 19.1038C4.32685 19.1909 4.12433 19.2814 3.92377 19.3752C3.38732 19.6245 2.863 19.8946 2.3508 20.1854C2.75059 20.8221 3.20504 21.4226 3.70896 21.9799L3.71929 21.9918L3.72863 22.0021L3.73256 22.0066L3.73895 22.0135L3.7591 22.0357L3.76205 22.0386L3.76647 22.0436C3.81575 22.0962 3.86829 22.1456 3.92377 22.1916C4.13027 22.3624 4.37258 22.484 4.63256 22.5474C4.89254 22.6108 5.16345 22.6143 5.42498 22.5577L5.43825 22.5543C5.47217 22.5469 5.50559 22.5385 5.53951 22.5286L5.56016 22.5222C5.59014 22.5128 5.62013 22.5034 5.65011 22.4926L5.80348 22.425L5.86197 22.3993C6.38236 22.174 6.91472 21.9724 7.45903 21.7944C7.80934 21.6799 8.16441 21.5758 8.52423 21.4821C8.62549 21.8373 8.71413 22.1959 8.79016 22.5577C8.79016 22.5641 8.79262 22.57 8.79409 22.5765C8.7995 22.6021 8.80491 22.6258 8.80982 22.6539C8.91829 23.1802 9.00366 23.7098 9.06592 24.2427C9.07526 24.3217 9.08411 24.4006 9.09197 24.4801C9.11852 24.6337 9.16547 24.7831 9.23158 24.9242C9.34505 25.166 9.51128 25.3792 9.71797 25.5478C9.92466 25.7164 10.1665 25.8361 10.4256 25.8982C10.5371 25.9228 10.6487 25.9475 10.7613 25.9677C11.4113 26.0943 12.0702 26.17 12.7319 26.1942C12.7247 25.451 12.6804 24.7086 12.5992 23.9699C12.5504 23.533 12.4886 23.0952 12.4139 22.6564Z"
      fill="currentColor"
    />
    <path
      d="M13.6969 26.1995C14.4728 26.1712 15.2447 26.0721 16.0027 25.9034C16.3381 25.8243 16.6431 25.6483 16.88 25.3971C17.1169 25.146 17.2754 24.8307 17.3358 24.4903C17.3417 24.433 17.3481 24.3763 17.3545 24.3195C17.357 24.2954 17.3594 24.2702 17.3624 24.2475C17.3712 24.169 17.382 24.0906 17.3924 24.0121C17.4514 23.5598 17.5267 23.1085 17.6185 22.6582C17.6254 22.6261 17.6318 22.594 17.6386 22.562C17.7153 22.2001 17.803 21.8396 17.9016 21.4804C18.2621 21.5738 18.6172 21.6779 18.9668 21.7927L19.0386 21.8169C19.4079 21.9393 19.7718 22.0727 20.1303 22.2171L20.1716 22.2334C20.2252 22.2551 20.2778 22.2778 20.3309 22.3C20.41 22.333 20.4892 22.3651 20.5673 22.3986C20.6371 22.4289 20.7066 22.4595 20.7757 22.4904C20.7974 22.4983 20.819 22.5047 20.8406 22.5116L20.8868 22.5269C20.9129 22.5343 20.9389 22.5403 20.9645 22.5467L21.0014 22.5556C21.0333 22.563 21.0653 22.5684 21.0972 22.5733L21.1159 22.5768C21.361 22.6132 21.611 22.5977 21.8497 22.5313C22.0885 22.4648 22.3107 22.3489 22.5021 22.1909C22.5576 22.145 22.6101 22.0955 22.6594 22.0429L22.6658 22.036L22.6766 22.0241L22.6962 22.0024L22.7159 21.9802C23.2214 21.4228 23.6773 20.8219 24.0785 20.1847C23.5666 19.8939 23.0423 19.6238 22.5055 19.3745C22.305 19.2807 22.1024 19.1903 21.898 19.1031C21.0121 18.7226 20.102 18.4015 19.1738 18.1419C19.1049 18.1227 19.0356 18.1034 18.9663 18.0852L18.8719 18.0605C18.5354 17.9707 18.1951 17.8885 17.851 17.8138C17.6353 17.7712 17.4135 17.7695 17.1972 17.8089C17.1805 17.8118 17.1638 17.8163 17.1481 17.8197L17.1078 17.8286C17.0768 17.8355 17.0468 17.8439 17.0163 17.8523L16.9672 17.8671L16.8988 17.8903L16.831 17.9169L16.7779 17.9396C16.7509 17.952 16.7239 17.9653 16.6973 17.9786L16.6772 17.9885L16.6668 17.9939L16.6403 18.0092L16.6378 18.0092L16.6334 18.0117L16.5877 18.0383L15.6046 18.6067L15.5235 18.6536L15.5186 18.6566C15.3304 18.7734 15.1659 18.9249 15.0339 19.1031C15.0285 19.1095 15.0236 19.1164 15.0187 19.1233C14.9057 19.2773 14.8182 19.4486 14.7596 19.6306C14.739 19.6947 14.7193 19.7589 14.6991 19.823C14.6077 20.1167 14.5225 20.4116 14.4435 20.7077C14.4249 20.7774 14.4067 20.847 14.389 20.9164C14.2412 21.4937 14.1173 22.0736 14.0174 22.6562C13.9423 23.0947 13.8804 23.5345 13.8316 23.9756C13.7504 24.7144 13.7061 25.4567 13.6988 26.2L13.6969 26.1995Z"
      fill="currentColor"
    />
    <path
      d="M21.6961 9.33407C21.2311 9.72091 20.7808 10.1285 20.3453 10.5568C20.2937 10.6061 20.243 10.6555 20.1919 10.7082C20.0966 10.8035 20.0032 10.9012 19.9098 10.9984C19.8636 11.0477 19.8174 11.0941 19.7716 11.1425C19.6591 11.2619 19.547 11.3823 19.4369 11.5041C19.1467 11.8189 18.9793 12.2281 18.9655 12.6568L18.9655 12.7767C18.9655 12.8132 18.9694 12.8502 18.9734 12.8867L18.9655 12.8867L18.9655 13.7748L18.9729 13.7748C18.9689 13.8133 18.9665 13.8523 18.9655 13.8913L18.9655 14.0112C18.9808 14.4167 19.1332 14.805 19.3976 15.112C19.4118 15.1283 19.4266 15.1441 19.4413 15.1614L19.4757 15.1984C19.5852 15.3194 19.6959 15.439 19.808 15.5571L19.8262 15.5763C19.9471 15.7036 20.0695 15.8294 20.1934 15.9538C20.2425 16.0031 20.2951 16.0549 20.3468 16.1053C20.7816 16.5329 21.2319 16.9405 21.6975 17.328C21.9623 17.5487 22.2319 17.7625 22.5062 17.9694C23.0413 18.374 23.5925 18.7523 24.1597 19.1043C24.2928 19.1872 24.4268 19.2686 24.5618 19.3485C24.6048 19.2676 24.6465 19.1862 24.6872 19.1043C24.9741 18.5314 25.2176 17.9376 25.4157 17.328L25.4049 17.328C25.4818 17.1285 25.522 16.9167 25.5233 16.7028C25.5233 16.688 25.5233 16.6727 25.5233 16.6579C25.5233 16.653 25.5233 16.648 25.5233 16.6431C25.5135 16.186 25.328 15.7504 25.0057 15.4273L24.9772 15.4012C24.9531 15.378 24.928 15.3548 24.9035 15.3326C24.8646 15.3044 24.8258 15.2753 24.787 15.2467C24.7594 15.2265 24.7319 15.2068 24.7049 15.186C24.365 14.9318 24.0334 14.6655 23.71 14.3872C23.6025 14.2938 23.4955 14.1992 23.389 14.1035L23.3089 14.0304C23.2463 13.9732 23.184 13.9155 23.1221 13.8572L23.0375 13.7778C22.8851 13.6327 22.7349 13.4847 22.5868 13.3337C22.7349 13.1827 22.8851 13.0347 23.0375 12.8897C23.1535 12.7791 23.2707 12.6706 23.389 12.564C23.8127 12.1811 24.2513 11.8202 24.7049 11.4814L24.8066 11.4059C24.8391 11.3823 24.871 11.3566 24.9049 11.3349C25.0928 11.1739 25.2449 10.9751 25.3515 10.7514C25.458 10.5277 25.5165 10.2841 25.5233 10.0362C25.5233 10.0273 25.5233 10.0189 25.5233 10.0101C25.5233 10.0012 25.5233 9.98391 25.5233 9.97108C25.5232 9.75323 25.4831 9.53728 25.4049 9.33407L25.4117 9.33407C25.2137 8.72445 24.9702 8.13066 24.6833 7.55776C24.6423 7.47586 24.6005 7.39362 24.5579 7.31106C24.4232 7.39099 24.2892 7.47323 24.1558 7.55776C23.5895 7.90941 23.0383 8.2877 22.5022 8.69263C22.2299 8.89921 21.9612 9.11302 21.6961 9.33407Z"
      fill="currentColor"
    />
    <path
      d="M0.900888 10.0035C0.900888 10.0085 0.900888 10.0134 0.900888 10.0183C0.91074 10.4754 1.09619 10.911 1.41849 11.2341C1.42734 11.243 1.43766 11.2514 1.44651 11.2603C1.47109 11.2835 1.49567 11.3067 1.52074 11.3289L1.63724 11.4147L1.71932 11.4754C2.05915 11.7297 2.39079 11.996 2.71423 12.2742C2.82172 12.3677 2.92871 12.4622 3.03522 12.558L3.11632 12.632C3.17826 12.6887 3.2397 12.7455 3.30066 12.8032L3.39061 12.8861C3.54299 13.0312 3.69324 13.1792 3.84137 13.3302C3.69357 13.4811 3.54332 13.6292 3.39061 13.7742C3.2746 13.8848 3.15745 13.9933 3.03915 14.0999C2.61543 14.4828 2.1768 14.8436 1.72326 15.1825L1.62151 15.258C1.58906 15.2816 1.55711 15.3073 1.52319 15.329C1.33532 15.49 1.18317 15.6888 1.07657 15.9125C0.969972 16.1362 0.911296 16.3798 0.904329 16.6277C0.904329 16.6366 0.904329 16.645 0.904329 16.6538C0.904329 16.6627 0.904329 16.68 0.904329 16.6928C0.904161 16.9095 0.943649 17.1245 1.02083 17.3269L1.01394 17.3269C1.21199 17.9365 1.4555 18.5303 1.74243 19.1032C1.78339 19.1851 1.82517 19.2665 1.86777 19.3474C2.00246 19.2675 2.13649 19.1861 2.26987 19.1032C2.83614 18.7512 3.38733 18.3729 3.92345 17.9683C4.19741 17.7617 4.46695 17.5479 4.73206 17.3269C5.19707 16.94 5.64734 16.5325 6.08285 16.1042C6.13447 16.0548 6.1851 16.0055 6.23622 15.9527C6.33453 15.854 6.42891 15.7553 6.52476 15.6566C6.56802 15.6112 6.61177 15.5663 6.65453 15.5209C6.76759 15.4012 6.87983 15.28 6.99124 15.1573C7.28156 14.8424 7.44894 14.433 7.46265 14.0042L7.46265 13.8843C7.46265 13.8478 7.45872 13.8108 7.45478 13.7742L7.46265 13.7742L7.46265 12.8861L7.45527 12.8861C7.4592 12.8476 7.46166 12.8086 7.46265 12.7696L7.46265 12.6497C7.44712 12.2442 7.29477 11.8561 7.03057 11.5489C7.01632 11.5326 7.00157 11.5168 6.98682 11.4996L6.95241 11.4626C6.84263 11.3415 6.73187 11.2219 6.62012 11.1039L6.60193 11.0846C6.48052 10.9573 6.35862 10.8315 6.23475 10.7071C6.18559 10.6578 6.13299 10.606 6.08138 10.5557C5.64652 10.128 5.19625 9.72047 4.73059 9.33297C4.46548 9.11225 4.19594 8.89844 3.92198 8.69153C3.38651 8.28692 2.83532 7.90864 2.26839 7.55666C2.13502 7.47377 2.00099 7.39153 1.8663 7.30995C1.8237 7.39087 1.78192 7.47311 1.74095 7.55666C1.45403 8.12956 1.21051 8.72335 1.01247 9.33297L1.01935 9.33297C0.942223 9.53238 0.901914 9.74423 0.900396 9.95814C0.901871 9.97491 0.900888 9.98873 0.900888 10.0035Z"
      fill="currentColor"
    />
    <path
      d="M14.0154 4.00476C14.1157 4.587 14.2395 5.16693 14.387 5.74456C14.4047 5.8143 14.4229 5.88387 14.4416 5.95328C14.5376 6.31512 14.6429 6.67416 14.7576 7.03041C14.7719 7.07432 14.7876 7.11824 14.8068 7.16166C14.8621 7.29509 14.9332 7.42134 15.0187 7.53764C15.0236 7.54455 15.0285 7.55146 15.0339 7.55788C15.1664 7.73386 15.3304 7.88346 15.5176 7.99899L15.5225 8.00195L15.5525 8.01922L15.5721 8.03057L16.5847 8.61774L16.5926 8.62218L16.6162 8.636L16.6241 8.64044L16.6619 8.66215L16.6742 8.66906L16.6998 8.68139C16.7243 8.69422 16.7489 8.70606 16.774 8.71741L16.829 8.74109C16.8521 8.75047 16.8753 8.75985 16.8988 8.76823L16.9623 8.78994L17.0222 8.8082L17.0945 8.82695L17.1638 8.84225L17.1943 8.84866C17.4106 8.88798 17.6323 8.8863 17.848 8.84373C18.2236 8.76346 18.5955 8.6735 18.9639 8.57383C19.0332 8.55557 19.1025 8.53633 19.1713 8.51708C20.1003 8.2581 21.0112 7.93749 21.898 7.55738C22.1024 7.47021 22.305 7.37975 22.5055 7.286C23.042 7.03699 23.5663 6.76693 24.0785 6.47581C23.6787 5.83906 23.2243 5.23858 22.7203 4.68124L22.7095 4.6694L22.7007 4.65904L22.6967 4.6546L22.6903 4.64769L22.6702 4.62549L22.6672 4.62253L22.6628 4.61759C22.6135 4.56497 22.561 4.51553 22.5055 4.46956C22.2989 4.29876 22.0566 4.1771 21.7965 4.11369C21.5364 4.05029 21.2654 4.04679 21.0038 4.10345L20.991 4.1069C20.9571 4.1143 20.9232 4.12269 20.8898 4.13256L20.8691 4.13897C20.8391 4.14835 20.8092 4.15772 20.7792 4.16858L20.6258 4.23618L20.5673 4.26184C20.0466 4.48749 19.5142 4.68914 18.9703 4.86677C18.6199 4.98124 18.2649 5.08535 17.9051 5.1791C17.8067 4.81989 17.7191 4.45937 17.6421 4.09753C17.6421 4.09111 17.6396 4.08519 17.6381 4.07878C17.6327 4.05312 17.6273 4.02697 17.6224 4.00131C17.5139 3.47335 17.4286 2.94375 17.3663 2.4125C17.357 2.33355 17.3481 2.2546 17.3403 2.17516C17.3137 2.02154 17.2668 1.87218 17.2007 1.73109C17.0872 1.48922 16.921 1.27608 16.7143 1.10748C16.5076 0.938868 16.2657 0.819111 16.0067 0.757077L16.0067 0.754611C15.8951 0.72994 15.783 0.705267 15.6709 0.685037C15.0209 0.55852 14.362 0.482802 13.7003 0.458559C13.7076 1.20176 13.7518 1.94414 13.833 2.68289C13.8799 3.12533 13.9407 3.56595 14.0154 4.00476Z"
      fill="currentColor"
    />
    <path
      d="M4.53037 7.55674C5.41626 7.93725 6.32632 8.25835 7.25456 8.51792C7.32338 8.53717 7.39269 8.55641 7.462 8.57467L7.55637 8.59934C7.89325 8.68914 8.23357 8.77138 8.57733 8.84605C8.79304 8.88862 9.01478 8.8903 9.2311 8.85098C9.24781 8.84802 9.26453 8.84358 9.28025 8.84013L9.32056 8.83124C9.35104 8.82433 9.38152 8.81595 9.41199 8.80756L9.46115 8.79276L9.52947 8.76957C9.55208 8.76118 9.5747 8.7523 9.59682 8.74292L9.6504 8.72022C9.67743 8.70789 9.70447 8.69457 9.73101 8.68124L9.75116 8.67138L9.76149 8.66595L9.78803 8.65065L9.79049 8.65065L9.79491 8.64818L9.84063 8.62154L10.8232 8.05016L10.9044 8.00082L10.9093 7.99786C11.0971 7.8827 11.2617 7.73306 11.3944 7.55674C11.3998 7.55033 11.4048 7.54342 11.4097 7.53651C11.5226 7.3825 11.6101 7.21123 11.6687 7.02928C11.6894 6.96513 11.709 6.90099 11.7292 6.83684C11.8206 6.54342 11.9058 6.24852 11.9848 5.95214C12.0035 5.8824 12.0217 5.81283 12.0393 5.74343C12.1871 5.16613 12.311 4.58619 12.411 4.00363C12.486 3.56482 12.5479 3.12502 12.5968 2.68423C12.6779 1.94547 12.7222 1.20309 12.7295 0.459892C11.9535 0.488185 11.1817 0.587276 10.4236 0.755944L10.4236 0.75841C10.0882 0.837556 9.78323 1.01356 9.54633 1.26469C9.30943 1.51581 9.15097 1.83108 9.09052 2.17156C9.08462 2.2288 9.07823 2.28554 9.07184 2.34229C9.06938 2.36647 9.06692 2.39163 9.06397 2.41433C9.05463 2.49278 9.04431 2.57123 9.03399 2.64969C8.975 3.10232 8.89963 3.55363 8.80787 4.00363C8.80099 4.0357 8.7946 4.06777 8.78772 4.10231C8.71104 4.46415 8.62337 4.82468 8.52474 5.18389C8.16426 5.0908 7.8092 4.98669 7.45954 4.87156L7.38777 4.84738C7.01878 4.72501 6.65487 4.59162 6.29603 4.44721L6.25425 4.43093L6.09498 4.36432C6.01633 4.33126 5.9372 4.29919 5.85904 4.26563C5.78924 4.2357 5.71977 4.20511 5.65062 4.17386L5.64816 4.17386C5.62653 4.16596 5.60491 4.15955 5.58328 4.15264L5.53658 4.13735C5.51102 4.12995 5.48497 4.12402 5.4594 4.11761L5.42254 4.10873C5.39059 4.10133 5.35864 4.0959 5.32423 4.09097L5.30604 4.08751C5.06095 4.05107 4.81098 4.06657 4.57222 4.13303C4.33347 4.19949 4.11124 4.31543 3.91986 4.47337C3.86437 4.51933 3.81183 4.56877 3.76256 4.62139L3.75617 4.6283L3.74536 4.64014L3.72569 4.66185L3.70603 4.68406C3.20295 5.24038 2.74916 5.83969 2.34983 6.47517C2.8617 6.76563 3.38603 7.03569 3.9228 7.28536C4.12336 7.37911 4.32588 7.46957 4.53037 7.55674Z"
      fill="currentColor"
    />
  </svg>
)

export const CrossIcon = (props: SVGProps) => (
  <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M9.0304 17.9341C8.66126 18.3032 8.64369 18.9624 9.03919 19.3403C9.41712 19.7358 10.0851 19.7183 10.4542 19.3491L14.7169 15.0864L18.9796 19.3491C19.3576 19.7271 20.0079 19.7358 20.3859 19.3403C20.7814 18.9624 20.7726 18.3032 20.3947 17.9253L16.132 13.6626L20.3947 9.40869C20.7726 9.02197 20.7814 8.37158 20.3859 7.99365C20.0079 7.59814 19.3576 7.60693 18.9796 7.98486L14.7169 12.2476L10.4542 7.98486C10.0851 7.61572 9.41712 7.59814 9.03919 7.99365C8.64369 8.37158 8.66126 9.03076 9.0304 9.3999L13.2931 13.6626L9.0304 17.9341Z"
      fill="currentColor"
    />
  </svg>
)

export const PlayButtonIcon = (props: SVGProps) => (
  <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <circle opacity="0.4" cx="12" cy="12" r="12" fill="#70757A" />
    <path
      d="M8.67188 17.2653C8.93555 17.2653 9.16783 17.1712 9.45661 17.0017L16.8708 12.7139C17.4107 12.4 17.6367 12.1551 17.6367 11.7596C17.6367 11.3641 17.4107 11.1256 16.8708 10.8054L9.45661 6.51758C9.16783 6.34807 8.93555 6.25391 8.67188 6.25391C8.15709 6.25391 7.79297 6.64941 7.79297 7.27093V16.2483C7.79297 16.8761 8.15709 17.2653 8.67188 17.2653Z"
      fill="white"
    />
  </svg>
)

export const PauseButtonIcon = (props: SVGProps) => (
  <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <circle opacity="0.4" cx="12" cy="12" r="12" fill="#70757A" />
    <path
      d="M8.88067 16.9757H10.356C10.9524 16.9757 11.26 16.6681 11.26 16.0717V7.43331C11.26 6.82436 10.9524 6.53557 10.356 6.5293H8.88067C8.28427 6.5293 7.97666 6.83691 7.97666 7.43331V16.0717C7.97038 16.6681 8.278 16.9757 8.88067 16.9757ZM13.6519 16.9757H15.1209C15.7173 16.9757 16.0249 16.6681 16.0249 16.0717V7.43331C16.0249 6.82436 15.7173 6.5293 15.1209 6.5293H13.6519C13.0492 6.5293 12.7479 6.83691 12.7479 7.43331V16.0717C12.7479 16.6681 13.0492 16.9757 13.6519 16.9757Z"
      fill="white"
    />
  </svg>
)

export const ListingMinusIcon = (props: SVGProps) => (
  <svg {...props} width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M7.63672 14.665H20.3633C20.8994 14.665 21.3564 14.2168 21.3564 13.6631C21.3564 13.1182 20.8994 12.6611 20.3633 12.6611H7.63672C7.11816 12.6611 6.64355 13.1182 6.64355 13.6631C6.64355 14.2168 7.11816 14.665 7.63672 14.665Z"
      fill="#D1D5DB"
    />
  </svg>
)

export const NonRarityIcon = (props: SVGProps) => {
  return (
    <svg {...props} fill="none" xmlns="http://www.w3.org/2000/svg">
      <path
        d="M13.9902 22.7422C18.9736 22.7422 23.0869 18.6289 23.0869 13.6543C23.0869 8.67969 18.9648 4.56641 13.9814 4.56641C9.00684 4.56641 4.90234 8.67969 4.90234 13.6543C4.90234 18.6289 9.01562 22.7422 13.9902 22.7422ZM13.9902 20.9316C9.95605 20.9316 6.73047 17.6885 6.73047 13.6543C6.73047 9.62012 9.95605 6.38574 13.9814 6.38574C18.0156 6.38574 21.2588 9.62012 21.2676 13.6543C21.2764 17.6885 18.0244 20.9316 13.9902 20.9316ZM13.9814 18.5938C14.21 18.5938 14.3857 18.4268 14.3857 18.1895V17.6006C15.8096 17.4688 16.8818 16.6514 16.8818 15.3154C16.8818 14.1201 16.1084 13.417 14.5791 13.1357L14.3857 13.0918V10.9121C14.9482 11.0088 15.335 11.3428 15.502 11.8613C15.6338 12.1514 15.8184 12.3184 16.1348 12.3184C16.4863 12.3184 16.7324 12.0811 16.7324 11.7471C16.7324 11.6416 16.7061 11.5449 16.6885 11.4395C16.4512 10.5342 15.5635 9.88379 14.3857 9.76074V9.17188C14.3857 8.93457 14.21 8.76758 13.9814 8.76758C13.7529 8.76758 13.5859 8.93457 13.5859 9.17188V9.76074C12.1973 9.90137 11.2129 10.7451 11.2129 11.9668C11.2129 13.1094 11.9775 13.7773 13.4365 14.1113L13.5859 14.1465V16.4668C12.874 16.3613 12.4609 15.9834 12.3203 15.4648C12.1973 15.1484 11.9951 14.9902 11.6963 14.9902C11.3271 14.9902 11.0898 15.2363 11.0898 15.5879C11.0898 15.6846 11.1162 15.7812 11.1426 15.8955C11.3975 16.8271 12.3291 17.4775 13.5859 17.5918V18.1895C13.5859 18.4355 13.7529 18.5938 13.9814 18.5938ZM13.5859 12.8896L13.5244 12.8721C12.8213 12.6699 12.4961 12.3623 12.4961 11.8877C12.4961 11.4043 12.9092 11.0088 13.5859 10.9033V12.8896ZM14.3857 14.3486L14.5527 14.3838C15.3174 14.5947 15.5898 14.9111 15.5898 15.4121C15.5898 15.9658 15.1855 16.3701 14.3857 16.4668V14.3486Z"
        fill="currentColor"
      />
    </svg>
  )
}

export const NonRarityIconFilled = (props: SVGProps) => {
  return (
    <svg {...props} fill="none" xmlns="http://www.w3.org/2000/svg">
      <path
        d="M13.9902 22.7422C18.9736 22.7422 23.0869 18.6289 23.0869 13.6543C23.0869 8.67969 18.9648 4.56641 13.9814 4.56641C9.00684 4.56641 4.90234 8.67969 4.90234 13.6543C4.90234 18.6289 9.01562 22.7422 13.9902 22.7422ZM13.9814 18.7871C13.7441 18.7871 13.5684 18.6113 13.5684 18.3652V17.7412C12.2588 17.6357 11.292 16.9502 11.0283 15.9834C10.9932 15.8691 10.9756 15.7637 10.9756 15.6582C10.9756 15.2891 11.2305 15.0342 11.6084 15.0342C11.9248 15.0342 12.1357 15.2012 12.2676 15.5264C12.4082 16.0625 12.8389 16.458 13.5684 16.5635V14.1729L13.4102 14.1377C11.8896 13.7861 11.0986 13.083 11.0986 11.8965C11.0986 10.6133 12.127 9.73438 13.5684 9.60254V8.9873C13.5684 8.73242 13.7441 8.56543 13.9814 8.56543C14.2188 8.56543 14.4033 8.74121 14.4033 8.9873V9.60254C15.6338 9.72559 16.5479 10.4023 16.7939 11.3428C16.8203 11.4482 16.8467 11.5537 16.8467 11.6592C16.8467 12.0107 16.5918 12.2656 16.2227 12.2656C15.8975 12.2656 15.6865 12.0811 15.5547 11.7822C15.3789 11.2461 14.9834 10.9033 14.4033 10.7979V13.0566L14.6055 13.1006C16.1963 13.3994 16.9961 14.1289 16.9961 15.377C16.9961 16.7656 15.8887 17.6182 14.4033 17.75V18.3652C14.4033 18.6113 14.2188 18.7871 13.9814 18.7871ZM13.5684 12.8457V10.7891C12.874 10.9033 12.4521 11.3164 12.4521 11.8086C12.4521 12.3008 12.7773 12.6172 13.5068 12.8281L13.5684 12.8457ZM14.4033 14.375V16.5635C15.2383 16.4668 15.6514 16.0449 15.6514 15.4736C15.6514 14.9639 15.3613 14.6299 14.5703 14.4189L14.4033 14.375Z"
        fill="currentColor"
      />
    </svg>
  )
}

export const RarityIcon = (props: SVGProps) => {
  return (
    <svg {...props} fill="none" xmlns="http://www.w3.org/2000/svg">
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M8.52676 6.59762C8.85906 6.21784 9.33913 6 9.84377 6L18.9362 6C19.4409 6 19.9209 6.21784 20.2532 6.59762L24.347 11.2762C24.9475 11.9624 24.9204 12.9947 24.2847 13.6485L15.6447 22.5353C14.9576 23.2421 13.8224 23.2421 13.1353 22.5353L4.49526 13.6485C3.85965 12.9947 3.83255 11.9624 4.43299 11.2762L8.52676 6.59762ZM10.9913 7.5L14.39 11.5785L17.7887 7.5L10.9913 7.5ZM19.4039 7.90484L15.9913 12L22.9872 12L19.4039 7.90484ZM22.337 13.5L17.948 13.5L15.9893 20.0291L22.337 13.5ZM12.7907 20.0291L10.832 13.5L6.44298 13.5L12.7907 20.0291ZM5.79283 12L12.7887 12L9.37609 7.90484L5.79283 12ZM12.398 13.5L14.39 20.1399L16.382 13.5L12.398 13.5Z"
        fill="currentColor"
      />
    </svg>
  )
}

export const ClockIconFilled = (props: SVGProps) => {
  return (
    <svg {...props} fill="none" xmlns="http://www.w3.org/2000/svg">
      <path
        d="M13.9844 22.736C18.9467 22.736 23.0704 18.6122 23.0704 13.65C23.0704 8.68774 18.9467 4.56396 13.9673 4.56396C9.0051 4.56396 4.89844 8.68774 4.89844 13.65C4.89844 18.6122 9.02222 22.736 13.9844 22.736ZM9.53555 14.9162C9.03933 14.9162 8.66288 14.5397 8.66288 14.0435C8.66288 13.5302 9.03933 13.1709 9.53555 13.1709H13.0947V8.27708C13.0947 7.78085 13.4882 7.40441 13.9673 7.40441C14.4635 7.40441 14.8742 7.78085 14.8742 8.27708V14.0435C14.8742 14.5226 14.4635 14.9162 13.9673 14.9162H9.53555Z"
        fill={vars.color.blue400}
      />
    </svg>
  )
}

export const ArrowsIcon = () => (
  <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M8.5166 5.71191C8.91211 5.29883 9.52734 5.30762 9.91406 5.71191L14.3438 10.2471C14.5195 10.4229 14.6338 10.6953 14.6338 10.9326C14.6338 11.4863 14.2471 11.8643 13.7021 11.8643C13.4385 11.8643 13.2275 11.7764 13.0518 11.5918L11.2412 9.71094L10.0811 8.375L10.1514 10.2383L10.1514 21.6465C10.1514 22.1914 9.75586 22.5869 9.21094 22.5869C8.66602 22.5869 8.2793 22.1914 8.2793 21.6465L8.2793 10.2383L8.34082 8.375L7.18945 9.71094L5.37891 11.5918C5.20313 11.7764 4.9834 11.8643 4.71973 11.8643C4.18359 11.8643 3.79688 11.4863 3.79688 10.9326C3.79688 10.6953 3.91113 10.4229 4.08691 10.2471L8.5166 5.71191ZM20.1533 22.2793C19.7578 22.6924 19.1426 22.6836 18.7559 22.2793L14.3262 17.7529C14.1504 17.5684 14.0361 17.2959 14.0361 17.0586C14.0361 16.5137 14.4229 16.1357 14.9678 16.1357C15.2227 16.1357 15.4424 16.2236 15.6182 16.3994L17.4287 18.2803L18.5801 19.6162L18.5186 17.7529L18.5186 6.34473C18.5186 5.80859 18.9141 5.4043 19.459 5.4043C19.9951 5.4043 20.3906 5.80859 20.3906 6.34473L20.3906 17.7529L20.3291 19.6162L21.4805 18.2803L23.291 16.3994C23.4668 16.2236 23.6865 16.1357 23.9414 16.1357C24.4863 16.1357 24.873 16.5137 24.873 17.0586C24.873 17.2959 24.7588 17.5684 24.583 17.7529L20.1533 22.2793Z"
      fill="#4673FA"
    />
  </svg>
)

export const ListingEqualsIcon = (props: SVGProps) => (
  <svg {...props} width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M8.7002 11.7822H19.291C19.8184 11.7822 20.2842 11.3252 20.2842 10.7803C20.2842 10.2266 19.8184 9.77832 19.291 9.77832H8.7002C8.18164 9.77832 7.70703 10.2266 7.70703 10.7803C7.70703 11.3252 8.18164 11.7822 8.7002 11.7822ZM8.7002 17.5566H19.291C19.8184 17.5566 20.2842 17.0996 20.2842 16.5547C20.2842 16.0098 19.8184 15.5527 19.291 15.5527H8.7002C8.18164 15.5527 7.70703 16.0098 7.70703 16.5547C7.70703 17.0996 8.18164 17.5566 8.7002 17.5566Z"
      fill="#D1D5DB"
    />
  </svg>
)

export const ReversedArrowsIcon = () => (
  <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M19.4834 5.71191C19.0879 5.29883 18.4727 5.30762 18.0859 5.71191L13.6562 10.2471C13.4805 10.4229 13.3662 10.6953 13.3662 10.9326C13.3662 11.4863 13.7529 11.8643 14.2979 11.8643C14.5615 11.8643 14.7725 11.7764 14.9482 11.5918L16.7588 9.71094L17.9189 8.375L17.8486 10.2383L17.8486 21.6465C17.8486 22.1914 18.2441 22.5869 18.7891 22.5869C19.334 22.5869 19.7207 22.1914 19.7207 21.6465L19.7207 10.2383L19.6592 8.375L20.8105 9.71094L22.6211 11.5918C22.7969 11.7764 23.0166 11.8643 23.2803 11.8643C23.8164 11.8643 24.2031 11.4863 24.2031 10.9326C24.2031 10.6953 24.0889 10.4229 23.9131 10.2471L19.4834 5.71191ZM7.84668 22.2793C8.24218 22.6924 8.85742 22.6836 9.24414 22.2793L13.6738 17.7529C13.8496 17.5684 13.9639 17.2959 13.9639 17.0586C13.9639 16.5137 13.5771 16.1357 13.0322 16.1357C12.7773 16.1357 12.5576 16.2236 12.3818 16.3994L10.5713 18.2803L9.41992 19.6162L9.48144 17.7529L9.48144 6.34473C9.48144 5.80859 9.08594 5.4043 8.54101 5.4043C8.00488 5.4043 7.60937 5.80859 7.60937 6.34473L7.60937 17.7529L7.6709 19.6162L6.51953 18.2803L4.70898 16.3994C4.5332 16.2236 4.31347 16.1357 4.05859 16.1357C3.51367 16.1357 3.12695 16.5137 3.12695 17.0586C3.12695 17.2959 3.24121 17.5684 3.41699 17.7529L7.84668 22.2793Z"
      fill="#4673FA"
    />
  </svg>
)

export const ShoppingCartIcon = (props: SVGProps) => (
  <svg {...props} width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M1.5249 2.73296C1.5249 2.92883 1.69064 3.09457 1.87898 3.09457H3.05797L3.64181 7.07978C3.72468 7.64856 4.02602 7.9951 4.60233 7.9951H8.98682C9.16385 7.9951 9.32582 7.85573 9.32582 7.65609C9.32582 7.46022 9.16385 7.32085 8.98682 7.32085H4.68897C4.50816 7.32085 4.39516 7.19655 4.36879 7.00445L4.30852 6.61271H9.01695C9.59326 6.61271 9.89837 6.2624 9.98124 5.68985L10.2637 3.80272C10.2713 3.75375 10.2788 3.68971 10.2788 3.64828C10.2788 3.42604 10.1244 3.27537 9.86447 3.27537H3.83015L3.76988 2.86857C3.72091 2.54086 3.58908 2.37512 3.17097 2.37512H1.87898C1.69064 2.37512 1.5249 2.54086 1.5249 2.73296ZM4.25202 9.22682C4.25202 9.5922 4.54583 9.886 4.9112 9.886C5.27658 9.886 5.57038 9.5922 5.57038 9.22682C5.57038 8.86145 5.27658 8.56764 4.9112 8.56764C4.54583 8.56764 4.25202 8.86145 4.25202 9.22682ZM7.72873 9.22682C7.72873 9.5922 8.0263 9.886 8.39167 9.886C8.75705 9.886 9.04708 9.5922 9.04708 9.22682C9.04708 8.86145 8.75705 8.56764 8.39167 8.56764C8.0263 8.56764 7.72873 8.86145 7.72873 9.22682Z"
      fill="#70757A"
    />
  </svg>
)
export const RarityVerified = () => (
  <svg width="17" height="17" viewBox="0 0 15 15" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M4.5686 3.53439C4.74662 3.33093 5.0038 3.21423 5.27414 3.21423L10.1451 3.21423C10.4154 3.21423 10.6726 3.33093 10.8506 3.53438L13.0437 6.04077C13.3654 6.40839 13.3509 6.96139 13.0104 7.31163L8.38181 12.0724C8.01367 12.4511 7.40558 12.4511 7.03744 12.0724L2.40887 7.31163C2.06836 6.96139 2.05385 6.40839 2.37552 6.04077L4.5686 3.53439Z"
      fill="#4673FA"
    />
    <path
      d="M7.50864 9.74988C7.31466 9.74988 7.15641 9.6669 7.01348 9.47501L5.76283 7.92953C5.67094 7.81544 5.625 7.69097 5.625 7.56131C5.625 7.29682 5.82919 7.079 6.09463 7.079C6.25288 7.079 6.37539 7.14123 6.50301 7.30719L7.48822 8.5778L9.60157 5.14456C9.70877 4.96823 9.85681 4.87488 10.0151 4.87488C10.2703 4.87488 10.5 5.05639 10.5 5.32607C10.5 5.44536 10.4438 5.57501 10.3673 5.69429L7.97827 9.47501C7.86597 9.65653 7.69751 9.74988 7.50864 9.74988Z"
      fill="white"
    />
  </svg>
)

export const BlankProfileIcon = (props: SVGProps) => (
  <svg {...props} width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M5.99637 9.74665C8.13211 9.74665 9.89495 7.98382 9.89495 5.85184C9.89495 3.71987 8.12835 1.95703 5.99261 1.95703C3.86063 1.95703 2.10156 3.71987 2.10156 5.85184C2.10156 7.98382 3.8644 9.74665 5.99637 9.74665ZM5.99261 6.46582C5.25432 6.46205 4.68178 5.84431 4.68178 5.02693C4.67425 4.25851 5.25809 3.61816 5.99261 3.61816C6.72712 3.61816 7.30343 4.25851 7.30343 5.02693C7.30343 5.84431 6.73089 6.47335 5.99261 6.46582ZM5.99261 9.10254C5.14886 9.10254 4.25237 8.75223 3.68359 8.14202C4.11677 7.49414 4.97559 7.11747 5.99261 7.11747C6.99833 7.11747 7.86468 7.48661 8.30162 8.14202C7.73284 8.75223 6.83636 9.10254 5.99261 9.10254Z"
      fill="#70757A"
    />
  </svg>
)

export const GemIcon = () => (
  <svg
    width="16"
    height="16"
    viewBox="0 0 16 16"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    xmlnsXlink="http://www.w3.org/1999/xlink"
  >
    <rect width="16" height="16" fill="url(#pattern0)" />
    <defs>
      <pattern id="pattern0" patternContentUnits="objectBoundingBox" width="1" height="1">
        <use xlinkHref="#image0_5407_11502" transform="scale(0.00195312)" />
      </pattern>
      <image
        id="image0_5407_11502"
        width="512"
        height="512"
        xlinkHref="data:image/png;base64,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"
      />
    </defs>
  </svg>
)

export const PlusThinWhiteIcon = () => (
  <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M7.63672 14.6562H12.998V20.0176C12.998 20.5625 13.4463 21.0195 14 21.0195C14.5537 21.0195 15.002 20.5625 15.002 20.0176V14.6562H20.3633C20.9082 14.6562 21.3652 14.208 21.3652 13.6543C21.3652 13.1006 20.9082 12.6523 20.3633 12.6523H15.002V7.29102C15.002 6.74609 14.5537 6.28906 14 6.28906C13.4463 6.28906 12.998 6.74609 12.998 7.29102V12.6523H7.63672C7.0918 12.6523 6.63477 13.1006 6.63477 13.6543C6.63477 14.208 7.0918 14.6562 7.63672 14.6562Z"
      fill="white"
    />
  </svg>
)
export const SamePriceIcon = () => (
  <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M13.5867 17.3018L14.9314 15.9395C13.8943 15.8516 13.1472 15.5088 12.6111 14.9727C11.1257 13.4873 11.1257 11.3867 12.6023 9.91895L15.5203 6.99219C17.0056 5.51563 19.0974 5.50684 20.5828 6.99219C22.0769 8.48633 22.0593 10.5781 20.5916 12.0547L19.0974 13.54C19.3787 14.1904 19.4753 14.9815 19.3171 15.667L21.8308 13.1621C23.9929 11.0088 24.0017 7.93262 21.822 5.75293C19.6335 3.56445 16.575 3.58203 14.4128 5.74414L11.3542 8.80274C9.19214 10.9648 9.18335 14.0322 11.363 16.2119C11.8728 16.7305 12.5759 17.1172 13.5867 17.3018ZM14.4041 9.875L13.0593 11.2373C14.0964 11.334 14.8435 11.668 15.3796 12.2041C16.8738 13.6895 16.865 15.79 15.3884 17.2666L12.4705 20.1846C10.9851 21.6699 8.89331 21.6699 7.41675 20.1846C5.92261 18.6904 5.9314 16.6074 7.40796 15.1309L8.89331 13.6367C8.61206 12.9951 8.52417 12.2041 8.67358 11.5098L6.15991 14.0234C3.9978 16.1768 3.98901 19.2441 6.1687 21.4238C8.35718 23.6123 11.4158 23.5947 13.5779 21.4414L16.6365 18.374C18.7986 16.2119 18.8074 13.1445 16.6277 10.9648C16.1179 10.4551 15.4236 10.0684 14.4041 9.875Z"
      fill="#4673FA"
    />
  </svg>
)

export const FloorPriceIcon = () => (
  <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M4.38477 21.2568C4.38477 21.7139 4.68359 22.0127 5.14063 22.0127H22.7451C23.2197 22.0127 23.6152 21.6436 23.6152 21.1514C23.6152 20.6592 23.2197 20.29 22.7451 20.29H6.35352C6.16895 20.29 6.10742 20.2285 6.10742 20.0439V15.2627L9.83398 13.1006C10.1328 13.3818 10.5283 13.5576 10.9766 13.5576C11.3545 13.5576 11.7148 13.4258 11.9961 13.2061L13.6484 14.6123C13.5869 14.7881 13.5518 14.9814 13.5518 15.1748C13.5518 16.1064 14.2988 16.8535 15.2217 16.8535C16.1445 16.8535 16.9004 16.1064 16.9004 15.1748C16.9004 15.1045 16.8916 15.0254 16.8828 14.9551L20.9082 12.5469C21.1719 12.7314 21.4971 12.8369 21.8398 12.8369C22.7627 12.8369 23.5186 12.0811 23.5186 11.1582C23.5186 10.2354 22.7627 9.47949 21.8398 9.47949C20.917 9.47949 20.1611 10.2354 20.1611 11.1582C20.1611 11.2725 20.1787 11.3867 20.1963 11.4922L16.25 13.8564C15.9688 13.6367 15.6084 13.5049 15.2217 13.5049C14.9492 13.5049 14.6855 13.5664 14.4482 13.6895L12.6289 12.1426C12.6377 12.0547 12.6465 11.9668 12.6465 11.8789C12.6465 10.9561 11.8994 10.2002 10.9766 10.2002C10.0449 10.2002 9.29785 10.9561 9.29785 11.8789C9.29785 11.9053 9.29785 11.9316 9.29785 11.958L6.10742 13.8037V6.22754C6.10742 5.74414 5.73828 5.35742 5.24609 5.35742C4.75391 5.35742 4.38477 5.74414 4.38477 6.22754V21.2568Z"
      fill="#4673FA"
    />
  </svg>
)

export const PrevListingIcon = () => (
  <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M23.2467 13.83C24.3319 15.0753 24.2692 16.3821 23.0078 17.627L17.4004 23.2344C16.0645 24.5615 14.6758 24.5527 13.3574 23.2344L4.74414 14.6123C4.05859 13.918 3.98828 13.5137 3.98828 12.5117V9.18066C3.98828 8.20508 4.2168 7.87109 4.92871 7.15918L6.94141 5.14648C7.66211 4.43457 7.99609 4.20605 8.96289 4.20605H12.3027C13.2959 4.20605 13.7002 4.27637 14.3857 4.9707L15.8151 6.39714C15.5471 7.01905 15.4002 7.69427 15.4002 8.39999C15.4002 8.4198 15.4003 8.43959 15.4005 8.45936L13.1377 6.20117C12.9619 6.02539 12.7949 5.91992 12.5137 5.91992H8.98047C8.7168 5.91992 8.53223 6.0166 8.35644 6.19238L5.97461 8.57422C5.80762 8.75 5.71094 8.92578 5.71094 9.19824V12.7314C5.71094 13.0215 5.79883 13.1885 5.97461 13.3643L14.4912 21.8896C15.0713 22.4697 15.6777 22.4785 16.2754 21.8809L21.6631 16.502C22.2607 15.9043 22.2432 15.2891 21.6719 14.7178L20.9088 13.9562C21.168 13.9851 21.4321 14 21.7002 14C22.2338 14 22.7519 13.941 23.2467 13.83ZM8.7959 10.2705C8.7959 10.9824 9.34082 11.5361 10.0615 11.5361C10.7734 11.5361 11.3184 10.9824 11.3184 10.2705C11.3184 9.56738 10.7734 9.00488 10.0615 9.00488C9.34082 9.00488 8.7959 9.56738 8.7959 10.2705Z"
      fill="#4673FA"
    />
    <path
      d="M16.9694 7.11626C16.4684 7.11626 16.2224 7.5733 16.5475 7.94244L17.7165 9.33111C17.9802 9.63873 18.2966 9.63873 18.569 9.33111L19.7292 7.94244C20.0544 7.58209 19.8083 7.11626 19.3073 7.11626H18.8767C19.3688 5.89458 20.5642 5.02447 21.9528 5.02447C23.7634 5.02447 25.2487 6.51861 25.2487 8.32037C25.2487 10.1309 23.7458 11.6251 21.9528 11.6251C20.8542 11.6251 19.9489 11.0889 19.3337 10.3331C19.1052 10.0518 18.7712 9.97271 18.4811 10.1485C18.1911 10.3331 18.1208 10.7549 18.3581 11.0626C19.2106 12.1963 20.5466 12.8555 21.9528 12.8555C24.4138 12.8555 26.4792 10.7989 26.4792 8.32037C26.4792 5.84185 24.4313 3.794 21.9528 3.794C19.8874 3.794 18.1208 5.20904 17.5847 7.11626H16.9694ZM21.7595 5.94732C21.4694 5.94732 21.2233 6.17583 21.2233 6.46587V8.64556C21.2233 8.79498 21.2585 8.91802 21.364 9.04986L22.3659 10.3682C22.5505 10.6231 22.8845 10.6758 23.1306 10.4913C23.3767 10.3067 23.4118 9.99908 23.2184 9.72662L22.2956 8.46978V6.46587C22.2956 6.16705 22.0583 5.94732 21.7595 5.94732Z"
      fill="#4673FA"
    />
  </svg>
)

export const EditPriceIcon = (props: SVGProps) => (
  <svg {...props} width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M12.4713 5.06496L13.2161 4.28041C13.5935 3.88317 13.6233 3.33696 13.2459 2.95958L12.9877 2.69144C12.65 2.35378 12.084 2.40344 11.7165 2.77089L10.9419 3.52565L12.4713 5.06496ZM3.10986 13.2347L5.14573 12.3806L11.7463 5.78L10.2169 4.26055L3.61635 10.8711L2.72255 12.8374C2.62324 13.0658 2.88145 13.324 3.10986 13.2347Z"
      fill="#70757A"
    />
  </svg>
)

export const AttachPriceIcon = (props: SVGProps) => (
  <svg {...props} width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M7.76353 9.88671L8.53195 9.10825C7.93931 9.05803 7.51242 8.86216 7.20605 8.5558C6.35728 7.70702 6.35728 6.50669 7.20103 5.66796L8.86844 3.99553C9.71722 3.15178 10.9125 3.14676 11.7613 3.99553C12.6151 4.84932 12.6051 6.04464 11.7663 6.88839L10.9125 7.73716C11.0732 8.10881 11.1285 8.56082 11.0381 8.95256L12.4745 7.5212C13.71 6.29073 13.715 4.53292 12.4694 3.28738C11.2189 2.03682 9.47112 2.04687 8.23563 3.28236L6.48786 5.03013C5.25237 6.26562 5.24735 8.01841 6.49289 9.26394C6.78418 9.56026 7.18597 9.78124 7.76353 9.88671ZM8.23061 5.64285L7.46219 6.42131C8.05483 6.47655 8.48172 6.6674 8.78809 6.97376C9.64188 7.82254 9.63686 9.02287 8.79311 9.86662L7.1257 11.534C6.27693 12.3828 5.08161 12.3828 4.23786 11.534C3.38407 10.6802 3.38909 9.48995 4.23284 8.6462L5.08161 7.7924C4.9209 7.42577 4.87068 6.97376 4.95605 6.577L3.51967 8.01339C2.28418 9.24385 2.27916 10.9966 3.52469 12.2422C4.77525 13.4927 6.52302 13.4827 7.75851 12.2522L9.50628 10.4994C10.7418 9.26394 10.7468 7.51115 9.50126 6.26562C9.20996 5.97432 8.8132 5.75334 8.23061 5.64285Z"
      fill="#4673FA"
    />
  </svg>
)

export const RowsCollpsedIcon = () => (
  <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M13.9912 5.42773C13.71 5.42773 13.4639 5.55957 13.1738 5.78809L7.24121 10.5869C7.03027 10.7627 6.89844 11.0264 6.89844 11.3516C6.89844 11.9492 7.38184 12.3887 7.93555 12.3887C8.19043 12.3887 8.44531 12.292 8.7002 12.0898L14 7.81836L19.291 12.0898C19.5371 12.292 19.8008 12.3887 20.0557 12.3887C20.6094 12.3887 21.0928 11.9492 21.0928 11.3516C21.0928 11.0264 20.9609 10.7627 20.75 10.5869L14.8086 5.78809C14.5273 5.55957 14.2812 5.42773 13.9912 5.42773ZM13.9912 21.7139C14.2812 21.7139 14.5273 21.5908 14.8086 21.3623L20.75 16.5635C20.9609 16.3789 21.0928 16.1152 21.0928 15.7988C21.0928 15.1924 20.6094 14.7529 20.0557 14.7529C19.8008 14.7529 19.5371 14.8584 19.291 15.0605L14 19.332L8.7002 15.0605C8.44531 14.8584 8.19043 14.7529 7.93555 14.7529C7.38184 14.7529 6.89844 15.1924 6.89844 15.7988C6.89844 16.1152 7.03027 16.3789 7.24121 16.5635L13.1738 21.3535C13.4639 21.5908 13.71 21.7139 13.9912 21.7139Z"
      fill="#70757A"
    />
  </svg>
)

export const CloseDropDownIcon = (props: SVGProps) => (
  <svg width="16" height="15" viewBox="0 0 16 15" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M1.18861 13.0509C0.819467 13.4201 0.801889 14.0792 1.1974 14.466C1.58412 14.8527 2.2433 14.8439 2.61244 14.4747L7.99134 9.08705L13.379 14.4747C13.757 14.8527 14.4074 14.8527 14.7941 14.466C15.172 14.0704 15.1808 13.4288 14.7941 13.0509L9.41517 7.66322L14.7941 2.28431C15.1808 1.90638 15.1808 1.25599 14.7941 0.869272C14.3986 0.491342 13.757 0.482553 13.379 0.860483L7.99134 6.24818L2.61244 0.860483C2.2433 0.491342 1.57533 0.473764 1.1974 0.869272C0.810678 1.25599 0.819467 1.91517 1.18861 2.28431L6.5763 7.66322L1.18861 13.0509Z"
      fill="#70757A"
    />
  </svg>
)

export const ShareIcon = () => (
  <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M21.8711 20.6436L21.8711 11.8564C21.8711 9.97559 20.8867 9 18.9883 9L17 9L17 10.7227L18.8828 10.7227C19.7002 10.7227 20.1484 11.1533 20.1484 12.0059L20.1484 20.5029C20.1484 21.3555 19.7002 21.7773 18.8828 21.7773L8.98828 21.7773C8.1709 21.7773 7.72266 21.3555 7.72266 20.5029L7.72266 12.0059C7.72266 11.1533 8.1709 10.7227 8.98828 10.7227L11 10.7227L11 9L8.88281 9C6.99317 9 6 9.97559 6 11.8564L6 20.6436C6 22.5244 6.99316 23.5 8.88281 23.5L18.9883 23.5C20.8867 23.5 21.8711 22.5244 21.8711 20.6436Z"
      fill={themeVars.colors.darkGray}
    />
    <path
      d="M14.8519 15.17L14.8519 6.57559L14.787 5.22562L15.3611 5.89148L16.6574 7.25057C16.8056 7.41476 17.0185 7.50597 17.2315 7.50597C17.6481 7.50597 18 7.19584 18 6.77626C18 6.55734 17.9074 6.39316 17.75 6.2381L14.6481 3.28276C14.4259 3.07297 14.2222 3 14 3C13.7778 3 13.5741 3.07297 13.3519 3.28276L10.2407 6.2381C10.0833 6.39316 10 6.55734 10 6.77626C10 7.19584 10.3333 7.50597 10.7593 7.50597C10.963 7.50597 11.1852 7.41476 11.3333 7.25057L12.6389 5.89148L13.213 5.2165L13.1389 6.57559L13.1389 15.17C13.1389 15.6169 13.5278 16 14 16C14.4722 16 14.8519 15.6169 14.8519 15.17Z"
      fill={themeVars.colors.darkGray}
    />
  </svg>
)
export const RowsExpandedIcon = () => (
  <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M13.9912 11.9609C14.2812 11.9609 14.5273 11.8379 14.8086 11.6094L20.75 6.81055C20.9609 6.62598 21.0928 6.3623 21.0928 6.0459C21.0928 5.43945 20.6094 5 20.0557 5C19.8008 5 19.5371 5.10547 19.291 5.30762L14 9.5791L8.7002 5.30762C8.44531 5.10547 8.19043 5 7.93555 5C7.38184 5 6.89844 5.43945 6.89844 6.0459C6.89844 6.3623 7.03027 6.62598 7.24121 6.81055L13.1738 11.6006C13.4639 11.8379 13.71 11.9609 13.9912 11.9609Z"
      fill="#70757A"
    />
    <path
      d="M14.0928 15C13.8115 15 13.5654 15.1318 13.2754 15.3604L7.34277 20.1592C7.13184 20.335 7 20.5986 7 20.9238C7 21.5215 7.4834 21.9609 8.03711 21.9609C8.29199 21.9609 8.54688 21.8643 8.80176 21.6621L14.1016 17.3906L19.3926 21.6621C19.6387 21.8643 19.9023 21.9609 20.1572 21.9609C20.7109 21.9609 21.1943 21.5215 21.1943 20.9238C21.1943 20.5986 21.0625 20.335 20.8516 20.1592L14.9102 15.3604C14.6289 15.1318 14.3828 15 14.0928 15Z"
      fill="#70757A"
    />
  </svg>
)

export const BagFillIcon = (props: SVGProps) => (
  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M6.38403 15.6292H13.7668C14.9785 15.6292 15.6816 14.9261 15.6816 13.5826V7.08495C15.6816 5.74148 14.9722 5.03836 13.6162 5.03836H12.731C12.6996 3.63211 11.5005 2.46442 10.0001 2.46442C8.50596 2.46442 7.30061 3.63211 7.26922 5.03836H6.38403C5.02801 5.03836 4.3186 5.74148 4.3186 7.08495V13.5826C4.3186 14.9261 5.02801 15.6292 6.38403 15.6292ZM10.0001 3.57561C10.8602 3.57561 11.4942 4.22223 11.5194 5.03836H8.48085C8.50596 4.22223 9.14003 3.57561 10.0001 3.57561Z"
      fill="currentColor"
    />
  </svg>
)

export const TagFillIcon = (props: SVGProps) => (
  <svg {...props} fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M13.3583 23.2344L4.745 14.6123C4.05945 13.918 3.98914 13.5137 3.98914 12.5117V9.18066C3.98914 8.20508 4.21765 7.87109 4.92957 7.15918L6.94226 5.14648C7.66296 4.43457 7.99695 4.20605 8.96374 4.20605H12.3036C13.2968 4.20605 13.701 4.27637 14.3866 4.9707L23.0175 13.584C24.3358 14.9023 24.3534 16.2998 23.0087 17.627L17.4012 23.2344C16.0653 24.5615 14.6766 24.5527 13.3583 23.2344ZM10.5106 11.5361C11.2313 11.5361 11.7762 10.9824 11.7762 10.2705C11.7762 9.56738 11.2313 9.00488 10.5106 9.00488C9.78992 9.00488 9.24499 9.56738 9.24499 10.2705C9.24499 10.9824 9.78992 11.5361 10.5106 11.5361Z"
      fill="currentColor"
    />
  </svg>
)

export const PaintPaletteIcon = () => (
  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M10.5462 16.1942C13.3336 16.1942 15.1919 15.2023 15.1919 13.727C15.1919 12.4463 14.1435 12.1826 14.1435 11.4355C14.1435 10.4122 17.7909 10.249 17.7909 7.58718C17.7909 4.95046 15.0663 3.2052 11.0171 3.2052C5.7499 3.2052 2.20288 5.87959 2.20288 9.80328C2.20288 13.6265 5.56784 16.1942 10.5462 16.1942ZM10.5462 14.8507C6.32746 14.8507 3.54007 12.8292 3.54007 9.80328C3.54007 6.64549 6.50324 4.54239 11.0171 4.54239C14.2941 4.54239 16.4537 5.77286 16.4537 7.58718C16.4537 9.71538 12.7874 9.4831 12.7874 11.3853C12.7874 12.4714 13.8421 12.7664 13.8421 13.5449C13.8421 14.3359 12.5363 14.8507 10.5462 14.8507ZM11.0359 7.66251C11.6197 7.66251 12.0843 7.19795 12.0843 6.62038C12.0843 6.03653 11.6197 5.57197 11.0359 5.57197C10.4583 5.57197 9.9812 6.03653 9.9812 6.62038C9.9812 7.19795 10.4583 7.66251 11.0359 7.66251ZM7.90322 8.6607C8.6189 8.6607 9.20274 8.08941 9.20274 7.36117C9.20274 6.64549 8.61262 6.0742 7.90322 6.0742C7.18126 6.0742 6.59741 6.64549 6.59741 7.36117C6.59741 8.08941 7.18126 8.6607 7.90322 8.6607ZM13.8609 8.05802C14.3255 8.05802 14.7022 7.68762 14.7022 7.2105C14.7022 6.73966 14.3255 6.35671 13.8609 6.35671C13.3838 6.35671 13.0009 6.73966 13.0009 7.2105C13.0009 7.68134 13.3838 8.05802 13.8609 8.05802ZM5.64945 10.6445C6.22074 10.6445 6.6853 10.1674 6.6853 9.5961C6.6853 9.02482 6.22702 8.56653 5.64945 8.56653C5.07816 8.56653 4.6136 9.02482 4.6136 9.5961C4.6136 10.1674 5.08444 10.6445 5.64945 10.6445ZM10.0063 13.4193C10.9982 13.4193 11.783 12.6346 11.783 11.6427C11.783 10.6696 10.9857 9.86605 10.0063 9.86605C9.02696 9.86605 8.22967 10.6696 8.22967 11.6427C8.22967 12.6221 9.02696 13.4193 10.0063 13.4193ZM10.0063 12.5907C9.47897 12.5907 9.05835 12.17 9.05835 11.6364C9.05835 11.0526 9.50408 10.7073 9.98748 10.701C10.4897 10.6947 10.9543 11.0337 10.9543 11.6364C10.9543 12.17 10.5337 12.5907 10.0063 12.5907Z"
      fill="currentColor"
    />
  </svg>
)

export const PaintPaletteIconFilled = (props: SVGProps) => (
  <svg {...props} fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M14.7646 22.5928C18.623 22.5928 21.207 21.2217 21.207 19.1738C21.207 17.3984 19.7568 17.0293 19.7568 15.9922C19.7568 14.5684 24.8193 14.3398 24.8193 10.6484C24.8193 6.9834 21.04 4.56641 15.4062 4.56641C8.09375 4.56641 3.17188 8.2666 3.17188 13.7246C3.17188 19.0332 7.84766 22.5928 14.7646 22.5928ZM15.6611 10.2354C14.8437 10.2354 14.1582 9.57617 14.1582 8.75C14.1582 7.91504 14.8437 7.24707 15.6611 7.24707C16.4961 7.24707 17.1553 7.91504 17.1553 8.75C17.1553 9.57617 16.4961 10.2354 15.6611 10.2354ZM10.8623 11.6768C9.83398 11.6768 8.99902 10.8594 8.99902 9.81348C8.99902 8.79395 9.83398 7.98535 10.8623 7.98535C11.8818 7.98535 12.7168 8.79395 12.7168 9.81348C12.7168 10.8594 11.8818 11.6768 10.8623 11.6768ZM19.9326 11C19.2559 11 18.7021 10.4639 18.7021 9.78711C18.7021 9.11914 19.2559 8.56543 19.9326 8.56543C20.6006 8.56543 21.1367 9.13672 21.1367 9.78711C21.1367 10.4463 20.6006 11 19.9326 11ZM7.39941 14.8496C6.58203 14.8496 5.91406 14.1729 5.91406 13.3555C5.91406 12.5557 6.6084 11.8789 7.39941 11.8789C8.2168 11.8789 8.87598 12.5381 8.87598 13.3555C8.87598 14.1729 8.20801 14.8496 7.39941 14.8496ZM14.6328 19.1826C13.2793 19.1826 12.1719 18.0752 12.1719 16.7129C12.1719 15.3594 13.2793 14.2432 14.6328 14.2432C15.9951 14.2432 17.1025 15.3594 17.1025 16.7129C17.1025 18.0928 16.0215 19.1826 14.6328 19.1826Z"
      fill="currentColor"
    />
  </svg>
)

export const DollarSignIcon = () => (
  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M9.99379 16.2444C13.5534 16.2444 16.4914 13.3064 16.4914 9.75307C16.4914 6.19978 13.5471 3.26172 9.98751 3.26172C6.43422 3.26172 3.50244 6.19978 3.50244 9.75307C3.50244 13.3064 6.4405 16.2444 9.99379 16.2444ZM9.99379 14.9512C7.11223 14.9512 4.80824 12.6346 4.80824 9.75307C4.80824 6.87151 7.11223 4.56124 9.98751 4.56124C12.8691 4.56124 15.1856 6.87151 15.1919 9.75307C15.1982 12.6346 12.8753 14.9512 9.99379 14.9512ZM9.98751 13.2812C10.1507 13.2812 10.2763 13.162 10.2763 12.9925V12.5718C11.2933 12.4777 12.0592 11.8938 12.0592 10.9396C12.0592 10.0858 11.5068 9.58357 10.4144 9.38267L10.2763 9.35128V7.79436C10.6781 7.86342 10.9543 8.10198 11.0736 8.47238C11.1678 8.67955 11.2996 8.79883 11.5256 8.79883C11.7767 8.79883 11.9525 8.62932 11.9525 8.39076C11.9525 8.31543 11.9337 8.24637 11.9211 8.17104C11.7516 7.52441 11.1175 7.05985 10.2763 6.97196V6.55134C10.2763 6.38184 10.1507 6.26256 9.98751 6.26256C9.82429 6.26256 9.70501 6.38184 9.70501 6.55134V6.97196C8.7131 7.0724 8.00997 7.67508 8.00997 8.54771C8.00997 9.36384 8.55615 9.84096 9.59828 10.0795L9.70501 10.1046V11.762C9.1965 11.6867 8.90144 11.4167 8.80099 11.0463C8.7131 10.8203 8.56871 10.7073 8.35526 10.7073C8.09159 10.7073 7.92208 10.8831 7.92208 11.1342C7.92208 11.2033 7.94092 11.2723 7.95975 11.3539C8.14181 12.0194 8.80727 12.484 9.70501 12.5656V12.9925C9.70501 13.1682 9.82429 13.2812 9.98751 13.2812ZM9.70501 9.20689L9.66106 9.19434C9.15883 9.04994 8.92655 8.83022 8.92655 8.49121C8.92655 8.14593 9.22161 7.86342 9.70501 7.78809V9.20689ZM10.2763 10.249L10.3956 10.2741C10.9418 10.4248 11.1364 10.6508 11.1364 11.0086C11.1364 11.4042 10.8476 11.6929 10.2763 11.762V10.249Z"
      fill="currentColor"
    />
  </svg>
)

export const ClockIcon = () => (
  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M10.7474 4.99984C10.7474 4.58562 10.4116 4.24984 9.9974 4.24984C9.58318 4.24984 9.2474 4.58562 9.2474 4.99984H10.7474ZM9.9974 9.99984H9.2474C9.2474 10.2839 9.4079 10.5436 9.66199 10.6707L9.9974 9.99984ZM12.9953 12.3373C13.3658 12.5226 13.8163 12.3724 14.0015 12.0019C14.1868 11.6314 14.0366 11.1809 13.6661 10.9957L12.9953 12.3373ZM17.5807 9.99984C17.5807 14.188 14.1856 17.5832 9.9974 17.5832V19.0832C15.014 19.0832 19.0807 15.0164 19.0807 9.99984H17.5807ZM9.9974 17.5832C5.80924 17.5832 2.41406 14.188 2.41406 9.99984H0.914062C0.914062 15.0164 4.98081 19.0832 9.9974 19.0832V17.5832ZM2.41406 9.99984C2.41406 5.81168 5.80924 2.4165 9.9974 2.4165V0.916504C4.98081 0.916504 0.914062 4.98325 0.914062 9.99984H2.41406ZM9.9974 2.4165C14.1856 2.4165 17.5807 5.81168 17.5807 9.99984H19.0807C19.0807 4.98325 15.014 0.916504 9.9974 0.916504V2.4165ZM9.2474 4.99984V9.99984H10.7474V4.99984H9.2474ZM9.66199 10.6707L12.9953 12.3373L13.6661 10.9957L10.3328 9.32902L9.66199 10.6707Z"
      fill={vars.color.grey300}
    />
  </svg>
)

export const LoadingIcon = (props: SVGProps) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    xmlnsXlink="http://www.w3.org/1999/xlink"
    width="100px"
    height="100px"
    viewBox="0 0 100 100"
    preserveAspectRatio="xMidYMid"
    {...props}
  >
    <circle cx="50" cy="50" fill="none" strokeWidth="10" r="35" strokeDasharray="164.93361431346415 56.97787143782138">
      <animateTransform
        attributeName="transform"
        type="rotate"
        repeatCount="indefinite"
        dur="1s"
        values="0 50 50;360 50 50"
        keyTimes="0;1"
        {...props}
      ></animateTransform>
    </circle>
  </svg>
)

export const ApprovedCheckmarkIcon = (props: SVGProps) => (
  <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M13.7464 21.1101C13.3792 21.6796 12.8372 22 12.2076 22C11.5607 22 11.0536 21.733 10.5814 21.1101L6.45464 15.9844C6.15738 15.6107 6 15.2191 6 14.792C6 13.9021 6.66448 13.208 7.52131 13.208C8.0459 13.208 8.46557 13.4038 8.88525 13.9555L12.1377 18.1735L19.0448 6.88988C19.412 6.28476 19.8842 6 20.4087 6C21.2306 6 22 6.58732 22 7.4594C22 7.86874 21.7902 8.29588 21.5628 8.66963L13.7464 21.1101Z"
      fill="currentColor"
    />
  </svg>
)

export const HazardIcon = () => (
  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
    <rect x="8.57227" y="6.66669" width="2.85714" height="8.57143" fill="white" />
    <path
      d="M5.14158 15.7143H14.8489C15.8017 15.7143 16.4294 15.0318 16.4294 14.1977C16.4294 13.9377 16.3509 13.6885 16.2052 13.4502L11.3516 5.05483C11.0489 4.53486 10.5221 4.28571 9.99523 4.28571C9.46839 4.28571 8.93034 4.53486 8.6389 5.05483L3.78524 13.4502C3.63952 13.6885 3.57227 13.9377 3.57227 14.1977C3.57227 15.0318 4.18878 15.7143 5.14158 15.7143ZM9.99523 11.4245C9.56928 11.4245 9.25542 11.1428 9.24421 10.7312L9.15453 7.71969C9.14332 7.24305 9.49081 6.90724 9.99523 6.90724C10.5109 6.90724 10.8584 7.23222 10.8471 7.71969L10.7575 10.7312C10.7351 11.1428 10.4324 11.4245 9.99523 11.4245ZM9.99523 14.0677C9.43477 14.0677 8.98639 13.6452 8.98639 13.1036C8.98639 12.5728 9.43477 12.1503 9.99523 12.1503C10.5669 12.1503 11.0153 12.5836 11.0153 13.1036C11.0041 13.6452 10.5669 14.0677 9.99523 14.0677Z"
      fill="#F95E14"
    />
  </svg>
)

export const EtherscanIcon = () => (
  <svg display="block" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
    <g clipPath="url(#clip0_8328_13322)">
      <path
        d="M5.58174 8.72049C5.58172 8.65516 5.59462 8.59046 5.61968 8.53012C5.64473 8.46978 5.68146 8.41499 5.72775 8.36889C5.77404 8.32279 5.82898 8.28629 5.88941 8.2615C5.94984 8.2367 6.01457 8.2241 6.07988 8.2244L6.90576 8.22711C7.03745 8.22711 7.16374 8.27944 7.25685 8.37259C7.34997 8.46573 7.40228 8.59207 7.40228 8.7238V11.8479C7.49531 11.8203 7.61463 11.7909 7.74534 11.7602C7.8361 11.7388 7.91698 11.6874 7.97488 11.6143C8.03278 11.5412 8.06429 11.4507 8.06431 11.3574V7.48229C8.06431 7.41705 8.07715 7.35245 8.1021 7.29218C8.12705 7.23191 8.16363 7.17714 8.20973 7.13101C8.25584 7.08488 8.31059 7.04828 8.37083 7.02331C8.43108 6.99834 8.49566 6.98549 8.56087 6.98548H9.38838C9.52006 6.9855 9.64634 7.03784 9.73945 7.13098C9.83256 7.22412 9.88488 7.35045 9.8849 7.48217V11.0789C9.8849 11.0789 10.092 10.995 10.2939 10.9098C10.3688 10.8781 10.4328 10.825 10.4778 10.7571C10.5228 10.6893 10.5468 10.6097 10.5469 10.5283V6.24034C10.5469 6.17512 10.5597 6.11053 10.5847 6.05027C10.6096 5.99001 10.6462 5.93525 10.6923 5.88913C10.7384 5.84301 10.7931 5.80642 10.8534 5.78146C10.9136 5.7565 10.9782 5.74365 11.0434 5.74365H11.8709C12.0026 5.74365 12.1289 5.79598 12.222 5.88913C12.3151 5.98227 12.3674 6.10861 12.3674 6.24034V9.77121C13.0849 9.25109 13.812 8.62547 14.389 7.87325C14.4727 7.76405 14.5281 7.63583 14.5502 7.50002C14.5724 7.3642 14.5605 7.22502 14.5158 7.09488C14.1254 5.95669 13.3931 4.9669 12.419 4.26087C11.4449 3.55483 10.2766 3.16701 9.07379 3.15043C5.83037 3.10685 3.14986 5.7554 3.15017 9.00037C3.14699 10.0272 3.41489 11.0366 3.92679 11.9267C3.99738 12.0484 4.10124 12.1474 4.22616 12.2122C4.35108 12.2769 4.49187 12.3046 4.632 12.2921C4.78855 12.2783 4.98346 12.2588 5.21517 12.2316C5.31603 12.2202 5.40914 12.172 5.47677 12.0963C5.5444 12.0205 5.58183 11.9226 5.58193 11.821V8.72049"
        fill="currentColor"
      />
      <path
        d="M5.56364 13.7308C6.43591 14.3656 7.46673 14.7466 8.54203 14.8317C9.61734 14.9168 10.6952 14.7027 11.6564 14.2131C12.6177 13.7234 13.4247 12.9773 13.9884 12.0573C14.552 11.1372 14.8502 10.0792 14.85 9.00012C14.85 8.86542 14.8438 8.73223 14.8348 8.59976C12.6984 11.787 8.75385 13.277 5.5636 13.7309"
        fill="currentColor"
      />
    </g>
    <defs>
      <clipPath id="clip0_8328_13322">
        <rect width="11.7" height="11.7" fill="white" transform="translate(3.15002 3.14999)" />
      </clipPath>
    </defs>
  </svg>
)

export const EasyEthIcon = (props: SVGProps) => (
  <svg
    display="block"
    width="15"
    height="15"
    viewBox="0 0 15 15"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <path d="M4.89734 7.46171L7.5 3L10.1027 7.46171L7.5 8.94895L4.89734 7.46171Z" fill="currentColor" />
    <path d="M4.89734 8.20544L7.5 9.69268L10.1027 8.20544L7.5 11.9235L4.89734 8.20544Z" fill="currentColor" />
  </svg>
)

export const InformationIcon = (props: SVGProps) => (
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M8.00419 3.00446C5.15653 3.00446 2.80608 5.35491 2.80608 8.19754C2.80608 11.0402 5.16155 13.3906 8.00921 13.3906C10.8518 13.3906 13.1973 11.0402 13.1973 8.19754C13.1973 5.35491 10.8468 3.00446 8.00419 3.00446ZM8.00419 4.03906C10.3094 4.03906 12.1526 5.8923 12.1526 8.19754C12.1526 10.5028 10.3094 12.351 8.00921 12.351C5.70396 12.351 3.85073 10.5028 3.8457 8.19754C3.84068 5.8923 5.69894 4.03906 8.00419 4.03906ZM8.00921 5.69643C7.68276 5.69643 7.41657 5.93248 7.41657 6.25391C7.41657 6.57031 7.67774 6.80636 8.00921 6.80636C8.33566 6.80636 8.60184 6.57031 8.60184 6.25391C8.60184 5.9375 8.33064 5.69643 8.00921 5.69643Z"
      fill={themeVars.colors.darkGray}
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M7.99939 7.22856C8.26764 7.22856 8.4851 7.44602 8.4851 7.71428L8.4851 10.2857C8.4851 10.554 8.26764 10.7714 7.99939 10.7714C7.73113 10.7714 7.51367 10.554 7.51367 10.2857L7.51367 7.71428C7.51367 7.44602 7.73113 7.22856 7.99939 7.22856Z"
      fill={themeVars.colors.darkGray}
    />
  </svg>
)

export const FailedListingIcon = (props: SVGProps) => (
  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M9.9933 16.2444C13.5529 16.2444 16.4909 13.3064 16.4909 9.75307C16.4909 6.19978 13.5466 3.26172 9.98703 3.26172C6.43373 3.26172 3.50195 6.19978 3.50195 9.75307C3.50195 13.3064 6.44001 16.2444 9.9933 16.2444ZM8.12877 12.3207C7.78976 12.3207 7.62653 12.1324 7.62653 11.8624V7.63742C7.62653 7.36747 7.78976 7.17913 8.12877 7.17913H8.80678C9.14579 7.17913 9.30901 7.36747 9.30901 7.63742V11.8624C9.30901 12.1324 9.14579 12.3207 8.80678 12.3207H8.12877ZM11.1798 12.3207C10.8471 12.3207 10.6776 12.1324 10.6776 11.8624V7.63742C10.6776 7.36747 10.8471 7.17913 11.1798 7.17913H11.8641C12.1906 7.17913 12.3538 7.36747 12.3538 7.63742V11.8624C12.3538 12.1324 12.1906 12.3207 11.8641 12.3207H11.1798Z"
      fill={themeVars.colors.darkGray}
    />
  </svg>
)

export const ToggleEyeIcon = () => (
  <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" viewBox="0 0 20 20">
    <circle cx="10" cy="10" r="9" fill={themeVars.colors.blackBlue} transform="rotate(-180 10 10)" />
    <g clipPath="url(#clip0_271_11037)">
      <path
        fill={themeVars.colors.white}
        d="M13.14.51a10.175 10.175 0 014.918 3.602 10.155 10.155 0 011.43 2.75 9.655 9.655 0 01.51 3.133 9.708 9.708 0 01-.507 3.137 9.997 9.997 0 01-1.43 2.75 10.37 10.37 0 01-2.172 2.177 10.01 10.01 0 01-2.741 1.43 9.64 9.64 0 01-3.136.51 9.671 9.671 0 01-3.14-.51 10.045 10.045 0 01-2.75-1.43 10.338 10.338 0 01-2.177-2.177 10.064 10.064 0 01-1.436-2.75 9.619 9.619 0 01-.511-3.137 9.627 9.627 0 01.511-3.133c.334-.985.818-1.913 1.436-2.75A10.243 10.243 0 014.122 1.94 10.12 10.12 0 016.866.51 9.643 9.643 0 0110.003 0a9.64 9.64 0 013.137.51zM7.678 5.892a8.755 8.755 0 00-1.955.91 8.79 8.79 0 00-1.497 1.175c-.364.35-.686.74-.96 1.163-.22.361-.33.649-.33.864 0 .21.11.496.33.86.273.424.595.814.96 1.163a8.929 8.929 0 003.46 2.084c.751.24 1.536.36 2.326.354a7.492 7.492 0 002.334-.354 8.578 8.578 0 001.958-.91 8.954 8.954 0 001.5-1.174c.365-.349.687-.739.96-1.163.22-.364.33-.65.33-.86 0-.21-.11-.503-.338-.864a6.64 6.64 0 00-.966-1.163 8.905 8.905 0 00-3.46-2.087 7.376 7.376 0 00-2.32-.356 7.418 7.418 0 00-2.332.358zm3.815 1.582c.438.261.804.628 1.064 1.067.263.442.4.948.395 1.463.006.52-.13 1.03-.395 1.478a2.97 2.97 0 01-1.064 1.056c-.45.262-.961.397-1.481.392a2.844 2.844 0 01-1.47-.392 3.01 3.01 0 01-1.065-1.056 2.817 2.817 0 01-.399-1.478 2.787 2.787 0 01.4-1.463A3.096 3.096 0 018.54 7.474a2.78 2.78 0 011.47-.403 2.816 2.816 0 011.482.403zM9.136 9.133a1.196 1.196 0 00-.368.87 1.183 1.183 0 00.368.869 1.178 1.178 0 00.86.368 1.222 1.222 0 00.881-.37 1.18 1.18 0 00.372-.868 1.192 1.192 0 00-.372-.871 1.21 1.21 0 00-1.352-.275c-.147.065-.28.159-.389.277z"
      />
    </g>
    <defs>
      <clipPath id="clip0_271_11037">
        <path fill={themeVars.colors.blackBlue} d="M0 0h20v20H0z" transform="rotate(-180 10 10)" />
      </clipPath>
    </defs>
  </svg>
)

export const CornerDownLeftIcon = (props: SVGProps) => (
  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M7.4987 8.33331L3.33203 12.5L7.4987 16.6666"
      stroke={themeVars.colors.darkGray}
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M16.6654 3.33331V9.16665C16.6654 10.0507 16.3142 10.8985 15.6891 11.5237C15.0639 12.1488 14.2161 12.5 13.332 12.5H3.33203"
      stroke={themeVars.colors.darkGray}
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
)

export const FilterIcon = (props: SVGProps) => (
  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M18.3332 2.5H1.6665L8.33317 10.3833V15.8333L11.6665 17.5V10.3833L18.3332 2.5Z"
      stroke="white"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
)

export const MagnifyingGlassIcon = (props: SVGProps) => (
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M15 15L11.2439 11.2439M12.3821 6.69106C12.3821 9.83414 9.83414 12.3821 6.69106 12.3821C3.54797 12.3821 1 9.83414 1 6.69106C1 3.54797 3.54797 1 6.69106 1C9.83414 1 12.3821 3.54797 12.3821 6.69106Z"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
)

export const NavMagnifyingGlassIcon = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M12.8333 22.1667C17.988 22.1667 22.1667 17.988 22.1667 12.8333C22.1667 7.67868 17.988 3.5 12.8333 3.5C7.67868 3.5 3.5 7.67868 3.5 12.8333C3.5 17.988 7.67868 22.1667 12.8333 22.1667Z"
      stroke="currentColor"
      strokeWidth="2.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M24.4969 24.4998L19.4219 19.4248"
      stroke="currentColor"
      strokeWidth="2.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
)

export const BagIcon = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M15.8333 5H4.16667C3.24619 5 2.5 5.68401 2.5 6.52778V17.2222C2.5 18.066 3.24619 18.75 4.16667 18.75H15.8333C16.7538 18.75 17.5 18.066 17.5 17.2222V6.52778C17.5 5.68401 16.7538 5 15.8333 5Z"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M12.5 8.33331C12.5 8.99635 12.2366 9.63224 11.7678 10.1011C11.2989 10.5699 10.663 10.8333 10 10.8333C9.33696 10.8333 8.70107 10.5699 8.23223 10.1011C7.76339 9.63224 7.5 8.99635 7.5 8.33331"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M7.5 5L7.5 4.375C7.5 3.71196 7.76339 3.07607 8.23223 2.60723C8.70107 2.13839 9.33696 1.875 10 1.875C10.663 1.875 11.2989 2.13839 11.7678 2.60723C12.2366 3.07607 12.5 3.71196 12.5 4.375L12.5 5"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
)

export const HundredsOverflowIcon = () => (
  <svg width="8" height="12" viewBox="0 0 8 12" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M0.781304 6.5554C0.565868 6.5554 0.381209 6.47964 0.227327 6.32812C0.073444 6.17661 -0.00231359 5.99195 5.38039e-05 5.77415C-0.00231359 5.56108 0.073444 5.37879 0.227327 5.22727C0.381209 5.07576 0.565868 5 0.781304 5C0.989637 5 1.17075 5.07576 1.32463 5.22727C1.48088 5.37879 1.56019 5.56108 1.56255 5.77415C1.56019 5.91856 1.52231 6.04995 1.44892 6.16832C1.37789 6.2867 1.2832 6.38139 1.16483 6.45242C1.04882 6.52107 0.920982 6.5554 0.781304 6.5554Z"
      fill="white"
    />
    <path
      d="M3.68169 6.5554C3.46626 6.5554 3.2816 6.47964 3.12772 6.32812C2.97383 6.17661 2.89808 5.99195 2.90044 5.77415C2.89808 5.56108 2.97383 5.37879 3.12772 5.22727C3.2816 5.07576 3.46626 5 3.68169 5C3.89003 5 4.07114 5.07576 4.22502 5.22727C4.38127 5.37879 4.46058 5.56108 4.46294 5.77415C4.46058 5.91856 4.4227 6.04995 4.34931 6.16832C4.27829 6.2867 4.18359 6.38139 4.06522 6.45242C3.94921 6.52107 3.82137 6.5554 3.68169 6.5554Z"
      fill="white"
    />
    <path
      d="M6.58209 6.5554C6.36665 6.5554 6.18199 6.47964 6.02811 6.32812C5.87423 6.17661 5.79847 5.99195 5.80084 5.77415C5.79847 5.56108 5.87423 5.37879 6.02811 5.22727C6.18199 5.07576 6.36665 5 6.58209 5C6.79042 5 6.97153 5.07576 7.12541 5.22727C7.28166 5.37879 7.36097 5.56108 7.36333 5.77415C7.36097 5.91856 7.32309 6.04995 7.2497 6.16832C7.17868 6.2867 7.08398 6.38139 6.96561 6.45242C6.8496 6.52107 6.72176 6.5554 6.58209 6.5554Z"
      fill="white"
    />
  </svg>
)

export const TagIcon = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M6.66667 6.66667H6.67361M17.9917 12.0083L12.0167 17.9833C11.8619 18.1383 11.6781 18.2612 11.4757 18.3451C11.2734 18.429 11.0565 18.4721 10.8375 18.4721C10.6185 18.4721 10.4016 18.429 10.1993 18.3451C9.99694 18.2612 9.81312 18.1383 9.65833 17.9833L2.5 10.8333V2.5H10.8333L17.9917 9.65833C18.3021 9.9706 18.4763 10.393 18.4763 10.8333C18.4763 11.2736 18.3021 11.6961 17.9917 12.0083Z"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
)

export const ThinTagIcon = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M20.59 13.41L13.42 20.58C13.2343 20.766 13.0137 20.9135 12.7709 21.0141C12.5281 21.1148 12.2678 21.1666 12.005 21.1666C11.7422 21.1666 11.4819 21.1148 11.2391 21.0141C10.9963 20.9135 10.7757 20.766 10.59 20.58L2 12V2H12L20.59 10.59C20.9625 10.9647 21.1716 11.4716 21.1716 12C21.1716 12.5284 20.9625 13.0353 20.59 13.41V13.41Z"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path d="M7 7H7.01" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" />
  </svg>
)

export const ThinTagIconMobile = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M20.59 13.41L13.42 20.58C13.2343 20.766 13.0137 20.9135 12.7709 21.0141C12.5281 21.1148 12.2678 21.1666 12.005 21.1666C11.7422 21.1666 11.4819 21.1148 11.2391 21.0141C10.9963 20.9135 10.7757 20.766 10.59 20.58L2 12V2H12L20.59 10.59C20.9625 10.9647 21.1716 11.4716 21.1716 12C21.1716 12.5284 20.9625 13.0353 20.59 13.41V13.41Z"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path d="M7 7H7.01" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" />
  </svg>
)

export const VoteIcon = (props: SVGProps) => (
  <svg {...props} fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M5.28033 9.9959C4.98744 10.2888 4.51256 10.2888 4.21967 9.9959C3.92678 9.703 3.92678 9.22813 4.21967 8.93524L9.93524 3.21967C10.2281 2.92678 10.703 2.92678 10.9959 3.21967L16.7115 8.93524C17.0044 9.22813 17.0044 9.703 16.7115 9.9959C16.4186 10.2888 15.9437 10.2888 15.6508 9.9959L10.4656 4.81066L5.28033 9.9959ZM5.28033 16.6646C4.98744 16.9575 4.51256 16.9575 4.21967 16.6646C3.92678 16.3717 3.92678 15.8968 4.21967 15.6039L9.93524 9.88838C10.2281 9.59548 10.703 9.59548 10.9959 9.88838L16.7115 15.6039C17.0044 15.8968 17.0044 16.3717 16.7115 16.6646C16.4186 16.9575 15.9437 16.9575 15.6508 16.6646L10.4656 11.4794L5.28033 16.6646Z"
      fill="currentColor"
    />
  </svg>
)

export const BarChartIcon = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path d="M12 20V10" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M6 20V4" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M18 20V16" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" />
  </svg>
)

export const BarChartIconMobile = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path d="M12 20V10" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M6 20V4" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M18 20V16" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" />
  </svg>
)

export const DiscordIcon = (props: SVGProps) => (
  <svg role="img" width="44" height="44" viewBox="0 0 44 44" xmlns="http://www.w3.org/2000/svg" {...props} fill="none">
    <path
      d="M27.2113 25.4989C25.6574 25.4989 24.3869 24.1067 24.3869 22.3837C24.3869 20.6607 25.63 19.2685 27.2113 19.2685C27.5983 19.2814 27.9789 19.3726 28.331 19.5367C28.6831 19.7007 28.9998 19.9345 29.2625 20.2243C29.5253 20.5141 29.729 20.8543 29.8617 21.225C29.9944 21.5956 30.0536 21.9895 30.0358 22.3837C30.0358 24.0927 28.7892 25.4989 27.2113 25.4989ZM16.7708 25.4989C15.2203 25.4989 13.9464 24.1067 13.9464 22.3837C13.9464 20.6607 15.1929 19.2685 16.7708 19.2685C17.1578 19.2814 17.5384 19.3726 17.8905 19.5367C18.2426 19.7007 18.5593 19.9345 18.822 20.2243C19.0848 20.5141 19.2885 20.8543 19.4212 21.225C19.5539 21.5956 19.6131 21.9895 19.5952 22.3837C19.5987 24.0927 18.3487 25.4989 16.7708 25.4989ZM32.8978 11.402C30.8261 10.4652 28.6454 9.80198 26.4087 9.42847C26.103 9.96986 25.8259 10.5276 25.5788 11.0992C23.2005 10.749 20.7851 10.749 18.4067 11.0992C18.1547 10.5281 17.8743 9.97046 17.5666 9.42847C15.3293 9.80279 13.1484 10.4684 11.0775 11.409C6.97921 17.4167 5.86241 23.2748 6.4191 29.0493C8.83313 30.8106 11.521 32.145 14.3699 32.9964C15.0139 32.1426 15.5852 31.2343 16.0775 30.2815C15.1502 29.9373 14.2533 29.5134 13.3965 29.0145C13.6185 28.8544 13.8405 28.6664 14.0522 28.5098C16.5478 29.6693 19.2586 30.2693 22.0013 30.2693C24.744 30.2693 27.4548 29.6693 29.9504 28.5098C30.1655 28.6838 30.3841 28.8578 30.6061 29.0145C29.7492 29.5157 28.851 29.9396 27.9217 30.2815C28.4139 31.2355 28.9852 32.145 29.6293 32.9999C32.4808 32.1479 35.171 30.8123 37.5869 29.0493C38.2222 22.3559 36.4531 16.55 32.8978 11.402Z"
      fill="currentColor"
    />
  </svg>
)

export const TwitterIcon = (props: SVGProps) => (
  <svg {...props} role="img" viewBox="0 0 44 44" xmlns="http://www.w3.org/2000/svg">
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M21.7923 16.074C20.5417 9.18217 28.4609 5.08251 33.1294 10.0503C33.1294 10.0503 35.2141 9.43965 37.0472 8.21838C36.5107 9.80217 35.4837 11.1529 34.1294 12.0558C34.1294 12.0558 36.6307 11.7074 37.7143 11.0093C37.7143 11.0093 36.6307 13.3645 34.6306 14.2374C35.713 30.0313 19.4592 39.6302 6.28571 31.7758C6.28571 31.7758 12.7884 32.1242 15.5414 28.81C15.5414 28.81 11.5389 29.1643 9.53874 24.0997C9.53874 24.0997 11.0388 24.7103 12.54 23.9249C12.54 23.9249 7.87157 23.1394 7.45393 17.2953C7.45393 17.2953 8.95516 18.5165 10.6223 18.0795C10.6223 18.0795 5.45382 14.8527 8.37161 9.00736C8.37161 9.00736 13.8731 16.3303 21.7934 16.074H21.7923Z"
      fill="currentColor"
    />
  </svg>
)

export const DiscordIconMenu = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M17.0325 6.95914C16.0748 6.51107 15.0508 6.18542 13.9802 6C13.8487 6.23771 13.6951 6.55743 13.5892 6.81177C12.4512 6.64062 11.3236 6.64062 10.2065 6.81177C10.1006 6.55743 9.94354 6.23771 9.81089 6C8.73916 6.18542 7.71399 6.51226 6.7563 6.96152C4.82465 9.8805 4.30101 12.727 4.56283 15.5331C5.844 16.4898 7.08562 17.071 8.30628 17.4513C8.60767 17.0365 8.87646 16.5956 9.10803 16.1309C8.66701 15.9633 8.24461 15.7565 7.84549 15.5164C7.95137 15.438 8.05494 15.356 8.15501 15.2716C10.5894 16.4102 13.2343 16.4102 15.6396 15.2716C15.7408 15.356 15.8444 15.438 15.9491 15.5164C15.5488 15.7577 15.1253 15.9645 14.6842 16.1321C14.9158 16.5956 15.1834 17.0377 15.486 17.4525C16.7078 17.0722 17.9506 16.491 19.2318 15.5331C19.539 12.2801 18.707 9.45977 17.0325 6.95914ZM9.43967 13.8074C8.70891 13.8074 8.10962 13.1251 8.10962 12.2944C8.10962 11.4636 8.69611 10.7802 9.43967 10.7802C10.1833 10.7802 10.7825 11.4624 10.7697 12.2944C10.7709 13.1251 10.1833 13.8074 9.43967 13.8074ZM14.3549 13.8074C13.6242 13.8074 13.0249 13.1251 13.0249 12.2944C13.0249 11.4636 13.6113 10.7802 14.3549 10.7802C15.0985 10.7802 15.6978 11.4624 15.685 12.2944C15.685 13.1251 15.0985 13.8074 14.3549 13.8074Z"
      fill="currentColor"
    />
  </svg>
)

export const DiscordIconMenuMobile = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M22.71 9.27886C21.4331 8.68142 20.0677 8.24723 18.6403 8C18.465 8.31694 18.2602 8.74324 18.119 9.08235C16.6016 8.85416 15.0982 8.85416 13.6087 9.08235C13.4675 8.74324 13.2581 8.31694 13.0812 8C11.6522 8.24723 10.2853 8.68302 9.0084 9.28202C6.43286 13.174 5.73467 16.9693 6.08377 20.7107C7.792 21.9864 9.44749 22.7613 11.075 23.2684C11.4769 22.7154 11.8353 22.1275 12.144 21.5078C11.556 21.2844 10.9928 21.0087 10.4606 20.6886C10.6018 20.584 10.7399 20.4746 10.8733 20.3621C14.1191 21.8802 17.6458 21.8802 20.8528 20.3621C20.9878 20.4746 21.1258 20.584 21.2655 20.6886C20.7318 21.0102 20.167 21.286 19.579 21.5094C19.8877 22.1275 20.2446 22.717 20.648 23.27C22.2771 22.7629 23.9341 21.988 25.6424 20.7107C26.052 16.3735 24.9426 12.613 22.71 9.27886ZM12.5862 18.4098C11.6119 18.4098 10.8128 17.5002 10.8128 16.3925C10.8128 15.2848 11.5948 14.3736 12.5862 14.3736C13.5777 14.3736 14.3767 15.2832 14.3596 16.3925C14.3612 17.5002 13.5777 18.4098 12.5862 18.4098ZM19.1399 18.4098C18.1655 18.4098 17.3665 17.5002 17.3665 16.3925C17.3665 15.2848 18.1485 14.3736 19.1399 14.3736C20.1313 14.3736 20.9304 15.2832 20.9133 16.3925C20.9133 17.5002 20.1313 18.4098 19.1399 18.4098Z"
      fill="currentColor"
    />
  </svg>
)

export const TwitterIconMenu = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M18.955 7.34849C18.4393 7.57725 17.885 7.73179 17.3033 7.80132C17.897 7.44542 18.3531 6.88184 18.5678 6.21026C18.012 6.53989 17.3966 6.77916 16.7415 6.90812C16.217 6.34918 15.4695 6 14.6424 6C13.0542 6 11.7665 7.28758 11.7665 8.87576C11.7665 9.10117 11.7919 9.32068 11.841 9.53116C9.45084 9.41124 7.33181 8.26628 5.91338 6.52636C5.66583 6.95109 5.52397 7.44507 5.52397 7.97213C5.52397 8.96989 6.03168 9.85012 6.80335 10.3658C6.33194 10.3509 5.8885 10.2215 5.50077 10.0061C5.50044 10.0181 5.50044 10.0302 5.50044 10.0423C5.50044 11.4356 6.49176 12.5979 7.80738 12.8623C7.56607 12.928 7.312 12.9631 7.04973 12.9631C6.86442 12.9631 6.6843 12.9451 6.50866 12.9116C6.87465 14.054 7.93669 14.8855 9.19518 14.9086C8.21094 15.68 6.97095 16.1398 5.62352 16.1398C5.39139 16.1398 5.16248 16.1261 4.9375 16.0996C6.21022 16.9156 7.72187 17.3917 9.34594 17.3917C14.6357 17.3917 17.5284 13.0096 17.5284 9.20917C17.5284 9.08449 17.5256 8.9605 17.52 8.83708C18.0819 8.43169 18.5694 7.92524 18.955 7.34849H18.955Z"
      fill="currentColor"
    />
  </svg>
)

export const TwitterIconMenuMobile = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M25.2759 9.79798C24.5883 10.103 23.8492 10.3091 23.0737 10.4018C23.8653 9.92722 24.4734 9.17579 24.7596 8.28035C24.0187 8.71985 23.1981 9.03888 22.3246 9.21083C21.6252 8.46557 20.6287 8 19.5258 8C17.4082 8 15.6912 9.71677 15.6912 11.8344C15.6912 12.1349 15.7251 12.4276 15.7906 12.7082C12.6037 12.5483 9.77835 11.0217 7.88711 8.70181C7.55704 9.26812 7.3679 9.92676 7.3679 10.6295C7.3679 11.9599 8.04485 13.1335 9.07374 13.8211C8.44519 13.8012 7.85393 13.6287 7.33696 13.3415C7.33653 13.3575 7.33653 13.3736 7.33653 13.3897C7.33653 15.2475 8.65829 16.7972 10.4124 17.1497C10.0907 17.2374 9.75194 17.2842 9.40224 17.2842C9.15516 17.2842 8.915 17.2601 8.68081 17.2154C9.16881 18.7387 10.5849 19.8473 12.2628 19.8782C10.9505 20.9067 9.29721 21.5197 7.50063 21.5197C7.19112 21.5197 6.88591 21.5015 6.58594 21.4661C8.2829 22.5541 10.2984 23.1889 12.4639 23.1889C19.5168 23.1889 23.3738 17.3461 23.3738 12.2789C23.3738 12.1126 23.3701 11.9473 23.3627 11.7828C24.1118 11.2423 24.7618 10.567 25.2759 9.79798H25.2759Z"
      fill="currentColor"
    />
  </svg>
)

export const GithubIconMenu = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M12 5.25C8.27062 5.25 5.25 8.34703 5.25 12.1707C5.25 15.2332 7.18219 17.8198 9.86531 18.7368C10.2028 18.7973 10.3294 18.5897 10.3294 18.408C10.3294 18.2437 10.3209 17.6987 10.3209 17.1191C8.625 17.4391 8.18625 16.6952 8.05125 16.3059C7.97531 16.1069 7.64625 15.4927 7.35938 15.3283C7.12312 15.1986 6.78562 14.8785 7.35094 14.8698C7.8825 14.8612 8.26219 15.3716 8.38875 15.5792C8.99625 16.626 9.96656 16.3318 10.3547 16.1502C10.4138 15.7003 10.5909 15.3975 10.785 15.2245C9.28312 15.0515 7.71375 14.4546 7.71375 11.8074C7.71375 11.0548 7.97531 10.4319 8.40563 9.94745C8.33812 9.77443 8.10187 9.06505 8.47312 8.11345C8.47312 8.11345 9.03844 7.93178 10.3294 8.82283C10.8694 8.66711 11.4431 8.58925 12.0169 8.58925C12.5906 8.58925 13.1644 8.66711 13.7044 8.82283C14.9953 7.92313 15.5606 8.11345 15.5606 8.11345C15.9319 9.06505 15.6956 9.77443 15.6281 9.94745C16.0584 10.4319 16.32 11.0461 16.32 11.8074C16.32 14.4632 14.7422 15.0515 13.2403 15.2245C13.485 15.4408 13.6959 15.856 13.6959 16.5048C13.6959 17.4305 13.6875 18.1745 13.6875 18.408C13.6875 18.5897 13.8141 18.806 14.1516 18.7368C16.8178 17.8198 18.75 15.2245 18.75 12.1707C18.75 8.34703 15.7294 5.25 12 5.25Z"
      fill="currentColor"
    />
  </svg>
)

export const GithubIconMenuMobile = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M16 7C11.0275 7 7 11.1294 7 16.2276C7 20.3109 9.57625 23.7597 13.1537 24.9824C13.6037 25.0631 13.7725 24.7863 13.7725 24.5441C13.7725 24.3249 13.7613 23.5982 13.7613 22.8254C11.5 23.2522 10.915 22.2602 10.735 21.7412C10.6337 21.4759 10.195 20.6569 9.8125 20.4378C9.4975 20.2647 9.0475 19.838 9.80125 19.8264C10.51 19.8149 11.0163 20.4954 11.185 20.7723C11.995 22.1679 13.2888 21.7758 13.8063 21.5335C13.885 20.9337 14.1213 20.53 14.38 20.2993C12.3775 20.0687 10.285 19.2728 10.285 15.7432C10.285 14.7397 10.6337 13.9092 11.2075 13.2633C11.1175 13.0326 10.8025 12.0867 11.2975 10.8179C11.2975 10.8179 12.0512 10.5757 13.7725 11.7638C14.4925 11.5561 15.2575 11.4523 16.0225 11.4523C16.7875 11.4523 17.5525 11.5561 18.2725 11.7638C19.9938 10.5642 20.7475 10.8179 20.7475 10.8179C21.2425 12.0867 20.9275 13.0326 20.8375 13.2633C21.4113 13.9092 21.76 14.7282 21.76 15.7432C21.76 19.2843 19.6562 20.0687 17.6538 20.2993C17.98 20.5877 18.2613 21.1414 18.2613 22.0065C18.2613 23.2407 18.25 24.2326 18.25 24.5441C18.25 24.7863 18.4187 25.0746 18.8688 24.9824C22.4237 23.7597 25 20.2993 25 16.2276C25 11.1294 20.9725 7 16 7Z"
      fill="currentColor"
    />
  </svg>
)

export const CheckMarkIcon = (props: SVGProps) => (
  <svg {...props} fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M16.6693 5.33789L7.5026 14.3175L3.33594 10.2358"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
)

export const RedIndicatorIcon = (props: SVGProps) => (
  <svg {...props} width="8" height="8" viewBox="0 0 8 8" fill="none" xmlns="http://www.w3.org/2000/svg">
    <circle r="4" transform="matrix(-1 0 0 1 4 4)" fill="#FA2C38" />
  </svg>
)

export const HamburgerIcon = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path d="M3.5 14H24.5" stroke="currentColor" strokeWidth="2.5" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M3.5 7H24.5" stroke="currentColor" strokeWidth="2.5" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M3.5 21H24.5" stroke="currentColor" strokeWidth="2.5" strokeLinecap="round" strokeLinejoin="round" />
  </svg>
)

export const CloseIcon = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M24.8839 8.88388C25.372 8.39573 25.372 7.60427 24.8839 7.11612C24.3957 6.62796 23.6043 6.62796 23.1161 7.11612L24.8839 8.88388ZM7.11612 23.1161C6.62796 23.6043 6.62796 24.3957 7.11612 24.8839C7.60427 25.372 8.39573 25.372 8.88388 24.8839L7.11612 23.1161ZM8.88388 7.11612C8.39573 6.62796 7.60427 6.62796 7.11612 7.11612C6.62796 7.60427 6.62796 8.39573 7.11612 8.88388L8.88388 7.11612ZM23.1161 24.8839C23.6043 25.372 24.3957 25.372 24.8839 24.8839C25.372 24.3957 25.372 23.6043 24.8839 23.1161L23.1161 24.8839ZM23.1161 7.11612L7.11612 23.1161L8.88388 24.8839L24.8839 8.88388L23.1161 7.11612ZM7.11612 8.88388L23.1161 24.8839L24.8839 23.1161L8.88388 7.11612L7.11612 8.88388Z"
      fill="currentColor"
    />
  </svg>
)

export const BulletIcon = (props: SVGProps) => (
  <svg width="4" height="4" viewBox="0 0 4 4" fill="none" xmlns="http://www.w3.org/2000/svg">
    <circle cx="2" cy="2" r="2" fill="#99A1BD" fillOpacity="0.24" />
  </svg>
)

export const GovernanceIcon = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M18.75 16.5V6.00002C18.7512 5.7042 18.6939 5.41106 18.5813 5.13752C18.4686 4.86397 18.3029 4.61544 18.0938 4.40626C17.8846 4.19708 17.636 4.0314 17.3625 3.91876C17.089 3.80613 16.7958 3.74878 16.5 3.75002H3.75"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path d="M9.75 8.75H15.75" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M9.75 12.75H15.75" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" />
    <path
      d="M2.07187 7.49977C1.829 7.22785 1.65585 6.90097 1.56733 6.54728C1.4788 6.19359 1.47756 5.82369 1.56369 5.46941C1.64983 5.11513 1.82077 4.7871 2.0618 4.51353C2.30283 4.23997 2.60673 4.02908 2.94734 3.89902C3.28795 3.76895 3.65507 3.72361 4.01709 3.76689C4.37911 3.81017 4.72519 3.94077 5.02554 4.14747C5.32589 4.35416 5.57151 4.63074 5.74126 4.95342C5.91101 5.27609 5.9998 5.63518 6 5.99977V17.9998C6.00019 18.3644 6.08899 18.7235 6.25874 19.0461C6.42849 19.3688 6.67411 19.6454 6.97446 19.8521C7.27481 20.0588 7.62089 20.1894 7.98291 20.2327C8.34493 20.2759 8.71205 20.2306 9.05266 20.1005C9.39327 19.9705 9.69717 19.7596 9.9382 19.486C10.1792 19.2125 10.3502 18.8844 10.4363 18.5301C10.5224 18.1759 10.5212 17.806 10.4327 17.4523C10.3441 17.0986 10.171 16.7717 9.92813 16.4998H20.4281C20.7177 16.8236 20.9074 17.2243 20.9743 17.6536C21.0411 18.0828 20.9823 18.5223 20.8048 18.9188C20.6274 19.3154 20.3389 19.6521 19.9743 19.8882C19.6096 20.1244 19.1844 20.25 18.75 20.2498H8.25"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
)

export const GovernanceIconMobile = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M18.75 16.5V6.00002C18.7512 5.7042 18.6939 5.41106 18.5813 5.13752C18.4686 4.86397 18.3029 4.61544 18.0938 4.40626C17.8846 4.19708 17.636 4.0314 17.3625 3.91876C17.089 3.80613 16.7958 3.74878 16.5 3.75002H3.75"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path d="M9.75 8.75H15.75" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M9.75 12.75H15.75" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" />
    <path
      d="M2.07187 7.50002C1.829 7.22809 1.65585 6.90121 1.56733 6.54752C1.4788 6.19384 1.47756 5.82393 1.56369 5.46966C1.64983 5.11538 1.82077 4.78734 2.0618 4.51378C2.30283 4.24022 2.60673 4.02933 2.94734 3.89926C3.28795 3.76919 3.65507 3.72385 4.01709 3.76713C4.37911 3.81041 4.72519 3.94102 5.02554 4.14771C5.32589 4.3544 5.57151 4.63099 5.74126 4.95366C5.91101 5.27633 5.9998 5.63542 6 6.00002V18C6.00019 18.3646 6.08899 18.7237 6.25874 19.0464C6.42849 19.369 6.67411 19.6456 6.97446 19.8523C7.27481 20.059 7.62089 20.1896 7.98291 20.2329C8.34493 20.2762 8.71205 20.2308 9.05266 20.1008C9.39327 19.9707 9.69717 19.7598 9.9382 19.4863C10.1792 19.2127 10.3502 18.8847 10.4363 18.5304C10.5224 18.1761 10.5212 17.8062 10.4327 17.4525C10.3441 17.0988 10.171 16.7719 9.92813 16.5H20.4281C20.7177 16.8238 20.9074 17.2246 20.9743 17.6538C21.0411 18.0831 20.9823 18.5225 20.8048 18.9191C20.6274 19.3156 20.3389 19.6523 19.9743 19.8885C19.6096 20.1247 19.1844 20.2502 18.75 20.25H8.25"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
)
export const SuspiciousIcon20 = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <rect x="8.57031" y="6.66663" width="2.85714" height="8.57143" fill="white" />
    <path
      d="M5.13962 15.7143H14.8469C15.7997 15.7143 16.4275 15.0319 16.4275 14.1978C16.4275 13.9378 16.349 13.6886 16.2033 13.4503L11.3496 5.05489C11.047 4.53492 10.5201 4.28577 9.99328 4.28577C9.46644 4.28577 8.92839 4.53492 8.63695 5.05489L3.78329 13.4503C3.63757 13.6886 3.57031 13.9378 3.57031 14.1978C3.57031 15.0319 4.18683 15.7143 5.13962 15.7143ZM9.99328 11.4246C9.56732 11.4246 9.25346 11.1429 9.24225 10.7313L9.15258 7.71975C9.14137 7.24311 9.48886 6.9073 9.99328 6.9073C10.5089 6.9073 10.8564 7.23228 10.8452 7.71975L10.7555 10.7313C10.7331 11.1429 10.4304 11.4246 9.99328 11.4246ZM9.99328 14.0678C9.43281 14.0678 8.98444 13.6453 8.98444 13.1036C8.98444 12.5728 9.43281 12.1504 9.99328 12.1504C10.565 12.1504 11.0133 12.5837 11.0133 13.1036C11.0021 13.6453 10.565 14.0678 9.99328 14.0678Z"
      fill="#FA2C38"
    />
  </svg>
)

export const MinusIconLarge = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M8.72879 16.7601H23.2734C23.8862 16.7601 24.4085 16.2478 24.4085 15.615C24.4085 14.9922 23.8862 14.4699 23.2734 14.4699H8.72879C8.13616 14.4699 7.59375 14.9922 7.59375 15.615C7.59375 16.2478 8.13616 16.7601 8.72879 16.7601Z"
      fill="currentColor"
    />
  </svg>
)

export const PlusIconLarge = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M8.72712 16.75H14.8544V22.8772C14.8544 23.5 15.3666 24.0223 15.9994 24.0223C16.6323 24.0223 17.1445 23.5 17.1445 22.8772V16.75H23.2718C23.8945 16.75 24.4169 16.2377 24.4169 15.6049C24.4169 14.9721 23.8945 14.4598 23.2718 14.4598H17.1445V8.33259C17.1445 7.70982 16.6323 7.1875 15.9994 7.1875C15.3666 7.1875 14.8544 7.70982 14.8544 8.33259V14.4598H8.72712C8.10435 14.4598 7.58203 14.9721 7.58203 15.6049C7.58203 16.2377 8.10435 16.75 8.72712 16.75Z"
      fill="currentColor"
    />
  </svg>
)

export const ChevronLeftIcon = (props: SVGProps) => (
  <svg width="8" height="16" viewBox="0 0 8 16" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path d="M7 1L1 7L7 13" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" />
  </svg>
)

export const TrendingArrow = (props: SVGProps) => (
  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M17.5 5.8335H18.25C18.25 5.41928 17.9142 5.0835 17.5 5.0835V5.8335ZM11.0227 12.4307L10.4876 12.9562C10.6286 13.0998 10.8214 13.1807 11.0227 13.1807C11.224 13.1807 11.4169 13.0998 11.5579 12.9562L11.0227 12.4307ZM7.61364 8.9585L8.14881 8.43305C8.00778 8.28941 7.81493 8.2085 7.61364 8.2085C7.41234 8.2085 7.21949 8.28941 7.07846 8.43305L7.61364 8.9585ZM1.96483 13.6414C1.67463 13.937 1.67899 14.4118 1.97456 14.702C2.27013 14.9922 2.74498 14.9878 3.03517 14.6923L1.96483 13.6414ZM13.4091 5.0835C12.9949 5.0835 12.6591 5.41928 12.6591 5.8335C12.6591 6.24771 12.9949 6.5835 13.4091 6.5835V5.0835ZM16.75 10.0002C16.75 10.4144 17.0858 10.7502 17.5 10.7502C17.9142 10.7502 18.25 10.4144 18.25 10.0002H16.75ZM16.9648 5.30805L10.4876 11.9053L11.5579 12.9562L18.0352 6.35894L16.9648 5.30805ZM11.5579 11.9053L8.14881 8.43305L7.07846 9.48394L10.4876 12.9562L11.5579 11.9053ZM7.07846 8.43305L1.96483 13.6414L3.03517 14.6923L8.14881 9.48394L7.07846 8.43305ZM13.4091 6.5835H17.5V5.0835H13.4091V6.5835ZM16.75 5.8335V10.0002H18.25V5.8335H16.75Z"
      fill={vars.color.grey300}
    />
  </svg>
)
export const ActivityListingIcon = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M14.7254 9.93992L9.94537 14.7199C9.82153 14.8439 9.67448 14.9422 9.51262 15.0093C9.35076 15.0764 9.17725 15.111 9.00203 15.111C8.82681 15.111 8.65331 15.0764 8.49145 15.0093C8.32958 14.9422 8.18253 14.8439 8.0587 14.7199L2.33203 8.99992V2.33325H8.9987L14.7254 8.05992C14.9737 8.30974 15.1131 8.64767 15.1131 8.99992C15.1131 9.35217 14.9737 9.6901 14.7254 9.93992V9.93992Z"
      stroke="currentColor"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path d="M5.66797 5.66675H5.6763" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" />
  </svg>
)

export const ActivitySaleIcon = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M12.6667 4.00012H3.33333C2.59695 4.00012 2 4.54733 2 5.22234V13.7779C2 14.4529 2.59695 15.0001 3.33333 15.0001H12.6667C13.403 15.0001 14 14.4529 14 13.7779V5.22234C14 4.54733 13.403 4.00012 12.6667 4.00012Z"
      stroke="currentColor"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M10 6.66675C10 7.19718 9.78929 7.70589 9.41421 8.08096C9.03914 8.45603 8.53043 8.66675 8 8.66675C7.46957 8.66675 6.96086 8.45603 6.58579 8.08096C6.21071 7.70589 6 7.19718 6 6.66675"
      stroke="currentColor"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M6 4.00012L6 3.50012C6 2.96969 6.21071 2.46098 6.58579 2.08591C6.96086 1.71083 7.46957 1.50012 8 1.50012C8.53043 1.50012 9.03914 1.71083 9.41421 2.08591C9.78929 2.46098 10 2.96969 10 3.50012L10 4.00012"
      stroke="currentColor"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
)

export const TokenWarningRedIcon = (props: SVGProps) => (
  <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M10.8566 6.57347L10.2153 6.18449L10.2132 6.18807L10.8566 6.57347ZM5.20993 16.0001L4.56645 15.6147L4.56044 15.6251L5.20993 16.0001ZM6.34993 18.0001L6.34169 18.7501H6.34993V18.0001ZM17.6433 18.0001V18.7502L17.6515 18.7501L17.6433 18.0001ZM18.7833 16.0001L19.4328 15.625L19.4267 15.6147L18.7833 16.0001ZM13.1366 6.57347L13.78 6.18806L13.7778 6.1845L13.1366 6.57347ZM11.9966 5.93164V5.18164V5.93164ZM12.7467 10.0001C12.7467 9.58587 12.411 9.25008 11.9967 9.25008C11.5825 9.25008 11.2467 9.58587 11.2467 10.0001H12.7467ZM11.2467 12.6667C11.2467 13.081 11.5825 13.4167 11.9967 13.4167C12.411 13.4167 12.7467 13.081 12.7467 12.6667H11.2467ZM11.9967 14.5834C11.5825 14.5834 11.2467 14.9192 11.2467 15.3334C11.2467 15.7476 11.5825 16.0834 11.9967 16.0834V14.5834ZM12.0034 16.0834C12.4176 16.0834 12.7534 15.7476 12.7534 15.3334C12.7534 14.9192 12.4176 14.5834 12.0034 14.5834V16.0834ZM10.2132 6.18807L4.56653 15.6147L5.85333 16.3855L11.5 6.95887L10.2132 6.18807ZM4.56044 15.6251C4.37853 15.9401 4.28228 16.2973 4.28126 16.661L5.78125 16.6652C5.78154 16.5634 5.80849 16.4634 5.85942 16.3752L4.56044 15.6251ZM4.28126 16.661C4.28024 17.0248 4.37449 17.3825 4.55463 17.6986L5.8578 16.9558C5.80736 16.8673 5.78097 16.7671 5.78125 16.6652L4.28126 16.661ZM4.55463 17.6986C4.73477 18.0146 4.99452 18.278 5.30805 18.4624L6.06875 17.1696C5.98097 17.118 5.90824 17.0442 5.8578 16.9558L4.55463 17.6986ZM5.30805 18.4624C5.62157 18.6469 5.97793 18.7461 6.34169 18.7501L6.35817 17.2502C6.25632 17.2491 6.15654 17.2213 6.06875 17.1696L5.30805 18.4624ZM6.34993 18.7501H17.6433V17.2501H6.34993V18.7501ZM17.6515 18.7501C18.0153 18.7461 18.3716 18.6469 18.6851 18.4624L17.9244 17.1696C17.8367 17.2213 17.7369 17.2491 17.635 17.2502L17.6515 18.7501ZM18.6851 18.4624C18.9987 18.278 19.2584 18.0146 19.4386 17.6986L18.1354 16.9558C18.085 17.0442 18.0122 17.118 17.9244 17.1696L18.6851 18.4624ZM19.4386 17.6986C19.6187 17.3825 19.713 17.0248 19.7119 16.661L18.2119 16.6652C18.2122 16.7671 18.1858 16.8673 18.1354 16.9558L19.4386 17.6986ZM19.7119 16.661C19.7109 16.2973 19.6147 15.9401 19.4328 15.6251L18.1338 16.3752C18.1847 16.4634 18.2117 16.5634 18.2119 16.6652L19.7119 16.661ZM19.4267 15.6147L13.78 6.18807L12.4932 6.95887L18.1399 16.3855L19.4267 15.6147ZM13.7778 6.1845C13.5921 5.87836 13.3307 5.62525 13.0187 5.44959L12.2828 6.75667C12.3701 6.80585 12.4434 6.87672 12.4953 6.96244L13.7778 6.1845ZM13.0187 5.44959C12.7067 5.27392 12.3547 5.18164 11.9966 5.18164V6.68164C12.0969 6.68164 12.1954 6.70748 12.2828 6.75667L13.0187 5.44959ZM11.9966 5.18164C11.6385 5.18164 11.2865 5.27392 10.9745 5.44959L11.7104 6.75667C11.7978 6.70748 11.8963 6.68164 11.9966 6.68164V5.18164ZM10.9745 5.44959C10.6625 5.62525 10.401 5.87836 10.2153 6.1845L11.4978 6.96244C11.5498 6.87672 11.6231 6.80585 11.7104 6.75667L10.9745 5.44959ZM11.2467 10.0001V12.6667H12.7467V10.0001H11.2467ZM11.9967 16.0834H12.0034V14.5834H11.9967V16.0834Z"
      fill={props.fill ? props.fill : '#FA2B39'}
    />
  </svg>
)
export const ActivityTransferIcon = (props: SVGProps) => (
  <svg fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path d="M14.6654 1.33337L7.33203 8.66671" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" />
    <path
      d="M14.6654 1.33337L9.9987 14.6667L7.33203 8.66671L1.33203 6.00004L14.6654 1.33337Z"
      stroke="currentColor"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
)

export const TokenWarningYellowIcon = (props: SVGProps) => (
  <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M10.8566 6.57347L10.2153 6.18449L10.2132 6.18807L10.8566 6.57347ZM5.20993 16.0001L4.56645 15.6147L4.56044 15.6251L5.20993 16.0001ZM6.34993 18.0001L6.34169 18.7501H6.34993V18.0001ZM17.6433 18.0001V18.7502L17.6515 18.7501L17.6433 18.0001ZM18.7833 16.0001L19.4328 15.625L19.4267 15.6147L18.7833 16.0001ZM13.1366 6.57347L13.78 6.18806L13.7778 6.1845L13.1366 6.57347ZM11.9966 5.93164V5.18164V5.93164ZM12.7467 10.0001C12.7467 9.58587 12.411 9.25008 11.9967 9.25008C11.5825 9.25008 11.2467 9.58587 11.2467 10.0001H12.7467ZM11.2467 12.6667C11.2467 13.081 11.5825 13.4167 11.9967 13.4167C12.411 13.4167 12.7467 13.081 12.7467 12.6667H11.2467ZM11.9967 14.5834C11.5825 14.5834 11.2467 14.9192 11.2467 15.3334C11.2467 15.7476 11.5825 16.0834 11.9967 16.0834V14.5834ZM12.0034 16.0834C12.4176 16.0834 12.7534 15.7476 12.7534 15.3334C12.7534 14.9192 12.4176 14.5834 12.0034 14.5834V16.0834ZM10.2132 6.18807L4.56653 15.6147L5.85333 16.3855L11.5 6.95887L10.2132 6.18807ZM4.56044 15.6251C4.37853 15.9401 4.28228 16.2973 4.28126 16.661L5.78125 16.6652C5.78154 16.5634 5.80849 16.4634 5.85942 16.3752L4.56044 15.6251ZM4.28126 16.661C4.28024 17.0248 4.37449 17.3825 4.55463 17.6986L5.8578 16.9558C5.80736 16.8673 5.78097 16.7671 5.78125 16.6652L4.28126 16.661ZM4.55463 17.6986C4.73477 18.0146 4.99452 18.278 5.30805 18.4624L6.06875 17.1696C5.98097 17.118 5.90824 17.0442 5.8578 16.9558L4.55463 17.6986ZM5.30805 18.4624C5.62157 18.6469 5.97793 18.7461 6.34169 18.7501L6.35817 17.2502C6.25632 17.2491 6.15654 17.2213 6.06875 17.1696L5.30805 18.4624ZM6.34993 18.7501H17.6433V17.2501H6.34993V18.7501ZM17.6515 18.7501C18.0153 18.7461 18.3716 18.6469 18.6851 18.4624L17.9244 17.1696C17.8367 17.2213 17.7369 17.2491 17.635 17.2502L17.6515 18.7501ZM18.6851 18.4624C18.9987 18.278 19.2584 18.0146 19.4386 17.6986L18.1354 16.9558C18.085 17.0442 18.0122 17.118 17.9244 17.1696L18.6851 18.4624ZM19.4386 17.6986C19.6187 17.3825 19.713 17.0248 19.7119 16.661L18.2119 16.6652C18.2122 16.7671 18.1858 16.8673 18.1354 16.9558L19.4386 17.6986ZM19.7119 16.661C19.7109 16.2973 19.6147 15.9401 19.4328 15.6251L18.1338 16.3752C18.1847 16.4634 18.2117 16.5634 18.2119 16.6652L19.7119 16.661ZM19.4267 15.6147L13.78 6.18807L12.4932 6.95887L18.1399 16.3855L19.4267 15.6147ZM13.7778 6.1845C13.5921 5.87836 13.3307 5.62525 13.0187 5.44959L12.2828 6.75667C12.3701 6.80585 12.4434 6.87672 12.4953 6.96244L13.7778 6.1845ZM13.0187 5.44959C12.7067 5.27392 12.3547 5.18164 11.9966 5.18164V6.68164C12.0969 6.68164 12.1954 6.70748 12.2828 6.75667L13.0187 5.44959ZM11.9966 5.18164C11.6385 5.18164 11.2865 5.27392 10.9745 5.44959L11.7104 6.75667C11.7978 6.70748 11.8963 6.68164 11.9966 6.68164V5.18164ZM10.9745 5.44959C10.6625 5.62525 10.401 5.87836 10.2153 6.1845L11.4978 6.96244C11.5498 6.87672 11.6231 6.80585 11.7104 6.75667L10.9745 5.44959ZM11.2467 10.0001V12.6667H12.7467V10.0001H11.2467ZM11.9967 16.0834H12.0034V14.5834H11.9967V16.0834Z"
      fill="#EEB317"
    />
  </svg>
)
export const ActivityExternalLinkIcon = (props: SVGProps) => (
  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
    <mask id="path-1-outside-1_3799_46574" maskUnits="userSpaceOnUse" x="2" y="2" width="15" height="15" fill="black">
      <rect fill="white" x="2" y="2" width="15" height="15" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M11.0078 3.5C11.0078 3.22386 11.2317 3 11.5078 3H15.5094L15.5127 3.00001C15.6416 2.99918 15.7709 3.04794 15.8693 3.14631C15.9877 3.26455 16.0344 3.42734 16.0094 3.58074V7.50474C16.0094 7.78088 15.7855 8.00474 15.5094 8.00474C15.2332 8.00474 15.0094 7.78088 15.0094 7.50474V4.71431L8.53338 11.1954C8.3382 11.3908 8.02161 11.3909 7.82627 11.1957C7.63093 11.0005 7.63081 10.6839 7.82599 10.4886L14.3095 4H11.5078C11.2317 4 11.0078 3.77614 11.0078 3.5ZM4.24437 6.24684C4.40078 6.09031 4.61283 6.00244 4.83386 6.00244H8.83544C9.11158 6.00244 9.33544 5.77858 9.33544 5.50244C9.33544 5.2263 9.11158 5.00244 8.83544 5.00244H4.83386C4.34736 5.00244 3.88087 5.19586 3.53699 5.54001C3.19311 5.88416 3 6.35083 3 6.83735V14.1794C3 14.6659 3.19311 15.1326 3.53699 15.4767C3.88087 15.8209 4.34736 16.0143 4.83386 16.0143H12.1701C12.6566 16.0143 13.1231 15.8209 13.467 15.4767C13.8108 15.1326 14.0039 14.6659 14.0039 14.1794V10.1746C14.0039 9.8985 13.7801 9.67464 13.5039 9.67464C13.2278 9.67464 13.0039 9.8985 13.0039 10.1746V14.1794C13.0039 14.4009 12.916 14.6133 12.7596 14.7699C12.6032 14.9264 12.3911 15.0143 12.1701 15.0143H4.83386C4.61283 15.0143 4.40078 14.9264 4.24437 14.7699C4.08795 14.6133 4 14.4009 4 14.1794V6.83735C4 6.61579 4.08795 6.40339 4.24437 6.24684Z"
      />
    </mask>
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M11.0078 3.5C11.0078 3.22386 11.2317 3 11.5078 3H15.5094L15.5127 3.00001C15.6416 2.99918 15.7709 3.04794 15.8693 3.14631C15.9877 3.26455 16.0344 3.42734 16.0094 3.58074V7.50474C16.0094 7.78088 15.7855 8.00474 15.5094 8.00474C15.2332 8.00474 15.0094 7.78088 15.0094 7.50474V4.71431L8.53338 11.1954C8.3382 11.3908 8.02161 11.3909 7.82627 11.1957C7.63093 11.0005 7.63081 10.6839 7.82599 10.4886L14.3095 4H11.5078C11.2317 4 11.0078 3.77614 11.0078 3.5ZM4.24437 6.24684C4.40078 6.09031 4.61283 6.00244 4.83386 6.00244H8.83544C9.11158 6.00244 9.33544 5.77858 9.33544 5.50244C9.33544 5.2263 9.11158 5.00244 8.83544 5.00244H4.83386C4.34736 5.00244 3.88087 5.19586 3.53699 5.54001C3.19311 5.88416 3 6.35083 3 6.83735V14.1794C3 14.6659 3.19311 15.1326 3.53699 15.4767C3.88087 15.8209 4.34736 16.0143 4.83386 16.0143H12.1701C12.6566 16.0143 13.1231 15.8209 13.467 15.4767C13.8108 15.1326 14.0039 14.6659 14.0039 14.1794V10.1746C14.0039 9.8985 13.7801 9.67464 13.5039 9.67464C13.2278 9.67464 13.0039 9.8985 13.0039 10.1746V14.1794C13.0039 14.4009 12.916 14.6133 12.7596 14.7699C12.6032 14.9264 12.3911 15.0143 12.1701 15.0143H4.83386C4.61283 15.0143 4.40078 14.9264 4.24437 14.7699C4.08795 14.6133 4 14.4009 4 14.1794V6.83735C4 6.61579 4.08795 6.40339 4.24437 6.24684Z"
      fill="currentColor"
    />
    <path
      d="M15.5094 3L15.51 2.8H15.5094V3ZM15.5127 3.00001L15.512 3.20002L15.514 3.20001L15.5127 3.00001ZM15.8693 3.14631L16.0107 3.00483V3.00483L15.8693 3.14631ZM16.0094 3.58074L15.812 3.54861C15.8103 3.55923 15.8094 3.56998 15.8094 3.58074H16.0094ZM15.0094 4.71431H15.2094C15.2094 4.6334 15.1606 4.56047 15.0859 4.52952C15.0111 4.49857 14.9251 4.51571 14.8679 4.57294L15.0094 4.71431ZM8.53338 11.1954L8.67486 11.3368V11.3368L8.53338 11.1954ZM7.82627 11.1957L7.68491 11.3372L7.82627 11.1957ZM7.82599 10.4886L7.96747 10.63L7.82599 10.4886ZM14.3095 4L14.451 4.14137C14.5081 4.08415 14.5252 3.99814 14.4942 3.92343C14.4633 3.84871 14.3904 3.8 14.3095 3.8V4ZM4.24437 6.24684L4.38585 6.38821H4.38585L4.24437 6.24684ZM3.53699 5.54001L3.39551 5.39865H3.39551L3.53699 5.54001ZM3.53699 15.4767L3.67846 15.3354L3.67846 15.3354L3.53699 15.4767ZM13.467 15.4767L13.6084 15.6181L13.467 15.4767ZM12.7596 14.7699L12.6181 14.6285L12.6181 14.6285L12.7596 14.7699ZM4.24437 14.7699L4.10289 14.9113H4.10289L4.24437 14.7699ZM11.5078 2.8C11.1212 2.8 10.8078 3.1134 10.8078 3.5H11.2078C11.2078 3.33431 11.3421 3.2 11.5078 3.2V2.8ZM15.5094 2.8H11.5078V3.2H15.5094V2.8ZM15.5133 2.80001L15.51 2.8L15.5087 3.2L15.512 3.20001L15.5133 2.80001ZM16.0107 3.00483C15.8729 2.86715 15.6916 2.79885 15.5114 2.80001L15.514 3.20001C15.5917 3.1995 15.6689 3.22873 15.728 3.28778L16.0107 3.00483ZM16.2068 3.61287C16.2417 3.39869 16.1765 3.17048 16.0107 3.00483L15.728 3.28778C15.7989 3.35862 15.8271 3.456 15.812 3.54861L16.2068 3.61287ZM16.2094 7.50474V3.58074H15.8094V7.50474H16.2094ZM15.5094 8.20474C15.896 8.20474 16.2094 7.89134 16.2094 7.50474H15.8094C15.8094 7.67042 15.6751 7.80474 15.5094 7.80474V8.20474ZM14.8094 7.50474C14.8094 7.89134 15.1228 8.20474 15.5094 8.20474V7.80474C15.3437 7.80474 15.2094 7.67042 15.2094 7.50474H14.8094ZM14.8094 4.71431V7.50474H15.2094V4.71431H14.8094ZM8.67486 11.3368L15.1509 4.85568L14.8679 4.57294L8.3919 11.0541L8.67486 11.3368ZM7.68491 11.3372C7.95838 11.6105 8.4016 11.6103 8.67486 11.3368L8.3919 11.0541C8.27479 11.1713 8.08484 11.1713 7.96764 11.0542L7.68491 11.3372ZM7.68452 10.3472C7.41126 10.6207 7.41143 11.0639 7.68491 11.3372L7.96764 11.0542C7.85044 10.9371 7.85036 10.7472 7.96747 10.63L7.68452 10.3472ZM14.168 3.85863L7.68452 10.3472L7.96747 10.63L14.451 4.14137L14.168 3.85863ZM11.5078 4.2H14.3095V3.8H11.5078V4.2ZM10.8078 3.5C10.8078 3.8866 11.1212 4.2 11.5078 4.2V3.8C11.3421 3.8 11.2078 3.66569 11.2078 3.5H10.8078ZM4.83386 5.80244C4.55974 5.80244 4.2968 5.91142 4.10289 6.10548L4.38585 6.38821C4.50476 6.2692 4.66593 6.20244 4.83386 6.20244V5.80244ZM8.83544 5.80244H4.83386V6.20244H8.83544V5.80244ZM9.13544 5.50244C9.13544 5.66813 9.00112 5.80244 8.83544 5.80244V6.20244C9.22204 6.20244 9.53544 5.88904 9.53544 5.50244H9.13544ZM8.83544 5.20244C9.00112 5.20244 9.13544 5.33676 9.13544 5.50244H9.53544C9.53544 5.11584 9.22204 4.80244 8.83544 4.80244V5.20244ZM4.83386 5.20244H8.83544V4.80244H4.83386V5.20244ZM3.67846 5.68138C3.98485 5.37475 4.40046 5.20244 4.83386 5.20244V4.80244C4.29427 4.80244 3.77689 5.01697 3.39551 5.39865L3.67846 5.68138ZM3.2 6.83735C3.2 6.40382 3.37208 5.988 3.67846 5.68138L3.39551 5.39865C3.01415 5.78031 2.8 6.29784 2.8 6.83735H3.2ZM3.2 14.1794V6.83735H2.8V14.1794H3.2ZM3.67846 15.3354C3.37208 15.0287 3.2 14.6129 3.2 14.1794H2.8C2.8 14.7189 3.01415 15.2364 3.39551 15.6181L3.67846 15.3354ZM4.83386 15.8143C4.40046 15.8143 3.98485 15.642 3.67846 15.3354L3.39551 15.6181C3.77689 15.9998 4.29427 16.2143 4.83386 16.2143V15.8143ZM12.1701 15.8143H4.83386V16.2143H12.1701V15.8143ZM13.3255 15.3354C13.0191 15.642 12.6035 15.8143 12.1701 15.8143V16.2143C12.7097 16.2143 13.2271 15.9998 13.6084 15.6181L13.3255 15.3354ZM13.8039 14.1794C13.8039 14.6129 13.6319 15.0287 13.3255 15.3354L13.6084 15.6181C13.9898 15.2364 14.2039 14.7189 14.2039 14.1794H13.8039ZM13.8039 10.1746V14.1794H14.2039V10.1746H13.8039ZM13.5039 9.87464C13.6696 9.87464 13.8039 10.009 13.8039 10.1746H14.2039C14.2039 9.78804 13.8905 9.47464 13.5039 9.47464V9.87464ZM13.2039 10.1746C13.2039 10.009 13.3383 9.87464 13.5039 9.87464V9.47464C13.1173 9.47464 12.8039 9.78804 12.8039 10.1746H13.2039ZM13.2039 14.1794V10.1746H12.8039V14.1794H13.2039ZM12.9011 14.9113C13.095 14.7172 13.2039 14.4539 13.2039 14.1794H12.8039C12.8039 14.3479 12.737 14.5095 12.6181 14.6285L12.9011 14.9113ZM12.1701 15.2143C12.4442 15.2143 12.7071 15.1053 12.9011 14.9113L12.6181 14.6285C12.4992 14.7475 12.338 14.8143 12.1701 14.8143V15.2143ZM4.83386 15.2143H12.1701V14.8143H4.83386V15.2143ZM4.10289 14.9113C4.2968 15.1053 4.55974 15.2143 4.83386 15.2143V14.8143C4.66593 14.8143 4.50476 14.7475 4.38585 14.6285L4.10289 14.9113ZM3.8 14.1794C3.8 14.4539 3.90898 14.7172 4.10289 14.9113L4.38585 14.6285C4.26691 14.5095 4.2 14.3479 4.2 14.1794H3.8ZM3.8 6.83735V14.1794H4.2V6.83735H3.8ZM4.10289 6.10548C3.90898 6.29954 3.8 6.5628 3.8 6.83735H4.2C4.2 6.66879 4.26691 6.50724 4.38585 6.38821L4.10289 6.10548Z"
      fill="currentColor"
      mask="url(#path-1-outside-1_3799_46574)"
    />
  </svg>
)

export const LargeBagIcon = (props: SVGProps) => (
  <svg width="96" height="96" viewBox="0 0 96 96" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M76 24H20C15.5817 24 12 27.2832 12 31.3333V82.6667C12 86.7168 15.5817 90 20 90H76C80.4183 90 84 86.7168 84 82.6667V31.3333C84 27.2832 80.4183 24 76 24Z"
      stroke="currentColor"
      strokeWidth="2.4"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M60 40C60 43.1826 58.7357 46.2348 56.4853 48.4853C54.2348 50.7357 51.1826 52 48 52C44.8174 52 41.7652 50.7357 39.5147 48.4853C37.2643 46.2348 36 43.1826 36 40"
      stroke="currentColor"
      strokeWidth="2.4"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M36 24L36 21C36 17.8174 37.2643 14.7651 39.5147 12.5147C41.7652 10.2643 44.8174 8.99999 48 8.99999C51.1826 8.99999 54.2348 10.2643 56.4853 12.5147C58.7357 14.7651 60 17.8174 60 21L60 24"
      stroke="currentColor"
      strokeWidth="2.4"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
)

export const CircularCloseIcon = (props: SVGProps) => (
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <circle cx="8" cy="8" r="8" fill="#293249" />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M4.64645 4.64645C4.84171 4.45118 5.15829 4.45118 5.35355 4.64645L8 7.29289L10.6464 4.64645C10.8417 4.45118 11.1583 4.45118 11.3536 4.64645C11.5488 4.84171 11.5488 5.15829 11.3536 5.35355L8.70711 8L11.3536 10.6464C11.5488 10.8417 11.5488 11.1583 11.3536 11.3536C11.1583 11.5488 10.8417 11.5488 10.6464 11.3536L8 8.70711L5.35355 11.3536C5.15829 11.5488 4.84171 11.5488 4.64645 11.3536C4.45118 11.1583 4.45118 10.8417 4.64645 10.6464L7.29289 8L4.64645 5.35355C4.45118 5.15829 4.45118 4.84171 4.64645 4.64645Z"
      fill="white"
    />
  </svg>
)

export const SquareArrowDownIcon = (props: SVGProps) => (
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M4.66797 4.66663L11.3346 11.3333M11.3346 11.3333V4.66663M11.3346 11.3333H4.66797"
      stroke="currentColor"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
)

export const SquareArrowUpIcon = (props: SVGProps) => (
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M4.66797 11.3334L11.3346 4.66671M11.3346 4.66671V11.3334M11.3346 4.66671H4.66797"
      stroke="currentColor"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
)

export const CloseTimerIcon = (props: SVGProps) => (
  <svg width="11" height="12" viewBox="0 0 11 12" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M8.2435 3.95892C8.53639 3.66603 8.53639 3.19115 8.2435 2.89826C7.95061 2.60537 7.47573 2.60537 7.18284 2.89826L8.2435 3.95892ZM2.03998 8.04112C1.74709 8.33401 1.74709 8.80888 2.03998 9.10178C2.33288 9.39467 2.80775 9.39467 3.10064 9.10178L2.03998 8.04112ZM3.10064 2.89826C2.80775 2.60537 2.33288 2.60537 2.03998 2.89826C1.74709 3.19115 1.74709 3.66603 2.03998 3.95892L3.10064 2.89826ZM7.18284 9.10178C7.47573 9.39467 7.95061 9.39467 8.2435 9.10178C8.53639 8.80888 8.53639 8.33401 8.2435 8.04112L7.18284 9.10178ZM7.18284 2.89826L2.03998 8.04112L3.10064 9.10178L8.2435 3.95892L7.18284 2.89826ZM2.03998 3.95892L7.18284 9.10178L8.2435 8.04112L3.10064 2.89826L2.03998 3.95892Z"
      fill="currentColor"
    />
  </svg>
)

export const ChevronDownBagIcon = (props: SVGProps) => (
  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M5 7.5L10 12.5L15 7.5"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
)

export const ChevronUpBagIcon = (props: SVGProps) => (
  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M5 12.5L10 7.5L15 12.5"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
)

export const BagCloseIcon = (props: SVGProps) => (
  <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M18.7071 6.70711C19.0976 6.31658 19.0976 5.68342 18.7071 5.29289C18.3166 4.90237 17.6834 4.90237 17.2929 5.29289L18.7071 6.70711ZM5.29289 17.2929C4.90237 17.6834 4.90237 18.3166 5.29289 18.7071C5.68342 19.0976 6.31658 19.0976 6.70711 18.7071L5.29289 17.2929ZM6.70711 5.29289C6.31658 4.90237 5.68342 4.90237 5.29289 5.29289C4.90237 5.68342 4.90237 6.31658 5.29289 6.70711L6.70711 5.29289ZM17.2929 18.7071C17.6834 19.0976 18.3166 19.0976 18.7071 18.7071C19.0976 18.3166 19.0976 17.6834 18.7071 17.2929L17.2929 18.7071ZM17.2929 5.29289L5.29289 17.2929L6.70711 18.7071L18.7071 6.70711L17.2929 5.29289ZM5.29289 6.70711L17.2929 18.7071L18.7071 17.2929L6.70711 5.29289L5.29289 6.70711Z"
      fill="currentColor"
    />
  </svg>
)
