import { ComponentProps } from 'react'
import styled from 'styled-components'

const Container = styled.div`
  position: absolute;
  top: 0;
  left: 0;
  z-index: 0;
`

export const SwapSmarterBannerBackground = (props: ComponentProps<'svg'>) => {
  return (
    <Container>
      <svg width="350" height="150" viewBox="0 0 350 150" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
        <rect width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect y="8.2063" width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect y="16.4124" width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect y="24.6187" width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect y="32.8245" width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect y="41.0308" width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect y="49.2371" width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect y="57.4431" width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect y="65.6494" width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect y="73.8555" width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect y="82.0618" width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect y="90.2681" width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect y="98.4741" width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect y="106.68" width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect y="114.886" width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect y="123.093" width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect y="131.299" width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect y="139.505" width="175" height="1.13189" rx="0.463417" fill="#F50DB4" />
        <rect x="175" y="12.9392" width="175" height="15.5033" rx="0.463417" fill="#F50DB4" />
        <rect x="175" y="73.7178" width="175" height="15.5033" rx="0.463417" fill="#F50DB4" />
        <rect x="175" y="134.497" width="175" height="15.5033" rx="0.463417" fill="#F50DB4" />
      </svg>
    </Container>
  )
}

export const UniswapLogoWithStar = (props: ComponentProps<'svg'>) => (
  <svg width="31.13" height="30.67" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      d="M12.1895 4.03545C11.7551 3.96846 11.7368 3.96059 11.9412 3.92936C12.3329 3.86946 13.2579 3.95109 13.8953 4.10179C15.3833 4.45348 16.7374 5.3544 18.1827 6.95444L18.5667 7.37951L19.116 7.29171C21.4302 6.92195 23.7844 7.21581 25.7534 8.12022C26.2951 8.36904 27.1492 8.86433 27.2559 8.99161C27.2899 9.03218 27.3523 9.29328 27.3946 9.57191C27.5408 10.5358 27.4676 11.2747 27.1711 11.8266C27.0097 12.1269 27.0007 12.222 27.1092 12.479C27.1958 12.6841 27.4373 12.8359 27.6763 12.8356C28.1656 12.8349 28.6923 12.0485 28.9364 10.9541L29.0333 10.5195L29.2253 10.7357C30.2786 11.9223 31.1059 13.5404 31.2481 14.6922L31.2851 14.9926L31.108 14.7196C30.8033 14.2498 30.4972 13.93 30.1051 13.672C29.3984 13.2071 28.6512 13.0489 26.6722 12.9452C24.8849 12.8515 23.8733 12.6997 22.8703 12.3745C21.1637 11.8213 20.3034 11.0845 18.2762 8.44008C17.3758 7.2655 16.8193 6.61563 16.2657 6.09228C15.0077 4.90312 13.7717 4.27947 12.1895 4.03545Z"
      fill="#F50DB4"
    />
    <path
      d="M27.659 6.658C27.704 5.87093 27.8113 5.35178 28.0272 4.87768C28.1126 4.69001 28.1926 4.53642 28.205 4.53642C28.2173 4.53642 28.1802 4.67494 28.1224 4.84421C27.9655 5.30433 27.9398 5.93367 28.0479 6.66587C28.1851 7.59491 28.2631 7.72895 29.2507 8.73252C29.7139 9.20324 30.2527 9.79692 30.448 10.0518L30.8032 10.5153L30.448 10.184C30.0137 9.77901 29.0149 8.98909 28.7942 8.87618C28.6463 8.80045 28.6243 8.80176 28.533 8.89207C28.449 8.97528 28.4312 9.10032 28.4195 9.69143C28.4014 10.6127 28.2751 11.204 27.9703 11.7953C27.8054 12.1151 27.7794 12.0469 27.9286 11.6859C28.04 11.4164 28.0513 11.2979 28.0505 10.4061C28.0488 8.6141 27.8348 8.18329 26.58 7.4453C26.2622 7.25834 25.7384 6.98872 25.4161 6.8461C25.0939 6.70349 24.8379 6.57927 24.8472 6.56999C24.8827 6.53482 26.1065 6.88995 26.599 7.07832C27.3316 7.35854 27.4526 7.39485 27.5415 7.36105C27.6012 7.33839 27.63 7.16569 27.659 6.658Z"
      fill="#F50DB4"
    />
    <path
      d="M13.0332 9.72354C12.1514 8.51647 11.6058 6.66576 11.7239 5.28227L11.7605 4.85414L11.9612 4.89056C12.3381 4.95892 12.988 5.19944 13.2924 5.38323C14.1275 5.88753 14.4891 6.55148 14.8569 8.2564C14.9646 8.75579 15.106 9.32091 15.171 9.51223C15.2758 9.82018 15.6715 10.5395 15.9932 11.0067C16.2249 11.3431 16.071 11.5026 15.5587 11.4566C14.7765 11.3864 13.7168 10.6592 13.0332 9.72354Z"
      fill="#F50DB4"
    />
    <path
      d="M26.5894 18.7071C22.4685 17.0574 21.017 15.6254 21.017 13.2093C21.017 12.8537 21.0294 12.5628 21.0444 12.5628C21.0594 12.5628 21.2188 12.6801 21.3987 12.8236C22.2343 13.49 23.1701 13.7746 25.7606 14.1504C27.285 14.3715 28.1429 14.5501 28.9343 14.8111C31.4495 15.6405 33.0057 17.3236 33.3768 19.6161C33.4846 20.2823 33.4214 21.5315 33.2466 22.1899C33.1085 22.7099 32.6873 23.6472 32.5756 23.6832C32.5447 23.6932 32.5143 23.5751 32.5063 23.4145C32.4639 22.5537 32.0264 21.7156 31.2917 21.0878C30.4562 20.3741 29.3338 19.8058 26.5894 18.7071Z"
      fill="#F50DB4"
    />
    <path
      d="M23.6964 19.3925C23.6447 19.087 23.5552 18.6969 23.4974 18.5255L23.3922 18.214L23.5875 18.432C23.8578 18.7336 24.0714 19.1196 24.2524 19.6337C24.3905 20.026 24.4061 20.1427 24.4051 20.7803C24.404 21.4062 24.3867 21.5374 24.2592 21.8906C24.058 22.4475 23.8084 22.8424 23.3894 23.2662C22.6367 24.028 21.6688 24.4497 20.2722 24.6247C20.0295 24.655 19.3219 24.7062 18.6998 24.7384C17.1321 24.8195 16.1004 24.9869 15.1733 25.3106C15.04 25.3572 14.9209 25.3855 14.9089 25.3735C14.8713 25.3363 15.5026 24.9622 16.024 24.7125C16.7591 24.3604 17.4909 24.1682 19.1306 23.8968C19.9406 23.7626 20.777 23.5999 20.9895 23.5351C22.9953 22.9237 24.0264 21.3457 23.6964 19.3925Z"
      fill="#F50DB4"
    />
    <path
      d="M25.5855 22.7282C25.0379 21.558 24.9122 20.4281 25.2122 19.3743C25.2443 19.2617 25.2959 19.1696 25.3269 19.1696C25.3579 19.1696 25.4872 19.239 25.614 19.3239C25.8663 19.4927 26.3723 19.7772 27.7205 20.508C29.4028 21.4199 30.3619 22.1261 31.0142 22.9329C31.5854 23.6395 31.9389 24.4441 32.1091 25.4254C32.2054 25.9813 32.149 27.3187 32.0055 27.8785C31.5532 29.6433 30.502 31.0295 29.0026 31.8385C28.7829 31.9569 28.5857 32.0542 28.5644 32.0547C28.543 32.0551 28.6231 31.8528 28.7423 31.605C29.2466 30.5566 29.3041 29.5369 28.9227 28.4019C28.6892 27.7069 28.2132 26.8589 27.2519 25.4257C26.1344 23.7593 25.8604 23.3159 25.5855 22.7282Z"
      fill="#F50DB4"
    />
    <path
      d="M10.1067 29.0425C11.6359 27.7587 13.5387 26.8466 15.272 26.5667C16.0189 26.446 17.2633 26.4939 17.955 26.6699C19.0637 26.952 20.0556 27.5839 20.5714 28.3368C21.0755 29.0726 21.2917 29.7138 21.5169 31.1404C21.6057 31.7032 21.7023 32.2683 21.7316 32.3962C21.9007 33.1356 22.2297 33.7266 22.6375 34.0234C23.2852 34.4947 24.4004 34.524 25.4975 34.0985C25.6837 34.0263 25.8454 33.9764 25.8567 33.9876C25.8965 34.0269 25.3441 34.3946 24.9544 34.5882C24.4299 34.8486 24.0129 34.9493 23.4589 34.9493C22.4541 34.9493 21.6199 34.4411 20.9238 33.4048C20.7868 33.2009 20.4789 32.59 20.2396 32.0474C19.5046 30.3807 19.1417 29.8729 18.2883 29.3173C17.5457 28.8338 16.588 28.7472 15.8675 29.0984C14.9211 29.5598 14.657 30.7623 15.3349 31.5244C15.6043 31.8273 16.1067 32.0885 16.5175 32.1393C17.286 32.2344 17.9465 31.653 17.9465 30.8815C17.9465 30.3806 17.7528 30.0947 17.2653 29.876C16.5995 29.5773 15.8838 29.9264 15.8872 30.5483C15.8887 30.8135 16.0049 30.9801 16.2722 31.1004C16.4438 31.1775 16.4477 31.1836 16.3079 31.1547C15.6969 31.0288 15.5538 30.2965 16.045 29.8104C16.6348 29.2268 17.8542 29.4843 18.273 30.2809C18.4489 30.6155 18.4694 31.2819 18.316 31.6843C17.9727 32.5849 16.9718 33.0585 15.9564 32.8008C15.2651 32.6253 14.9836 32.4353 14.1501 31.5817C12.7018 30.0983 12.1395 29.8109 10.0515 29.4868L9.65139 29.4247L10.1067 29.0425Z"
      fill="#F50DB4"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M3.31095 2.49323C8.14768 8.32999 11.479 10.7381 11.8492 11.2469C12.1548 11.667 12.0398 12.0447 11.5162 12.3407C11.225 12.5053 10.6263 12.672 10.3265 12.672C9.9875 12.672 9.8711 12.542 9.8711 12.542C9.67453 12.3566 9.56382 12.389 8.55433 10.6074C7.15285 8.44518 5.97999 6.65152 5.94799 6.62149C5.87401 6.55204 5.87528 6.55439 8.41143 11.0663C8.82121 12.0066 8.49294 12.3518 8.49294 12.4858C8.49294 12.7582 8.41818 12.9014 8.08014 13.2763C7.51661 13.9014 7.2647 14.6037 7.08285 16.0573C6.87899 17.6867 6.30575 18.8377 4.71712 20.8076C3.78719 21.9607 3.63503 22.1721 3.40038 22.6368C3.10482 23.2221 3.02355 23.5499 2.99061 24.289C2.9558 25.0704 3.02361 25.5752 3.26371 26.3223C3.47392 26.9764 3.69334 27.4083 4.25428 28.2721C4.73836 29.0176 5.01709 29.5716 5.01709 29.7883C5.01709 29.9607 5.0502 29.9609 5.80032 29.7926C7.59546 29.3895 9.0531 28.6806 9.87291 27.8119C10.3803 27.2742 10.4994 26.9773 10.5033 26.2404C10.5058 25.7584 10.4887 25.6575 10.3577 25.3803C10.1444 24.929 9.75611 24.5538 8.90028 23.9721C7.77891 23.2099 7.29995 22.5963 7.16765 21.7524C7.05913 21.06 7.18503 20.5715 7.80538 19.2788C8.44748 17.9406 8.6066 17.3704 8.71424 16.0217C8.78375 15.1503 8.88003 14.8066 9.13183 14.5308C9.39445 14.2432 9.63087 14.1457 10.2808 14.0575C11.3404 13.9135 12.0151 13.641 12.5697 13.1328C13.0508 12.692 13.2521 12.2673 13.283 11.6279L13.3064 11.1433L13.0376 10.8316C12.064 9.7029 2.65892 1.60596 2.599 1.60596C2.5862 1.60596 2.90659 2.00526 3.31095 2.49323ZM5.56363 25.1732C5.78376 24.7856 5.6668 24.2872 5.29858 24.0438C4.95067 23.8138 4.4102 23.9221 4.4102 24.2219C4.4102 24.3133 4.46106 24.3799 4.57571 24.4386C4.76876 24.5373 4.78277 24.6484 4.63088 24.8754C4.47706 25.1053 4.48948 25.3074 4.66592 25.4447C4.95028 25.6661 5.35281 25.5444 5.56363 25.1732Z"
      fill="#F50DB4"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M13.9751 14.3117C13.4777 14.4636 12.9942 14.9878 12.8445 15.5374C12.7532 15.8727 12.805 16.4608 12.9418 16.6425C13.1627 16.9359 13.3764 17.0132 13.955 17.0091C15.0878 17.0013 16.0726 16.5182 16.187 15.9143C16.2809 15.4193 15.8484 14.7333 15.2526 14.4321C14.9452 14.2768 14.2914 14.2151 13.9751 14.3117ZM15.2994 15.3412C15.474 15.0944 15.3976 14.8277 15.1005 14.6473C14.5347 14.3038 13.6791 14.5881 13.6791 15.1195C13.6791 15.384 14.1253 15.6727 14.5343 15.6727C14.8065 15.6727 15.179 15.5113 15.2994 15.3412Z"
      fill="#F50DB4"
    />
  </svg>
)
