export type IconPaths = string[]
interface Icons {
  [key: string]: IconPaths
}
export const Icons: Icons = {
  '0': [
    'M35.9315 6.04118C38.8539 5.57595 42.4241 9.14606 41.9588 12.0685C40.7958 19.3746 40.7958 28.6254 41.9588 35.9315C42.424 38.8539 38.8539 42.4241 35.9315 41.9588C28.6254 40.7958 19.3746 40.7958 12.0685 41.9588C9.14606 42.4241 5.57595 38.8539 6.04117 35.9315C7.20424 28.6254 7.20424 19.3746 6.04117 12.0685C5.57594 9.14606 9.14605 5.57594 12.0685 6.04117C19.3746 7.20424 28.6254 7.20424 35.9315 6.04118Z',
  ],
  '2': [
    'M19.9695 5.01604C21.6325 2.32799 26.3675 2.32799 28.0305 5.01604C31.7883 11.0904 36.9096 16.2117 42.984 19.9695C45.672 21.6325 45.672 26.3675 42.984 28.0305C36.9096 31.7883 31.7883 36.9096 28.0305 42.984C26.3675 45.672 21.6325 45.672 19.9695 42.984C16.2117 36.9096 11.0904 31.7883 5.01604 28.0305C2.32799 26.3675 2.32799 21.6325 5.01604 19.9695C11.0904 16.2117 16.2117 11.0904 19.9695 5.01604Z',
  ],
  '3': [
    'M19.8589 4.71531C22.146 2.42823 25.8541 2.42823 28.1411 4.71532L43.2847 19.8589C45.5718 22.146 45.5718 25.8541 43.2847 28.1411L28.1411 43.2847C25.854 45.5718 22.1459 45.5718 19.8589 43.2847L4.71531 28.1411C2.42823 25.854 2.42823 22.1459 4.71532 19.8589L19.8589 4.71531Z',
  ],
  '4': [
    'M24 12.9976L12.9976 24L24 35.0024L35.0024 24L24 12.9976ZM28.1411 4.71532C25.854 2.42823 22.146 2.42823 19.8589 4.71531L4.71532 19.8589C2.42823 22.1459 2.42823 25.854 4.71531 28.1411L19.8589 43.2847C22.1459 45.5718 25.854 45.5718 28.1411 43.2847L43.2847 28.1411C45.5718 25.854 45.5718 22.146 43.2847 19.8589L28.1411 4.71532Z',
  ],
  '5': [
    'M13.2 6C9.22355 6 6 9.22355 6 13.2V34.8C6 38.7765 9.22355 42 13.2 42H34.8C38.7765 42 42 38.7765 42 34.8V13.2C42 9.22355 38.7765 6 34.8 6H13.2ZM24 33C28.9706 33 33 28.9706 33 24C33 19.0294 28.9706 15 24 15C19.0294 15 15 19.0294 15 24C15 28.9706 19.0294 33 24 33Z',
  ],
  '6': [
    'M13.2 6C9.22355 6 6 9.22355 6 13.2V34.8C6 38.7765 9.22355 42 13.2 42H34.8C38.7765 42 42 38.7765 42 34.8V13.2C42 9.22355 38.7765 6 34.8 6H13.2ZM26.1213 14.1213C24.9497 12.9497 23.0503 12.9497 21.8787 14.1213L14.1213 21.8787C12.9497 23.0503 12.9497 24.9497 14.1213 26.1213L21.8787 33.8787C23.0503 35.0503 24.9497 35.0503 26.1213 33.8787L33.8787 26.1213C35.0503 24.9497 35.0503 23.0503 33.8787 21.8787L26.1213 14.1213Z',
  ],
  '7': [
    'M23.1261 0.341446C23.3211 -0.113815 24.6789 -0.113816 24.8739 0.341446C27.3708 6.17087 34.2236 9.00939 40.1112 6.65296C40.571 6.46893 41.5311 7.42898 41.347 7.88879C38.9906 13.7764 41.8291 20.6292 47.6586 23.1261C48.1138 23.3211 48.1138 24.6789 47.6586 24.8739C41.8291 27.3708 38.9906 34.2236 41.347 40.1112C41.5311 40.571 40.571 41.5311 40.1112 41.347C34.2236 38.9906 27.3708 41.8291 24.8739 47.6586C24.6789 48.1138 23.3211 48.1138 23.1261 47.6586C20.6292 41.8291 13.7764 38.9906 7.88878 41.347C7.42898 41.5311 6.46893 40.571 6.65296 40.1112C9.00939 34.2236 6.17087 27.3708 0.341446 24.8739C-0.113815 24.6789 -0.113816 23.3211 0.341446 23.1261C6.17087 20.6292 9.00939 13.7764 6.65296 7.88878C6.46893 7.42898 7.42898 6.46894 7.88879 6.65296C13.7764 9.00939 20.6292 6.17087 23.1261 0.341446Z',
  ],
  '8': [
    'M39.1787 9.90269C39.3397 9.50036 38.4996 8.66032 38.0973 8.82135C32.9456 10.8832 26.9495 8.39951 24.7646 3.29876C24.594 2.90041 23.406 2.90041 23.2354 3.29877C21.0506 8.39951 15.0544 10.8832 9.90269 8.82134C9.50036 8.66032 8.66032 9.50036 8.82134 9.90269C10.8832 15.0544 8.39951 21.0506 3.29876 23.2354C2.90041 23.406 2.90041 24.594 3.29877 24.7646C8.39951 26.9495 10.8832 32.9456 8.82134 38.0973C8.66032 38.4996 9.50036 39.3397 9.90269 39.1787C15.0544 37.1168 21.0506 39.6005 23.2354 44.7012C23.406 45.0996 24.594 45.0996 24.7646 44.7012C26.9495 39.6005 32.9456 37.1168 38.0973 39.1787C38.4996 39.3397 39.3397 38.4996 39.1787 38.0973C37.1168 32.9456 39.6005 26.9495 44.7012 24.7646C45.0996 24.594 45.0996 23.406 44.7012 23.2354C39.6005 21.0506 37.1168 15.0544 39.1787 9.90269ZM24 29.8873C28.8772 29.8873 29.8873 28.8772 29.8873 24C29.8873 19.1228 28.8772 18.1127 24 18.1127C19.1228 18.1127 18.1127 19.1228 18.1127 24C18.1127 28.8772 19.1228 29.8873 24 29.8873Z',
  ],
  '9': [
    'M39.1787 9.90269C39.3397 9.50036 38.4996 8.66032 38.0973 8.82135C32.9456 10.8832 26.9495 8.39951 24.7646 3.29876C24.594 2.90041 23.406 2.90041 23.2354 3.29877C21.0506 8.39951 15.0544 10.8832 9.90269 8.82134C9.50036 8.66032 8.66032 9.50036 8.82134 9.90269C10.8832 15.0544 8.39951 21.0506 3.29876 23.2354C2.90041 23.406 2.90041 24.594 3.29877 24.7646C8.39951 26.9495 10.8832 32.9456 8.82134 38.0973C8.66032 38.4996 9.50036 39.3397 9.90269 39.1787C15.0544 37.1168 21.0506 39.6005 23.2354 44.7012C23.406 45.0996 24.594 45.0996 24.7646 44.7012C26.9495 39.6005 32.9456 37.1168 38.0973 39.1787C38.4996 39.3397 39.3397 38.4996 39.1787 38.0973C37.1168 32.9456 39.6005 26.9495 44.7012 24.7646C45.0996 24.594 45.0996 23.406 44.7012 23.2354C39.6005 21.0506 37.1168 15.0544 39.1787 9.90269ZM32.5708 24.2602C32.7145 24.1165 32.7145 23.8835 32.5708 23.7398L24.2602 15.4292C24.1165 15.2855 23.8835 15.2855 23.7398 15.4292L15.4292 23.7398C15.2855 23.8835 15.2855 24.1165 15.4292 24.2602L23.7398 32.5708C23.8835 32.7145 24.1165 32.7145 24.2602 32.5708L32.5708 24.2602Z',
  ],
  '10': [
    'M37.5625 3.9963C36.6683 3.38886 35.4972 3.38886 34.603 3.9963C28.2038 8.34345 24 15.6808 24 24V2.85513C24 1.18684 22.6418 -0.185425 20.9863 0.0205284C13.9255 0.898912 7.81014 4.82329 3.9963 10.4375C3.38886 11.3317 3.38886 12.5028 3.9963 13.3969C8.34345 19.7962 15.6808 24 24 24H2.85513C1.18684 24 -0.185425 25.3582 0.0205285 27.0137C0.898913 34.0745 4.82329 40.1899 10.4375 44.0037C11.3317 44.6111 12.5028 44.6111 13.397 44.0037C19.7962 39.6565 24 32.3192 24 24L24 45.1449C24 46.8132 25.3582 48.1854 27.0137 47.9795C34.0745 47.1011 40.1899 43.1767 44.0037 37.5625C44.6111 36.6683 44.6111 35.4972 44.0037 34.603C39.658 28.206 32.3242 24.0028 24.0084 24H45.1449C46.8132 24 48.1854 22.6418 47.9795 20.9863C47.1011 13.9255 43.1767 7.81015 37.5625 3.9963Z',
  ],
  '11': [
    'M39.2895 41.8988C40.8137 42.423 42.423 40.8137 41.8988 39.2896C38.4921 29.3839 38.4921 18.6161 41.8988 8.71045C42.423 7.18627 40.8137 5.57697 39.2895 6.10116C29.3839 9.50786 18.6161 9.50786 8.71045 6.10116C7.18627 5.57697 5.57697 7.18627 6.10116 8.71045C9.50786 18.6161 9.50786 29.3839 6.10116 39.2896C5.57697 40.8137 7.18627 42.423 8.71045 41.8988C18.6161 38.4921 29.3839 38.4921 39.2895 41.8988ZM33.1899 25.2278C33.868 24.5497 33.868 23.4503 33.1899 22.7723L25.2277 14.8101C24.5497 14.1321 23.4503 14.1321 22.7723 14.8101L14.8101 22.7723C14.132 23.4503 14.132 24.5497 14.8101 25.2278L22.7723 33.1899C23.4503 33.868 24.5497 33.868 25.2277 33.1899L33.1899 25.2278Z',
  ],
  '12': [
    'M43.858 25.3653C45.0968 24.7606 45.0968 22.8141 43.858 22.2094C35.8073 18.2791 29.2954 11.7672 25.3651 3.71643C24.7603 2.47766 22.8139 2.47766 22.2091 3.71643C18.2789 11.7672 11.7669 18.2791 3.71619 22.2094C2.47742 22.8141 2.47742 24.7606 3.71618 25.3653C11.7669 29.2956 18.2789 35.8076 22.2091 43.8583C22.8139 45.097 24.7603 45.097 25.3651 43.8583C29.2954 35.8076 35.8073 29.2956 43.858 25.3653ZM31.6468 24.8374C32.2267 24.2575 32.2267 23.3172 31.6468 22.7373L24.8371 15.9276C24.2572 15.3477 23.317 15.3477 22.7371 15.9276L15.9274 22.7373C15.3475 23.3172 15.3475 24.2575 15.9274 24.8374L22.7371 31.6471C23.317 32.227 24.2572 32.227 24.8371 31.6471L31.6468 24.8374Z',
    'M26.9998 24.0001C26.9998 25.6569 25.6567 27.0001 23.9998 27.0001C22.343 27.0001 20.9998 25.6569 20.9998 24.0001C20.9998 22.3432 22.343 21.0001 23.9998 21.0001C25.6567 21.0001 26.9998 22.3432 26.9998 24.0001Z',
  ],
  '13': [
    'M3 5C3 3.89543 3.89543 3 5 3H22C23.1046 3 24 3.89543 24 5V24H5C3.89543 24 3 23.1046 3 22V5Z',
    'M24 24H43C44.1046 24 45 24.8954 45 26V43C45 44.1046 44.1046 45 43 45H26C24.8954 45 24 44.1046 24 43V24Z',
  ],
  '14': [
    'M41.1283 12.9343C44.0366 8.93533 39.0647 3.96337 35.0658 6.87168L27.798 12.1573L26.5004 9.92938C25.3843 8.01323 22.6161 8.01323 21.5 9.92938L20.2023 12.1575L12.9343 6.87169C8.93533 3.96338 3.96337 8.93532 6.87168 12.9342L12.1574 20.2022L9.92973 21.4997C8.01358 22.6157 8.01358 25.3839 9.92973 26.5L12.1576 27.7976L6.87169 35.0657C3.96338 39.0647 8.93532 44.0366 12.9342 41.1283L20.2024 35.8424L21.5 38.0703C22.6161 39.9865 25.3843 39.9865 26.5004 38.0703L27.7979 35.8426L35.0657 41.1283C39.0647 44.0366 44.0366 39.0647 41.1283 35.0658L35.8425 27.7978L38.0707 26.5C39.9868 25.3839 39.9868 22.6157 38.0707 21.4997L35.8427 20.202L41.1283 12.9343Z',
  ],
  '15': [
    'M22.3866 1.13864C22.9265 -0.379548 25.0735 -0.379548 25.6134 1.13864L29.2424 11.3436L39.0246 6.69372C40.4798 6.00196 41.998 7.52015 41.3063 8.97544L36.6564 18.7576L46.8614 22.3866C48.3796 22.9265 48.3796 25.0735 46.8614 25.6134L36.6564 29.2425L41.3063 39.0246C41.998 40.4798 40.4798 41.998 39.0246 41.3063L29.2424 36.6564L25.6134 46.8614C25.0735 48.3796 22.9265 48.3796 22.3866 46.8614L18.7576 36.6564L8.97544 41.3063C7.52015 41.998 6.00196 40.4798 6.69372 39.0246L11.3436 29.2425L1.13864 25.6134C-0.379548 25.0735 -0.379548 22.9265 1.13864 22.3866L11.3436 18.7576L6.69372 8.97544C6.00196 7.52015 7.52015 6.00196 8.97544 6.69372L18.7576 11.3436L22.3866 1.13864Z',
  ],
  '16': [
    'M25.6134 1.13864C25.0735 -0.379548 22.9265 -0.379548 22.3866 1.13864L18.7576 11.3436L8.97544 6.69372C7.52015 6.00196 6.00196 7.52015 6.69372 8.97544L11.3436 18.7576L1.13864 22.3866C-0.379548 22.9265 -0.379548 25.0735 1.13864 25.6134L11.3436 29.2425L6.69372 39.0246C6.00196 40.4799 7.52015 41.998 8.97544 41.3063L18.7576 36.6564L22.3866 46.8614C22.9265 48.3795 25.0735 48.3796 25.6134 46.8614L29.2424 36.6564L39.0246 41.3063C40.4799 41.998 41.998 40.4799 41.3063 39.0246L36.6564 29.2425L46.8614 25.6134C48.3795 25.0735 48.3796 22.9265 46.8614 22.3866L36.6564 18.7576L41.3063 8.97544C41.998 7.52015 40.4799 6.00196 39.0246 6.69372L29.2424 11.3436L25.6134 1.13864ZM33.8785 26.1211C35.0501 24.9496 35.0501 23.0501 33.8785 21.8785L26.1211 14.1211C24.9496 12.9496 23.0501 12.9496 21.8785 14.1211L14.1211 21.8785C12.9496 23.0501 12.9496 24.9496 14.1211 26.1211L21.8785 33.8785C23.0501 35.0501 24.9496 35.0501 26.1211 33.8785L33.8785 26.1211Z',
  ],
  '17': [
    'M20.9454 0.0175773C22.4936 -0.167833 23.763 1.13917 23.763 2.72944V21.3625C23.763 22.9527 22.4993 24.2419 20.9405 24.2419L2.67549 24.2419C1.11665 24.2419 -0.16452 22.9469 0.0172307 21.3675C1.30306 10.1936 9.99222 1.32931 20.9454 0.0175773Z',
    'M27.0546 47.9824C25.5064 48.1678 24.237 46.8608 24.237 45.2706V26.6375C24.237 25.0473 25.5007 23.7581 27.0595 23.7581L45.3245 23.7581C46.8833 23.7581 48.1645 25.0531 47.9828 26.6325C46.6969 37.8064 38.0078 46.6707 27.0546 47.9824Z',
  ],
  '18': [
    'M38.8016 5.11721C40.0503 6.10068 40.0418 7.94128 38.9183 9.06599L26.0344 21.9636C24.9109 23.0883 23.0893 23.0883 21.9657 21.9636L9.08172 9.06587C7.9582 7.94116 7.94965 6.10056 9.19842 5.11709C17.8618 -1.70574 30.1382 -1.70569 38.8016 5.11721Z',
    'M9.19842 42.8829C7.94965 41.8994 7.9582 40.0588 9.08172 38.9341L21.9656 26.0365C23.0891 24.9118 24.9107 24.9118 26.0342 26.0365L38.9183 38.9342C40.0418 40.0589 40.0503 41.8995 38.8016 42.883C30.1382 49.7058 17.8618 49.7058 9.19842 42.8829Z',
  ],
  '19': [
    'M3.21139 5.99109C2.97749 4.35083 4.34315 3 6 3H21C22.6569 3 24 4.34315 24 6V17.5019C24 17.777 24.223 18 24.4981 18C24.7185 18 24.9123 17.8546 24.9789 17.6445C27.3805 10.0723 33.959 4.35932 42.0089 3.2114C43.6492 2.97749 45 4.34315 45 6V21C45 22.6569 43.6569 24 42 24H30.4981C30.223 24 30 24.223 30 24.4981C30 24.7185 30.1454 24.9123 30.3555 24.9789C37.9277 27.3805 43.6407 33.959 44.7886 42.0089C45.0225 43.6492 43.6569 45 42 45H27C25.3431 45 24 43.6569 24 42L24 30.4981C24 30.223 23.777 30 23.5019 30C23.2815 30 23.0877 30.1454 23.0211 30.3555C20.6195 37.9277 14.041 43.6407 5.99109 44.7886C4.35083 45.0225 3 43.6569 3 42V27C3 25.3431 4.34315 24 6 24H17.5019C17.777 24 18 23.777 18 23.5019C18 23.2815 17.8546 23.0877 17.6445 23.0211C10.0723 20.6195 4.35932 14.041 3.21139 5.99109Z',
  ],
  '20': [
    'M42 39C42 40.6569 40.6468 42.0262 39.0126 41.7532C30.4932 40.3302 24 32.9234 24 24C24 32.9234 17.5068 40.3302 8.98744 41.7532C7.35323 42.0262 6 40.6568 6 39L6 24C6 14.0589 14.0589 6 24 6C33.9411 6 42 14.0589 42 24L42 39Z',
  ],
  '21': [
    'M6 8C6 6.89543 6.89889 5.98834 7.9968 6.1095C16.9982 7.10294 24 14.7338 24 24C24 14.7338 31.0018 7.10293 40.0032 6.1095C41.1011 5.98834 42 6.89543 42 8L42 24C42 33.9411 33.9411 42 24 42C14.0589 42 6 33.9411 6 24V8Z',
  ],
  '22': [
    'M24 39C32.2843 39 39 32.2843 39 24C39 15.7157 32.2843 9 24 9C15.7157 9 9 15.7157 9 24C9 32.2843 15.7157 39 24 39ZM24 48C37.2548 48 48 37.2548 48 24C48 10.7452 37.2548 0 24 0C10.7452 0 0 10.7452 0 24C0 37.2548 10.7452 48 24 48Z',
    'M33 24C33 28.9706 28.9706 33 24 33C19.0294 33 15 28.9706 15 24C15 19.0294 19.0294 15 24 15C28.9706 15 33 19.0294 33 24Z',
  ],
  '23': [
    'M24 48C37.2548 48 48 37.2548 48 24C48 10.7452 37.2548 0 24 0C10.7452 0 0 10.7452 0 24C0 37.2548 10.7452 48 24 48ZM24 39C32.2843 39 39 32.2843 39 24C39 15.7157 32.2843 9 24 9C15.7157 9 9 15.7157 9 24C9 32.2843 15.7157 39 24 39Z',
  ],
  '24': [
    'M24 48C37.2548 48 48 37.2548 48 24C48 10.7452 37.2548 0 24 0C10.7452 0 0 10.7452 0 24C0 37.2548 10.7452 48 24 48ZM15 12C13.3431 12 12 13.3431 12 15V33C12 34.6569 13.3431 36 15 36H33C34.6569 36 36 34.6569 36 33V15C36 13.3431 34.6569 12 33 12H15Z',
  ],
  '25': [
    'M33.3792 44.7786C33.3792 45.6276 32.8025 46.3502 32.0018 46.6327C26.8338 48.4558 21.1662 48.4558 15.9981 46.6327C15.1975 46.3502 14.6208 45.6276 14.6208 44.7786C14.6208 42.5409 16.4262 38.267 18.4528 34.1744C19.1126 32.8421 18.8692 31.2332 17.818 30.182C16.7668 29.1307 15.1579 28.8874 13.8256 29.5471C9.73302 31.5738 5.45914 33.3792 3.22143 33.3792C2.3724 33.3792 1.64977 32.8025 1.36732 32.0018C-0.455773 26.8338 -0.455774 21.1662 1.36732 15.9982C1.64977 15.1975 2.3724 14.6208 3.22144 14.6208C5.45914 14.6208 9.73302 16.4262 13.8256 18.4528C15.1579 19.1126 16.7668 18.8692 17.818 17.818C18.8692 16.7668 19.1126 15.1579 18.4528 13.8256C16.4262 9.73302 14.6208 5.45915 14.6208 3.22144C14.6208 2.3724 15.1975 1.64977 15.9982 1.36732C21.1662 -0.455775 26.8338 -0.455774 32.0018 1.36732C32.8025 1.64978 33.3792 2.3724 33.3792 3.22144C33.3792 5.45914 31.5738 9.73301 29.5472 13.8256C28.8874 15.1579 29.1307 16.7668 30.182 17.818C31.2332 18.8692 32.8421 19.1126 34.1744 18.4528C38.267 16.4262 42.5408 14.6208 44.7785 14.6208C45.6276 14.6208 46.3502 15.1975 46.6327 15.9982C48.4557 21.1662 48.4558 26.8338 46.6327 32.0018C46.3502 32.8025 45.6276 33.3792 44.7785 33.3792C42.5408 33.3792 38.267 31.5738 34.1744 29.5472C32.8421 28.8874 31.2332 29.1308 30.182 30.182C29.1307 31.2332 28.8874 32.8421 29.5471 34.1744C31.5738 38.267 33.3792 42.5409 33.3792 44.7786Z',
  ],
  '26': [
    'M31.3191 12C30.5659 12 30.048 11.2453 30.284 10.5301C30.7006 9.2676 30.9586 8.16879 30.9586 7.38358C30.9586 3.30574 27.8433 0 24.0004 0C20.1574 0 17.0421 3.30574 17.0421 7.38358C17.0421 8.16871 17.3 9.26735 17.7166 10.5297C17.9527 11.2451 17.4346 12 16.6812 12C16.3583 12 16.0535 11.8538 15.8447 11.6075C15.0056 10.617 14.2238 9.84775 13.5729 9.45896C10.1595 7.42004 5.83469 8.55845 3.91321 12.0017C1.99173 15.4449 3.2012 19.8891 6.61463 21.928C7.55052 22.487 9.28014 22.8952 11.2979 23.1934C11.6991 23.2526 12 23.5945 12 24C12 24.4056 11.6991 24.7474 11.2979 24.8066C9.28013 25.1048 7.55051 25.513 6.61463 26.072C3.2012 28.1109 1.99173 32.5551 3.91321 35.9983C5.83469 39.4415 10.1595 40.58 13.5729 38.541C14.2238 38.1522 15.0056 37.383 15.8447 36.3925C16.0535 36.1462 16.3583 36 16.6812 36C17.4346 36 17.9527 36.7549 17.7166 37.4703C17.3 38.7326 17.0421 39.8313 17.0421 40.6164C17.0421 44.6943 20.1574 48 24.0004 48C27.8433 48 30.9586 44.6943 30.9586 40.6164C30.9586 39.8312 30.7006 38.7324 30.284 37.4699C30.048 36.7547 30.5659 36 31.3191 36C31.6419 36 31.9466 36.1461 32.1553 36.3924C32.9944 37.3829 33.7762 38.1522 34.4271 38.541C37.8405 40.5799 42.1654 39.4415 44.0868 35.9982C46.0083 32.555 44.7988 28.1109 41.3854 26.0719C40.4495 25.5129 38.7198 25.1047 36.702 24.8065C36.3009 24.7473 36 24.4055 36 24C36 23.5945 36.3009 23.2527 36.702 23.1935C38.7198 22.8953 40.4495 22.4871 41.3854 21.9281C44.7988 19.8891 46.0083 15.445 44.0868 12.0018C42.1654 8.55854 37.8405 7.42012 34.4271 9.45904C33.7762 9.84783 32.9944 10.6171 32.1553 11.6076C31.9466 11.8539 31.6419 12 31.3191 12Z',
  ],
  '27': [
    'M16.5 24C16.5 22.7276 15.6729 21.6068 14.4665 21.2022C10.6157 19.9109 6.74897 18.3551 5.34083 16.947C2.18519 13.7914 2.22515 8.63507 5.43014 5.43012C8.63508 2.22516 13.7914 2.18518 16.9471 5.34083C18.3552 6.74896 19.911 10.6157 21.2023 14.4665C21.6068 15.6729 22.7276 16.5 24 16.5C25.2724 16.5 26.3932 15.6729 26.7977 14.4665C28.089 10.6157 29.6448 6.74896 31.053 5.34083C34.2087 2.18518 39.3649 2.22516 42.5699 5.43012C45.7748 8.63507 45.8148 13.7914 42.6592 16.947C41.2511 18.3551 37.3843 19.9109 33.5335 21.2022C32.3272 21.6068 31.5 22.7276 31.5 24C31.5 25.2724 32.3272 26.3932 33.5335 26.7978C37.3843 28.0891 41.2511 29.6449 42.6592 31.053C45.8148 34.2087 45.7748 39.3649 42.5699 42.5699C39.3649 45.7749 34.2087 45.8148 31.053 42.6592C29.6448 41.2511 28.0891 37.3843 26.7978 33.5335C26.3933 32.3272 25.2724 31.5 24.0001 31.5C22.7277 31.5 21.6068 32.3272 21.2023 33.5335C19.911 37.3843 18.3552 41.2511 16.9471 42.6592C13.7914 45.8148 8.63508 45.7749 5.43014 42.5699C2.22515 39.3649 2.18519 34.2087 5.34083 31.053C6.74893 29.6449 10.6157 28.0891 14.4665 26.7978C15.6729 26.3932 16.5 25.2724 16.5 24Z',
  ],
  '28': [
    'M17.616 10.2184C18.1375 11.8705 20.051 12.5324 21.7533 12.21C22.4811 12.0721 23.2321 12 24 12C24.7681 12 25.5193 12.0722 26.2472 12.2101C27.9495 12.5326 29.8631 11.8708 30.3846 10.2185C30.7418 9.08697 30.9586 8.10348 30.9586 7.38358C30.9586 3.30574 27.8433 0 24.0004 0C20.1574 0 17.0421 3.30574 17.0421 7.38358C17.0421 8.10345 17.2589 9.08688 17.616 10.2184Z',
    'M15.6147 11.3399C16.7538 12.6447 16.3151 14.6228 15.1457 15.9004C14.0378 17.1109 13.1749 18.5492 12.6354 20.1369C12.0747 21.7868 10.5389 23.142 8.84516 22.7325C7.9119 22.5069 7.13878 22.2411 6.61463 21.928C3.2012 19.8891 1.99173 15.4449 3.91321 12.0017C5.83469 8.55845 10.1595 7.42004 13.5729 9.45896C14.1639 9.81199 14.8629 10.4787 15.6147 11.3399Z',
    'M12.6354 27.8631C12.0747 26.2132 10.5389 24.858 8.84518 25.2675C7.91191 25.4931 7.13878 25.7589 6.61463 26.072C3.2012 28.1109 1.99173 32.5551 3.91321 35.9983C5.83469 39.4415 10.1595 40.58 13.5729 38.541C14.1639 38.188 14.8629 37.5213 15.6147 36.6601C16.7538 35.3553 16.3151 33.3772 15.1457 32.0996C14.0378 30.8891 13.1749 29.4508 12.6354 27.8631Z',
    'M21.7533 35.79C20.051 35.4676 18.1375 36.1295 17.616 37.7816C17.2589 38.9131 17.0421 39.8966 17.0421 40.6164C17.0421 44.6943 20.1574 48 24.0004 48C27.8433 48 30.9586 44.6943 30.9586 40.6164C30.9586 39.8965 30.7418 38.913 30.3846 37.7815C29.8631 36.1292 27.9495 35.4674 26.2472 35.7899C25.5193 35.9278 24.7681 36 24 36C23.2321 36 22.4811 35.9279 21.7533 35.79Z',
    'M32.8544 32.0995C31.685 33.3772 31.2463 35.3552 32.3853 36.66C33.1371 37.5212 33.8361 38.1879 34.4271 38.541C37.8405 40.5799 42.1654 39.4415 44.0868 35.9982C46.0083 32.555 44.7988 28.1109 41.3854 26.0719C40.8612 25.7589 40.0881 25.4931 39.1549 25.2674C37.4611 24.8579 35.9253 26.2131 35.3647 27.863C34.8251 29.4507 33.9622 30.8891 32.8544 32.0995Z',
    'M39.1549 22.7326C37.4611 23.1421 35.9253 21.7869 35.3647 20.137C34.8251 18.5493 33.9622 17.1109 32.8544 15.9005C31.685 14.6228 31.2463 12.6448 32.3853 11.34C33.1371 10.4788 33.8361 9.81207 34.4271 9.45904C37.8405 7.42012 42.1654 8.55854 44.0868 12.0018C46.0083 15.445 44.7988 19.8891 41.3854 21.9281C40.8612 22.2411 40.0881 22.5069 39.1549 22.7326Z',
  ],
  '29': [
    'M26.237 0.926653C25.0014 -0.308885 22.9982 -0.308884 21.7627 0.926655L16.0911 6.59826H9.76032C8.01301 6.59826 6.59653 8.01474 6.59653 9.76205V16.0928L0.926653 21.7627C-0.308885 22.9982 -0.308884 25.0014 0.926654 26.237L6.59653 31.9068V38.238C6.59653 39.9853 8.01301 41.4018 9.76033 41.4018H16.0911L21.7627 47.0733C22.9982 48.3089 25.0014 48.3089 26.237 47.0733L31.9085 41.4018H38.237C39.9843 41.4018 41.4008 39.9853 41.4008 38.238V31.9091L47.073 26.237C48.3085 25.0014 48.3085 22.9982 47.073 21.7627L41.4008 16.0905V9.76205C41.4008 8.01474 39.9843 6.59826 38.237 6.59826H31.9086L26.237 0.926653ZM25.8615 15.2798C24.8332 14.2515 23.166 14.2515 22.1377 15.2798L15.2794 22.1381C14.2511 23.1664 14.2511 24.8336 15.2794 25.8618L22.1377 32.7201C23.166 33.7484 24.8332 33.7484 25.8615 32.7201L32.7197 25.8618C33.748 24.8336 33.748 23.1664 32.7197 22.1381L25.8615 15.2798Z',
  ],
  '30': [
    'M23.9977 0C20.5488 0.000333309 17.5532 1.94053 16.0425 4.78886C12.9601 3.84306 9.47004 4.58931 7.0311 7.02778L7.02777 7.0311C4.58931 9.47004 3.84305 12.9601 4.78885 16.0425C1.94053 17.5532 0.000333309 20.5488 0 23.9976V24.0024C0.000333309 27.4512 1.94053 30.4468 4.78886 31.9575C3.84306 35.0399 4.58931 38.53 7.02778 40.9689L7.0311 40.9722C9.47004 43.4107 12.9602 44.1569 16.0425 43.2111C17.5532 46.0595 20.5488 47.9997 23.9976 48H24.0024C27.4512 47.9997 30.4468 46.0595 31.9575 43.2111C35.0399 44.1569 38.53 43.4107 40.9689 40.9722L40.9722 40.9689C43.4107 38.53 44.1569 35.0399 43.2111 31.9575C46.0595 30.4468 47.9997 27.4512 48 24.0024V23.9977C47.9997 20.5488 46.0595 17.5532 43.2111 16.0425C44.1569 12.9601 43.4107 9.47004 40.9722 7.0311L40.9689 7.02777C38.53 4.58931 35.0399 3.84305 31.9575 4.78885C30.4468 1.94053 27.4512 0.000333309 24.0024 0H23.9977ZM24 33C28.9706 33 33 28.9706 33 24C33 19.0294 28.9706 15 24 15C19.0294 15 15 19.0294 15 24C15 28.9706 19.0294 33 24 33Z',
  ],
  '31': [
    'M23.9984 0C20.6847 0.000213504 17.9986 2.68668 17.9988 6.00039C17.999 9.31409 20.6871 12.0002 24.0008 12C27.3145 12.0002 30.001 9.3141 30.0012 6.00039C30.0014 2.68668 27.3153 0.000213504 24.0016 0H23.9984Z',
    'M40.9695 7.02833C38.6262 4.68533 34.8272 4.68558 32.4842 7.02888C30.1412 9.37218 30.1425 13.1723 32.4858 15.5153C34.8288 17.8586 38.6278 17.8588 40.9711 15.5158C43.3144 13.1728 43.3147 9.37384 40.9717 7.03055L40.9695 7.02833Z',
    'M15.5153 15.5142C17.8586 13.1712 17.8588 9.37218 15.5158 7.02888C13.1728 4.68558 9.37384 4.68534 7.03055 7.02833L7.02833 7.03055C4.68533 9.37385 4.68558 13.1728 7.02888 15.5158C9.37218 17.8588 13.1723 17.8575 15.5153 15.5142Z',
    'M12 23.9992C12.0002 20.6855 9.3141 17.999 6.00039 17.9988C2.68668 17.9986 0.000213504 20.6847 0 23.9984V24.0016C0.000213504 27.3153 2.68668 30.0014 6.00039 30.0012C9.31409 30.001 12.0002 27.3129 12 23.9992Z',
    'M48 23.9984C47.9998 20.6847 45.3133 17.9986 41.9996 17.9988C38.6859 17.999 35.9998 20.6871 36 24.0008C35.9998 27.3145 38.6859 30.001 41.9996 30.0012C45.3133 30.0014 47.9998 27.3153 48 24.0016V23.9984Z',
    'M15.5142 32.4847C13.1712 30.1414 9.37218 30.1412 7.02888 32.4842C4.68558 34.8272 4.68534 38.6262 7.02833 40.9695L7.03055 40.9717C9.37385 43.3147 13.1728 43.3144 15.5158 40.9711C17.8588 38.6278 17.8575 34.8277 15.5142 32.4847Z',
    'M40.9717 40.9695C43.3147 38.6262 43.3144 34.8272 40.9711 32.4842C38.6278 30.1412 34.8277 30.1425 32.4847 32.4858C30.1414 34.8288 30.1412 38.6278 32.4842 40.9711C34.8272 43.3144 38.6262 43.3147 40.9695 40.9717L40.9717 40.9695Z',
    'M23.9992 36C20.6855 35.9998 17.999 38.6859 17.9988 41.9996C17.9986 45.3133 20.6847 47.9998 23.9984 48H24.0016C27.3153 47.9998 30.0014 45.3133 30.0012 41.9996C30.001 38.6859 27.3129 35.9998 23.9992 36Z',
    'M24 33C28.9706 33 33 28.9706 33 24C33 19.0294 28.9706 15 24 15C19.0294 15 15 19.0294 15 24C15 28.9706 19.0294 33 24 33Z',
  ],
  '32': [
    'M21 6C21 4.34315 22.3431 3 24 3C25.6569 3 27 4.34315 27 6V15C27 16.6569 25.6569 18 24 18C22.3431 18 21 16.6569 21 15V6Z',
    'M21 33C21 31.3431 22.3431 30 24 30C25.6569 30 27 31.3431 27 33V42C27 43.6569 25.6569 45 24 45C22.3431 45 21 43.6569 21 42V33Z',
    'M42 21C43.6569 21 45 22.3431 45 24C45 25.6569 43.6569 27 42 27H33C31.3431 27 30 25.6569 30 24C30 22.3431 31.3431 21 33 21H42Z',
    'M15 21C16.6569 21 18 22.3431 18 24C18 25.6569 16.6569 27 15 27H6C4.34315 27 3 25.6569 3 24C3 22.3431 4.34315 21 6 21H15Z',
  ],
  '33': [
    'M35.9747 7.03378C37.353 5.65541 39.5878 5.65541 40.9662 7.03378C42.3446 8.41216 42.3446 10.647 40.9662 12.0253L33.4789 19.5127C32.1005 20.891 29.8657 20.891 28.4873 19.5127C27.1089 18.1343 27.1089 15.8995 28.4873 14.5211L35.9747 7.03378Z',
    'M14.5211 28.4873C15.8995 27.1089 18.1343 27.1089 19.5127 28.4873C20.891 29.8657 20.891 32.1005 19.5127 33.4789L12.0253 40.9662C10.647 42.3446 8.41216 42.3446 7.03379 40.9662C5.65541 39.5878 5.65541 37.353 7.03379 35.9747L14.5211 28.4873Z',
    'M40.9662 35.9747C42.3446 37.353 42.3446 39.5878 40.9662 40.9662C39.5878 42.3446 37.353 42.3446 35.9747 40.9662L28.4873 33.4789C27.1089 32.1005 27.1089 29.8657 28.4873 28.4873C29.8657 27.1089 32.1005 27.1089 33.4789 28.4873L40.9662 35.9747Z',
    'M19.5127 14.5211C20.891 15.8995 20.891 18.1343 19.5127 19.5127C18.1343 20.891 15.8995 20.891 14.5211 19.5127L7.03378 12.0253C5.6554 10.647 5.65541 8.41216 7.03379 7.03378C8.41216 5.6554 10.647 5.65541 12.0253 7.03378L19.5127 14.5211Z',
  ],
  '34': [
    'M41.9999 4.5C43.6567 4.5 45.0224 5.85083 44.7885 7.49109C43.3366 17.6723 34.5824 25.5 23.9999 25.5C13.4174 25.5 4.6631 17.6723 3.21125 7.49109C2.97734 5.85083 4.343 4.5 5.99985 4.5H13.4999C19.2988 4.5 23.9999 9.20101 23.9999 15C23.9999 9.20101 28.7009 4.5 34.4999 4.5H41.9999Z',
    'M5.99985 25.5C4.343 25.5 2.97734 26.8508 3.21125 28.4911C4.6631 38.6723 13.4174 46.5 23.9999 46.5C34.5824 46.5 43.3366 38.6723 44.7885 28.4911C45.0224 26.8508 43.6567 25.5 41.9999 25.5H34.4999C28.7009 25.5 23.9999 30.201 23.9999 36C23.9999 30.201 19.2988 25.5 13.4999 25.5H5.99985Z',
  ],
  '35': [
    'M6.03559 39.0129C5.75948 40.6466 7.12908 42 8.78593 42L14.8932 42C19.923 42 24.0004 37.9706 24.0004 33C24.0004 37.9706 28.0778 42 33.1076 42H39.2149C40.8717 42 42.2413 40.6466 41.9652 39.0129C40.8075 32.1648 35.7368 26.6258 29.1019 24.716C28.7811 24.6237 28.554 24.3338 28.554 24C28.554 23.6662 28.7811 23.3763 29.1019 23.284C35.7368 21.3742 40.8075 15.8352 41.9652 8.9871C42.2413 7.35343 40.8717 6 39.2149 6H33.1076C28.0778 6 24.0004 10.0294 24.0004 15C24.0004 10.0294 19.923 6 14.8932 6H8.78593C7.12908 6 5.75948 7.35342 6.03559 8.98711C7.1931 15.8359 12.2638 21.3753 18.8992 23.2846C19.2198 23.3768 19.4468 23.6664 19.4468 24C19.4468 24.3336 19.2198 24.6232 18.8992 24.7154C12.2638 26.6247 7.1931 32.1641 6.03559 39.0129Z',
  ],
  '36': [
    'M28.541 24C28.541 23.6075 28.7998 23.264 29.1711 23.1367C35.8814 20.8368 40.9702 14.1754 41.9802 5.99363C42.1832 4.34926 40.8202 3 39.1634 3H8.8369C7.18005 3 5.81706 4.34926 6.02011 5.99363C7.03026 14.1742 12.1192 20.8349 18.8286 23.1357C19.2002 23.2632 19.4593 23.6071 19.4593 24C19.4593 24.3929 19.2002 24.7368 18.8286 24.8643C12.1192 27.1651 7.03026 33.8258 6.02011 42.0064C5.81706 43.6507 7.18005 45 8.8369 45H39.1634C40.8202 45 42.1832 43.6507 41.9802 42.0064C40.9702 33.8246 35.8814 27.1632 29.1711 24.8633C28.7998 24.736 28.541 24.3925 28.541 24Z',
  ],
  '37': [
    'M30 6C30 2.68629 27.3137 0 24 0C20.6863 0 18 2.68629 18 6V16C18 17.1046 17.1046 18 16 18H6C2.68629 18 0 20.6863 0 24C0 27.3137 2.68629 30 6 30H16C17.1046 30 18 30.8954 18 32V42C18 45.3137 20.6863 48 24 48C27.3137 48 30 45.3137 30 42V32C30 30.8954 30.8954 30 32 30H42C45.3137 30 48 27.3137 48 24C48 20.6863 45.3137 18 42 18H32C30.8954 18 30 17.1046 30 16V6Z',
  ],
  '38': [
    'M14.4853 4.97056C11.8579 2.34315 7.59798 2.34315 4.97056 4.97056C2.34315 7.59798 2.34315 11.8579 4.97056 14.4853L12.1066 21.6213C13.4203 22.935 13.4203 25.065 12.1066 26.3787L4.97056 33.5147C2.34315 36.1421 2.34315 40.402 4.97056 43.0294C7.59798 45.6569 11.8579 45.6569 14.4853 43.0294L21.6213 35.8934C22.935 34.5797 25.065 34.5797 26.3787 35.8934L33.5147 43.0294C36.1421 45.6569 40.402 45.6569 43.0294 43.0294C45.6569 40.402 45.6569 36.1421 43.0294 33.5147L35.8934 26.3787C34.5797 25.065 34.5797 22.935 35.8934 21.6213L43.0294 14.4853C45.6569 11.8579 45.6569 7.59798 43.0294 4.97056C40.402 2.34315 36.1421 2.34315 33.5147 4.97056L26.3787 12.1066C25.065 13.4203 22.935 13.4203 21.6213 12.1066L14.4853 4.97056Z',
  ],
  '39': [
    'M27.5147 3.51472C32.201 -1.17157 39.799 -1.17157 44.4853 3.51472C49.1716 8.20101 49.1716 15.799 44.4853 20.4853C43.5273 21.4432 42.4477 22.2053 41.2962 22.7717C40.8231 23.0043 40.5 23.4728 40.5 24C40.5 24.5272 40.8231 24.9957 41.2962 25.2283C42.4477 25.7947 43.5273 26.5568 44.4853 27.5147C49.1716 32.201 49.1716 39.799 44.4853 44.4853C39.799 49.1716 32.201 49.1716 27.5147 44.4853C26.5568 43.5273 25.7947 42.4477 25.2283 41.2962C24.9957 40.8231 24.5272 40.5 24 40.5C23.4728 40.5 23.0043 40.8231 22.7717 41.2962C22.2053 42.4477 21.4432 43.5273 20.4853 44.4853C15.799 49.1716 8.20101 49.1716 3.51472 44.4853C-1.17157 39.799 -1.17157 32.201 3.51472 27.5147C4.47266 26.5568 5.55226 25.7947 6.70379 25.2283C7.17688 24.9957 7.5 24.5272 7.5 24C7.5 23.4728 7.17688 23.0043 6.70379 22.7717C5.55226 22.2053 4.47266 21.4432 3.51472 20.4853C-1.17157 15.799 -1.17157 8.20101 3.51472 3.51472C8.20101 -1.17157 15.799 -1.17157 20.4853 3.51472C21.4432 4.47266 22.2053 5.55226 22.7717 6.70379C23.0043 7.17688 23.4728 7.5 24 7.5C24.5272 7.5 24.9957 7.17688 25.2283 6.70379C25.7947 5.55226 26.5568 4.47266 27.5147 3.51472ZM25.2283 17.2962C24.9957 16.8231 24.5272 16.5 24 16.5C23.4728 16.5 23.0043 16.8231 22.7717 17.2962C22.2053 18.4477 21.4432 19.5273 20.4853 20.4853C19.5273 21.4432 18.4477 22.2053 17.2962 22.7717C16.8231 23.0043 16.5 23.4728 16.5 24C16.5 24.5272 16.8231 24.9957 17.2962 25.2283C18.4477 25.7947 19.5273 26.5568 20.4853 27.5147C21.4432 28.4727 22.2053 29.5523 22.7717 30.7038C23.0043 31.1769 23.4728 31.5 24 31.5C24.5272 31.5 24.9957 31.1769 25.2283 30.7038C25.7947 29.5523 26.5568 28.4727 27.5147 27.5147C28.4727 26.5568 29.5523 25.7947 30.7038 25.2283C31.1769 24.9957 31.5 24.5272 31.5 24C31.5 23.4728 31.1769 23.0043 30.7038 22.7717C29.5523 22.2053 28.4727 21.4432 27.5147 20.4853C26.5568 19.5273 25.7947 18.4477 25.2283 17.2962Z',
  ],
  '40': [
    'M34.682 13.318C34.0476 12.6837 33.815 11.7661 33.898 10.8728C33.9265 10.5661 33.9411 10.2553 33.9411 9.94113C33.9411 4.45079 29.4903 0 24 0C18.5097 0 14.0589 4.45079 14.0589 9.94113C14.0589 10.1577 14.0658 10.3727 14.0795 10.5859C14.1409 11.5456 13.885 12.525 13.205 13.205C12.525 13.885 11.5456 14.1409 10.5859 14.0795C10.3727 14.0658 10.1577 14.0589 9.94112 14.0589C4.45079 14.0589 0 18.5097 0 24C0 29.4904 4.45079 33.9411 9.94112 33.9411C10.2553 33.9411 10.566 33.9266 10.8728 33.8981C11.7661 33.815 12.6836 34.0476 13.318 34.682C13.9524 35.3164 14.185 36.2339 14.102 37.1272C14.0735 37.434 14.0589 37.7447 14.0589 38.0589C14.0589 43.5492 18.5097 48 24 48C29.4903 48 33.9411 43.5492 33.9411 38.0589C33.9411 37.9331 33.9388 37.808 33.9342 37.6834C33.8969 36.6799 34.1725 35.662 34.8826 34.952L34.952 34.8826C35.662 34.1726 36.6799 33.8969 37.6833 33.9342C37.808 33.9388 37.9331 33.9411 38.0589 33.9411C43.5492 33.9411 48 29.4904 48 24C48 18.5097 43.5492 14.0589 38.0589 14.0589C37.7447 14.0589 37.4339 14.0735 37.1272 14.102C36.2339 14.185 35.3164 13.9524 34.682 13.318ZM19.5689 19.5689C19.8683 19.2695 20.3185 19.188 20.7181 19.3278C21.7456 19.687 22.85 19.8823 24 19.8823C25.0664 19.8823 26.0935 19.7143 27.0565 19.4035C27.4982 19.261 27.9898 19.3538 28.318 19.682C28.6462 20.0103 28.7391 20.5018 28.5965 20.9435C28.2857 21.9065 28.1178 22.9336 28.1178 24C28.1178 25.2389 28.3444 26.4249 28.7585 27.5188C28.8936 27.8758 28.8233 28.2834 28.5533 28.5533C28.2834 28.8232 27.8758 28.8936 27.5188 28.7585C26.4249 28.3444 25.2389 28.1177 24 28.1177C22.9336 28.1177 21.9064 28.2857 20.9435 28.5965C20.5017 28.7391 20.0102 28.6463 19.682 28.318C19.3537 27.9898 19.2609 27.4983 19.4035 27.0565C19.7143 26.0936 19.8822 25.0664 19.8822 24C19.8822 22.85 19.687 21.7456 19.3278 20.7181C19.188 20.3185 19.2695 19.8683 19.5689 19.5689Z',
  ],
  '41': [
    'M33 20.2641C33 20.0536 33.0778 19.8512 33.2128 19.6897C34.9528 17.6073 36 14.9259 36 12C36 5.37258 30.6274 0 24 0C17.3726 0 12 5.37258 12 12C12 14.9259 13.0472 17.6073 14.7872 19.6897C14.9222 19.8512 15 20.0536 15 20.2641C15 20.8284 14.467 21.2402 13.9098 21.1511C13.2878 21.0517 12.65 21 12 21C5.37258 21 0 26.3726 0 33C0 39.6274 5.37258 45 12 45C16.7265 45 20.8147 42.2674 22.7711 38.2959C23.0041 37.823 23.4728 37.5 24 37.5C24.5272 37.5 24.9959 37.823 25.2288 38.2959C27.1853 42.2674 31.2735 45 36 45C42.6274 45 48 39.6274 48 33C48 26.3726 42.6274 21 36 21C35.35 21 34.7122 21.0517 34.0902 21.1511C33.533 21.2402 33 20.8284 33 20.2641Z',
  ],
  '42': [
    'M24 48C37.2548 48 48 37.2548 48 24C48 10.7452 37.2548 0 24 0C10.7452 0 0 10.7452 0 24C0 37.2548 10.7452 48 24 48ZM24 9C26.0711 9 27.75 10.6789 27.75 12.75C27.75 16.8921 31.1079 20.25 35.25 20.25C37.3211 20.25 39 21.9289 39 24C39 26.0711 37.3211 27.75 35.25 27.75C31.1079 27.75 27.75 31.1079 27.75 35.25C27.75 37.3211 26.0711 39 24 39C21.9289 39 20.25 37.3211 20.25 35.25C20.25 31.1079 16.8921 27.75 12.75 27.75C10.6789 27.75 9 26.0711 9 24C9 21.9289 10.6789 20.25 12.75 20.25C16.8921 20.25 20.25 16.8921 20.25 12.75C20.25 10.6789 21.9289 9 24 9Z',
  ],
  '43': [
    'M24 48C37.2548 48 48 37.2548 48 24C48 10.7452 37.2548 0 24 0C10.7452 0 0 10.7452 0 24C0 37.2548 10.7452 48 24 48ZM38.162 21.9769L26.0231 9.83801C24.9058 8.72066 23.0942 8.72066 21.9769 9.83801L9.83801 21.9769C8.72066 23.0942 8.72066 24.9058 9.83801 26.0231L21.9769 38.162C23.0942 39.2793 24.9058 39.2793 26.0231 38.162L38.162 26.0231C39.2793 24.9058 39.2793 23.0942 38.162 21.9769Z',
  ],
  '44': [
    'M13.2 6C9.22355 6 6 9.22355 6 13.2V34.8C6 38.7765 9.22355 42 13.2 42H34.8C38.7765 42 42 38.7765 42 34.8V13.2C42 9.22355 38.7765 6 34.8 6H13.2ZM17.7 13.5C15.3804 13.5 13.5 15.3804 13.5 17.7V30.3C13.5 32.6196 15.3804 34.5 17.7 34.5H30.3C32.6196 34.5 34.5 32.6196 34.5 30.3V17.7C34.5 15.3804 32.6196 13.5 30.3 13.5H17.7Z',
  ],
  '45': [
    'M13.2 6C9.22355 6 6 9.22355 6 13.2V34.8C6 38.7765 9.22355 42 13.2 42H34.8C38.7765 42 42 38.7765 42 34.8V13.2C42 9.22355 38.7765 6 34.8 6H13.2ZM26.6414 16.9055C25.5087 14.8019 22.4913 14.8019 21.3586 16.9055L15.8812 27.0777C14.805 29.0764 16.2526 31.5 18.5227 31.5L29.4773 31.5C31.7474 31.5 33.195 29.0764 32.1188 27.0777L26.6414 16.9055Z',
  ],
  '46': [
    'M6 13.2C6 9.22355 9.22355 6 13.2 6H34.8C38.7765 6 42 9.22355 42 13.2V34.8C42 38.7765 38.7765 42 34.8 42H13.2C9.22355 42 6 38.7765 6 34.8V13.2ZM26.7207 14.6596C26.7207 13.1907 25.5026 12 24 12C22.4974 12 21.2793 13.1907 21.2793 14.6596V14.9293C21.2793 18.4701 18.3429 21.3404 14.7207 21.3404C13.2181 21.3404 12 22.5312 12 24C12 25.4688 13.2181 26.6596 14.7207 26.6596C18.3429 26.6596 21.2793 29.5299 21.2793 33.0707V33.3404C21.2793 34.8093 22.4974 36 24 36C25.5026 36 26.7207 34.8093 26.7207 33.3404V33.0706C26.7207 29.5299 29.6571 26.6596 33.2793 26.6596C34.7819 26.6596 36 25.4688 36 24C36 22.5312 34.7819 21.3404 33.2793 21.3404C29.6571 21.3404 26.7207 18.4701 26.7207 14.9294V14.6596Z',
  ],
  '47': [
    'M30.2518 22.9393C30.8376 23.5251 30.8376 24.4749 30.2518 25.0607L25.0607 30.2518C24.4749 30.8376 23.5251 30.8376 22.9393 30.2518L17.7482 25.0607C17.1624 24.4749 17.1624 23.5251 17.7482 22.9393L22.9393 17.7482C23.5251 17.1624 24.4749 17.1624 25.0607 17.7482L30.2518 22.9393Z',
    'M13.2 6C9.22355 6 6 9.22355 6 13.2V34.8C6 38.7765 9.22355 42 13.2 42H34.8C38.7765 42 42 38.7765 42 34.8V13.2C42 9.22355 38.7765 6 34.8 6H13.2ZM39.7937 22.3636C41.0306 23.0031 41.0306 24.9969 39.7937 25.6364C33.724 28.7747 28.7747 33.724 25.6364 39.7937C24.9969 41.0306 23.0031 41.0306 22.3636 39.7937C19.2253 33.724 14.276 28.7747 8.20633 25.6364C6.96942 24.9969 6.96942 23.0031 8.20633 22.3636C14.276 19.2253 19.2253 14.276 22.3636 8.20633C23.0031 6.96942 24.9969 6.96942 25.6364 8.20633C28.7747 14.276 33.724 19.2253 39.7937 22.3636Z',
  ],
  '48': [
    'M6 11.25C6 8.35051 8.35051 6 11.25 6H36.75C39.6495 6 42 8.35051 42 11.25C42 14.1495 39.6495 16.5 36.75 16.5H30.0551C28.7188 16.5 28.0495 18.1157 28.9945 19.0607L32.4062 22.4724C32.992 23.0582 32.992 24.008 32.4062 24.5938L28.0607 28.9393C27.1157 29.8843 27.785 31.5 29.1213 31.5H36.75C39.6495 31.5 42 33.8505 42 36.75C42 39.6495 39.6495 42 36.75 42H11.25C8.3505 42 6 39.6495 6 36.75C6 33.8505 8.35051 31.5 11.25 31.5H20.0037C21.34 31.5 22.0093 29.8843 21.0643 28.9393L16.7188 24.5938C16.133 24.008 16.133 23.0582 16.7188 22.4724L20.1305 19.0607C21.0755 18.1157 20.4062 16.5 19.0699 16.5H11.25C8.3505 16.5 6 14.1495 6 11.25Z',
  ],
  '49': [
    'M6 10C6 7.79086 7.79086 6 10 6H38C40.2091 6 42 7.79086 42 10V12.5C42 14.1901 40.9518 15.6354 39.4701 16.2212C39.3078 16.2854 39.1574 16.3785 39.0396 16.5072L32.7975 23.3302C32.4476 23.7127 32.448 24.2992 32.7985 24.6812L39.0528 31.4986C39.1697 31.6261 39.3187 31.7185 39.4794 31.7825C40.9562 32.3707 42 33.8135 42 35.5V38C42 40.2091 40.2091 42 38 42H10C7.79086 42 6 40.2091 6 38V35.5C6 33.81 7.04812 32.3647 8.52979 31.7788C8.69278 31.7144 8.8439 31.6207 8.96193 31.4911L15.1617 24.6855C15.5092 24.3041 15.5094 23.7209 15.1622 23.3392L8.94135 16.5012C8.8244 16.3726 8.67485 16.2793 8.51351 16.2147C7.04044 15.6247 6 14.1838 6 12.5V10Z',
  ],
  '50': [
    'M6 11.25C6 8.35051 8.35051 6 11.25 6H36.75C39.6495 6 42 8.35051 42 11.25C42 14.1495 39.6495 16.5 36.75 16.5C36.3358 16.5 36 16.8358 36 17.25C36 17.6642 36.3375 17.9951 36.7485 18.0462C39.709 18.4146 42 20.9398 42 24C42 27.0602 39.709 29.5854 36.7485 29.9538C36.3375 30.0049 36 30.3358 36 30.75C36 31.1642 36.3358 31.5 36.75 31.5C39.6495 31.5 42 33.8505 42 36.75C42 39.6495 39.6495 42 36.75 42H11.25C8.3505 42 6 39.6495 6 36.75C6 33.8505 8.35051 31.5 11.25 31.5C11.6642 31.5 12 31.1642 12 30.75C12 30.3358 11.6625 30.0049 11.2515 29.9538C8.29104 29.5854 6 27.0602 6 24C6 20.9398 8.29103 18.4146 11.2515 18.0462C11.6625 17.9951 12 17.6642 12 17.25C12 16.8358 11.6642 16.5 11.25 16.5C8.3505 16.5 6 14.1495 6 11.25Z',
  ],
  '51': [
    'M6 11.25C6 8.35051 8.35051 6 11.25 6H36.75C39.6495 6 42 8.35051 42 11.25C42 12.7441 41.3759 14.0924 40.3742 15.0484L27.622 28.9875C26.7415 29.95 27.4242 31.5 28.7287 31.5H36.75C39.6495 31.5 42 33.8505 42 36.75C42 39.6495 39.6495 42 36.75 42H11.25C8.3505 42 6 39.6495 6 36.75C6 33.8505 8.35051 31.5 11.25 31.5H19.194C20.4965 31.5 21.18 29.954 20.3036 28.9906L7.57467 14.9989C6.6029 14.0461 6 12.7185 6 11.25Z',
  ],
  '52': [
    'M6 11.25C6 8.35051 8.35051 6 11.25 6H36.6276C39.5271 6 41.8776 8.35051 41.8776 11.25C41.8776 14.1495 39.5271 16.5 36.6276 16.5C35.2392 16.5 34.6938 18.3005 35.8488 19.0709L41.3348 22.7305C42.2235 23.3233 42.2252 24.6288 41.338 25.224L35.84 28.9122C34.6801 29.6902 35.2309 31.5 36.6276 31.5C39.5271 31.5 41.8776 33.8505 41.8776 36.75C41.8776 39.6495 39.5271 42 36.6276 42H11.25C8.3505 42 6 39.6495 6 36.75C6 33.8505 8.35051 31.5 11.25 31.5H11.8221C13.304 31.5 13.8884 29.5798 12.6578 28.7543L7.39502 25.224C6.50781 24.6288 6.50949 23.3233 7.39825 22.7305L12.619 19.2478C13.8535 18.4244 13.2705 16.5 11.7866 16.5H11.25C8.3505 16.5 6 14.1495 6 11.25ZM20.4869 16.5C19.6585 16.5 18.9869 17.1716 18.9869 18L18.9869 30C18.9869 30.8284 19.6585 31.5 20.4869 31.5H28.2461C29.0745 31.5 29.7461 30.8284 29.7461 30V18C29.7461 17.1716 29.0745 16.5 28.2461 16.5H20.4869Z',
  ],
  '53': [
    'M25.6134 1.13864C25.0735 -0.379548 22.9265 -0.379548 22.3866 1.13864L21.541 3.51642C20.0519 7.70386 15.2686 9.68516 11.2547 7.77716L8.97544 6.69372C7.52015 6.00196 6.00196 7.52015 6.69372 8.97544C9.18135 14.2087 6.59816 20.4451 1.13864 22.3866C-0.379548 22.9265 -0.379548 25.0735 1.13864 25.6134C6.59816 27.5549 9.18135 33.7913 6.69372 39.0246C6.00196 40.4798 7.52015 41.998 8.97544 41.3063L11.2547 40.2228C15.2686 38.3148 20.0519 40.2961 21.541 44.4836L22.3866 46.8614C22.9265 48.3795 25.0735 48.3796 25.6134 46.8614L26.459 44.4836C27.9481 40.2961 32.7314 38.3148 36.7453 40.2228L39.0246 41.3063C40.4798 41.998 41.998 40.4798 41.3063 39.0246L40.2228 36.7453C38.3148 32.7314 40.2961 27.9481 44.4836 26.459L46.8614 25.6134C48.3795 25.0735 48.3796 22.9265 46.8614 22.3866L44.4836 21.541C40.2961 20.0519 38.3148 15.2686 40.2228 11.2547L41.3063 8.97544C41.998 7.52015 40.4798 6.00196 39.0246 6.69372L36.7453 7.77716C32.7314 9.68516 27.9481 7.70386 26.459 3.51642L25.6134 1.13864Z',
  ],
  '54': [
    'M14.0681 44.7957C14.8034 45.1475 15.6854 45.0484 16.2618 44.4721C17.347 43.3868 18.5121 40.9707 19.6005 38.1645C20.2704 36.4371 22.1473 35.5202 24 35.5202C25.8528 35.5202 27.7296 36.4371 28.3995 38.1645C29.4879 40.9707 30.653 43.3868 31.7383 44.4721C32.3146 45.0484 33.1966 45.1475 33.9319 44.7957C38.6777 42.525 42.525 38.6777 44.7957 33.9319C45.1475 33.1966 45.0484 32.3146 44.4721 31.7382C43.3869 30.653 40.9707 29.4879 38.1645 28.3995C36.4371 27.7296 35.5202 25.8528 35.5202 24C35.5202 22.1473 36.4371 20.2704 38.1645 19.6005C40.9707 18.5121 43.3869 17.347 44.4721 16.2618C45.0484 15.6854 45.1475 14.8034 44.7957 14.0681C42.5251 9.32233 38.6777 5.47498 33.9319 3.20433C33.1966 2.85253 32.3146 2.9516 31.7383 3.52796C30.653 4.61317 29.4879 7.02935 28.3995 9.83554C27.7296 11.5629 25.8528 12.4799 24 12.4799C22.1473 12.4799 20.2705 11.5629 19.6005 9.83554C18.5121 7.02935 17.347 4.61317 16.2618 3.52796C15.6854 2.9516 14.8034 2.85254 14.0681 3.20433C9.32234 5.47498 5.47497 9.32234 3.20432 14.0681C2.85254 14.8034 2.9516 15.6854 3.52796 16.2618C4.61317 17.347 7.02935 18.5121 9.83553 19.6005C11.5629 20.2705 12.4799 22.1473 12.4799 24C12.4799 25.8527 11.5629 27.7296 9.83553 28.3995C7.02935 29.4879 4.61316 30.653 3.52796 31.7382C2.9516 32.3146 2.85254 33.1966 3.20433 33.9319C5.47498 38.6777 9.32234 42.525 14.0681 44.7957Z',
  ],
  '55': [
    'M47.8755 26.4594C47.7497 27.6957 46.555 28.4884 45.336 28.2472L35.1524 26.2326C32.7396 25.7553 31.4202 28.9412 33.464 30.3095L42.0879 36.0831C43.1205 36.7744 43.405 38.1797 42.6203 39.1433C41.5829 40.4174 40.4174 41.5829 39.1433 42.6203C38.1797 43.405 36.7744 43.1205 36.0831 42.0879L30.3095 33.464C28.9412 31.4202 25.7553 32.7396 26.2326 35.1524L28.2472 45.336C28.4884 46.555 27.6957 47.7497 26.4594 47.8755C25.6508 47.9578 24.8303 48 24 48C23.1697 48 22.3492 47.9578 21.5406 47.8755C20.3043 47.7497 19.5116 46.555 19.7528 45.336L21.7674 35.1524C22.2447 32.7396 19.0588 31.4202 17.6905 33.464L11.9169 42.0879C11.2256 43.1205 9.82031 43.405 8.85671 42.6203C7.58264 41.5829 6.41707 40.4174 5.37966 39.1433C4.59504 38.1797 4.87952 36.7744 5.91211 36.0831L14.536 30.3095C16.5798 28.9412 15.2604 25.7553 12.8476 26.2326L2.66404 28.2472C1.44502 28.4884 0.250313 27.6957 0.124475 26.4594C0.0421664 25.6508 0 24.8303 0 24C0 23.1697 0.0421663 22.3492 0.124475 21.5406C0.250313 20.3043 1.44502 19.5116 2.66404 19.7528L12.8476 21.7674C15.2604 22.2447 16.5798 19.0588 14.536 17.6905L5.91211 11.9169C4.87951 11.2256 4.59504 9.82031 5.37966 8.85671C6.41707 7.58264 7.58264 6.41707 8.85671 5.37966C9.82031 4.59504 11.2256 4.87952 11.9169 5.91211L17.6905 14.536C19.0588 16.5798 22.2447 15.2604 21.7674 12.8476L19.7528 2.66404C19.5116 1.44502 20.3043 0.250313 21.5406 0.124475C22.3492 0.0421664 23.1697 0 24 0C24.8303 0 25.6508 0.0421663 26.4594 0.124475C27.6957 0.250313 28.4884 1.44502 28.2472 2.66404L26.2326 12.8476C25.7553 15.2604 28.9412 16.5798 30.3095 14.536L36.0831 5.91211C36.7744 4.87951 38.1797 4.59504 39.1433 5.37966C40.4174 6.41707 41.5829 7.58264 42.6203 8.8567C43.405 9.82031 43.1205 11.2256 42.0879 11.9169L33.464 17.6905C31.4202 19.0588 32.7396 22.2447 35.1524 21.7674L45.336 19.7528C46.555 19.5116 47.7497 20.3043 47.8755 21.5406C47.9578 22.3492 48 23.1697 48 24C48 24.8303 47.9578 25.6508 47.8755 26.4594Z',
  ],
  '56': [
    'M21 6C21 4.34315 22.3431 3 24 3C25.6569 3 27 4.34315 27 6V15C27 16.6569 25.6569 18 24 18C22.3431 18 21 16.6569 21 15V6Z',
    'M21 33C21 31.3431 22.3431 30 24 30C25.6569 30 27 31.3431 27 33V42C27 43.6569 25.6569 45 24 45C22.3431 45 21 43.6569 21 42V33Z',
    'M42 21C43.6569 21 45 22.3431 45 24C45 25.6569 43.6569 27 42 27H33C31.3431 27 30 25.6569 30 24C30 22.3431 31.3431 21 33 21H42Z',
    'M15 21C16.6569 21 18 22.3431 18 24C18 25.6569 16.6569 27 15 27H6C4.34315 27 3 25.6569 3 24C3 22.3431 4.34315 21 6 21H15Z',
    'M34.6066 9.15076C35.7782 7.97918 37.6777 7.97918 38.8492 9.15076C40.0208 10.3223 40.0208 12.2218 38.8492 13.3934L32.4853 19.7574C31.3137 20.9289 29.4142 20.9289 28.2426 19.7574C27.0711 18.5858 27.0711 16.6863 28.2426 15.5147L34.6066 9.15076Z',
    'M15.5147 28.2426C16.6863 27.0711 18.5858 27.0711 19.7574 28.2426C20.9289 29.4142 20.9289 31.3137 19.7574 32.4853L13.3934 38.8492C12.2218 40.0208 10.3223 40.0208 9.15076 38.8492C7.97919 37.6777 7.97919 35.7782 9.15076 34.6066L15.5147 28.2426Z',
    'M38.8492 34.6066C40.0208 35.7782 40.0208 37.6777 38.8492 38.8492C37.6777 40.0208 35.7782 40.0208 34.6066 38.8492L28.2426 32.4853C27.0711 31.3137 27.0711 29.4142 28.2426 28.2426C29.4142 27.0711 31.3137 27.0711 32.4853 28.2426L38.8492 34.6066Z',
    'M19.7574 15.5147C20.9289 16.6863 20.9289 18.5858 19.7574 19.7574C18.5858 20.9289 16.6863 20.9289 15.5147 19.7574L9.15076 13.3934C7.97918 12.2218 7.97919 10.3223 9.15076 9.15076C10.3223 7.97918 12.2218 7.97918 13.3934 9.15076L19.7574 15.5147Z',
  ],
  '57': [
    'M21 6C21 4.34315 22.3431 3 24 3C25.6569 3 27 4.34315 27 6V15C27 16.6569 25.6569 18 24 18C22.3431 18 21 16.6569 21 15V6Z',
    'M21 33C21 31.3431 22.3431 30 24 30C25.6569 30 27 31.3431 27 33V42C27 43.6569 25.6569 45 24 45C22.3431 45 21 43.6569 21 42V33Z',
    'M42 21C43.6569 21 45 22.3431 45 24C45 25.6569 43.6569 27 42 27H33C31.3431 27 30 25.6569 30 24C30 22.3431 31.3431 21 33 21H42Z',
    'M15 21C16.6569 21 18 22.3431 18 24C18 25.6569 16.6569 27 15 27H6C4.34315 27 3 25.6569 3 24C3 22.3431 4.34315 21 6 21H15Z',
    'M34.6066 9.15076C35.7782 7.97918 37.6777 7.97918 38.8492 9.15076C40.0208 10.3223 40.0208 12.2218 38.8492 13.3934L36.7279 15.5147C35.5563 16.6863 33.6569 16.6863 32.4853 15.5147C31.3137 14.3431 31.3137 12.4437 32.4853 11.2721L34.6066 9.15076Z',
    'M11.2721 32.4853C12.4437 31.3137 14.3431 31.3137 15.5147 32.4853C16.6863 33.6569 16.6863 35.5563 15.5147 36.7279L13.3934 38.8492C12.2218 40.0208 10.3223 40.0208 9.15076 38.8492C7.97919 37.6777 7.97919 35.7782 9.15076 34.6066L11.2721 32.4853Z',
    'M38.8492 34.6066C40.0208 35.7782 40.0208 37.6777 38.8492 38.8492C37.6777 40.0208 35.7782 40.0208 34.6066 38.8492L32.4853 36.7279C31.3137 35.5563 31.3137 33.6569 32.4853 32.4853C33.6569 31.3137 35.5563 31.3137 36.7279 32.4853L38.8492 34.6066Z',
    'M15.5147 11.2721C16.6863 12.4437 16.6863 14.3431 15.5147 15.5147C14.3431 16.6863 12.4437 16.6863 11.2721 15.5147L9.15076 13.3934C7.97918 12.2218 7.97919 10.3223 9.15076 9.15076C10.3223 7.97918 12.2218 7.97918 13.3934 9.15076L15.5147 11.2721Z',
  ],
  '58': [
    'M24 0C26.2091 0 28 1.79086 28 4V10.7222C28 12.0586 29.6157 12.7278 30.5607 11.7829L35.314 7.02948C36.8761 5.46739 39.4088 5.46739 40.9709 7.02948C42.533 8.59158 42.533 11.1242 40.9709 12.6863L36.2179 17.4393C35.2729 18.3843 35.9422 20 37.2785 20H44C46.2091 20 48 21.7909 48 24C48 26.2091 46.2091 28 44 28H37.2783C35.9419 28 35.2727 29.6157 36.2176 30.5607L40.9705 35.3136C42.5326 36.8756 42.5326 39.4083 40.9705 40.9704C39.4084 42.5325 36.8758 42.5325 35.3137 40.9704L30.5607 36.2174C29.6157 35.2724 28 35.9417 28 37.2781V44C28 46.2091 26.2091 48 24 48C21.7909 48 20 46.2091 20 44V37.2785C20 35.9422 18.3843 35.2729 17.4393 36.2179L12.6866 40.9706C11.1245 42.5327 8.59186 42.5327 7.02977 40.9706C5.46767 39.4085 5.46767 36.8759 7.02977 35.3138L11.7829 30.5607C12.7278 29.6157 12.0586 28 10.7222 28H4C1.79086 28 0 26.2091 0 24C0 21.7909 1.79086 20 4 20L10.7219 20C12.0583 20 12.7275 18.3843 11.7826 17.4393L7.02939 12.6861C5.46729 11.124 5.4673 8.59137 7.02939 7.02928C8.59149 5.46718 11.1241 5.46718 12.6862 7.02928L17.4393 11.7824C18.3843 12.7273 20 12.0581 20 10.7217V4C20 1.79086 21.7909 0 24 0ZM24 33C28.9706 33 33 28.9706 33 24C33 19.0294 28.9706 15 24 15C19.0294 15 15 19.0294 15 24C15 28.9706 19.0294 33 24 33Z',
  ],
  '59': [
    'M24 3C22.3431 3 21 4.34315 21 6V8.55731C21 9.88919 20.0467 11.019 18.8171 11.5307C17.5874 12.0424 16.1443 11.9017 15.2025 10.9599L13.3934 9.15076C12.2218 7.97918 10.3223 7.97918 9.15076 9.15076C7.97919 10.3223 7.97918 12.2218 9.15076 13.3934L10.9599 15.2025C11.9017 16.1443 12.0424 17.5874 11.5307 18.8171C11.019 20.0467 9.88919 21 8.55731 21H6C4.34315 21 3 22.3431 3 24C3 25.6569 4.34315 27 6 27H8.55731C9.88919 27 11.019 27.9533 11.5307 29.1829C12.0424 30.4126 11.9017 31.8557 10.9599 32.7975L9.15076 34.6066C7.97919 35.7782 7.97919 37.6777 9.15076 38.8492C10.3223 40.0208 12.2218 40.0208 13.3934 38.8492L15.2025 37.0401C16.1443 36.0983 17.5874 35.9576 18.8171 36.4693C20.0467 36.981 21 38.1108 21 39.4427V42C21 43.6569 22.3431 45 24 45C25.6569 45 27 43.6569 27 42V39.4427C27 38.1108 27.9533 36.981 29.1829 36.4693C30.4126 35.9576 31.8557 36.0983 32.7975 37.0401L34.6066 38.8492C35.7782 40.0208 37.6777 40.0208 38.8492 38.8492C40.0208 37.6777 40.0208 35.7782 38.8492 34.6066L37.0401 32.7975C36.0983 31.8557 35.9576 30.4126 36.4693 29.1829C36.981 27.9533 38.1108 27 39.4427 27H42C43.6569 27 45 25.6569 45 24C45 22.3431 43.6569 21 42 21H39.4427C38.1108 21 36.981 20.0467 36.4693 18.8171C35.9576 17.5874 36.0983 16.1443 37.0401 15.2025L38.8492 13.3934C40.0208 12.2218 40.0208 10.3223 38.8492 9.15076C37.6777 7.97918 35.7782 7.97918 34.6066 9.15076L32.7975 10.9599C31.8557 11.9017 30.4126 12.0424 29.1829 11.5307C27.9533 11.019 27 9.88919 27 8.55731V6C27 4.34315 25.6569 3 24 3Z',
  ],
  '60': [
    'M22.5 3C21.6716 3 21 3.67157 21 4.5V15.0356C21 15.3212 20.8179 15.5738 20.5542 15.6832C20.2902 15.7927 19.9846 15.742 19.7826 15.5399L12.3327 8.0901C11.747 7.50431 10.7972 7.50431 10.2114 8.0901L8.0901 10.2114C7.50431 10.7972 7.50431 11.747 8.0901 12.3327L15.5399 19.7826C15.742 19.9846 15.7927 20.2902 15.6832 20.5542C15.5738 20.8179 15.3212 21 15.0356 21H4.5C3.67157 21 3 21.6716 3 22.5V25.5C3 26.3284 3.67157 27 4.5 27H15.0356C15.3212 27 15.5738 27.1821 15.6832 27.4458C15.7927 27.7098 15.742 28.0154 15.5399 28.2174L8.0901 35.6673C7.50431 36.2531 7.50431 37.2028 8.0901 37.7886L10.2114 39.9099C10.7972 40.4957 11.747 40.4957 12.3327 39.9099L19.7826 32.4601C19.9846 32.258 20.2902 32.2073 20.5542 32.3168C20.8179 32.4262 21 32.6788 21 32.9644V43.5C21 44.3284 21.6716 45 22.5 45H25.5C26.3284 45 27 44.3284 27 43.5V32.9644C27 32.6788 27.1821 32.4262 27.4458 32.3168C27.7098 32.2073 28.0154 32.258 28.2174 32.4601L35.6673 39.9099C36.253 40.4957 37.2028 40.4957 37.7886 39.9099L39.9099 37.7886C40.4957 37.2028 40.4957 36.2531 39.9099 35.6673L32.4601 28.2174C32.258 28.0154 32.2073 27.7098 32.3168 27.4458C32.4262 27.1821 32.6788 27 32.9644 27H43.5C44.3284 27 45 26.3284 45 25.5V22.5C45 21.6716 44.3284 21 43.5 21H32.9644C32.6788 21 32.4262 20.8179 32.3168 20.5542C32.2073 20.2902 32.258 19.9846 32.4601 19.7826L39.9099 12.3327C40.4957 11.747 40.4957 10.7972 39.9099 10.2114L37.7886 8.0901C37.2028 7.50431 36.253 7.50431 35.6673 8.0901L28.2174 15.5399C28.0154 15.742 27.7098 15.7927 27.4458 15.6832C27.1821 15.5738 27 15.3212 27 15.0356V4.5C27 3.67157 26.3284 3 25.5 3H22.5Z',
  ],
  '61': [
    'M31 3C34.0928 3 36.6 5.50721 36.6 8.6C36.6 10.1464 37.8536 11.4 39.4 11.4C42.4928 11.4 45 13.9072 45 17C45 20.0928 42.4928 22.6 39.4 22.6H38C37.2268 22.6 36.6 23.2268 36.6 24C36.6 24.7732 37.2268 25.4 38 25.4H39.4C42.4928 25.4 45 27.9072 45 31C45 34.0928 42.4928 36.6 39.4 36.6C37.8536 36.6 36.6 37.8536 36.6 39.4C36.6 42.4928 34.0928 45 31 45C27.9072 45 25.4 42.4928 25.4 39.4V38C25.4 37.2268 24.7732 36.6 24 36.6C23.2268 36.6 22.6 37.2268 22.6 38V39.4C22.6 42.4928 20.0928 45 17 45C13.9072 45 11.4 42.4928 11.4 39.4C11.4 37.8536 10.1464 36.6 8.6 36.6C5.50721 36.6 3 34.0928 3 31C3 27.9072 5.50721 25.4 8.6 25.4H10C10.7732 25.4 11.4 24.7732 11.4 24C11.4 23.2268 10.7732 22.6 10 22.6H8.6C5.50721 22.6 3 20.0928 3 17C3 13.9072 5.50721 11.4 8.6 11.4C10.1464 11.4 11.4 10.1464 11.4 8.6C11.4 5.5072 13.9072 3 17 3C20.0928 3 22.6 5.50721 22.6 8.6V10C22.6 10.7732 23.2268 11.4 24 11.4C24.7732 11.4 25.4 10.7732 25.4 10V8.6C25.4 5.5072 27.9072 3 31 3ZM21.2 18.4C19.6536 18.4 18.4 19.6536 18.4 21.2V26.8C18.4 28.3464 19.6536 29.6 21.2 29.6H26.8C28.3464 29.6 29.6 28.3464 29.6 26.8V21.2C29.6 19.6536 28.3464 18.4 26.8 18.4H21.2Z',
  ],
  '62': [
    'M24.8056 0C28.1193 -3.16102e-08 30.8056 2.68629 30.8056 6V8.74781L32.4969 7.05653C34.84 4.71339 38.639 4.71339 40.9821 7.05653C43.3253 9.39968 43.3253 13.1987 40.9821 15.5418L38.8257 17.6982H42C45.3137 17.6982 48 20.3845 48 23.6982C48 27.0119 45.3137 29.6982 42 29.6982H39.3072L41.7652 32.1561C44.1083 34.4993 44.1083 38.2983 41.7652 40.6414C39.422 42.9846 35.623 42.9846 33.2799 40.6414L30.8056 38.1671V42C30.8056 45.3137 28.1193 48 24.8056 48C21.4919 48 18.8056 45.3137 18.8056 42V37.7184L15.5263 40.9977C13.1831 43.3408 9.38416 43.3408 7.04101 40.9977C4.69786 38.6545 4.69786 34.8555 7.04101 32.5124L9.85517 29.6982H6C2.68629 29.6982 0 27.0119 0 23.6982C0 20.3845 2.68629 17.6982 6 17.6982H10.3367L7.82404 15.1856C5.48089 12.8424 5.48089 9.04344 7.82404 6.70029C10.1672 4.35715 13.9662 4.35715 16.3093 6.70029L18.8056 9.19656V6C18.8056 2.68629 21.4919 1.10635e-07 24.8056 0Z',
  ],
  '63': [
    'M27.4393 22.9393C28.0251 23.5251 28.0251 24.4749 27.4393 25.0607L25.0607 27.4393C24.4749 28.0251 23.5251 28.0251 22.9393 27.4393L20.5607 25.0607C19.9749 24.4749 19.9749 23.5251 20.5607 22.9393L22.9393 20.5607C23.5251 19.9749 24.4749 19.9749 25.0607 20.5607L27.4393 22.9393Z',
    'M22.3866 1.13864C22.9265 -0.379548 25.0735 -0.379548 25.6134 1.13864L26.459 3.51642C27.9481 7.70386 32.7314 9.68516 36.7453 7.77716L39.0246 6.69372C40.4798 6.00196 41.998 7.52015 41.3063 8.97544L40.2228 11.2547C38.3148 15.2686 40.2961 20.0519 44.4836 21.541L46.8614 22.3866C48.3796 22.9265 48.3795 25.0735 46.8614 25.6134L44.4836 26.459C40.2961 27.9481 38.3148 32.7314 40.2228 36.7453L41.3063 39.0246C41.998 40.4798 40.4798 41.998 39.0246 41.3063L36.7453 40.2228C32.7314 38.3148 27.9481 40.2961 26.459 44.4836L25.6134 46.8614C25.0735 48.3796 22.9265 48.3795 22.3866 46.8614L21.541 44.4836C20.0519 40.2961 15.2686 38.3148 11.2547 40.2228L8.97544 41.3063C7.52015 41.998 6.00196 40.4798 6.69372 39.0246C9.18135 33.7913 6.59816 27.5549 1.13864 25.6134C-0.379548 25.0735 -0.379548 22.9265 1.13864 22.3866C6.59816 20.4451 9.18135 14.2087 6.69372 8.97544C6.00196 7.52015 7.52015 6.00196 8.97544 6.69372L11.2547 7.77716C15.2686 9.68516 20.0519 7.70386 21.541 3.51642L22.3866 1.13864ZM32.3631 22.2244C33.5473 22.957 33.5473 25.043 32.3631 25.7756C29.6871 27.431 27.431 29.6871 25.7756 32.3631C25.043 33.5473 22.957 33.5473 22.2244 32.3631C20.569 29.6871 18.3129 27.431 15.6369 25.7756C14.4527 25.043 14.4527 22.957 15.6369 22.2244C18.3129 20.569 20.569 18.3129 22.2244 15.6369C22.957 14.4527 25.043 14.4527 25.7756 15.6369C27.431 18.3129 29.6871 20.569 32.3631 22.2244Z',
  ],
  '64': [
    'M19.1687 22.6711C21.3456 23.3082 23.3082 21.3456 22.6711 19.1687C21.2572 14.3378 18.9523 7.34616 16.947 5.34084C13.7914 2.18518 8.63507 2.22516 5.43011 5.43011C2.22516 8.63507 2.18518 13.7914 5.34084 16.947C7.34616 18.9523 14.3378 21.2572 19.1687 22.6711Z',
    'M28.8313 25.3289C26.6544 24.6918 24.6918 26.6544 25.3289 28.8313C26.7428 33.6622 29.0477 40.6538 31.053 42.6592C34.2086 45.8148 39.3649 45.7748 42.5699 42.5699C45.7748 39.3649 45.8148 34.2086 42.6592 31.053C40.6538 29.0477 33.6622 26.7428 28.8313 25.3289Z',
    'M25.3289 19.1687C24.6918 21.3456 26.6544 23.3082 28.8313 22.6711C33.6622 21.2572 40.6538 18.9523 42.6592 16.947C45.8148 13.7914 45.7748 8.63507 42.5699 5.43011C39.3649 2.22516 34.2086 2.18518 31.053 5.34084C29.0477 7.34616 26.7428 14.3378 25.3289 19.1687Z',
    'M19.1687 25.3289C21.3456 24.6918 23.3082 26.6544 22.6711 28.8313C21.2572 33.6622 18.9523 40.6538 16.947 42.6592C13.7914 45.8148 8.63507 45.7748 5.43011 42.5699C2.22516 39.3649 2.18518 34.2086 5.34084 31.053C7.34616 29.0477 14.3378 26.7428 19.1687 25.3289Z',
  ],
  '65': [
    'M21 6C21 4.34315 22.3431 3 24 3C25.6569 3 27 4.34315 27 6V8.55731C27 9.45924 27.4371 10.2685 28.1012 10.8559C29.0669 8.39844 30.0942 6.29966 31.053 5.34084C34.2086 2.18518 39.3649 2.22516 42.5699 5.43011C45.7748 8.63507 45.8148 13.7914 42.6592 16.947C41.7003 17.9058 39.6016 18.9331 37.1441 19.8988C37.7315 20.5629 38.5408 21 39.4427 21H42C43.6569 21 45 22.3431 45 24C45 25.6569 43.6569 27 42 27H39.4427C38.5408 27 37.7315 27.4371 37.1441 28.1012C39.6016 29.0669 41.7003 30.0942 42.6592 31.053C45.8148 34.2086 45.7748 39.3649 42.5699 42.5699C39.3649 45.7748 34.2086 45.8148 31.053 42.6592C30.0942 41.7003 29.0669 39.6016 28.1012 37.1441C27.4371 37.7315 27 38.5408 27 39.4427V42C27 43.6569 25.6569 45 24 45C22.3431 45 21 43.6569 21 42V39.4427C21 38.5408 20.5629 37.7315 19.8988 37.1441C18.9331 39.6016 17.9058 41.7003 16.947 42.6592C13.7914 45.8148 8.63507 45.7748 5.43011 42.5699C2.22516 39.3649 2.18518 34.2086 5.34084 31.053C6.29966 30.0942 8.39844 29.0669 10.8559 28.1012C10.2685 27.4371 9.45924 27 8.55731 27H6C4.34315 27 3 25.6569 3 24C3 22.3431 4.34315 21 6 21H8.55731C9.45924 21 10.2685 20.5629 10.8559 19.8988C8.39844 18.9331 6.29966 17.9058 5.34084 16.947C2.18518 13.7914 2.22516 8.63507 5.43011 5.43011C8.63507 2.22516 13.7914 2.18518 16.947 5.34084C17.9058 6.29966 18.9331 8.39844 19.8988 10.8559C20.5629 10.2685 21 9.45924 21 8.55731V6Z',
  ],
  '66': [
    'M26.0315 14.2248C27.9542 12.0448 30.5482 8.68843 30.5482 6.44729C30.5482 2.88655 27.6165 0 24.0001 0C20.3838 0 17.4521 2.88655 17.4521 6.44729C17.4521 8.68843 20.0461 12.0448 21.9687 14.2248C22.1876 14.4729 22.0709 15.0585 21.7501 15.1396C21.0231 15.3237 20.3308 15.5948 19.6849 15.9413C19.321 16.1366 18.7858 15.8114 18.7016 15.4071C18.002 12.0464 16.8302 7.56993 15.3261 6.06581C12.8083 3.54799 8.69421 3.57988 6.13705 6.13705C3.57988 8.69421 3.54799 12.8083 6.06581 15.3261C7.56993 16.8302 12.0464 18.002 15.4071 18.7016C15.8114 18.7858 16.1365 19.321 15.9412 19.6848C15.5946 20.3307 15.3234 21.0231 15.1393 21.7502C15.0582 22.0709 14.4729 22.1876 14.2248 21.9687C12.0448 20.0461 8.68843 17.4521 6.44729 17.4521C2.88655 17.4521 0 20.3838 0 24.0001C0 27.6165 2.88655 30.5482 6.44729 30.5482C8.68843 30.5482 12.0448 27.9542 14.2248 26.0315C14.4729 25.8127 15.0582 25.9294 15.1394 26.2501C15.3235 26.9771 15.5946 27.6694 15.9412 28.3152C16.1364 28.6791 15.8114 29.2142 15.4071 29.2984C12.0464 29.998 7.56993 31.1698 6.06581 32.6739C3.54799 35.1917 3.57988 39.3058 6.13705 41.8629C8.69421 44.4201 12.8083 44.452 15.3261 41.9342C16.8302 40.4301 18.002 35.9536 18.7016 32.5929C18.7858 32.1886 19.321 31.8635 19.6849 32.0587C20.3307 32.4052 21.0229 32.6764 21.7498 32.8604C22.0706 32.9416 22.1873 33.5271 21.9684 33.7752C20.0458 35.9552 17.4518 39.3116 17.4518 41.5527C17.4518 45.1134 20.3835 48 23.9998 48C27.6162 48 30.5479 45.1134 30.5479 41.5527C30.5479 39.3116 27.9539 35.9552 26.0312 33.7752C25.8124 33.5271 25.9291 32.9415 26.2499 32.8603C26.9768 32.6762 27.669 32.4051 28.3148 32.0586C28.6788 31.8632 29.2142 32.1885 29.2984 32.5929C29.998 35.9536 31.1698 40.4301 32.6739 41.9342C35.1917 44.452 39.3058 44.4201 41.8629 41.8629C44.4201 39.3058 44.452 35.1917 41.9342 32.6739C40.4301 31.1698 35.9536 29.998 32.5929 29.2984C32.1884 29.2142 31.8631 28.6787 32.0584 28.3147C32.4049 27.669 32.676 26.9768 32.86 26.2499C32.9412 25.9291 33.5271 25.8124 33.7752 26.0312C35.9552 27.9539 39.3116 30.5479 41.5527 30.5479C45.1134 30.5479 48 27.6162 48 23.9998C48 20.3835 45.1134 17.4518 41.5527 17.4518C39.3116 17.4518 35.9552 20.0458 33.7752 21.9684C33.527 22.1873 32.9411 22.0706 32.8599 21.7498C32.6759 21.023 32.4048 20.331 32.0584 19.6854C31.8631 19.3213 32.1884 18.7858 32.5929 18.7016C35.9536 18.002 40.4301 16.8302 41.9342 15.3261C44.452 12.8083 44.4201 8.69421 41.8629 6.13705C39.3058 3.57988 35.1917 3.54799 32.6739 6.06581C31.1698 7.56993 29.998 12.0464 29.2984 15.4071C29.2142 15.8115 28.6787 16.1368 28.3147 15.9415C27.6691 15.595 26.977 15.3239 26.2502 15.1399C25.9294 15.0586 25.8127 14.4729 26.0315 14.2248Z',
  ],
  '67': [
    'M8.58549 17.8501C7.00742 17.1133 6 15.5375 6 13.8057V8.97421C6 5.72496 9.38069 3.56179 12.3599 4.90475L22.1401 9.31341C23.322 9.84619 24.678 9.84619 25.8599 9.31341L35.6401 4.90475C38.6193 3.56179 42 5.72496 42 8.97421L42 13.8563C42 15.5619 41.0225 17.1188 39.4804 17.8693L26.3145 24.2776C25.0882 24.8744 23.6554 24.886 22.4196 24.309L8.58549 17.8501Z',
    'M8.48518 36.3136C6.96195 35.5561 6 34.0094 6 32.3176V27.409C6 24.1598 9.38069 21.9966 12.3599 23.3395L22.1401 27.7482C23.322 28.281 24.678 28.281 25.8599 27.7482L35.6401 23.3396C38.6193 21.9966 42 24.1598 42 27.409L42 32.3176C42 34.0094 41.0381 35.5561 39.5148 36.3136L26.0148 43.027C24.7467 43.6577 23.2533 43.6577 21.9852 43.027L8.48518 36.3136Z',
  ],
  '68': [
    'M13.5511 23.0104C11.7626 23.0845 10.0249 22.4014 8.75924 21.1267L3.47103 15.8011C2.494 14.8172 3.13018 13.1326 4.50954 13.0512L11.0897 12.6628C11.9003 12.615 12.5469 11.9637 12.5945 11.1474L12.9801 4.52071C13.061 3.13159 14.7337 2.49091 15.7107 3.47485L21.0548 8.85668C22.2878 10.0984 22.9648 11.7927 22.9294 13.5485L22.8685 16.5653C22.7998 19.9732 20.11 22.7389 16.7282 22.8789L13.5511 23.0104Z',
    'M13.5511 24.9896C11.7626 24.9155 10.0249 25.5986 8.75924 26.8733L3.47103 32.1989C2.494 33.1828 3.13018 34.8674 4.50954 34.9488L11.0897 35.3372C11.9003 35.385 12.5469 36.0363 12.5945 36.8526L12.9801 43.4793C13.061 44.8684 14.7337 45.5091 15.7107 44.5251L21.0548 39.1433C22.2878 37.9016 22.9648 36.2072 22.9294 34.4516L22.8685 31.4347C22.7998 28.0268 20.11 25.2611 16.7282 25.1211L13.5511 24.9896Z',
    'M39.2398 21.1267C37.9741 22.4014 36.2364 23.0845 34.448 23.0104L31.2708 22.8789C27.8891 22.7389 25.1992 19.9732 25.1305 16.5653L25.0697 13.5485C25.0343 11.7927 25.7112 10.0984 26.9442 8.85668L32.2883 3.47485C33.2653 2.49091 34.9381 3.13159 35.0189 4.52071L35.4046 11.1474C35.4521 11.9637 36.0988 12.615 36.9093 12.6628L43.4895 13.0512C44.8688 13.1326 45.505 14.8172 44.528 15.8011L39.2398 21.1267Z',
    'M34.448 24.9896C36.2364 24.9155 37.9741 25.5986 39.2398 26.8733L44.528 32.1989C45.505 33.1828 44.8688 34.8674 43.4895 34.9488L36.9093 35.3372C36.0988 35.385 35.4521 36.0363 35.4046 36.8526L35.0189 43.4793C34.9381 44.8684 33.2653 45.5091 32.2883 44.5251L26.9442 39.1433C25.7112 37.9016 25.0343 36.2072 25.0697 34.4516L25.1305 31.4347C25.1992 28.0268 27.8891 25.2611 31.2708 25.1211L34.448 24.9896Z',
  ],
  '69': [
    'M9.11981 10.6978C6.96006 11.8725 6.96006 15.1275 9.11981 16.3022L13.6206 18.75L9.11981 21.1978C6.96006 22.3725 6.96006 25.6275 9.11981 26.8022L13.6206 29.25L9.11981 31.6978C6.96006 32.8725 6.96006 36.1275 9.11981 37.3022L22.6282 44.6489C23.4888 45.117 24.5112 45.117 25.3718 44.6489L38.8802 37.3022C41.0399 36.1275 41.0399 32.8725 38.8802 31.6978L34.3794 29.25L38.8802 26.8022C41.0399 25.6275 41.0399 22.3725 38.8802 21.1978L34.3794 18.75L38.8802 16.3022C41.0399 15.1275 41.0399 11.8725 38.8802 10.6978L25.3718 3.35106C24.5112 2.88298 23.4888 2.88298 22.6282 3.35106L9.11981 10.6978Z',
  ],
  '70': [
    'M9.18898 10.6067C7.22685 11.6108 6 13.5786 6 15.7217V30.8614C6 33.0044 7.22685 34.9722 9.18899 35.9763L21.189 42.1168C22.947 43.0164 25.053 43.0164 26.811 42.1168L38.811 35.9763C40.7732 34.9722 42 33.0044 42 30.8614V15.7217C42 13.5786 40.7731 11.6108 38.811 10.6067L26.811 4.46622C25.053 3.5666 22.947 3.5666 21.189 4.46622L9.18898 10.6067ZM24 29.0813C27.3137 29.0813 30 26.4892 30 23.2917C30 20.0942 27.3137 17.5021 24 17.5021C20.6863 17.5021 18 20.0942 18 23.2917C18 26.4892 20.6863 29.0813 24 29.0813Z',
  ],
  '71': [
    'M9.18898 10.3395C7.22685 11.4208 6 13.5399 6 15.8479V32.1521C6 34.4601 7.22685 36.5792 9.18899 37.6605L21.189 44.2734C22.947 45.2422 25.053 45.2422 26.811 44.2734L38.811 37.6605C40.7732 36.5792 42 34.4601 42 32.1521V15.8479C42 13.5399 40.7731 11.4208 38.811 10.3395L26.811 3.72661C25.053 2.7578 22.947 2.7578 21.189 3.72661L9.18898 10.3395ZM12.3783 22.6237C11.8742 23.4714 11.8739 24.5288 12.3776 25.3768L17.2639 33.6031C17.7464 34.4153 18.6186 34.9123 19.5598 34.9112L28.4446 34.9014C29.3834 34.9004 30.2527 34.4039 30.7342 33.5939L35.6221 25.37C36.126 24.5222 36.126 23.4647 35.6221 22.6169L30.7362 14.3963C30.2536 13.5845 29.3816 13.0877 28.4407 13.0888L19.5549 13.0986C18.6164 13.0996 17.7473 13.5958 17.2657 14.4055L12.3783 22.6237Z',
  ],
  '72': [
    'M18.75 10.875C18.75 12.1844 19.0407 13.5398 19.9666 14.4657L20.4093 14.9084C21.3352 15.8343 22.6906 16.125 24 16.125C24.0261 16.125 24.0521 16.1251 24.0781 16.1254C25.4949 16.1391 26.9743 15.853 27.9761 14.8511C28.978 13.8493 29.2641 12.3699 29.2504 10.9531C29.2501 10.9271 29.25 10.9011 29.25 10.875C29.25 6.52576 32.7758 3 37.125 3C41.4742 3 45 6.52576 45 10.875C45 15.2242 41.4742 18.75 37.125 18.75C35.8153 18.75 34.4594 19.0407 33.5333 19.9669L33.0919 20.4083C32.1657 21.3344 31.875 22.6903 31.875 24C31.875 25.3094 32.1657 26.6648 33.0916 27.5907L33.5343 28.0334C34.4602 28.9593 35.8157 29.25 37.125 29.25C41.4742 29.25 45 32.7758 45 37.125C45 41.4742 41.4742 45 37.125 45C32.7758 45 29.25 41.4742 29.25 37.125C29.25 37.0986 29.2501 37.0723 29.2504 37.046C29.2643 35.6294 28.9782 34.1502 27.9765 33.1485C26.9748 32.1468 25.4956 31.8607 24.079 31.8746C24.0527 31.8749 24.0264 31.875 24 31.875C22.6903 31.875 21.3344 32.1657 20.4083 33.0919L19.9669 33.5333C19.0407 34.4594 18.75 35.8153 18.75 37.125C18.75 41.4742 15.2242 45 10.875 45C6.52576 45 3 41.4742 3 37.125C3 32.7758 6.52576 29.25 10.875 29.25C10.9011 29.25 10.9271 29.2501 10.9531 29.2504C12.3699 29.2641 13.8493 28.978 14.8511 27.9761C15.853 26.9743 16.1391 25.4949 16.1254 24.0781C16.1251 24.0521 16.125 24.0261 16.125 24C16.125 23.9736 16.1251 23.9473 16.1254 23.921C16.1393 22.5044 15.8532 21.0252 14.8515 20.0235C13.8498 19.0218 12.3706 18.7357 10.954 18.7496C10.9277 18.7499 10.9014 18.75 10.875 18.75C6.52576 18.75 3 15.2242 3 10.875C3 6.52576 6.52576 3 10.875 3C15.2242 3 18.75 6.52576 18.75 10.875Z',
  ],
  '73': [
    'M22.3432 7.24786C22.9813 5.97487 24.8102 5.97109 25.4537 7.24144L27.8207 11.9145C28.2976 12.8561 29.5063 13.1572 30.3749 12.5508L39.2509 6.35363C40.7267 5.32328 42.612 6.92994 41.8084 8.53308L34.3862 23.3397C34.1424 23.826 34.1436 24.3977 34.3894 24.8829L41.7876 39.4889C42.5976 41.0881 40.7206 42.7024 39.2404 41.6796L30.46 35.6127C29.5888 35.0108 28.3822 35.3171 27.9095 36.2602L25.6578 40.7521C25.0197 42.0251 23.1908 42.0289 22.5473 40.7586L20.1803 36.0855C19.7034 35.1439 18.4947 34.8428 17.6261 35.4492L8.75002 41.6464C7.27428 42.6767 5.38897 41.0701 6.19258 39.4669L13.6148 24.6603C13.8585 24.174 13.8573 23.6023 13.6116 23.1171L6.21337 8.51111C5.40334 6.91191 7.28036 5.29762 8.76061 6.32041L17.541 12.3873C18.4121 12.9892 19.6188 12.6829 20.0915 11.7398L22.3432 7.24786Z',
  ],
  '74': [
    'M22.4031 4.23315C22.8616 2.58895 25.1384 2.58895 25.5969 4.23316L28.3161 13.9847C28.562 14.8667 29.4474 15.3899 30.3167 15.1669L39.928 12.7012C41.5486 12.2855 42.687 14.3035 41.5249 15.5319L34.6328 22.8178C34.0095 23.4768 34.0095 24.5232 34.6328 25.1822L41.5249 32.4681C42.687 33.6965 41.5486 35.7145 39.928 35.2988L30.3167 32.8331C29.4474 32.6101 28.562 33.1333 28.3161 34.0153L25.5969 43.7668C25.1384 45.4111 22.8616 45.4111 22.4031 43.7668L19.6839 34.0153C19.438 33.1333 18.5526 32.6101 17.6832 32.8331L8.07197 35.2988C6.45142 35.7145 5.31303 33.6965 6.4751 32.4681L13.3671 25.1822C13.9905 24.5232 13.9905 23.4768 13.3671 22.8178L6.47509 15.5319C5.31303 14.3035 6.45142 12.2855 8.07198 12.7012L17.6833 15.1669C18.5526 15.3899 19.438 14.8667 19.6839 13.9847L22.4031 4.23315Z',
  ],
  '75': [
    'M25.73 6.62211L26.8327 10.6838C28.0571 15.1937 29.8126 19.5422 32.0622 23.6382C34.3582 27.8185 37.1523 31.7052 40.3832 35.2133L42.9853 38.0386C44.2442 39.4055 43.011 41.6509 41.2554 41.1883L37.4604 40.1884C33.0673 39.0308 28.5431 38.4448 24 38.4448C19.4569 38.4448 14.9327 39.0308 10.5396 40.1884L6.74464 41.1883C4.98904 41.6509 3.75578 39.4055 5.01469 38.0386L7.61677 35.2133C10.8477 31.7051 13.6418 27.8185 15.9378 23.6382C18.1874 19.5422 19.9429 15.1937 21.1673 10.6838L22.27 6.62211C22.7667 4.79263 25.2333 4.79263 25.73 6.62211Z',
  ],
}
