import { platformAndroid } from '@rnef/platform-android'
import { platformIOS } from '@rnef/platform-ios'
import { pluginMetro } from '@rnef/plugin-metro'
import { providerGitHub } from '@rnef/provider-github'
import { config } from 'dotenv'
config({ path: '../../.env.defaults.local' })

const isGitHubAction = process.env.GITHUB_ACTIONS === 'true'

export default {
  plugins: [pluginMetro()],
  platforms: {
    ios: platformIOS(),
    android: platformAndroid(),
  },
  remoteCacheProvider: isGitHubAction
    ? 'github-actions'
    : providerGitHub({
        owner: 'uniswap',
        repository: 'universe',
        token: process.env.GH_TOKEN_RN_CLI,
      }),
  fingerprint: {
    ignorePaths: [
      // Files generated by [GraphQL] Apollo Generate Swift script phase in Xcode, making fingerprint unstable when installing pods vs not
      'ios/OneSignalNotificationServiceExtension/Env.swift',
      'ios/WidgetsCore/Env.swift',
      'ios/WidgetsCore/MobileSchema/MobileSchema.graphql.swift',
      'ios/WidgetsCore/MobileSchema/Fragments/**/*',
      'ios/WidgetsCore/MobileSchema/Operations/**/*',
      'ios/WidgetsCore/MobileSchema/Schema/**/*',
      // There's a setup script in Podfile that changes the podspec in node_modules, making fingerprint unstable when installing pods vs not
      '../../node_modules/react-native-permissions/RNPermissions.podspec',
    ],
  },
}
