import { G, Path, Svg } from 'react-native-svg'

// eslint-disable-next-line no-relative-import-paths/no-relative-import-paths
import { createIcon } from '../factories/createIcon'

export const [InsufficientGas, AnimatedInsufficientGas] = createIcon({
  name: 'InsufficientGas',
  getIcon: (props) => (
    <Svg viewBox="0 0 25 24" fill="none" {...props}>
      <G id="gas insufficient">
        <Path
          id="Subtract"
          d="M17.2217 1.80783C16.8395 1.40923 16.2064 1.39599 15.8078 1.77827C15.4092 2.16055 15.396 2.79358 15.7783 3.19218L18.2517 5.77117C17.218 6.24482 16.5 7.28851 16.5 8.4999C16.5 10.1568 17.8431 11.4999 19.5 11.4999C19.8506 11.4999 20.1872 11.4397 20.5 11.3292V16.7012C20.5 17.1422 20.1427 17.5 19.7 17.5C19.2582 17.5 18.9 17.1418 18.9 16.7V14.3999C18.9 12.7431 17.5569 11.3999 15.9 11.3999H14.5V5.4999C14.5 3.84305 13.1569 2.4999 11.5 2.4999H5.5C3.84315 2.4999 2.5 3.84305 2.5 5.4999V20.5C2.50001 20.9142 2.62592 21.299 2.84157 21.6182C3.20098 22.1502 3.80964 22.5 4.5 22.5H12.5C13.1499 22.5 13.7274 22.19 14.0927 21.7098C14.3095 21.4249 14.4515 21.08 14.4897 20.7045C14.4965 20.6372 14.5 20.569 14.5 20.5V13.3999H15.9C16.4523 13.3999 16.9 13.8476 16.9 14.3999V16.7C16.9 18.2464 18.1536 19.5 19.7 19.5C21.2455 19.5 22.5 18.2484 22.5 16.7012V8.32698C22.5 7.84819 22.3481 7.43172 22.1459 7.08465C21.9729 6.76205 21.7428 6.47474 21.4689 6.23633L17.2217 1.80783ZM19.5 7.4999C19.7296 7.4999 19.941 7.57725 20.1098 7.70731C20.2349 7.83559 20.3303 7.95164 20.3968 8.05693C20.4629 8.19045 20.5 8.34084 20.5 8.4999C20.5 9.05219 20.0523 9.4999 19.5 9.4999C18.9477 9.4999 18.5 9.05219 18.5 8.4999C18.5 7.94762 18.9477 7.4999 19.5 7.4999ZM4.71572 5.72463C4.71572 5.17235 5.16343 4.72463 5.71572 4.72463H11.2157C11.768 4.72463 12.2157 5.17235 12.2157 5.72463V9.72463C12.2157 10.2769 11.768 10.7246 11.2157 10.7246H5.71572C5.16343 10.7246 4.71572 10.2769 4.71572 9.72463V5.72463ZM11.4306 19.403C11.1377 19.6959 10.6628 19.6959 10.3699 19.403L8.50464 17.5377L6.63934 19.403C6.34645 19.6959 5.87157 19.6959 5.57868 19.403C5.28579 19.1101 5.28579 18.6353 5.57868 18.3424L7.44398 16.4771L5.57864 14.6117C5.28575 14.3188 5.28575 13.844 5.57864 13.5511C5.87153 13.2582 6.34641 13.2582 6.6393 13.5511L8.50464 15.4164L10.37 13.5511C10.6629 13.2582 11.1377 13.2582 11.4306 13.5511C11.7235 13.844 11.7235 14.3188 11.4306 14.6117L9.5653 16.4771L11.4306 18.3424C11.7235 18.6353 11.7235 19.1101 11.4306 19.403Z"
          fill={'currentColor' ?? '#E10F0F'}
          fillRule="evenodd"
          clipRule="evenodd"
        />
      </G>
    </Svg>
  ),
  defaultFill: '#E10F0F',
})
