import { G, Path, Svg } from 'react-native-svg'

// eslint-disable-next-line no-relative-import-paths/no-relative-import-paths
import { createIcon } from '../factories/createIcon'

export const [Signature, AnimatedSignature] = createIcon({
  name: 'Signature',
  getIcon: (props) => (
    <Svg viewBox="0 0 16 16" fill="none" {...props}>
      <G id="signature">
        <Path
          id="Vector"
          d="M0.339514 12.4249H3.91243C3.84237 12.6943 3.80463 12.9584 3.80463 13.2009C3.80463 14.0685 4.28966 14.6883 5.30817 14.6883C6.54766 14.6883 7.55 13.8153 8.19669 12.4249H15.6605C15.8491 12.4249 16 12.2794 16 12.0908C16 11.9022 15.8491 11.7621 15.6605 11.7621H8.46614C8.76791 10.8783 8.95114 9.84357 8.98889 8.72263C9.3284 8.6472 9.68403 8.60946 10.0505 8.60946C10.2392 8.60946 10.3469 8.69031 10.3469 8.83043C10.3469 9.29926 10.0936 9.66571 10.0936 10.1346C10.0936 10.5441 10.3955 10.792 10.7888 10.792C11.8827 10.792 13.2031 8.92203 13.6396 8.92203C14.0383 8.92203 13.5426 10.6034 14.9006 10.6034C15.1216 10.6034 15.4072 10.5441 15.6282 10.404C15.7575 10.3124 15.8491 10.1831 15.8491 10.016C15.8491 9.81123 15.7198 9.64417 15.5042 9.64417C15.3156 9.64417 15.1593 9.80043 14.9761 9.80043C14.3941 9.80043 14.9491 8.01128 13.8768 8.01128C12.9391 8.01128 11.4732 9.83277 11.1014 9.83277C11.0529 9.83277 11.0152 9.80583 11.0152 9.74117C11.0152 9.54717 11.2576 9.11066 11.2576 8.67414C11.2576 8.13526 10.8103 7.79034 10.1098 7.79034C9.72717 7.79034 9.34994 7.82806 8.98889 7.89811C8.87031 5.05811 7.52306 2.82166 5.46446 2.82166C4.07949 2.82166 3.01246 4.00186 3.01246 5.5054C3.01246 7.26223 4.15494 8.76574 5.57763 9.76271C4.94711 10.3825 4.45671 11.0884 4.15494 11.7621H0.339514C0.150886 11.7621 0 11.9022 0 12.0908C0 12.2794 0.150886 12.4249 0.339514 12.4249ZM3.8316 5.5054C3.8316 4.45454 4.54294 3.6408 5.46446 3.6408C7.08117 3.6408 8.12663 5.65091 8.17514 8.11908C7.43146 8.37774 6.75243 8.77114 6.16503 9.23997C5.04411 8.46397 3.8316 7.1814 3.8316 5.5054ZM0.183229 10.6142C0.323343 10.7543 0.533514 10.7489 0.679 10.6142L1.35263 9.94057L2.02626 10.6142C2.16637 10.7543 2.38194 10.7543 2.52206 10.6142C2.66217 10.4741 2.66217 10.2585 2.52206 10.1184L1.84843 9.45017L2.52206 8.77654C2.66217 8.63643 2.66217 8.42626 2.52206 8.28611C2.38194 8.14063 2.16637 8.14603 2.02626 8.28611L1.35263 8.95437L0.679 8.28611C0.533514 8.14063 0.323343 8.14063 0.183229 8.28611C0.0431143 8.42626 0.0431143 8.6418 0.183229 8.77654L0.856857 9.45017L0.183229 10.1184C0.0431143 10.2639 0.0431143 10.4741 0.183229 10.6142ZM6.75243 10.4417C6.82249 10.4741 6.88717 10.4902 6.95183 10.4902C7.17277 10.4902 7.32906 10.3178 7.32906 10.1346C7.32906 9.99983 7.2644 9.87051 7.10811 9.79506C7.03266 9.75734 6.95723 9.7196 6.8764 9.67648C7.2644 9.40166 7.69551 9.15914 8.15897 8.97591C8.09429 10.016 7.89491 10.9753 7.58774 11.7621H5.02257C5.30277 11.2339 5.72311 10.6789 6.25663 10.1885C6.41831 10.2801 6.58537 10.3609 6.75243 10.4417ZM4.64531 13.0446C4.64531 12.856 4.67766 12.6459 4.74771 12.4249H7.28057C6.79554 13.3195 6.14349 13.8691 5.3998 13.8691C4.88246 13.8691 4.64531 13.5297 4.64531 13.0446Z"
          fill={'currentColor' ?? '#7D7D7D'}
        />
      </G>
    </Svg>
  ),
  defaultFill: '#7D7D7D',
})
