#!/bin/bash
nodeidx=${1:-""}
randomport=`shuf -i 10000-11000 -n1`
port=$((10300+$nodeidx))
rpcport=$((9845+$nodeidx))
authrpcport=$((8851+$nodeidx))
p2pport=$((30403+$nodeidx))
miner=0x`cat ../data/node${nodeidx}/data/keystore/* | jq -r .address`

echo "start geth node $nodeidx"
nodedir=../data/node${nodeidx}

../bin/geth --datadir ${nodedir}/data --verbosity 3 --networkid 9987 --rpc.allow-unprotected-txs --miner.gaslimit=900000000 --miner.threads=8 --mine --miner.etherbase=$miner --port $port --allow-insecure-unlock --unlock $miner --password ../config/pwd  --http --http.addr 0.0.0.0 --http.port $rpcport --http.api admin,eth,web3,net,debug,miner,txpool --http.corsdomain '*' --http.vhosts '*' --authrpc.port ${authrpcport} --nat=none --bootnodes enode://8ea90c3008b4f431faf1e8871c1a8006bd0f548e9bdb982c9ded63eca6797b4d7b9acfa15678ca1e8ba9bec70f8c548fb33a47915f41b5623e5a26042359e248@127.0.0.1:0?discport=30305 >> $nodedir/node.log 2>&1 &
