package caddy

var staticWebsiteCaddyFileTempl = `
{{ .DomainName }} {
    root * {{ .RootDir }}
    file_server

    import COMMON_CONFIG
}
`

var forwardWebsiteCaddyFileTempl = `
{{ .DomainName }} {
    reverse_proxy https://{{ .Target }} {
                header_up Host {upstream_hostport}
                transport http {
                        tls_insecure_skip_verify
                }
        }
}
`

var forwardWebsitePayloadTempl = `
{
  "handle": [
    {
      "handler": "subroute",
      "routes": [
        {
          "handle": [
            {
              "handler": "reverse_proxy",
              "headers": {
                "request": {
                  "set": {
                    "Host": [
                      "{http.reverse_proxy.upstream.hostport}"
                    ]
                  }
                }
              },
              "transport": {
                "protocol": "http",
                "tls": {
                  "insecure_skip_verify": true
                }
              },
              "upstreams": [
                {
                  "dial": "{{ .Target }}:443"
                }
              ]
            }
          ]
        }
      ]
    }
  ],
  "match": [
    {
      "host": [
        "{{ .DomainName }}"
      ]
    }
  ],
  "terminal": true
}`

var newWebsitePayloadTempl = `
{
  "handle": [
    {
      "handler": "subroute",
      "routes": [
        {
          "handle": [
            {
              "handler": "vars",
              "root": "{{ .RootDir }}"
            }
          ]
        },
        {
          "handle": [
            {
              "handler": "headers",
              "response": {
                "set": {
                  "Strict-Transport-Security": [
                    "max-age=63072000"
                  ]
                }
              }
            }
          ],
          "match": [
            {
              "path": [
                "/"
              ]
            }
          ]
        },
        {
          "handle": [
            {
              "encodings": {
                "gzip": {},
                "zstd": {}
              },
              "handler": "encode",
              "prefer": [
                "zstd",
                "gzip"
              ]
            },
            {
              "handler": "file_server",
              "hide": [
                "./Caddyfile",
                "{{ .WebsiteCaddyFile }}"
              ]
            }
          ]
        }
      ]
    }
  ],
  "match": [
    {
      "host": [
        "{{ .DomainName }}"
      ]
    }
  ],
  "terminal": true
}`
