package root

import (
	"fmt"
	"github.com/spf13/cobra"
	"github.com/xueqianlu/caddyproxy/command/run"
	"os"
)

type RootCommand struct {
	baseCmd *cobra.Command
}

func NewRootCommand() *RootCommand {
	rootCommand := &RootCommand{
		baseCmd: &cobra.Command{
			Short: "CaddyProxy is a tool to control caddy config via API",
		},
	}
	rootCommand.baseCmd.CompletionOptions.HiddenDefaultCmd = true
	rootCommand.registerSubCommands()

	return rootCommand
}

func (rc *RootCommand) registerSubCommands() {
	rc.baseCmd.AddCommand(run.GetCommand())
}

func (rc *RootCommand) Execute() {
	if err := rc.baseCmd.Execute(); err != nil {
		_, _ = fmt.Fprintln(os.Stderr, err)

		os.Exit(1)
	}
}
