import type { Block, BlocksResponse, BlockTransactionsResponse } from 'types/api/block';

import { ADDRESS_PARAMS } from './addressParams';
import { TX } from './tx';

export const BLOCK_HASH = '0x8fa7b9e5e5e79deeb62d608db22ba9a5cb45388c7ebb9223ae77331c6080dc70';

export const BLOCK: Block = {
  base_fee_per_gas: '14',
  burnt_fees: '92834504000000000',
  burnt_fees_percentage: 42.2,
  difficulty: '340282366920938463463374607431768211451',
  extra_data: 'TODO',
  gas_limit: '30000000',
  gas_target_percentage: 55.79,
  gas_used: '6631036',
  gas_used_percentage: 22.10,
  has_beacon_chain_withdrawals: null,
  hash: BLOCK_HASH,
  height: 8988736,
  miner: ADDRESS_PARAMS,
  nonce: '0x0000000000000000',
  parent_hash: BLOCK_HASH,
  priority_fee: '19241635454943109',
  rewards: [
    {
      reward: '19241635454943109',
      type: 'Validator Reward',
    },
  ],
  size: 46406,
  state_root: 'TODO',
  timestamp: '2023-05-12T19:29:12.000000Z',
  total_difficulty: '10837812015930321201107455268036056402048391639',
  tx_count: 142,
  tx_fees: '19241635547777613',
  type: 'block',
  uncles_hashes: [],
};

export const BLOCKS: BlocksResponse = {
  items: Array(50).fill(BLOCK),
  next_page_params: {
    block_number: 8988686,
    items_count: 50,
  },
};

export const BLOCK_TXS: BlockTransactionsResponse = {
  items: Array(50).fill(TX),
  next_page_params: {
    block_number: 9004925,
    index: 49,
    items_count: 50,
  },
};
