import React from 'react';

import makePrettyLink from 'lib/makePrettyLink';
import { Link } from 'toolkit/chakra/link';
import IconSvg from 'ui/shared/IconSvg';

interface Props {
  url?: string | undefined;
}

const WebsiteLink = ({ url }: Props) => {
  if (!url) {
    return null;
  }

  return (
    <Link
      external
      noIcon
      href={ url }
      display="inline-flex"
      alignItems="center"
      columnGap={ 1 }
      mt={ 3 }
    >
      <IconSvg name="link" boxSize={ 5 } color="text.secondary"/>
      <span>{ makePrettyLink(url)?.domain }</span>
    </Link>
  );
};

export default WebsiteLink;
