import { chakra } from '@chakra-ui/react';
import React from 'react';

import shortenString from 'lib/shortenString';
import { Tooltip } from 'toolkit/chakra/tooltip';

interface Props {
  hash: string;
  noTooltip?: boolean;
  type?: 'long' | 'short';
  as?: React.ElementType;
}

const HashStringShorten = ({ hash, noTooltip, as = 'span', type }: Props) => {
  const charNumber = type === 'long' ? 16 : 8;
  if (hash.length <= charNumber) {
    return <chakra.span as={ as }>{ hash }</chakra.span>;
  }

  const content = <chakra.span as={ as }>{ shortenString(hash, charNumber) }</chakra.span>;

  if (noTooltip) {
    return content;
  }

  return (
    <Tooltip content={ hash } disabled={ noTooltip }>
      { content }
    </Tooltip>
  );
};

export default HashStringShorten;
