import React from 'react';

import config from 'configs/app';
import * as ensDomainMock from 'mocks/ens/domain';
import * as ensDomainEventsMock from 'mocks/ens/events';
import { test, expect } from 'playwright/lib';

import NameDomain from './NameDomain';

test('details tab', async({ render, mockTextAd, mockApiResponse }) => {
  await mockTextAd();
  await mockApiResponse('domain_info', ensDomainMock.ensDomainA, {
    pathParams: { chainId: config.chain.id, name: ensDomainMock.ensDomainA.name },
  });
  const component = await render(
    <NameDomain/>,
    { hooksConfig: {
      router: {
        query: { name: ensDomainMock.ensDomainA.name },
        isReady: true,
      },
    } },
  );
  await expect(component).toHaveScreenshot();
});

test('history tab +@mobile', async({ render, mockTextAd, mockApiResponse }) => {
  await mockTextAd();
  await mockApiResponse('domain_info', ensDomainMock.ensDomainA, {
    pathParams: { chainId: config.chain.id, name: ensDomainMock.ensDomainA.name },
  });
  await mockApiResponse('domain_events', {
    items: [
      ensDomainEventsMock.ensDomainEventA,
      ensDomainEventsMock.ensDomainEventB,
    ],
  }, {
    pathParams: { chainId: config.chain.id, name: ensDomainMock.ensDomainA.name },
  });
  const component = await render(
    <NameDomain/>,
    { hooksConfig: {
      router: {
        query: { name: ensDomainMock.ensDomainA.name, tab: 'history' },
        isReady: true,
      },
    } },
  );
  await expect(component).toHaveScreenshot();
});
