import React from 'react';
import type { ControllerRenderProps, Control } from 'react-hook-form';
import { Controller } from 'react-hook-form';

import type { FormFields } from '../types';

import CheckboxInput from 'ui/shared/CheckboxInput';

import ContractVerificationFormRow from '../ContractVerificationFormRow';

interface Props {
  control: Control<FormFields>;
}

const ContractVerificationFieldConstArgs = ({ control }: Props) => {
  const renderControl = React.useCallback(({ field }: {field: ControllerRenderProps<FormFields, 'constructor_args'>}) => (
    <CheckboxInput<FormFields, 'constructor_args'> text="Try to fetch constructor arguments automatically" field={ field }/>
  ), []);

  return (
    <ContractVerificationFormRow>
      <Controller
        name="constructor_args"
        control={ control }
        render={ renderControl }
      />
    </ContractVerificationFormRow>
  );
};

export default React.memo(ContractVerificationFieldConstArgs);
