import type { IconProps } from '@chakra-ui/react';
import { Icon, useColorModeValue } from '@chakra-ui/react';
import React from 'react';

const WatermarkIcon = (props: IconProps) => {
  const watermarkColor = useColorModeValue('link', 'white');
  return (
    <Icon
      { ...props }
      position="absolute"
      opacity={ 0.1 }
      top="50%"
      left="50%"
      transform="translate(-50%, -50%)"
      pointerEvents="none"
      viewBox="0 0 114 20"
      color={ watermarkColor }
    >
      { /* eslint-disable-next-line max-len */ }
      <path d="M7.71 1a1 1 0 0 0-1-1H4.52a1 1 0 0 0-1 1v2.167a1 1 0 0 1-1 1H1a1 1 0 0 0-1 1V19a1 1 0 0 0 1 1h2.188a1 1 0 0 0 1-1V5.167a1 1 0 0 1 1-1H6.71a1 1 0 0 0 1-1V1ZM16.114 1a1 1 0 0 0-1-1h-2.188a1 1 0 0 0-1 1v2.167a1 1 0 0 0 1 1h1.376a1 1 0 0 1 1 1V19a1 1 0 0 0 1 1h2.188a1 1 0 0 0 1-1V5.167a1 1 0 0 0-1-1h-1.376a1 1 0 0 1-1-1V1ZM11.868 8.976a1 1 0 0 0-1-1H8.68a1 1 0 0 0-1 1v6.095a1 1 0 0 0 1 1h2.188a1 1 0 0 0 1-1V8.976ZM27.702 4.533h4.948c2.096 0 3.23 1.103 3.23 2.69a2.468 2.468 0 0 1-1.495 2.344v.051a2.81 2.81 0 0 1 1.464 1.05c.36.501.546 1.107.529 1.725 0 1.774-1.227 3.17-3.453 3.17h-5.223V4.533Zm4.982 4.482c.79 0 1.357-.585 1.357-1.476 0-.892-.567-1.477-1.357-1.477h-3.139v2.953h3.14Zm.224 5.032c.944 0 1.631-.724 1.631-1.775s-.687-1.758-1.632-1.758h-3.362v3.533h3.362ZM38.68 5.845h-1.036V4.181h2.852v11.375h-1.821l.005-9.711ZM42.182 11.48c0-2.499 1.84-4.343 4.383-4.343 2.542 0 4.398 1.827 4.398 4.342 0 2.516-1.839 4.325-4.398 4.325-2.56 0-4.383-1.826-4.383-4.325Zm3.902 2.687h.981c1.117 0 2.096-1.189 2.096-2.688s-.982-2.707-2.096-2.707h-.981c-1.117 0-2.096 1.23-2.096 2.707 0 1.477.98 2.688 2.096 2.688ZM52.145 11.462c0-2.55 1.755-4.325 4.28-4.325 2.028 0 3.625 1.051 3.883 3.2h-1.77c-.171-1.085-.944-1.568-1.735-1.568h-.859c-1.1 0-1.992 1.206-1.992 2.708 0 1.501.893 2.722 1.992 2.722h.86a1.75 1.75 0 0 0 1.752-1.602h1.769c-.245 2.12-1.855 3.222-3.927 3.222-2.518-.015-4.253-1.807-4.253-4.357ZM61.955 4.181h1.803v6.274h1.308l2.44-3.084h2.061l-3.006 3.808 3.144 4.377H67.54l-2.628-3.619h-1.154v3.619h-1.803V4.18ZM70.53 13.1h1.734c.086.723.533 1.188 1.473 1.188h1.136c.807 0 1.185-.414 1.185-.965 0-.551-.309-.879-1.048-.985l-1.909-.246c-1.615-.19-2.336-1.154-2.336-2.412 0-1.654 1.227-2.55 3.418-2.55 2.099 0 3.37.844 3.436 2.722h-1.735c-.086-.706-.378-1.206-1.271-1.206H73.58c-.773 0-1.134.414-1.134.948s.343.896 1.082 1l1.927.245c1.563.19 2.284 1.034 2.284 2.344 0 1.688-1.116 2.619-3.59 2.619-2.393.002-3.554-.911-3.62-2.703ZM78.873 11.462c0-2.55 1.752-4.325 4.28-4.325 2.027 0 3.625 1.051 3.883 3.2h-1.77c-.172-1.085-.945-1.568-1.735-1.568h-.859c-1.102 0-1.995 1.206-1.995 2.708 0 1.501.893 2.722 1.995 2.722h.86a1.75 1.75 0 0 0 1.751-1.602h1.77c-.246 2.12-1.856 3.222-3.927 3.222-2.515-.015-4.253-1.807-4.253-4.357ZM88.199 11.48c0-2.499 1.838-4.343 4.38-4.343 2.543 0 4.4 1.827 4.4 4.342 0 2.516-1.838 4.325-4.4 4.325-2.562 0-4.38-1.826-4.38-4.325Zm3.9 2.687h.981c1.117 0 2.098-1.189 2.098-2.688s-.981-2.707-2.098-2.707h-.982c-1.116 0-2.095 1.23-2.095 2.707 0 1.477.984 2.688 2.1 2.688h-.005ZM98.477 12.53V7.381h1.803v4.842c0 1.189.602 1.895 1.392 1.895h.982c.841 0 1.597-.775 1.597-1.895V7.38h1.806v8.184h-1.754v-1.12c-.491.845-1.357 1.362-2.68 1.362-1.978-.003-3.146-1.157-3.146-3.277ZM109.059 13.65V8.974h-1.581V7.38h1.581V5.087h1.821V7.38h2.13v1.585h-2.13v4.17c0 .534.172.793.756.793h1.443v1.636h-1.964c-1.32-.002-2.056-.691-2.056-1.915Z" fill="currentColor"/>
    </Icon>
  );
};

export default WatermarkIcon;
