import React, { useCallback } from 'react';

import {
  Button,
  Modal,
  ModalOverlay,
  ModalContent,
  ModalFooter,
  ModalHeader,
  ModalBody,
  ModalCloseButton,
} from '@chakra-ui/react';

type Props = {
  isOpen: boolean;
  onClose: () => void;
  onDelete: () => void;
  title: string;
  text: string;
}

const DeleteModal: React.FC<Props> = ({ isOpen, onClose, onDelete, title, text }) => {

  const onDeleteClick = useCallback(() => {
    onDelete();
    onClose()
  }, [ onClose, onDelete ]);

  return (
    <Modal isOpen={ isOpen } onClose={ onClose } size="md">
      <ModalOverlay/>
      <ModalContent>
        <ModalHeader fontWeight="500" textStyle="h3">{ title }</ModalHeader>
        <ModalCloseButton/>
        <ModalBody>
          { text }
        </ModalBody>
        <ModalFooter>
          <Button variant="primary" size="lg" onClick={ onDeleteClick }>
              Delete
          </Button>
        </ModalFooter>
      </ModalContent>
    </Modal>
  )
}

export default DeleteModal;
