import { SearchIcon } from '@chakra-ui/icons';
import { Text, Grid, GridItem, Link, Tooltip, Button, useColorModeValue } from '@chakra-ui/react';
import React from 'react';

import Address from 'ui/shared/address/Address';
import AddressIcon from 'ui/shared/address/AddressIcon';
import AddressLink from 'ui/shared/address/AddressLink';
import TxLogTopic from 'ui/tx/logs/TxLogTopic';
import DecodedInputData from 'ui/tx/TxDecodedInputData';

interface Props {
  address: string;
  topics: Array<{ hex: string }>;
  data: string;
  index: number;
}

const RowHeader = ({ children }: { children: React.ReactNode }) => (
  <GridItem _notFirst={{ mt: { base: 5, lg: 0 } }}>
    <Text fontWeight={{ base: 700, lg: 500 }}>{ children }</Text>
  </GridItem>
);

const TxLogItem = ({ address, index, topics, data }: Props) => {
  const borderColor = useColorModeValue('blackAlpha.200', 'whiteAlpha.200');
  const dataBgColor = useColorModeValue('blackAlpha.50', 'whiteAlpha.50');

  return (
    <Grid
      gridTemplateColumns={{ base: 'minmax(0, 1fr)', lg: '200px minmax(0, 1fr)' }}
      gap={{ base: 3, lg: 8 }}
      py={ 8 }
      _notFirst={{
        borderTopWidth: '1px',
        borderTopColor: borderColor,
      }}
      _first={{
        pt: 0,
      }}
    >
      <RowHeader>Address</RowHeader>
      <GridItem display="flex" alignItems="center">
        <Address>
          <AddressIcon hash={ address }/>
          <AddressLink hash={ address } ml={ 2 }/>
        </Address>
        <Tooltip label="Find matches topic">
          <Link ml={ 2 }>
            <SearchIcon w={ 5 } h={ 5 }/>
          </Link>
        </Tooltip>
        <Tooltip label="Log index">
          <Button variant="outline" isActive ml={{ base: 6, lg: 'auto' }} size="sm" fontWeight={ 400 }>
            { index }
          </Button>
        </Tooltip>
      </GridItem>
      <RowHeader>Decode input data</RowHeader>
      <GridItem>
        <DecodedInputData/>
      </GridItem>
      <RowHeader>Topics</RowHeader>
      <GridItem>
        { topics.map((item, index) => <TxLogTopic key={ index } { ...item } index={ index }/>) }
      </GridItem>
      <RowHeader>Data</RowHeader>
      <GridItem p={ 4 } fontSize="sm" borderRadius="md" bgColor={ dataBgColor }>
        { data }
      </GridItem>
    </Grid>
  );
};

export default React.memo(TxLogItem);
