import { chakra } from '@chakra-ui/react';
import React from 'react';

interface Props {
  src: string;
  onLoad: () => void;
  onError: () => void;
  onClick?: () => void;
}

const NftVideo = ({ src, onLoad, onError, onClick }: Props) => {
  return (
    <chakra.video
      src={ src }
      autoPlay
      disablePictureInPicture
      loop
      muted
      playsInline
      onCanPlayThrough={ onLoad }
      onError={ onError }
      borderRadius="md"
      onClick={ onClick }
      transitionProperty="transform"
      transitionDuration="normal"
      transitionTimingFunction="ease"
      cursor="pointer"
      _hover={{
        transform: 'scale(1.2)',
      }}
    />
  );
};

export default chakra(NftVideo);
