import type { AppCategory, AppItemOverview } from '~/types/client/apps';

export const APP_CATEGORIES: Array<AppCategory> = [
  {
    id: 'defi',
    name: 'DeFi',
  },
  {
    id: 'exchanges',
    name: 'Exchanges',
  },
  {
    id: 'finance',
    name: 'Finance',
  },
  {
    id: 'games',
    name: 'Games',
  },
  {
    id: 'marketplaces',
    name: 'Marketplaces',
  },
  {
    id: 'nft',
    name: 'NFT',
  },
  {
    id: 'security',
    name: 'Security',
  },
  {
    id: 'social',
    name: 'Social',
  },
  {
    id: 'tools',
    name: 'Tools',
  },
  {
    id: 'Yield-farming',
    name: 'yield-farming',
  },
];

export const TEMPORARY_DEMO_APPS: Array<AppItemOverview> = [
  {
    id: 'easy-staking',
    title: 'Easy Staking',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[0], APP_CATEGORIES[1] ],
    shortDescription: 'Accessible DeFi staking platform for STAKE holders on Ethereum',
    site: 'https://easy-staking.xdaichain.com/',
    // eslint-disable-next-line max-len
    description: 'Easy Staking allows users to place STAKE into a contract and receive STAKE emissions on Ethereum. It provides an accessible staking mechanism for users and increases STAKE utility and DeFi composability. EasyStaking also:\n\n- Incentivizes liquidity providers on decentralized exchanges through unique reward mechanisms\n- Creates staking opportunities via hardware wallets and other Ethereum applications\n- Provides staking opportunities with no minimum STAKE requirements to participate\n- Limits total circulating supply',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'curve',
    title: 'Curve',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[1], APP_CATEGORIES[2] ],
    // eslint-disable-next-line max-len
    shortDescription: 'Curve is an exchange liquidity pool on Ethereum designed for: extremely efficient stablecoin trading, low risk, supplemental fee income for liquidity providers, without an opportunity cost.',
    site: 'https://xdai.curve.fi/',
    // eslint-disable-next-line max-len
    description: 'Curve is an exchange liquidity pool on Ethereum designed for: extremely efficient stablecoin trading, low risk, supplemental fee income for liquidity providers, without an opportunity cost.',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'honwyswap',
    title: 'HonwySwap',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[1], APP_CATEGORIES[2] ],
    // eslint-disable-next-line max-len
    shortDescription: 'Honeyswap is a decentralized exchange built on the Gnosis Chain, this enables users to experience fast and secure transactions with incredibly low fees.  Multiple tokens are available with which you can swap and add liquidity.',
    site: 'https://honeyswap.org/',
    // eslint-disable-next-line max-len
    description: 'Honeyswap is a decentralized exchange built on the Gnosis Chain, this enables users to experience fast and secure transactions with incredibly low fees.  Multiple tokens are available with which you can swap and add liquidity.',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'sushi',
    title: 'Sushi',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[0], APP_CATEGORIES[1] ],
    shortDescription: 'Swap, yield, lend, borrow, leverage, limit, launch all on one community-driven ecosystem',
    site: 'https://app.sushi.com/',
    description: 'Swap, yield, lend, borrow, leverage, limit, launch all on one community-driven ecosystem',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'bao-finance',
    title: 'Bao Finance',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[0], APP_CATEGORIES[1] ],
    shortDescription: 'Yield Farming for Synthetic Assets from LP tokens',
    site: 'https://farms.baoswap.xyz/',
    description: 'Yield Farming for Synthetic Assets from LP tokens',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'component',
    title: 'Component',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[1], APP_CATEGORIES[2] ],
    // eslint-disable-next-line max-len
    shortDescription: 'During the Unit protocol development, we faced difficulty finding a reliable, flexible protocol for stablecoin swap without interface censorship.',
    site: 'https://xdai.component.finance',
    // eslint-disable-next-line max-len
    description: 'During the Unit protocol development, we faced difficulty finding a reliable, flexible protocol for stablecoin swap without interface censorship.',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'pooltogether',
    title: 'PoolTogether',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[1], APP_CATEGORIES[2] ],
    shortDescription: 'View, deposit and withdraw for all V3 Pools',
    site: 'https://app.pooltogether.com/',
    description: 'View, deposit and withdraw for all V3 Pools',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'swapr',
    title: 'Swapr',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[0], APP_CATEGORIES[1] ],
    shortDescription: 'A governance-enabled automated market maker with adjustable fees.',
    site: 'https://swapr.eth.limo',
    description: 'A governance-enabled automated market maker with adjustable fees.',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'levinswap',
    title: 'Levinswap',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[0], APP_CATEGORIES[1] ],
    // eslint-disable-next-line max-len
    shortDescription: 'AMM DEX on the xDai chain. Its uniqueness comes from the ability to trade securities tokens, specifically, tokenized real estate tokens.',
    site: 'https://app.levinswap.org/',
    description: 'AMM DEX on the xDai chain. Its uniqueness comes from the ability to trade securities tokens, specifically, tokenized real estate tokens.',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'omen',
    title: 'Omen',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[1], APP_CATEGORIES[2] ],
    shortDescription: 'Decentralized prediction markets on Ethereum',
    site: 'https://xdai.omen.eth.link/',
    description: 'Decentralized prediction markets on Ethereum',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'nifty-ink',
    title: 'Nifty Ink',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[1], APP_CATEGORIES[2] ],
    shortDescription: 'NFT artwork created and sold on xDAI using meta transactions, burner wallets, and bridged to Ethereum',
    site: 'https://nifty.ink/explore',
    description: 'NFT artwork created and sold on xDAI using meta transactions, burner wallets, and bridged to Ethereum',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'treasure-chess',
    title: 'Treasure Chess',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[0], APP_CATEGORIES[1] ],
    shortDescription: 'Every chess game is one-of-a-kind. Make yours a collectible.',
    site: 'https://treasure.chess.com/',
    description: 'Every chess game is one-of-a-kind. Make yours a collectible.',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'unique-one',
    title: 'Unique.One',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[0], APP_CATEGORIES[1] ],
    // eslint-disable-next-line max-len
    shortDescription: 'A truly decentralised non-profit platform owned and managed by the Digital Arts community, bringing together Artists, Creators and Collectors as One.',
    site: 'https://www.unique.one/',
    // eslint-disable-next-line max-len
    description: 'A truly decentralised non-profit platform owned and managed by the Digital Arts community, bringing together Artists, Creators and Collectors as One.',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'cold-truth-culture',
    title: 'Cold Truth Culture',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[1], APP_CATEGORIES[2] ],
    shortDescription: 'A Community That Empowers NFT Artists',
    site: 'https://www.coldtruthculture.io/',
    description: 'A Community That Empowers NFT Artists',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'xdai-bridge',
    title: 'xDai Bridge',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[1], APP_CATEGORIES[2] ],
    shortDescription: 'Token bridge between the Gnosis Chain and the Ethereum network',
    site: 'https://bridge.gnosischain.com/',
    description: 'Token bridge between the Gnosis Chain and the Ethereum network',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'omni-bridge',
    title: 'OmniBridge',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[0], APP_CATEGORIES[1] ],
    shortDescription: 'The OmniBridge multi-token extension is the simplest way to transfer ANY ERC20/ ERC677 /ERC827 token to and from the xDai chain.',
    site: 'https://omni.gnosischain.com/bridge',
    description: 'The OmniBridge multi-token extension is the simplest way to transfer ANY ERC20/ ERC677 /ERC827 token to and from the xDai chain.',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'gnosis-safe',
    title: 'Gnosis Safe',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[0], APP_CATEGORIES[1] ],
    shortDescription: 'Gnosis Safe is the most trusted platform to manage digital assets on Ethereum',
    site: 'https://gnosis-safe.io/',
    description: 'Gnosis Safe is the most trusted platform to manage digital assets on Ethereum',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'multisender',
    title: 'Multisender',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[1], APP_CATEGORIES[2] ],
    // eslint-disable-next-line max-len
    shortDescription: 'Send ERC20 token or ETH. Batch sender. Bulk Sender. Token Multisender allows you to airdrop tokens in a few transactions in trustless way. Batch sending ERC20, Ethereum tokens.',
    site: 'https://multisender.app/',
    // eslint-disable-next-line max-len
    description: 'Send ERC20 token or ETH. Batch sender. Bulk Sender. Token Multisender allows you to airdrop tokens in a few transactions in trustless way. Batch sending ERC20, Ethereum tokens.',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'disperse',
    title: 'Disperse',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[1], APP_CATEGORIES[2] ],
    shortDescription: 'Distribute ether or tokens to multiple addresses',
    site: 'https://disperse.app/',
    description: 'Distribute ether or tokens to multiple addresses',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
  {
    id: 'symmetric',
    title: 'Symmetric',
    logo: 'https://www.fillmurray.com/144/144',
    categories: [ APP_CATEGORIES[1], APP_CATEGORIES[2] ],
    // eslint-disable-next-line max-len
    shortDescription: 'DEX or Decentralized Exchange, also called an Automated Market Maker (AMM) in Decentralized Finance (DeFi). Symmetric is live on gnosis chain (xDai) and Celo.',
    site: 'https://symmetric.finance/',
    // eslint-disable-next-line max-len
    description: 'DEX or Decentralized Exchange, also called an Automated Market Maker (AMM) in Decentralized Finance (DeFi). Symmetric is live on gnosis chain (xDai) and Celo.',
    url: 'https://blockscout-allowance-mainnet-stage.vercel.app/',
    twitter: 'https://twitter.com/EasyStaking',
    telegram: 'https://t.me/easystaking',
    github: 'https://github.com/mikhin',
  },
];
