import { defineSlotRecipe } from '@chakra-ui/react';

export const recipe = defineSlotRecipe({
  slots: [ 'root', 'list', 'trigger', 'content', 'indicator' ],
  base: {
    root: {
      '--tabs-trigger-radius': 'radii.l2',
      position: 'relative',
      _horizontal: {
        display: 'block',
      },
      _vertical: {
        display: 'flex',
      },
    },
    list: {
      display: 'inline-flex',
      position: 'relative',
      isolation: 'isolate',
      '--tabs-indicator-shadow': 'shadows.xs',
      '--tabs-indicator-bg': 'colors.bg',
      minH: 'var(--tabs-height)',
      _horizontal: {
        flexDirection: 'row',
      },
      _vertical: {
        flexDirection: 'column',
      },
    },
    trigger: {
      outline: '0',
      minW: 'var(--tabs-height)',
      height: 'var(--tabs-height)',
      display: 'flex',
      alignItems: 'center',
      fontWeight: 'medium',
      position: 'relative',
      cursor: 'button',
      gap: '2',
      _focusVisible: {
        zIndex: 1,
        outline: '2px solid',
        outlineColor: 'colorPalette.focusRing',
      },
      _disabled: {
        cursor: 'not-allowed',
        opacity: 0.5,
      },
    },
    content: {
      focusVisibleRing: 'inside',
      _horizontal: {
        width: '100%',
        pt: 'var(--tabs-content-padding)',
      },
      _vertical: {
        height: '100%',
        ps: 'var(--tabs-content-padding)',
      },
    },
    indicator: {
      width: 'var(--width)',
      height: 'var(--height)',
      borderRadius: 'var(--tabs-indicator-radius)',
      bg: 'var(--tabs-indicator-bg)',
      shadow: 'var(--tabs-indicator-shadow)',
      zIndex: -1,
    },
  },

  variants: {
    fitted: {
      'true': {
        list: {
          display: 'flex',
        },
        trigger: {
          flex: 1,
          textAlign: 'center',
          justifyContent: 'center',
        },
      },
    },

    justify: {
      start: {
        list: {
          justifyContent: 'flex-start',
        },
      },
      center: {
        list: {
          justifyContent: 'center',
        },
      },
      end: {
        list: {
          justifyContent: 'flex-end',
        },
      },
    },

    size: {
      sm: {
        root: {
          '--tabs-height': 'sizes.8',
          '--tabs-content-padding': 'spacing.6',
        },
        trigger: {
          py: '1',
          px: '3',
          textStyle: 'sm',
        },
      },
      md: {
        root: {
          '--tabs-height': 'sizes.10',
          '--tabs-content-padding': 'spacing.6',
        },
        trigger: {
          py: '2',
          px: '4',
          textStyle: 'md',
        },
      },
    },

    variant: {
      solid: {
        trigger: {
          fontWeight: '600',
          borderRadius: 'base',
          color: 'tabs.solid.fg',
          bg: 'transparent',
          _selected: {
            bg: 'tabs.solid.bg.selected',
            color: 'tabs.solid.fg.selected',
            _hover: {
              color: 'tabs.solid.fg.selected',
            },
          },
          _hover: {
            color: 'link.primary.hover',
          },
        },
      },
      secondary: {
        list: {
          border: 'none',
          columnGap: '3',
          _horizontal: {
            _before: {
              display: 'none',
            },
          },
        },
        trigger: {
          fontWeight: '500',
          color: 'tabs.secondary.fg',
          bg: 'transparent',
          borderWidth: '2px',
          borderStyle: 'solid',
          borderColor: 'tabs.secondary.border',
          borderRadius: 'base',
          _selected: {
            bg: 'tabs.secondary.bg.selected',
            color: 'tabs.secondary.fg.selected',
            borderColor: 'tabs.secondary.bg.selected',
            _hover: {
              color: 'tabs.secondary.fg.selected',
              borderColor: 'tabs.secondary.bg.selected',
            },
          },
          _hover: {
            color: 'link.primary.hover',
            borderColor: 'link.primary.hover',
          },
        },
      },
    },
  },

  defaultVariants: {
    size: 'md',
    variant: 'solid',
  },
});
