import type { LinkProps } from '@chakra-ui/react';
import React from 'react';

import type { EntityTag } from './types';

import * as mixpanel from 'lib/mixpanel/index';
import LinkExternal from 'ui/shared/LinkExternal';
import LinkInternal from 'ui/shared/LinkInternal';

import { getTagLinkParams } from './utils';

interface Props {
  data: EntityTag;
  children: React.ReactNode;
}

const EntityTagLink = ({ data, children }: Props) => {

  const linkParams = getTagLinkParams(data);

  const handleLinkClick = React.useCallback(() => {
    if (!linkParams?.href) {
      return;
    }

    mixpanel.logEvent(mixpanel.EventTypes.PAGE_WIDGET, {
      Type: 'Address tag',
      Info: data.slug,
      URL: linkParams.href,
    });
  }, [ linkParams?.href, data.slug ]);

  const linkProps: LinkProps = {
    color: 'inherit',
    display: 'inline-flex',
    overflow: 'hidden',
    _hover: { textDecor: 'none', color: 'inherit' },
    onClick: handleLinkClick,
  };

  if (linkParams?.type === 'internal') {
    return (
      <LinkInternal
        { ...linkProps }
        href={ linkParams.href }
      >
        { children }
      </LinkInternal>
    );
  }

  if (linkParams?.type === 'external') {
    return (
      <LinkExternal
        { ...linkProps }
        href={ linkParams.href }
        iconColor={ data.meta?.textColor }
      >
        { children }
      </LinkExternal>
    );
  }

  // eslint-disable-next-line react/jsx-no-useless-fragment
  return <>{ children }</>;
};

export default React.memo(EntityTagLink);
