import type { NextPage } from 'next';
import dynamic from 'next/dynamic';
import React from 'react';

import PageNextJs from 'nextjs/PageNextJs';

const OutputRoots = dynamic(() => import('ui/pages/L2OutputRoots'), { ssr: false });

const Page: NextPage = () => {
  return (
    <PageNextJs pathname="/output-roots">
      <OutputRoots/>
    </PageNextJs>
  );
};

export default Page;

export { optimisticRollup as getServerSideProps } from 'nextjs/getServerSideProps';
