import {
  Transfer as TransferEvent,
  Approval as ApprovalEvent,
  ApprovalForAll as ApprovalForAllEvent
} from "../generated/Drago/Drago"
import {Transfer, Approval, ApprovalForAll, Minted, TokenOwner} from "../generated/schema"
import {
  store,
  Bytes,
  BigInt,
} from "@graphprotocol/graph-ts";

export function handleTransfer(event: TransferEvent): void {
  let entity = new Transfer(
    event.transaction.hash.concatI32(event.logIndex.toI32())
  )

  entity.from = event.params.from
  entity.to = event.params.to
  entity.tokenId = event.params.tokenId

  entity.blockNumber = event.block.number
  entity.blockTimestamp = event.block.timestamp
  entity.transactionHash = event.transaction.hash

  entity.save()
  // update TokenOwner
  if (true) {
    let ownerEntity= new TokenOwner(event.params.tokenId.toString())
    ownerEntity.owner = event.params.to
    ownerEntity.tokenId = event.params.tokenId
    ownerEntity.save()
  }

  if (event.params.from.toHexString() == "0x0000000000000000000000000000000000000000") {
    // Mint
    let mintEntity = new Minted(
        event.transaction.hash.concatI32(event.logIndex.toI32())
    )
    mintEntity.from = event.params.from
    mintEntity.to = event.params.to
    mintEntity.tokenId = event.params.tokenId

    mintEntity.blockNumber = event.block.number
    mintEntity.blockTimestamp = event.block.timestamp
    mintEntity.transactionHash = event.transaction.hash

    // set new fields.
    // set sort to transaction hash latest 6 bytes.
    mintEntity.sortHash = Bytes.fromHexString(event.transaction.hash.toHexString().slice(-12))
    mintEntity.sortIndex = event.logIndex

    mintEntity.save()
  }
}

export function handleApproval(event: ApprovalEvent): void {
  let entity = new Approval(
    event.transaction.hash.concatI32(event.logIndex.toI32())
  )
  entity.owner = event.params.owner
  entity.approved = event.params.approved
  entity.tokenId = event.params.tokenId

  entity.blockNumber = event.block.number
  entity.blockTimestamp = event.block.timestamp
  entity.transactionHash = event.transaction.hash

  entity.save()
}

export function handleApprovalForAll(event: ApprovalForAllEvent): void {
  let entity = new ApprovalForAll(
    event.transaction.hash.concatI32(event.logIndex.toI32())
  )
  entity.owner = event.params.owner
  entity.operator = event.params.operator
  entity.approved = event.params.approved

  entity.blockNumber = event.block.number
  entity.blockTimestamp = event.block.timestamp
  entity.transactionHash = event.transaction.hash

  entity.save()
}
