package types

type NodeInfo struct {
	MinerPubkey    string `bson:"miner_pubkey" json:"miner_pubkey"`
	BenefitAddress string `bson:"benefit_address" json:"benefit_address"`
	DeviceIp       string `bson:"device_ip" json:"device_ip"`
}

type InstalledModelInfo struct {
	ModelId  string `bson:"model_id" json:"model_id"`
	DiskSize uint64 `bson:"disk_size" json:"disk_size"`
}

type RunningModelInfo struct {
	ModelId     string `bson:"model_id" json:"model_id"`
	StartedTime uint64 `bson:"started_time" json:"started_time"`
	LatestTime  uint64 `bson:"latest_time" json:"latest_time"`
	RunCount    uint64 `bson:"run_count" json:"run_count"`
	GpuRamUsed  uint64 `bson:"gpu_ram" json:"gpu_ram"`
}

type ModelInfo struct {
	InstalledModels []*InstalledModelInfo `bson:"installed_models" json:"installed_models"`
	RunningModels   []*RunningModelInfo   `bson:"running_models" json:"running_models"`
}

type DeviceInfo struct {
	DeviceType  string `bson:"device_type" json:"device_type"`
	DeviceModel string `bson:"device_model" json:"device_model"`
	DeviceParam string `bson:"device_param" json:"device_param"`
	DevicePower uint64 `bson:"device_power" json:"device_power"`
}

type DeviceUsage struct {
	DeviceType  string `bson:"device_type" json:"device_type"`
	DeviceUsage uint64 `bson:"device_usage" json:"device_usage"`
}

type CpuInfo struct {
	Model string `bson:"model" json:"model"`
	Core  uint   `bson:"core" json:"core"`
	Usage uint   `bson:"usage" json:"usage"`
}

type GpuInfo struct {
	Model  string `bson:"model" json:"model"`
	Ram    uint   `bson:"ram" json:"ram"`
	Usage  uint   `bson:"usage" json:"usage"`
	Occupy uint   `bson:"occupy" json:"occupy"`
	Temp   uint   `bson:"temp" json:"temp"`
}

type RamInfo struct {
	Size  uint `bson:"size" json:"size"`
	Usage uint `bson:"usage" json:"usage"`
}

type DiskInfo struct {
	Size  uint `bson:"size" json:"size"`
	Usage uint `bson:"usage" json:"usage"`
}

type HardwareInfo struct {
	Cpu  []*CpuInfo `bson:"cpu" json:"cpu"`
	Gpu  []*GpuInfo `bson:"gpu" json:"gpu"`
	Ram  *RamInfo   `bson:"ram" json:"ram"`
	Disk *DiskInfo  `bson:"disk" json:"disk"`
}

type WorkerInfo struct {
	WorkerId   string        `bson:"worker_id" json:"worker_id"`
	NodeInfo   *NodeInfo     `bson:"node_info" json:"node_info"`
	ModelInofs *ModelInfo    `bson:"model_infos" json:"model_infos"`
	Hardware   *HardwareInfo `bson:"hardware" json:"hardware"`
}
