-- WARNING: This schema is for context only and is not meant to be run.
-- Table order and constraints may not be valid for execution.

CREATE TABLE invitation (
  user_id uuid NOT NULL,
  inviter_id uuid,
  wallet_address character varying NOT NULL,
  real_name character varying NOT NULL DEFAULT ''::character varying,
  x_name character varying,
  wechat_name character varying,
  created_at timestamp with time zone NOT NULL DEFAULT now(),
  updated_at timestamp without time zone,
  is_signed boolean DEFAULT false,
  reward integer DEFAULT 0,
  CONSTRAINT invitation_pkey PRIMARY KEY (user_id),
  CONSTRAINT invitation_user_id_fkey FOREIGN KEY (user_id) REFERENCES auth.users(id),
  CONSTRAINT invitation_inviter_id_fkey FOREIGN KEY (inviter_id) REFERENCES auth.users(id)
);


DROP TABLE IF EXISTS sign_config;
CREATE TABLE IF NOT EXISTS sign_config (
                                           id SERIAL PRIMARY KEY,
                                           qr_code_secret TEXT NOT NULL,
                                           venue_latitude DECIMAL(10,8) NOT NULL,
                                           venue_longitude DECIMAL(11,8) NOT NULL,
                                           start_time TIMESTAMP NOT NULL,
                                           end_time TIMESTAMP NOT NULL,
                                           radius_km DECIMAL(5,2) DEFAULT 1.0,
                                           reward_base_amount DECIMAL(10,0) DEFAULT 10,
                                           reward_max_amount DECIMAL(10,0) DEFAULT 1000,
                                           created_at TIMESTAMP DEFAULT NOW()
);

-- 签到记录表
CREATE TABLE IF NOT EXISTS sign_logs (
                                         id SERIAL PRIMARY KEY,
                                         user_id UUID REFERENCES auth.users(id),
                                         qr_code TEXT NOT NULL,
                                         user_latitude DECIMAL(10,8) NOT NULL,
                                         user_longitude DECIMAL(11,8) NOT NULL,
                                         distance_km DECIMAL(8,3),
                                         is_successful BOOLEAN DEFAULT false,
                                         error_reason TEXT,
                                         signed_at TIMESTAMP DEFAULT NOW()
);

INSERT INTO sign_config (
    qr_code_secret,
    venue_latitude,
    venue_longitude,
    start_time,
    end_time,
    radius_km,
    reward_base_amount,
    reward_max_amount
) VALUES (
             'meeting_checkin_2024_08_29_abcdefghijklmnopqrstuvwxyz123456789012',
             22.2835121, --pier 1929
             114.1743664,
             '2025-08-28 11:30:00', -- UTC 时间，对应北京时间 19:30
             '2025-08-29 12:30:00', -- UTC 时间，对应北京时间 20:30
             1.0,
             10,
          1000
         );
