# RPC Proxy

This is a simple RPC proxy server that forwards requests to an Ethereum RPC backend. It includes features like whitelisting, blacklisting, and rate limiting.

## Environment Variables

The following environment variables can be used to configure the proxy:

### General Configuration

- `ETH_RPC_BACKEND`: The URL of the real Ethereum RPC backend to forward requests to.
- `MYSQL_DSN`: The Data Source Name (DSN) for the MySQL database connection (e.g., `user:password@tcp(127.0.0.1:3306)/dbname`).
- `BLACKLIST_CONTRACT_ADDR`: The address of the blacklist contract on the Ethereum network.
- `WHITELIST_FILE`: The path to the file containing whitelisted IP addresses or domains.
- `BLACKLIST_CACHE_CLEANUP_INTERVAL`: The interval for cleaning up the blacklist cache (default: `5m`).

### Rate Limiting Configuration

The proxy implements a two-stage rate limiting mechanism: **Normal Mode** and **Penalty Mode**.

#### Normal Mode
Applies to all non-whitelisted IPs by default.

- `RATE_LIMIT_NORMAL`: The number of requests allowed per 15 minutes for normal usage (default: `1000`).
- `RATE_BURST_NORMAL`: The burst size for normal usage (default: `20`).

#### Penalty Mode
Applies to IPs that frequently exceed the rate limit.

- `RATE_LIMIT_PENALTY`: The number of requests allowed per 15 minutes for penalized IPs (default: `100`).
- `RATE_BURST_PENALTY`: The burst size for penalized IPs (default: `5`).
- `PENALTY_DURATION`: The duration an IP stays in penalty mode (default: `20m`).
- `PENALTY_TRIGGER_COUNT`: The number of consecutive rate limit violations required to trigger penalty mode (default: `5`).

### IP Blacklist Configuration

You can specify a file containing a list of IP addresses to be blacklisted. IPs in this list will be automatically placed in **Penalty Mode**.

- `IP_BLACKLIST_FILE`: The path to the file containing blacklisted IP addresses or domains.

### Ban List Configuration

The proxy maintains a persistent ban list for IPs that attempt to send transactions from blacklisted addresses.

- `BAN_LIST_FILE`: The path to the file where banned IPs are stored (default: `banlist.txt`).

### Local Address Blacklist Configuration

You can specify a file containing a list of Ethereum addresses to be blacklisted locally. Requests from these addresses will be blocked, and the sender's IP will be banned.

- `LOCAL_BLACKLIST_FILE`: The path to the file containing blacklisted Ethereum addresses.

## Usage

1. Set the required environment variables.
2. Run the proxy server.
3. The server listens on port `8545`.

## Whitelist File Format

The whitelist file should contain one entry per line. Lines starting with `#` or `//` are ignored.
Wildcards `*` are supported.

Example:
```
127.0.0.1
example.com
*.example.com
```

## IP Blacklist File Format

The IP blacklist file follows the same format as the whitelist file.

Example:
```
192.168.1.100
bad-actor.com
*.botnet.net
```

## Ban List File Format

The ban list file contains one IP address per line. This file is automatically updated by the proxy when a blacklisted sender is detected.

Example:
```
10.0.0.5
192.168.1.20
```

## Local Address Blacklist File Format

The local address blacklist file contains one Ethereum address per line.

Example:
```
0x1234567890abcdef1234567890abcdef12345678
0xabcdef1234567890abcdef1234567890abcdef12
```
