package main

import (
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/ethclient"
	"testing"
)

func TestInBlackList(t *testing.T) {
	client, err := ethclient.Dial("https://mars.rpc.movachain.com")
	if err != nil {
		t.Fatalf("Failed to connect to Ethereum client: %v", err)
	}
	result, err := IsInBlacklist(client, common.HexToAddress("0x339F0Ca78A02062fcD1E2f81F9976b32d9552e82"), common.HexToAddress("0x74FB49FB24700C896B6E68Af0dB872Ac0cD97c0C"))
	if err != nil {
		t.Fatalf("IsInBlacklist failed: %v", err)
	} else {
		t.Logf("IsInBlacklist result: %v", result)
	}
}
