package tech.pegasys.teku.attacker2;

import com.googlecode.jsonrpc4j.JsonRpcHttpClient;

import java.net.URI;

public class JsonRpcClientUtil {

    private JsonRpcClientUtil(){

    }
    public static JsonRpcHttpClient getJsonRpcClient(){
        return JsonRpcHttpClientSingleton.singleton();
    }
    private static class JsonRpcHttpClientSingleton{
        private static JsonRpcHttpClient singleton(){
            JsonRpcHttpClient client = null;
            try {
                client = new JsonRpcHttpClient(URI.create(System.getenv("ATTACKER_SERVICE_URL")).toURL());
            } catch (Exception e) {
                e.printStackTrace();
            }
            return client;
        }
    }
}
