/*
 * Copyright Consensys Software Inc., 2022
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package tech.pegasys.teku.bls.impl.blst;

import static org.assertj.core.api.Assertions.assertThat;

import java.util.Random;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import tech.pegasys.teku.bls.BLS;
import tech.pegasys.teku.bls.BLSSecretKeyTest;

public class BlstSecretKeyTest extends BLSSecretKeyTest {

  @BeforeAll
  public static void init() {
    BLS.setBlsImplementation(BlstLoader.INSTANCE.orElseThrow());
  }

  @AfterAll
  public static void cleanup() {
    BLS.resetBlsImplementation();
  }

  @Test
  void shouldBeZeroKeyAfterDestroy() {
    final BlstSecretKey secretKey = BlstSecretKey.generateNew(new Random());
    assertThat(secretKey.isZero()).isFalse();

    secretKey.destroy();
    assertThat(secretKey).isEqualTo(BlstSecretKey.ZERO_SK);
  }
}
