/*
 * Copyright Consensys Software Inc., 2022
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package tech.pegasys.teku.infrastructure.ssz.collections;

import tech.pegasys.teku.infrastructure.ssz.SszMutableVector;
import tech.pegasys.teku.infrastructure.ssz.SszPrimitive;

public interface SszMutablePrimitiveVector<ElementT, SszElementT extends SszPrimitive<ElementT>>
    extends SszMutablePrimitiveCollection<ElementT, SszElementT>,
        SszMutableVector<SszElementT>,
        SszPrimitiveVector<ElementT, SszElementT> {

  @Override
  SszPrimitiveVector<ElementT, SszElementT> commitChanges();

  @Override
  SszMutablePrimitiveVector<ElementT, SszElementT> createWritableCopy();
}
