/*
 * Copyright Consensys Software Inc., 2022
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package tech.pegasys.teku.storage.server.kvstore.serialization;

import static org.assertj.core.api.Assertions.assertThat;
import static tech.pegasys.teku.storage.server.kvstore.serialization.KvStoreSerializer.DEPOSIT_SNAPSHOT_SERIALIZER;

import org.junit.jupiter.api.Test;
import tech.pegasys.teku.ethereum.pow.api.DepositTreeSnapshot;
import tech.pegasys.teku.spec.Spec;
import tech.pegasys.teku.spec.TestSpecFactory;
import tech.pegasys.teku.spec.util.DataStructureUtil;

public class DepositSnapshotSerializerTest {
  private final Spec spec = TestSpecFactory.createMinimalPhase0();
  private final DataStructureUtil dataStructureUtil = new DataStructureUtil(spec);

  private final KvStoreSerializer<DepositTreeSnapshot> depositSnapshotSerializer =
      DEPOSIT_SNAPSHOT_SERIALIZER;

  @Test
  public void roundTrip_snapshot() {
    final DepositTreeSnapshot value = dataStructureUtil.randomDepositTreeSnapshot();
    final byte[] bytes = depositSnapshotSerializer.serialize(value);
    final DepositTreeSnapshot deserialized = depositSnapshotSerializer.deserialize(bytes);
    assertThat(deserialized).isEqualTo(value);
  }
}
