/*
 * Copyright Consensys Software Inc., 2022
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package tech.pegasys.teku.spec.datastructures.blocks.blockbody.versions.electra;

import static com.google.common.base.Preconditions.checkArgument;

import java.util.Optional;
import tech.pegasys.teku.spec.datastructures.blocks.blockbody.BeaconBlockBodySchema;
import tech.pegasys.teku.spec.datastructures.blocks.blockbody.versions.deneb.BeaconBlockBodySchemaDeneb;
import tech.pegasys.teku.spec.datastructures.execution.versions.electra.ExecutionRequestsSchema;

public interface BeaconBlockBodySchemaElectra<T extends BeaconBlockBodyElectra>
    extends BeaconBlockBodySchemaDeneb<T> {

  static BeaconBlockBodySchemaElectra<?> required(final BeaconBlockBodySchema<?> schema) {
    checkArgument(
        schema instanceof BeaconBlockBodySchemaElectra,
        "Expected a BeaconBlockBodySchemaElectra but was %s",
        schema.getClass());
    return (BeaconBlockBodySchemaElectra<?>) schema;
  }

  ExecutionRequestsSchema getExecutionRequestsSchema();

  @Override
  default Optional<BeaconBlockBodySchemaElectra<?>> toVersionElectra() {
    return Optional.of(this);
  }
}
