package tech.pegasys.teku.attacker;

import static org.assertj.core.api.Assertions.assertThat;

import org.checkerframework.checker.units.qual.A;
import org.junit.jupiter.api.Test;
import tech.pegasys.teku.infrastructure.async.SafeFuture;

import java.util.concurrent.ExecutionException;

public class AttackServiceTest {

    @Test
    public void attackIsNotEnabled() {
        AttackService s = new AttackService();
        assertThat(s.enabled()).isEqualTo(false);
    }

    @Test
    public void attackIsEnabled() {
        AttackService s = new AttackService("http://127.0.0.1:12000");
        assertThat(s.enabled()).isEqualTo(true);
    }

    @Test
    public void blockGetNewParentRoot() throws ExecutionException, InterruptedException {
        AttackService s = new AttackService("http://127.0.0.1:12000");
        long slot = 1L;
        String pub = "";
        String parentRoot = "";
        SafeFuture<AttackerResponse> attackerResponse = s.blockGetNewParentRoot(slot, pub, parentRoot);
        assertThat(attackerResponse.get().getCmd().getValue())
                .isEqualTo(AttackerCommand.CMD_NULL.getValue());
    }
    public void blockBeforeBroadcast() {
        AttackService s = new AttackService("http://127.0.0.1:12000");
        long slot = 1L;
        boolean skipBroadCast = false;

        try {
            AttackerResponse attackerResponse = s.blockBeforeBroadcast(slot).get(); // Blocking call to get the result
            switch (attackerResponse.getCmd()) {
                case CMD_EXIT:
                case CMD_ABORT:
                    System.exit(-1); // Terminate the process
                    break;
                case CMD_SKIP:
                    skipBroadCast = true; // Skip broadcast
                    break;
                case CMD_RETURN:
                    // Simulate returning a response (adjust as per actual method requirements)
                    return; // Exit the method
                case CMD_NULL:
                case CMD_CONTINUE:
                    // Do nothing
                    break;
                default:
                    throw new IllegalStateException("Unexpected command received: " + attackerResponse.getCmd());
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to process attacker response", e);
        }

        System.out.println("Block before broadcast completed for slot: " + slot);
        // then sleep 10s
    }
}