/*
 * Copyright Consensys Software Inc., 2023
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package tech.pegasys.teku.spec.datastructures.builder.versions.electra;

import org.apache.tuweni.units.bigints.UInt256;
import tech.pegasys.teku.bls.BLSPublicKey;
import tech.pegasys.teku.infrastructure.ssz.SszList;
import tech.pegasys.teku.infrastructure.ssz.containers.Container5;
import tech.pegasys.teku.infrastructure.ssz.primitive.SszUInt256;
import tech.pegasys.teku.infrastructure.ssz.tree.TreeNode;
import tech.pegasys.teku.spec.datastructures.execution.ExecutionPayloadHeader;
import tech.pegasys.teku.spec.datastructures.execution.versions.electra.ExecutionRequests;
import tech.pegasys.teku.spec.datastructures.type.SszKZGCommitment;
import tech.pegasys.teku.spec.datastructures.type.SszPublicKey;

public class BuilderBidElectraImpl
    extends Container5<
        BuilderBidElectraImpl,
        ExecutionPayloadHeader,
        SszList<SszKZGCommitment>,
        ExecutionRequests,
        SszUInt256,
        SszPublicKey>
    implements BuilderBidElectra {

  BuilderBidElectraImpl(final BuilderBidSchemaElectra schema, final TreeNode backingNode) {
    super(schema, backingNode);
  }

  public BuilderBidElectraImpl(
      final BuilderBidSchemaElectra schema,
      final ExecutionPayloadHeader header,
      final SszList<SszKZGCommitment> blobKzgCommitments,
      final ExecutionRequests executionRequests,
      final SszUInt256 value,
      final SszPublicKey publicKey) {
    super(schema, header, blobKzgCommitments, executionRequests, value, publicKey);
  }

  @Override
  public ExecutionPayloadHeader getHeader() {
    return getField0();
  }

  @Override
  public SszList<SszKZGCommitment> getBlobKzgCommitments() {
    return getField1();
  }

  @Override
  public ExecutionRequests getExecutionRequests() {
    return getField2();
  }

  @Override
  public UInt256 getValue() {
    return getField3().get();
  }

  @Override
  public BLSPublicKey getPublicKey() {
    return getField4().getBLSPublicKey();
  }
}
