package tech.pegasys.teku.attacker;

import com.googlecode.jsonrpc4j.JsonRpcHttpClient;

import java.net.MalformedURLException;
import java.net.URI;

public class JsonRpcClientUtil {

    private static final JsonRpcClientUtil INSTANCE = new JsonRpcClientUtil();

    private JsonRpcClientUtil() {
        // Private constructor to prevent instantiation
    }

    public static JsonRpcClientUtil getInstance() {
        return INSTANCE;
    }

    public JsonRpcHttpClient getJsonRpcClient() {
        return createJsonRpcClient("");
    }

    public JsonRpcHttpClient getJsonRpcClientByUrl(final String url) {
        return createJsonRpcClient(url);
    }

    private JsonRpcHttpClient createJsonRpcClient(final String url) {
        try {
            String realUrl = url.isEmpty() ? System.getenv("ATTACKER_SERVICE_URL") : url;
            if (realUrl == null || realUrl.isEmpty()) {
                return null;
            } else {
                return new JsonRpcHttpClient(URI.create(realUrl).toURL());
            }
        } catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}