package dbModel

import (
	"go.mongodb.org/mongo-driver/bson/primitive"
)

type Height struct {
	ID       primitive.ObjectID `bson:"_id,omitempty"`
	Key      string             `bson:"key"`
	IntValue int64              `bson:"int_value"`
}

func (h *Height) TableName() string {
	return "heights"
}

type BridgeEvent struct {
	ID              primitive.ObjectID `bson:"_id,omitempty"`
	FromChain       int64              `bson:"from_chain"`
	OutTimestamp    int64              `bson:"out_timestamp"`
	FromToken       string             `bson:"from_token"`
	FromAddress     string             `bson:"from_address"`
	FromChainTxHash string             `bson:"from_chain_tx_hash"`
	SendAmount      string             `bson:"send_amount"`
	FeeAmount       string             `bson:"fee_amount"`
	Receiver        string             `bson:"receiver"`
	ToChain         int64              `bson:"to_chain"`
	ToToken         string             `bson:"to_token"`
	ReceiveAmount   string             `bson:"receive_amount"`
	OutId           int64              `bson:"out_id"`
	InTimestamp     int64              `bson:"in_timestamp"`
	InId            int64              `bson:"in_id"`
	ToContract      string             `bson:"to_contract"`
	ToChainTxHash   string             `bson:"to_chain_tx_hash"`
	ToChainStatus   int                `bson:"to_chain_status"`
}

func (b *BridgeEvent) TableName() string {
	return "bridge_events"
}

type BridgeTokenInfo struct {
	ID        primitive.ObjectID `bson:"_id,omitempty"`
	ChainId   int64              `bson:"chain_id"`
	Contract  string             `bson:"contract"`
	Token     string             `bson:"token"`
	TokenName string             `bson:"token_name"`
	ToChainId int64              `bson:"to_chain_id"`
	ToToken   string             `bson:"to_token"`
	Enabled   bool               `bson:"enabled"`
}

func (b *BridgeTokenInfo) TableName() string {
	return "bridge_token_info"
}

type TokenInfo struct {
	ID       primitive.ObjectID `bson:"_id,omitempty"`
	Address  string             `bson:"address"`
	Name     string             `bson:"name"`
	Symbol   string             `bson:"symbol"`
	Decimals int64              `bson:"decimals"`
}

func (t *TokenInfo) TableName() string {
	return "token_info"
}
