// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package bridge

import (
	"errors"
	"math/big"
	"strings"

	ethereum "github.com/ethereum/go-ethereum"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = errors.New
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
	_ = abi.ConvertType
)

// BridgeOutConfig is an auto generated low-level Go binding around an user-defined struct.
type BridgeOutConfig struct {
	ReceiveToken common.Address
	Fee          *big.Int
	Limit        *big.Int
	IsBurn       bool
	Enabled      bool
}

// BridgesubmitParams is an auto generated low-level Go binding around an user-defined struct.
type BridgesubmitParams struct {
	ToChainID   *big.Int
	Receiver    common.Address
	Token       common.Address
	Amount      *big.Int
	OutId       *big.Int
	FromChainID *big.Int
	Sender      common.Address
	SendToken   common.Address
	SendAmount  *big.Int
	Signature   [32]byte
}

// BridgeContractMetaData contains all meta data concerning the BridgeContract contract.
var BridgeContractMetaData = &bind.MetaData{
	ABI: "[{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"address\",\"name\":\"previousAdmin\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"address\",\"name\":\"newAdmin\",\"type\":\"address\"}],\"name\":\"AdminChanged\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"beacon\",\"type\":\"address\"}],\"name\":\"BeaconUpgraded\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"oldReceiver\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"newReceiver\",\"type\":\"address\"}],\"name\":\"FeeReceiverChanged\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"previousOwner\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"newOwner\",\"type\":\"address\"}],\"name\":\"OwnershipTransferred\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"prior\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"present\",\"type\":\"uint256\"}],\"name\":\"RequirementChange\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"fromToken\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"toToken\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"swap\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"address[]\",\"name\":\"path\",\"type\":\"address[]\"}],\"name\":\"SwapConfigChanged\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"uint256\",\"name\":\"toChainID\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"bool\",\"name\":\"enabled\",\"type\":\"bool\"}],\"name\":\"TokenOutConfigChanged\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"fromChainID\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"outId\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"inId\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"address\",\"name\":\"receiver\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"amount\",\"type\":\"uint256\"}],\"name\":\"TransferIn\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"inId\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"address\",\"name\":\"validator\",\"type\":\"address\"}],\"name\":\"TransferInConfirmation\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"inId\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"address\",\"name\":\"receiver\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"amount\",\"type\":\"uint256\"}],\"name\":\"TransferInExecution\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"inId\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"address\",\"name\":\"validator\",\"type\":\"address\"}],\"name\":\"TransferInRejection\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"outId\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"fromChainID\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"address\",\"name\":\"sender\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"amount\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"fee\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"toChainID\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"address\",\"name\":\"receiver\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"address\",\"name\":\"receiveToken\",\"type\":\"address\"}],\"name\":\"TransferOut\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"oldTreasury\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"newTreasury\",\"type\":\"address\"}],\"name\":\"TreasuryChanged\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"minReserve\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"reserveRatio\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"bool\",\"name\":\"enabled\",\"type\":\"bool\"}],\"name\":\"TreasuryConfigChanged\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"amount\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"contractBalance\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"treasuryBalance\",\"type\":\"uint256\"}],\"name\":\"TreasuryTransfer\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"implementation\",\"type\":\"address\"}],\"name\":\"Upgraded\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"address\",\"name\":\"validator\",\"type\":\"address\"}],\"name\":\"ValidatorAddition\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"address\",\"name\":\"validator\",\"type\":\"address\"}],\"name\":\"ValidatorRemoval\",\"type\":\"event\"},{\"inputs\":[],\"name\":\"_inID\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"_outID\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"validator\",\"type\":\"address\"}],\"name\":\"addValidator\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"}],\"name\":\"autoTransferToTreasury\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"}],\"name\":\"calculateTreasuryTransfer\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"canTransfer\",\"type\":\"bool\"},{\"internalType\":\"uint256\",\"name\":\"transferAmount\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"willReserve\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"currentBalance\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"toChainID\",\"type\":\"uint256\"},{\"components\":[{\"internalType\":\"address\",\"name\":\"receiveToken\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"fee\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"limit\",\"type\":\"uint256\"},{\"internalType\":\"bool\",\"name\":\"isBurn\",\"type\":\"bool\"},{\"internalType\":\"bool\",\"name\":\"enabled\",\"type\":\"bool\"}],\"internalType\":\"structBridge.OutConfig\",\"name\":\"config\",\"type\":\"tuple\"}],\"name\":\"changeOutConfig\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"required\",\"type\":\"uint256\"}],\"name\":\"changeValidRequired\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"inId\",\"type\":\"uint256\"}],\"name\":\"confirmInTransfer\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"amount\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"to\",\"type\":\"address\"}],\"name\":\"emergencyWithdraw\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"feeReceiver\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"name\":\"getInId\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"toChainID\",\"type\":\"uint256\"}],\"name\":\"getSupportedTokensOut\",\"outputs\":[{\"internalType\":\"address[]\",\"name\":\"\",\"type\":\"address[]\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"name\":\"inTotal\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"name\":\"inTransfers\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"inId\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"receiver\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"fee\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"amount\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"fromChainID\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"outId\",\"type\":\"uint256\"},{\"internalType\":\"bool\",\"name\":\"executed\",\"type\":\"bool\"},{\"internalType\":\"uint256\",\"name\":\"confirmCounter\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"rejectCounter\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"initialOwner\",\"type\":\"address\"}],\"name\":\"initialize\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"inId\",\"type\":\"uint256\"}],\"name\":\"isChecked\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"inId\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"validator\",\"type\":\"address\"}],\"name\":\"isConfirmed\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"inId\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"validator\",\"type\":\"address\"}],\"name\":\"isRejected\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"name\":\"isTokenSupportedOut\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"toChainID\",\"type\":\"uint256\"}],\"name\":\"isTokenTransferEnabled\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"name\":\"isValidator\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"name\":\"outConfiguration\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"receiveToken\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"fee\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"limit\",\"type\":\"uint256\"},{\"internalType\":\"bool\",\"name\":\"isBurn\",\"type\":\"bool\"},{\"internalType\":\"bool\",\"name\":\"enabled\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"name\":\"outTotal\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"amount\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"toChainID\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"receiver\",\"type\":\"address\"}],\"name\":\"outTransfer\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"name\":\"outTransfers\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"outId\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"fromChainID\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"sender\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"amount\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"fee\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"toChainID\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"receiver\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"receiveToken\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"receiveAmount\",\"type\":\"uint256\"},{\"internalType\":\"bytes32\",\"name\":\"signature\",\"type\":\"bytes32\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"owner\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"proxiableUUID\",\"outputs\":[{\"internalType\":\"bytes32\",\"name\":\"\",\"type\":\"bytes32\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"inId\",\"type\":\"uint256\"}],\"name\":\"rejectInTransfer\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"validator\",\"type\":\"address\"}],\"name\":\"removeValidator\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"renounceOwnership\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"validator\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"newValidator\",\"type\":\"address\"}],\"name\":\"replaceValidator\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"inId\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"receiver\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"amount\",\"type\":\"uint256\"}],\"name\":\"retryTransfer\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"newReceiver\",\"type\":\"address\"}],\"name\":\"setFeeReceiver\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"newTreasury\",\"type\":\"address\"}],\"name\":\"setTreasury\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"minReserve\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"reserveRatio\",\"type\":\"uint256\"},{\"internalType\":\"bool\",\"name\":\"enabled\",\"type\":\"bool\"}],\"name\":\"setTreasuryConfig\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"components\":[{\"internalType\":\"uint256\",\"name\":\"toChainID\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"receiver\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"amount\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"outId\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"fromChainID\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"sender\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"sendToken\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"sendAmount\",\"type\":\"uint256\"},{\"internalType\":\"bytes32\",\"name\":\"signature\",\"type\":\"bytes32\"}],\"internalType\":\"structBridge.submitParams\",\"name\":\"params\",\"type\":\"tuple\"}],\"name\":\"submitInTransfer\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"name\":\"supportedTokensOut\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"newOwner\",\"type\":\"address\"}],\"name\":\"transferOwnership\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"treasury\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"name\":\"treasuryConfigs\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"minReserve\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"reserveRatio\",\"type\":\"uint256\"},{\"internalType\":\"bool\",\"name\":\"enabled\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"name\":\"treasuryTotal\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"newImplementation\",\"type\":\"address\"}],\"name\":\"upgradeTo\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"newImplementation\",\"type\":\"address\"},{\"internalType\":\"bytes\",\"name\":\"data\",\"type\":\"bytes\"}],\"name\":\"upgradeToAndCall\",\"outputs\":[],\"stateMutability\":\"payable\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"validRequired\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"token\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"amount\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"toChainID\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"receiver\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"fromToken\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"toToken\",\"type\":\"address\"}],\"name\":\"outTransferSwap\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"}]",
}

// BridgeContractABI is the input ABI used to generate the binding from.
// Deprecated: Use BridgeContractMetaData.ABI instead.
var BridgeContractABI = BridgeContractMetaData.ABI

// BridgeContract is an auto generated Go binding around an Ethereum contract.
type BridgeContract struct {
	BridgeContractCaller     // Read-only binding to the contract
	BridgeContractTransactor // Write-only binding to the contract
	BridgeContractFilterer   // Log filterer for contract events
}

// BridgeContractCaller is an auto generated read-only Go binding around an Ethereum contract.
type BridgeContractCaller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// BridgeContractTransactor is an auto generated write-only Go binding around an Ethereum contract.
type BridgeContractTransactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// BridgeContractFilterer is an auto generated log filtering Go binding around an Ethereum contract events.
type BridgeContractFilterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// BridgeContractSession is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type BridgeContractSession struct {
	Contract     *BridgeContract   // Generic contract binding to set the session for
	CallOpts     bind.CallOpts     // Call options to use throughout this session
	TransactOpts bind.TransactOpts // Transaction auth options to use throughout this session
}

// BridgeContractCallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type BridgeContractCallerSession struct {
	Contract *BridgeContractCaller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts         // Call options to use throughout this session
}

// BridgeContractTransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type BridgeContractTransactorSession struct {
	Contract     *BridgeContractTransactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts         // Transaction auth options to use throughout this session
}

// BridgeContractRaw is an auto generated low-level Go binding around an Ethereum contract.
type BridgeContractRaw struct {
	Contract *BridgeContract // Generic contract binding to access the raw methods on
}

// BridgeContractCallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type BridgeContractCallerRaw struct {
	Contract *BridgeContractCaller // Generic read-only contract binding to access the raw methods on
}

// BridgeContractTransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type BridgeContractTransactorRaw struct {
	Contract *BridgeContractTransactor // Generic write-only contract binding to access the raw methods on
}

// NewBridgeContract creates a new instance of BridgeContract, bound to a specific deployed contract.
func NewBridgeContract(address common.Address, backend bind.ContractBackend) (*BridgeContract, error) {
	contract, err := bindBridgeContract(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &BridgeContract{BridgeContractCaller: BridgeContractCaller{contract: contract}, BridgeContractTransactor: BridgeContractTransactor{contract: contract}, BridgeContractFilterer: BridgeContractFilterer{contract: contract}}, nil
}

// NewBridgeContractCaller creates a new read-only instance of BridgeContract, bound to a specific deployed contract.
func NewBridgeContractCaller(address common.Address, caller bind.ContractCaller) (*BridgeContractCaller, error) {
	contract, err := bindBridgeContract(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &BridgeContractCaller{contract: contract}, nil
}

// NewBridgeContractTransactor creates a new write-only instance of BridgeContract, bound to a specific deployed contract.
func NewBridgeContractTransactor(address common.Address, transactor bind.ContractTransactor) (*BridgeContractTransactor, error) {
	contract, err := bindBridgeContract(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &BridgeContractTransactor{contract: contract}, nil
}

// NewBridgeContractFilterer creates a new log filterer instance of BridgeContract, bound to a specific deployed contract.
func NewBridgeContractFilterer(address common.Address, filterer bind.ContractFilterer) (*BridgeContractFilterer, error) {
	contract, err := bindBridgeContract(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &BridgeContractFilterer{contract: contract}, nil
}

// bindBridgeContract binds a generic wrapper to an already deployed contract.
func bindBridgeContract(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := BridgeContractMetaData.GetAbi()
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, *parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_BridgeContract *BridgeContractRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _BridgeContract.Contract.BridgeContractCaller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_BridgeContract *BridgeContractRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _BridgeContract.Contract.BridgeContractTransactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_BridgeContract *BridgeContractRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _BridgeContract.Contract.BridgeContractTransactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_BridgeContract *BridgeContractCallerRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _BridgeContract.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_BridgeContract *BridgeContractTransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _BridgeContract.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_BridgeContract *BridgeContractTransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _BridgeContract.Contract.contract.Transact(opts, method, params...)
}

// InID is a free data retrieval call binding the contract method 0xa4e7fe23.
//
// Solidity: function _inID() view returns(uint256)
func (_BridgeContract *BridgeContractCaller) InID(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "_inID")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// InID is a free data retrieval call binding the contract method 0xa4e7fe23.
//
// Solidity: function _inID() view returns(uint256)
func (_BridgeContract *BridgeContractSession) InID() (*big.Int, error) {
	return _BridgeContract.Contract.InID(&_BridgeContract.CallOpts)
}

// InID is a free data retrieval call binding the contract method 0xa4e7fe23.
//
// Solidity: function _inID() view returns(uint256)
func (_BridgeContract *BridgeContractCallerSession) InID() (*big.Int, error) {
	return _BridgeContract.Contract.InID(&_BridgeContract.CallOpts)
}

// OutID is a free data retrieval call binding the contract method 0xbb736eff.
//
// Solidity: function _outID() view returns(uint256)
func (_BridgeContract *BridgeContractCaller) OutID(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "_outID")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// OutID is a free data retrieval call binding the contract method 0xbb736eff.
//
// Solidity: function _outID() view returns(uint256)
func (_BridgeContract *BridgeContractSession) OutID() (*big.Int, error) {
	return _BridgeContract.Contract.OutID(&_BridgeContract.CallOpts)
}

// OutID is a free data retrieval call binding the contract method 0xbb736eff.
//
// Solidity: function _outID() view returns(uint256)
func (_BridgeContract *BridgeContractCallerSession) OutID() (*big.Int, error) {
	return _BridgeContract.Contract.OutID(&_BridgeContract.CallOpts)
}

// CalculateTreasuryTransfer is a free data retrieval call binding the contract method 0x2d3a6f72.
//
// Solidity: function calculateTreasuryTransfer(address token) view returns(bool canTransfer, uint256 transferAmount, uint256 willReserve, uint256 currentBalance)
func (_BridgeContract *BridgeContractCaller) CalculateTreasuryTransfer(opts *bind.CallOpts, token common.Address) (struct {
	CanTransfer    bool
	TransferAmount *big.Int
	WillReserve    *big.Int
	CurrentBalance *big.Int
}, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "calculateTreasuryTransfer", token)

	outstruct := new(struct {
		CanTransfer    bool
		TransferAmount *big.Int
		WillReserve    *big.Int
		CurrentBalance *big.Int
	})
	if err != nil {
		return *outstruct, err
	}

	outstruct.CanTransfer = *abi.ConvertType(out[0], new(bool)).(*bool)
	outstruct.TransferAmount = *abi.ConvertType(out[1], new(*big.Int)).(**big.Int)
	outstruct.WillReserve = *abi.ConvertType(out[2], new(*big.Int)).(**big.Int)
	outstruct.CurrentBalance = *abi.ConvertType(out[3], new(*big.Int)).(**big.Int)

	return *outstruct, err

}

// CalculateTreasuryTransfer is a free data retrieval call binding the contract method 0x2d3a6f72.
//
// Solidity: function calculateTreasuryTransfer(address token) view returns(bool canTransfer, uint256 transferAmount, uint256 willReserve, uint256 currentBalance)
func (_BridgeContract *BridgeContractSession) CalculateTreasuryTransfer(token common.Address) (struct {
	CanTransfer    bool
	TransferAmount *big.Int
	WillReserve    *big.Int
	CurrentBalance *big.Int
}, error) {
	return _BridgeContract.Contract.CalculateTreasuryTransfer(&_BridgeContract.CallOpts, token)
}

// CalculateTreasuryTransfer is a free data retrieval call binding the contract method 0x2d3a6f72.
//
// Solidity: function calculateTreasuryTransfer(address token) view returns(bool canTransfer, uint256 transferAmount, uint256 willReserve, uint256 currentBalance)
func (_BridgeContract *BridgeContractCallerSession) CalculateTreasuryTransfer(token common.Address) (struct {
	CanTransfer    bool
	TransferAmount *big.Int
	WillReserve    *big.Int
	CurrentBalance *big.Int
}, error) {
	return _BridgeContract.Contract.CalculateTreasuryTransfer(&_BridgeContract.CallOpts, token)
}

// FeeReceiver is a free data retrieval call binding the contract method 0xb3f00674.
//
// Solidity: function feeReceiver() view returns(address)
func (_BridgeContract *BridgeContractCaller) FeeReceiver(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "feeReceiver")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// FeeReceiver is a free data retrieval call binding the contract method 0xb3f00674.
//
// Solidity: function feeReceiver() view returns(address)
func (_BridgeContract *BridgeContractSession) FeeReceiver() (common.Address, error) {
	return _BridgeContract.Contract.FeeReceiver(&_BridgeContract.CallOpts)
}

// FeeReceiver is a free data retrieval call binding the contract method 0xb3f00674.
//
// Solidity: function feeReceiver() view returns(address)
func (_BridgeContract *BridgeContractCallerSession) FeeReceiver() (common.Address, error) {
	return _BridgeContract.Contract.FeeReceiver(&_BridgeContract.CallOpts)
}

// GetInId is a free data retrieval call binding the contract method 0x9f4faadf.
//
// Solidity: function getInId(uint256 , uint256 ) view returns(uint256)
func (_BridgeContract *BridgeContractCaller) GetInId(opts *bind.CallOpts, arg0 *big.Int, arg1 *big.Int) (*big.Int, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "getInId", arg0, arg1)

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// GetInId is a free data retrieval call binding the contract method 0x9f4faadf.
//
// Solidity: function getInId(uint256 , uint256 ) view returns(uint256)
func (_BridgeContract *BridgeContractSession) GetInId(arg0 *big.Int, arg1 *big.Int) (*big.Int, error) {
	return _BridgeContract.Contract.GetInId(&_BridgeContract.CallOpts, arg0, arg1)
}

// GetInId is a free data retrieval call binding the contract method 0x9f4faadf.
//
// Solidity: function getInId(uint256 , uint256 ) view returns(uint256)
func (_BridgeContract *BridgeContractCallerSession) GetInId(arg0 *big.Int, arg1 *big.Int) (*big.Int, error) {
	return _BridgeContract.Contract.GetInId(&_BridgeContract.CallOpts, arg0, arg1)
}

// GetSupportedTokensOut is a free data retrieval call binding the contract method 0x0ff90455.
//
// Solidity: function getSupportedTokensOut(uint256 toChainID) view returns(address[])
func (_BridgeContract *BridgeContractCaller) GetSupportedTokensOut(opts *bind.CallOpts, toChainID *big.Int) ([]common.Address, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "getSupportedTokensOut", toChainID)

	if err != nil {
		return *new([]common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new([]common.Address)).(*[]common.Address)

	return out0, err

}

// GetSupportedTokensOut is a free data retrieval call binding the contract method 0x0ff90455.
//
// Solidity: function getSupportedTokensOut(uint256 toChainID) view returns(address[])
func (_BridgeContract *BridgeContractSession) GetSupportedTokensOut(toChainID *big.Int) ([]common.Address, error) {
	return _BridgeContract.Contract.GetSupportedTokensOut(&_BridgeContract.CallOpts, toChainID)
}

// GetSupportedTokensOut is a free data retrieval call binding the contract method 0x0ff90455.
//
// Solidity: function getSupportedTokensOut(uint256 toChainID) view returns(address[])
func (_BridgeContract *BridgeContractCallerSession) GetSupportedTokensOut(toChainID *big.Int) ([]common.Address, error) {
	return _BridgeContract.Contract.GetSupportedTokensOut(&_BridgeContract.CallOpts, toChainID)
}

// InTotal is a free data retrieval call binding the contract method 0xe3c5d947.
//
// Solidity: function inTotal(address ) view returns(uint256)
func (_BridgeContract *BridgeContractCaller) InTotal(opts *bind.CallOpts, arg0 common.Address) (*big.Int, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "inTotal", arg0)

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// InTotal is a free data retrieval call binding the contract method 0xe3c5d947.
//
// Solidity: function inTotal(address ) view returns(uint256)
func (_BridgeContract *BridgeContractSession) InTotal(arg0 common.Address) (*big.Int, error) {
	return _BridgeContract.Contract.InTotal(&_BridgeContract.CallOpts, arg0)
}

// InTotal is a free data retrieval call binding the contract method 0xe3c5d947.
//
// Solidity: function inTotal(address ) view returns(uint256)
func (_BridgeContract *BridgeContractCallerSession) InTotal(arg0 common.Address) (*big.Int, error) {
	return _BridgeContract.Contract.InTotal(&_BridgeContract.CallOpts, arg0)
}

// InTransfers is a free data retrieval call binding the contract method 0xdcbbb052.
//
// Solidity: function inTransfers(uint256 ) view returns(uint256 inId, address token, address receiver, uint256 fee, uint256 amount, uint256 fromChainID, uint256 outId, bool executed, uint256 confirmCounter, uint256 rejectCounter)
func (_BridgeContract *BridgeContractCaller) InTransfers(opts *bind.CallOpts, arg0 *big.Int) (struct {
	InId           *big.Int
	Token          common.Address
	Receiver       common.Address
	Fee            *big.Int
	Amount         *big.Int
	FromChainID    *big.Int
	OutId          *big.Int
	Executed       bool
	ConfirmCounter *big.Int
	RejectCounter  *big.Int
}, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "inTransfers", arg0)

	outstruct := new(struct {
		InId           *big.Int
		Token          common.Address
		Receiver       common.Address
		Fee            *big.Int
		Amount         *big.Int
		FromChainID    *big.Int
		OutId          *big.Int
		Executed       bool
		ConfirmCounter *big.Int
		RejectCounter  *big.Int
	})
	if err != nil {
		return *outstruct, err
	}

	outstruct.InId = *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)
	outstruct.Token = *abi.ConvertType(out[1], new(common.Address)).(*common.Address)
	outstruct.Receiver = *abi.ConvertType(out[2], new(common.Address)).(*common.Address)
	outstruct.Fee = *abi.ConvertType(out[3], new(*big.Int)).(**big.Int)
	outstruct.Amount = *abi.ConvertType(out[4], new(*big.Int)).(**big.Int)
	outstruct.FromChainID = *abi.ConvertType(out[5], new(*big.Int)).(**big.Int)
	outstruct.OutId = *abi.ConvertType(out[6], new(*big.Int)).(**big.Int)
	outstruct.Executed = *abi.ConvertType(out[7], new(bool)).(*bool)
	outstruct.ConfirmCounter = *abi.ConvertType(out[8], new(*big.Int)).(**big.Int)
	outstruct.RejectCounter = *abi.ConvertType(out[9], new(*big.Int)).(**big.Int)

	return *outstruct, err

}

// InTransfers is a free data retrieval call binding the contract method 0xdcbbb052.
//
// Solidity: function inTransfers(uint256 ) view returns(uint256 inId, address token, address receiver, uint256 fee, uint256 amount, uint256 fromChainID, uint256 outId, bool executed, uint256 confirmCounter, uint256 rejectCounter)
func (_BridgeContract *BridgeContractSession) InTransfers(arg0 *big.Int) (struct {
	InId           *big.Int
	Token          common.Address
	Receiver       common.Address
	Fee            *big.Int
	Amount         *big.Int
	FromChainID    *big.Int
	OutId          *big.Int
	Executed       bool
	ConfirmCounter *big.Int
	RejectCounter  *big.Int
}, error) {
	return _BridgeContract.Contract.InTransfers(&_BridgeContract.CallOpts, arg0)
}

// InTransfers is a free data retrieval call binding the contract method 0xdcbbb052.
//
// Solidity: function inTransfers(uint256 ) view returns(uint256 inId, address token, address receiver, uint256 fee, uint256 amount, uint256 fromChainID, uint256 outId, bool executed, uint256 confirmCounter, uint256 rejectCounter)
func (_BridgeContract *BridgeContractCallerSession) InTransfers(arg0 *big.Int) (struct {
	InId           *big.Int
	Token          common.Address
	Receiver       common.Address
	Fee            *big.Int
	Amount         *big.Int
	FromChainID    *big.Int
	OutId          *big.Int
	Executed       bool
	ConfirmCounter *big.Int
	RejectCounter  *big.Int
}, error) {
	return _BridgeContract.Contract.InTransfers(&_BridgeContract.CallOpts, arg0)
}

// IsChecked is a free data retrieval call binding the contract method 0x1d6f846c.
//
// Solidity: function isChecked(uint256 inId) view returns(bool)
func (_BridgeContract *BridgeContractCaller) IsChecked(opts *bind.CallOpts, inId *big.Int) (bool, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "isChecked", inId)

	if err != nil {
		return *new(bool), err
	}

	out0 := *abi.ConvertType(out[0], new(bool)).(*bool)

	return out0, err

}

// IsChecked is a free data retrieval call binding the contract method 0x1d6f846c.
//
// Solidity: function isChecked(uint256 inId) view returns(bool)
func (_BridgeContract *BridgeContractSession) IsChecked(inId *big.Int) (bool, error) {
	return _BridgeContract.Contract.IsChecked(&_BridgeContract.CallOpts, inId)
}

// IsChecked is a free data retrieval call binding the contract method 0x1d6f846c.
//
// Solidity: function isChecked(uint256 inId) view returns(bool)
func (_BridgeContract *BridgeContractCallerSession) IsChecked(inId *big.Int) (bool, error) {
	return _BridgeContract.Contract.IsChecked(&_BridgeContract.CallOpts, inId)
}

// IsConfirmed is a free data retrieval call binding the contract method 0x80f59a65.
//
// Solidity: function isConfirmed(uint256 inId, address validator) view returns(bool)
func (_BridgeContract *BridgeContractCaller) IsConfirmed(opts *bind.CallOpts, inId *big.Int, validator common.Address) (bool, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "isConfirmed", inId, validator)

	if err != nil {
		return *new(bool), err
	}

	out0 := *abi.ConvertType(out[0], new(bool)).(*bool)

	return out0, err

}

// IsConfirmed is a free data retrieval call binding the contract method 0x80f59a65.
//
// Solidity: function isConfirmed(uint256 inId, address validator) view returns(bool)
func (_BridgeContract *BridgeContractSession) IsConfirmed(inId *big.Int, validator common.Address) (bool, error) {
	return _BridgeContract.Contract.IsConfirmed(&_BridgeContract.CallOpts, inId, validator)
}

// IsConfirmed is a free data retrieval call binding the contract method 0x80f59a65.
//
// Solidity: function isConfirmed(uint256 inId, address validator) view returns(bool)
func (_BridgeContract *BridgeContractCallerSession) IsConfirmed(inId *big.Int, validator common.Address) (bool, error) {
	return _BridgeContract.Contract.IsConfirmed(&_BridgeContract.CallOpts, inId, validator)
}

// IsRejected is a free data retrieval call binding the contract method 0x1d6c0c82.
//
// Solidity: function isRejected(uint256 inId, address validator) view returns(bool)
func (_BridgeContract *BridgeContractCaller) IsRejected(opts *bind.CallOpts, inId *big.Int, validator common.Address) (bool, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "isRejected", inId, validator)

	if err != nil {
		return *new(bool), err
	}

	out0 := *abi.ConvertType(out[0], new(bool)).(*bool)

	return out0, err

}

// IsRejected is a free data retrieval call binding the contract method 0x1d6c0c82.
//
// Solidity: function isRejected(uint256 inId, address validator) view returns(bool)
func (_BridgeContract *BridgeContractSession) IsRejected(inId *big.Int, validator common.Address) (bool, error) {
	return _BridgeContract.Contract.IsRejected(&_BridgeContract.CallOpts, inId, validator)
}

// IsRejected is a free data retrieval call binding the contract method 0x1d6c0c82.
//
// Solidity: function isRejected(uint256 inId, address validator) view returns(bool)
func (_BridgeContract *BridgeContractCallerSession) IsRejected(inId *big.Int, validator common.Address) (bool, error) {
	return _BridgeContract.Contract.IsRejected(&_BridgeContract.CallOpts, inId, validator)
}

// IsTokenSupportedOut is a free data retrieval call binding the contract method 0xa146a803.
//
// Solidity: function isTokenSupportedOut(uint256 , address ) view returns(bool)
func (_BridgeContract *BridgeContractCaller) IsTokenSupportedOut(opts *bind.CallOpts, arg0 *big.Int, arg1 common.Address) (bool, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "isTokenSupportedOut", arg0, arg1)

	if err != nil {
		return *new(bool), err
	}

	out0 := *abi.ConvertType(out[0], new(bool)).(*bool)

	return out0, err

}

// IsTokenSupportedOut is a free data retrieval call binding the contract method 0xa146a803.
//
// Solidity: function isTokenSupportedOut(uint256 , address ) view returns(bool)
func (_BridgeContract *BridgeContractSession) IsTokenSupportedOut(arg0 *big.Int, arg1 common.Address) (bool, error) {
	return _BridgeContract.Contract.IsTokenSupportedOut(&_BridgeContract.CallOpts, arg0, arg1)
}

// IsTokenSupportedOut is a free data retrieval call binding the contract method 0xa146a803.
//
// Solidity: function isTokenSupportedOut(uint256 , address ) view returns(bool)
func (_BridgeContract *BridgeContractCallerSession) IsTokenSupportedOut(arg0 *big.Int, arg1 common.Address) (bool, error) {
	return _BridgeContract.Contract.IsTokenSupportedOut(&_BridgeContract.CallOpts, arg0, arg1)
}

// IsTokenTransferEnabled is a free data retrieval call binding the contract method 0x0af9a61c.
//
// Solidity: function isTokenTransferEnabled(address token, uint256 toChainID) view returns(bool)
func (_BridgeContract *BridgeContractCaller) IsTokenTransferEnabled(opts *bind.CallOpts, token common.Address, toChainID *big.Int) (bool, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "isTokenTransferEnabled", token, toChainID)

	if err != nil {
		return *new(bool), err
	}

	out0 := *abi.ConvertType(out[0], new(bool)).(*bool)

	return out0, err

}

// IsTokenTransferEnabled is a free data retrieval call binding the contract method 0x0af9a61c.
//
// Solidity: function isTokenTransferEnabled(address token, uint256 toChainID) view returns(bool)
func (_BridgeContract *BridgeContractSession) IsTokenTransferEnabled(token common.Address, toChainID *big.Int) (bool, error) {
	return _BridgeContract.Contract.IsTokenTransferEnabled(&_BridgeContract.CallOpts, token, toChainID)
}

// IsTokenTransferEnabled is a free data retrieval call binding the contract method 0x0af9a61c.
//
// Solidity: function isTokenTransferEnabled(address token, uint256 toChainID) view returns(bool)
func (_BridgeContract *BridgeContractCallerSession) IsTokenTransferEnabled(token common.Address, toChainID *big.Int) (bool, error) {
	return _BridgeContract.Contract.IsTokenTransferEnabled(&_BridgeContract.CallOpts, token, toChainID)
}

// IsValidator is a free data retrieval call binding the contract method 0xfacd743b.
//
// Solidity: function isValidator(address ) view returns(bool)
func (_BridgeContract *BridgeContractCaller) IsValidator(opts *bind.CallOpts, arg0 common.Address) (bool, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "isValidator", arg0)

	if err != nil {
		return *new(bool), err
	}

	out0 := *abi.ConvertType(out[0], new(bool)).(*bool)

	return out0, err

}

// IsValidator is a free data retrieval call binding the contract method 0xfacd743b.
//
// Solidity: function isValidator(address ) view returns(bool)
func (_BridgeContract *BridgeContractSession) IsValidator(arg0 common.Address) (bool, error) {
	return _BridgeContract.Contract.IsValidator(&_BridgeContract.CallOpts, arg0)
}

// IsValidator is a free data retrieval call binding the contract method 0xfacd743b.
//
// Solidity: function isValidator(address ) view returns(bool)
func (_BridgeContract *BridgeContractCallerSession) IsValidator(arg0 common.Address) (bool, error) {
	return _BridgeContract.Contract.IsValidator(&_BridgeContract.CallOpts, arg0)
}

// OutConfiguration is a free data retrieval call binding the contract method 0xeef92145.
//
// Solidity: function outConfiguration(address , uint256 ) view returns(address receiveToken, uint256 fee, uint256 limit, bool isBurn, bool enabled)
func (_BridgeContract *BridgeContractCaller) OutConfiguration(opts *bind.CallOpts, arg0 common.Address, arg1 *big.Int) (struct {
	ReceiveToken common.Address
	Fee          *big.Int
	Limit        *big.Int
	IsBurn       bool
	Enabled      bool
}, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "outConfiguration", arg0, arg1)

	outstruct := new(struct {
		ReceiveToken common.Address
		Fee          *big.Int
		Limit        *big.Int
		IsBurn       bool
		Enabled      bool
	})
	if err != nil {
		return *outstruct, err
	}

	outstruct.ReceiveToken = *abi.ConvertType(out[0], new(common.Address)).(*common.Address)
	outstruct.Fee = *abi.ConvertType(out[1], new(*big.Int)).(**big.Int)
	outstruct.Limit = *abi.ConvertType(out[2], new(*big.Int)).(**big.Int)
	outstruct.IsBurn = *abi.ConvertType(out[3], new(bool)).(*bool)
	outstruct.Enabled = *abi.ConvertType(out[4], new(bool)).(*bool)

	return *outstruct, err

}

// OutConfiguration is a free data retrieval call binding the contract method 0xeef92145.
//
// Solidity: function outConfiguration(address , uint256 ) view returns(address receiveToken, uint256 fee, uint256 limit, bool isBurn, bool enabled)
func (_BridgeContract *BridgeContractSession) OutConfiguration(arg0 common.Address, arg1 *big.Int) (struct {
	ReceiveToken common.Address
	Fee          *big.Int
	Limit        *big.Int
	IsBurn       bool
	Enabled      bool
}, error) {
	return _BridgeContract.Contract.OutConfiguration(&_BridgeContract.CallOpts, arg0, arg1)
}

// OutConfiguration is a free data retrieval call binding the contract method 0xeef92145.
//
// Solidity: function outConfiguration(address , uint256 ) view returns(address receiveToken, uint256 fee, uint256 limit, bool isBurn, bool enabled)
func (_BridgeContract *BridgeContractCallerSession) OutConfiguration(arg0 common.Address, arg1 *big.Int) (struct {
	ReceiveToken common.Address
	Fee          *big.Int
	Limit        *big.Int
	IsBurn       bool
	Enabled      bool
}, error) {
	return _BridgeContract.Contract.OutConfiguration(&_BridgeContract.CallOpts, arg0, arg1)
}

// OutTotal is a free data retrieval call binding the contract method 0xdf18226d.
//
// Solidity: function outTotal(address ) view returns(uint256)
func (_BridgeContract *BridgeContractCaller) OutTotal(opts *bind.CallOpts, arg0 common.Address) (*big.Int, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "outTotal", arg0)

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// OutTotal is a free data retrieval call binding the contract method 0xdf18226d.
//
// Solidity: function outTotal(address ) view returns(uint256)
func (_BridgeContract *BridgeContractSession) OutTotal(arg0 common.Address) (*big.Int, error) {
	return _BridgeContract.Contract.OutTotal(&_BridgeContract.CallOpts, arg0)
}

// OutTotal is a free data retrieval call binding the contract method 0xdf18226d.
//
// Solidity: function outTotal(address ) view returns(uint256)
func (_BridgeContract *BridgeContractCallerSession) OutTotal(arg0 common.Address) (*big.Int, error) {
	return _BridgeContract.Contract.OutTotal(&_BridgeContract.CallOpts, arg0)
}

// OutTransfers is a free data retrieval call binding the contract method 0x95b6b9f4.
//
// Solidity: function outTransfers(uint256 ) view returns(uint256 outId, uint256 fromChainID, address sender, address token, uint256 amount, uint256 fee, uint256 toChainID, address receiver, address receiveToken, uint256 receiveAmount, bytes32 signature)
func (_BridgeContract *BridgeContractCaller) OutTransfers(opts *bind.CallOpts, arg0 *big.Int) (struct {
	OutId         *big.Int
	FromChainID   *big.Int
	Sender        common.Address
	Token         common.Address
	Amount        *big.Int
	Fee           *big.Int
	ToChainID     *big.Int
	Receiver      common.Address
	ReceiveToken  common.Address
	ReceiveAmount *big.Int
	Signature     [32]byte
}, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "outTransfers", arg0)

	outstruct := new(struct {
		OutId         *big.Int
		FromChainID   *big.Int
		Sender        common.Address
		Token         common.Address
		Amount        *big.Int
		Fee           *big.Int
		ToChainID     *big.Int
		Receiver      common.Address
		ReceiveToken  common.Address
		ReceiveAmount *big.Int
		Signature     [32]byte
	})
	if err != nil {
		return *outstruct, err
	}

	outstruct.OutId = *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)
	outstruct.FromChainID = *abi.ConvertType(out[1], new(*big.Int)).(**big.Int)
	outstruct.Sender = *abi.ConvertType(out[2], new(common.Address)).(*common.Address)
	outstruct.Token = *abi.ConvertType(out[3], new(common.Address)).(*common.Address)
	outstruct.Amount = *abi.ConvertType(out[4], new(*big.Int)).(**big.Int)
	outstruct.Fee = *abi.ConvertType(out[5], new(*big.Int)).(**big.Int)
	outstruct.ToChainID = *abi.ConvertType(out[6], new(*big.Int)).(**big.Int)
	outstruct.Receiver = *abi.ConvertType(out[7], new(common.Address)).(*common.Address)
	outstruct.ReceiveToken = *abi.ConvertType(out[8], new(common.Address)).(*common.Address)
	outstruct.ReceiveAmount = *abi.ConvertType(out[9], new(*big.Int)).(**big.Int)
	outstruct.Signature = *abi.ConvertType(out[10], new([32]byte)).(*[32]byte)

	return *outstruct, err

}

// OutTransfers is a free data retrieval call binding the contract method 0x95b6b9f4.
//
// Solidity: function outTransfers(uint256 ) view returns(uint256 outId, uint256 fromChainID, address sender, address token, uint256 amount, uint256 fee, uint256 toChainID, address receiver, address receiveToken, uint256 receiveAmount, bytes32 signature)
func (_BridgeContract *BridgeContractSession) OutTransfers(arg0 *big.Int) (struct {
	OutId         *big.Int
	FromChainID   *big.Int
	Sender        common.Address
	Token         common.Address
	Amount        *big.Int
	Fee           *big.Int
	ToChainID     *big.Int
	Receiver      common.Address
	ReceiveToken  common.Address
	ReceiveAmount *big.Int
	Signature     [32]byte
}, error) {
	return _BridgeContract.Contract.OutTransfers(&_BridgeContract.CallOpts, arg0)
}

// OutTransfers is a free data retrieval call binding the contract method 0x95b6b9f4.
//
// Solidity: function outTransfers(uint256 ) view returns(uint256 outId, uint256 fromChainID, address sender, address token, uint256 amount, uint256 fee, uint256 toChainID, address receiver, address receiveToken, uint256 receiveAmount, bytes32 signature)
func (_BridgeContract *BridgeContractCallerSession) OutTransfers(arg0 *big.Int) (struct {
	OutId         *big.Int
	FromChainID   *big.Int
	Sender        common.Address
	Token         common.Address
	Amount        *big.Int
	Fee           *big.Int
	ToChainID     *big.Int
	Receiver      common.Address
	ReceiveToken  common.Address
	ReceiveAmount *big.Int
	Signature     [32]byte
}, error) {
	return _BridgeContract.Contract.OutTransfers(&_BridgeContract.CallOpts, arg0)
}

// Owner is a free data retrieval call binding the contract method 0x8da5cb5b.
//
// Solidity: function owner() view returns(address)
func (_BridgeContract *BridgeContractCaller) Owner(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "owner")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// Owner is a free data retrieval call binding the contract method 0x8da5cb5b.
//
// Solidity: function owner() view returns(address)
func (_BridgeContract *BridgeContractSession) Owner() (common.Address, error) {
	return _BridgeContract.Contract.Owner(&_BridgeContract.CallOpts)
}

// Owner is a free data retrieval call binding the contract method 0x8da5cb5b.
//
// Solidity: function owner() view returns(address)
func (_BridgeContract *BridgeContractCallerSession) Owner() (common.Address, error) {
	return _BridgeContract.Contract.Owner(&_BridgeContract.CallOpts)
}

// ProxiableUUID is a free data retrieval call binding the contract method 0x52d1902d.
//
// Solidity: function proxiableUUID() view returns(bytes32)
func (_BridgeContract *BridgeContractCaller) ProxiableUUID(opts *bind.CallOpts) ([32]byte, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "proxiableUUID")

	if err != nil {
		return *new([32]byte), err
	}

	out0 := *abi.ConvertType(out[0], new([32]byte)).(*[32]byte)

	return out0, err

}

// ProxiableUUID is a free data retrieval call binding the contract method 0x52d1902d.
//
// Solidity: function proxiableUUID() view returns(bytes32)
func (_BridgeContract *BridgeContractSession) ProxiableUUID() ([32]byte, error) {
	return _BridgeContract.Contract.ProxiableUUID(&_BridgeContract.CallOpts)
}

// ProxiableUUID is a free data retrieval call binding the contract method 0x52d1902d.
//
// Solidity: function proxiableUUID() view returns(bytes32)
func (_BridgeContract *BridgeContractCallerSession) ProxiableUUID() ([32]byte, error) {
	return _BridgeContract.Contract.ProxiableUUID(&_BridgeContract.CallOpts)
}

// SupportedTokensOut is a free data retrieval call binding the contract method 0xfee324de.
//
// Solidity: function supportedTokensOut(uint256 , uint256 ) view returns(address)
func (_BridgeContract *BridgeContractCaller) SupportedTokensOut(opts *bind.CallOpts, arg0 *big.Int, arg1 *big.Int) (common.Address, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "supportedTokensOut", arg0, arg1)

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// SupportedTokensOut is a free data retrieval call binding the contract method 0xfee324de.
//
// Solidity: function supportedTokensOut(uint256 , uint256 ) view returns(address)
func (_BridgeContract *BridgeContractSession) SupportedTokensOut(arg0 *big.Int, arg1 *big.Int) (common.Address, error) {
	return _BridgeContract.Contract.SupportedTokensOut(&_BridgeContract.CallOpts, arg0, arg1)
}

// SupportedTokensOut is a free data retrieval call binding the contract method 0xfee324de.
//
// Solidity: function supportedTokensOut(uint256 , uint256 ) view returns(address)
func (_BridgeContract *BridgeContractCallerSession) SupportedTokensOut(arg0 *big.Int, arg1 *big.Int) (common.Address, error) {
	return _BridgeContract.Contract.SupportedTokensOut(&_BridgeContract.CallOpts, arg0, arg1)
}

// Treasury is a free data retrieval call binding the contract method 0x61d027b3.
//
// Solidity: function treasury() view returns(address)
func (_BridgeContract *BridgeContractCaller) Treasury(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "treasury")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// Treasury is a free data retrieval call binding the contract method 0x61d027b3.
//
// Solidity: function treasury() view returns(address)
func (_BridgeContract *BridgeContractSession) Treasury() (common.Address, error) {
	return _BridgeContract.Contract.Treasury(&_BridgeContract.CallOpts)
}

// Treasury is a free data retrieval call binding the contract method 0x61d027b3.
//
// Solidity: function treasury() view returns(address)
func (_BridgeContract *BridgeContractCallerSession) Treasury() (common.Address, error) {
	return _BridgeContract.Contract.Treasury(&_BridgeContract.CallOpts)
}

// TreasuryConfigs is a free data retrieval call binding the contract method 0x97e6d405.
//
// Solidity: function treasuryConfigs(address ) view returns(uint256 minReserve, uint256 reserveRatio, bool enabled)
func (_BridgeContract *BridgeContractCaller) TreasuryConfigs(opts *bind.CallOpts, arg0 common.Address) (struct {
	MinReserve   *big.Int
	ReserveRatio *big.Int
	Enabled      bool
}, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "treasuryConfigs", arg0)

	outstruct := new(struct {
		MinReserve   *big.Int
		ReserveRatio *big.Int
		Enabled      bool
	})
	if err != nil {
		return *outstruct, err
	}

	outstruct.MinReserve = *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)
	outstruct.ReserveRatio = *abi.ConvertType(out[1], new(*big.Int)).(**big.Int)
	outstruct.Enabled = *abi.ConvertType(out[2], new(bool)).(*bool)

	return *outstruct, err

}

// TreasuryConfigs is a free data retrieval call binding the contract method 0x97e6d405.
//
// Solidity: function treasuryConfigs(address ) view returns(uint256 minReserve, uint256 reserveRatio, bool enabled)
func (_BridgeContract *BridgeContractSession) TreasuryConfigs(arg0 common.Address) (struct {
	MinReserve   *big.Int
	ReserveRatio *big.Int
	Enabled      bool
}, error) {
	return _BridgeContract.Contract.TreasuryConfigs(&_BridgeContract.CallOpts, arg0)
}

// TreasuryConfigs is a free data retrieval call binding the contract method 0x97e6d405.
//
// Solidity: function treasuryConfigs(address ) view returns(uint256 minReserve, uint256 reserveRatio, bool enabled)
func (_BridgeContract *BridgeContractCallerSession) TreasuryConfigs(arg0 common.Address) (struct {
	MinReserve   *big.Int
	ReserveRatio *big.Int
	Enabled      bool
}, error) {
	return _BridgeContract.Contract.TreasuryConfigs(&_BridgeContract.CallOpts, arg0)
}

// TreasuryTotal is a free data retrieval call binding the contract method 0x410c1861.
//
// Solidity: function treasuryTotal(address ) view returns(uint256)
func (_BridgeContract *BridgeContractCaller) TreasuryTotal(opts *bind.CallOpts, arg0 common.Address) (*big.Int, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "treasuryTotal", arg0)

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// TreasuryTotal is a free data retrieval call binding the contract method 0x410c1861.
//
// Solidity: function treasuryTotal(address ) view returns(uint256)
func (_BridgeContract *BridgeContractSession) TreasuryTotal(arg0 common.Address) (*big.Int, error) {
	return _BridgeContract.Contract.TreasuryTotal(&_BridgeContract.CallOpts, arg0)
}

// TreasuryTotal is a free data retrieval call binding the contract method 0x410c1861.
//
// Solidity: function treasuryTotal(address ) view returns(uint256)
func (_BridgeContract *BridgeContractCallerSession) TreasuryTotal(arg0 common.Address) (*big.Int, error) {
	return _BridgeContract.Contract.TreasuryTotal(&_BridgeContract.CallOpts, arg0)
}

// ValidRequired is a free data retrieval call binding the contract method 0xb2491786.
//
// Solidity: function validRequired() view returns(uint256)
func (_BridgeContract *BridgeContractCaller) ValidRequired(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _BridgeContract.contract.Call(opts, &out, "validRequired")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// ValidRequired is a free data retrieval call binding the contract method 0xb2491786.
//
// Solidity: function validRequired() view returns(uint256)
func (_BridgeContract *BridgeContractSession) ValidRequired() (*big.Int, error) {
	return _BridgeContract.Contract.ValidRequired(&_BridgeContract.CallOpts)
}

// ValidRequired is a free data retrieval call binding the contract method 0xb2491786.
//
// Solidity: function validRequired() view returns(uint256)
func (_BridgeContract *BridgeContractCallerSession) ValidRequired() (*big.Int, error) {
	return _BridgeContract.Contract.ValidRequired(&_BridgeContract.CallOpts)
}

// AddValidator is a paid mutator transaction binding the contract method 0x4d238c8e.
//
// Solidity: function addValidator(address validator) returns()
func (_BridgeContract *BridgeContractTransactor) AddValidator(opts *bind.TransactOpts, validator common.Address) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "addValidator", validator)
}

// AddValidator is a paid mutator transaction binding the contract method 0x4d238c8e.
//
// Solidity: function addValidator(address validator) returns()
func (_BridgeContract *BridgeContractSession) AddValidator(validator common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.AddValidator(&_BridgeContract.TransactOpts, validator)
}

// AddValidator is a paid mutator transaction binding the contract method 0x4d238c8e.
//
// Solidity: function addValidator(address validator) returns()
func (_BridgeContract *BridgeContractTransactorSession) AddValidator(validator common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.AddValidator(&_BridgeContract.TransactOpts, validator)
}

// AutoTransferToTreasury is a paid mutator transaction binding the contract method 0xe75a381b.
//
// Solidity: function autoTransferToTreasury(address token) returns()
func (_BridgeContract *BridgeContractTransactor) AutoTransferToTreasury(opts *bind.TransactOpts, token common.Address) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "autoTransferToTreasury", token)
}

// AutoTransferToTreasury is a paid mutator transaction binding the contract method 0xe75a381b.
//
// Solidity: function autoTransferToTreasury(address token) returns()
func (_BridgeContract *BridgeContractSession) AutoTransferToTreasury(token common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.AutoTransferToTreasury(&_BridgeContract.TransactOpts, token)
}

// AutoTransferToTreasury is a paid mutator transaction binding the contract method 0xe75a381b.
//
// Solidity: function autoTransferToTreasury(address token) returns()
func (_BridgeContract *BridgeContractTransactorSession) AutoTransferToTreasury(token common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.AutoTransferToTreasury(&_BridgeContract.TransactOpts, token)
}

// ChangeOutConfig is a paid mutator transaction binding the contract method 0x4901c4b8.
//
// Solidity: function changeOutConfig(address token, uint256 toChainID, (address,uint256,uint256,bool,bool) config) returns()
func (_BridgeContract *BridgeContractTransactor) ChangeOutConfig(opts *bind.TransactOpts, token common.Address, toChainID *big.Int, config BridgeOutConfig) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "changeOutConfig", token, toChainID, config)
}

// ChangeOutConfig is a paid mutator transaction binding the contract method 0x4901c4b8.
//
// Solidity: function changeOutConfig(address token, uint256 toChainID, (address,uint256,uint256,bool,bool) config) returns()
func (_BridgeContract *BridgeContractSession) ChangeOutConfig(token common.Address, toChainID *big.Int, config BridgeOutConfig) (*types.Transaction, error) {
	return _BridgeContract.Contract.ChangeOutConfig(&_BridgeContract.TransactOpts, token, toChainID, config)
}

// ChangeOutConfig is a paid mutator transaction binding the contract method 0x4901c4b8.
//
// Solidity: function changeOutConfig(address token, uint256 toChainID, (address,uint256,uint256,bool,bool) config) returns()
func (_BridgeContract *BridgeContractTransactorSession) ChangeOutConfig(token common.Address, toChainID *big.Int, config BridgeOutConfig) (*types.Transaction, error) {
	return _BridgeContract.Contract.ChangeOutConfig(&_BridgeContract.TransactOpts, token, toChainID, config)
}

// ChangeValidRequired is a paid mutator transaction binding the contract method 0x093bb31f.
//
// Solidity: function changeValidRequired(uint256 required) returns()
func (_BridgeContract *BridgeContractTransactor) ChangeValidRequired(opts *bind.TransactOpts, required *big.Int) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "changeValidRequired", required)
}

// ChangeValidRequired is a paid mutator transaction binding the contract method 0x093bb31f.
//
// Solidity: function changeValidRequired(uint256 required) returns()
func (_BridgeContract *BridgeContractSession) ChangeValidRequired(required *big.Int) (*types.Transaction, error) {
	return _BridgeContract.Contract.ChangeValidRequired(&_BridgeContract.TransactOpts, required)
}

// ChangeValidRequired is a paid mutator transaction binding the contract method 0x093bb31f.
//
// Solidity: function changeValidRequired(uint256 required) returns()
func (_BridgeContract *BridgeContractTransactorSession) ChangeValidRequired(required *big.Int) (*types.Transaction, error) {
	return _BridgeContract.Contract.ChangeValidRequired(&_BridgeContract.TransactOpts, required)
}

// ConfirmInTransfer is a paid mutator transaction binding the contract method 0xb7746905.
//
// Solidity: function confirmInTransfer(uint256 inId) returns()
func (_BridgeContract *BridgeContractTransactor) ConfirmInTransfer(opts *bind.TransactOpts, inId *big.Int) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "confirmInTransfer", inId)
}

// ConfirmInTransfer is a paid mutator transaction binding the contract method 0xb7746905.
//
// Solidity: function confirmInTransfer(uint256 inId) returns()
func (_BridgeContract *BridgeContractSession) ConfirmInTransfer(inId *big.Int) (*types.Transaction, error) {
	return _BridgeContract.Contract.ConfirmInTransfer(&_BridgeContract.TransactOpts, inId)
}

// ConfirmInTransfer is a paid mutator transaction binding the contract method 0xb7746905.
//
// Solidity: function confirmInTransfer(uint256 inId) returns()
func (_BridgeContract *BridgeContractTransactorSession) ConfirmInTransfer(inId *big.Int) (*types.Transaction, error) {
	return _BridgeContract.Contract.ConfirmInTransfer(&_BridgeContract.TransactOpts, inId)
}

// EmergencyWithdraw is a paid mutator transaction binding the contract method 0x551512de.
//
// Solidity: function emergencyWithdraw(address token, uint256 amount, address to) returns()
func (_BridgeContract *BridgeContractTransactor) EmergencyWithdraw(opts *bind.TransactOpts, token common.Address, amount *big.Int, to common.Address) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "emergencyWithdraw", token, amount, to)
}

// EmergencyWithdraw is a paid mutator transaction binding the contract method 0x551512de.
//
// Solidity: function emergencyWithdraw(address token, uint256 amount, address to) returns()
func (_BridgeContract *BridgeContractSession) EmergencyWithdraw(token common.Address, amount *big.Int, to common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.EmergencyWithdraw(&_BridgeContract.TransactOpts, token, amount, to)
}

// EmergencyWithdraw is a paid mutator transaction binding the contract method 0x551512de.
//
// Solidity: function emergencyWithdraw(address token, uint256 amount, address to) returns()
func (_BridgeContract *BridgeContractTransactorSession) EmergencyWithdraw(token common.Address, amount *big.Int, to common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.EmergencyWithdraw(&_BridgeContract.TransactOpts, token, amount, to)
}

// Initialize is a paid mutator transaction binding the contract method 0xc4d66de8.
//
// Solidity: function initialize(address initialOwner) returns()
func (_BridgeContract *BridgeContractTransactor) Initialize(opts *bind.TransactOpts, initialOwner common.Address) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "initialize", initialOwner)
}

// Initialize is a paid mutator transaction binding the contract method 0xc4d66de8.
//
// Solidity: function initialize(address initialOwner) returns()
func (_BridgeContract *BridgeContractSession) Initialize(initialOwner common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.Initialize(&_BridgeContract.TransactOpts, initialOwner)
}

// Initialize is a paid mutator transaction binding the contract method 0xc4d66de8.
//
// Solidity: function initialize(address initialOwner) returns()
func (_BridgeContract *BridgeContractTransactorSession) Initialize(initialOwner common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.Initialize(&_BridgeContract.TransactOpts, initialOwner)
}

// OutTransfer is a paid mutator transaction binding the contract method 0xb2351737.
//
// Solidity: function outTransfer(address token, uint256 amount, uint256 toChainID, address receiver) returns()
func (_BridgeContract *BridgeContractTransactor) OutTransfer(opts *bind.TransactOpts, token common.Address, amount *big.Int, toChainID *big.Int, receiver common.Address) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "outTransfer", token, amount, toChainID, receiver)
}

// OutTransfer is a paid mutator transaction binding the contract method 0xb2351737.
//
// Solidity: function outTransfer(address token, uint256 amount, uint256 toChainID, address receiver) returns()
func (_BridgeContract *BridgeContractSession) OutTransfer(token common.Address, amount *big.Int, toChainID *big.Int, receiver common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.OutTransfer(&_BridgeContract.TransactOpts, token, amount, toChainID, receiver)
}

// OutTransfer is a paid mutator transaction binding the contract method 0xb2351737.
//
// Solidity: function outTransfer(address token, uint256 amount, uint256 toChainID, address receiver) returns()
func (_BridgeContract *BridgeContractTransactorSession) OutTransfer(token common.Address, amount *big.Int, toChainID *big.Int, receiver common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.OutTransfer(&_BridgeContract.TransactOpts, token, amount, toChainID, receiver)
}

// OutTransferSwap is a paid mutator transaction binding the contract method 0x433ba133.
//
// Solidity: function outTransferSwap(address token, uint256 amount, uint256 toChainID, address receiver, address fromToken, address toToken) returns()
func (_BridgeContract *BridgeContractTransactor) OutTransferSwap(opts *bind.TransactOpts, token common.Address, amount *big.Int, toChainID *big.Int, receiver common.Address, fromToken common.Address, toToken common.Address) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "outTransferSwap", token, amount, toChainID, receiver, fromToken, toToken)
}

// OutTransferSwap is a paid mutator transaction binding the contract method 0x433ba133.
//
// Solidity: function outTransferSwap(address token, uint256 amount, uint256 toChainID, address receiver, address fromToken, address toToken) returns()
func (_BridgeContract *BridgeContractSession) OutTransferSwap(token common.Address, amount *big.Int, toChainID *big.Int, receiver common.Address, fromToken common.Address, toToken common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.OutTransferSwap(&_BridgeContract.TransactOpts, token, amount, toChainID, receiver, fromToken, toToken)
}

// OutTransferSwap is a paid mutator transaction binding the contract method 0x433ba133.
//
// Solidity: function outTransferSwap(address token, uint256 amount, uint256 toChainID, address receiver, address fromToken, address toToken) returns()
func (_BridgeContract *BridgeContractTransactorSession) OutTransferSwap(token common.Address, amount *big.Int, toChainID *big.Int, receiver common.Address, fromToken common.Address, toToken common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.OutTransferSwap(&_BridgeContract.TransactOpts, token, amount, toChainID, receiver, fromToken, toToken)
}

// RejectInTransfer is a paid mutator transaction binding the contract method 0x9004e82d.
//
// Solidity: function rejectInTransfer(uint256 inId) returns()
func (_BridgeContract *BridgeContractTransactor) RejectInTransfer(opts *bind.TransactOpts, inId *big.Int) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "rejectInTransfer", inId)
}

// RejectInTransfer is a paid mutator transaction binding the contract method 0x9004e82d.
//
// Solidity: function rejectInTransfer(uint256 inId) returns()
func (_BridgeContract *BridgeContractSession) RejectInTransfer(inId *big.Int) (*types.Transaction, error) {
	return _BridgeContract.Contract.RejectInTransfer(&_BridgeContract.TransactOpts, inId)
}

// RejectInTransfer is a paid mutator transaction binding the contract method 0x9004e82d.
//
// Solidity: function rejectInTransfer(uint256 inId) returns()
func (_BridgeContract *BridgeContractTransactorSession) RejectInTransfer(inId *big.Int) (*types.Transaction, error) {
	return _BridgeContract.Contract.RejectInTransfer(&_BridgeContract.TransactOpts, inId)
}

// RemoveValidator is a paid mutator transaction binding the contract method 0x40a141ff.
//
// Solidity: function removeValidator(address validator) returns()
func (_BridgeContract *BridgeContractTransactor) RemoveValidator(opts *bind.TransactOpts, validator common.Address) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "removeValidator", validator)
}

// RemoveValidator is a paid mutator transaction binding the contract method 0x40a141ff.
//
// Solidity: function removeValidator(address validator) returns()
func (_BridgeContract *BridgeContractSession) RemoveValidator(validator common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.RemoveValidator(&_BridgeContract.TransactOpts, validator)
}

// RemoveValidator is a paid mutator transaction binding the contract method 0x40a141ff.
//
// Solidity: function removeValidator(address validator) returns()
func (_BridgeContract *BridgeContractTransactorSession) RemoveValidator(validator common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.RemoveValidator(&_BridgeContract.TransactOpts, validator)
}

// RenounceOwnership is a paid mutator transaction binding the contract method 0x715018a6.
//
// Solidity: function renounceOwnership() returns()
func (_BridgeContract *BridgeContractTransactor) RenounceOwnership(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "renounceOwnership")
}

// RenounceOwnership is a paid mutator transaction binding the contract method 0x715018a6.
//
// Solidity: function renounceOwnership() returns()
func (_BridgeContract *BridgeContractSession) RenounceOwnership() (*types.Transaction, error) {
	return _BridgeContract.Contract.RenounceOwnership(&_BridgeContract.TransactOpts)
}

// RenounceOwnership is a paid mutator transaction binding the contract method 0x715018a6.
//
// Solidity: function renounceOwnership() returns()
func (_BridgeContract *BridgeContractTransactorSession) RenounceOwnership() (*types.Transaction, error) {
	return _BridgeContract.Contract.RenounceOwnership(&_BridgeContract.TransactOpts)
}

// ReplaceValidator is a paid mutator transaction binding the contract method 0x53149d72.
//
// Solidity: function replaceValidator(address validator, address newValidator) returns()
func (_BridgeContract *BridgeContractTransactor) ReplaceValidator(opts *bind.TransactOpts, validator common.Address, newValidator common.Address) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "replaceValidator", validator, newValidator)
}

// ReplaceValidator is a paid mutator transaction binding the contract method 0x53149d72.
//
// Solidity: function replaceValidator(address validator, address newValidator) returns()
func (_BridgeContract *BridgeContractSession) ReplaceValidator(validator common.Address, newValidator common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.ReplaceValidator(&_BridgeContract.TransactOpts, validator, newValidator)
}

// ReplaceValidator is a paid mutator transaction binding the contract method 0x53149d72.
//
// Solidity: function replaceValidator(address validator, address newValidator) returns()
func (_BridgeContract *BridgeContractTransactorSession) ReplaceValidator(validator common.Address, newValidator common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.ReplaceValidator(&_BridgeContract.TransactOpts, validator, newValidator)
}

// RetryTransfer is a paid mutator transaction binding the contract method 0x5f323ec2.
//
// Solidity: function retryTransfer(uint256 inId, address receiver, address token, uint256 amount) returns()
func (_BridgeContract *BridgeContractTransactor) RetryTransfer(opts *bind.TransactOpts, inId *big.Int, receiver common.Address, token common.Address, amount *big.Int) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "retryTransfer", inId, receiver, token, amount)
}

// RetryTransfer is a paid mutator transaction binding the contract method 0x5f323ec2.
//
// Solidity: function retryTransfer(uint256 inId, address receiver, address token, uint256 amount) returns()
func (_BridgeContract *BridgeContractSession) RetryTransfer(inId *big.Int, receiver common.Address, token common.Address, amount *big.Int) (*types.Transaction, error) {
	return _BridgeContract.Contract.RetryTransfer(&_BridgeContract.TransactOpts, inId, receiver, token, amount)
}

// RetryTransfer is a paid mutator transaction binding the contract method 0x5f323ec2.
//
// Solidity: function retryTransfer(uint256 inId, address receiver, address token, uint256 amount) returns()
func (_BridgeContract *BridgeContractTransactorSession) RetryTransfer(inId *big.Int, receiver common.Address, token common.Address, amount *big.Int) (*types.Transaction, error) {
	return _BridgeContract.Contract.RetryTransfer(&_BridgeContract.TransactOpts, inId, receiver, token, amount)
}

// SetFeeReceiver is a paid mutator transaction binding the contract method 0xefdcd974.
//
// Solidity: function setFeeReceiver(address newReceiver) returns()
func (_BridgeContract *BridgeContractTransactor) SetFeeReceiver(opts *bind.TransactOpts, newReceiver common.Address) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "setFeeReceiver", newReceiver)
}

// SetFeeReceiver is a paid mutator transaction binding the contract method 0xefdcd974.
//
// Solidity: function setFeeReceiver(address newReceiver) returns()
func (_BridgeContract *BridgeContractSession) SetFeeReceiver(newReceiver common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.SetFeeReceiver(&_BridgeContract.TransactOpts, newReceiver)
}

// SetFeeReceiver is a paid mutator transaction binding the contract method 0xefdcd974.
//
// Solidity: function setFeeReceiver(address newReceiver) returns()
func (_BridgeContract *BridgeContractTransactorSession) SetFeeReceiver(newReceiver common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.SetFeeReceiver(&_BridgeContract.TransactOpts, newReceiver)
}

// SetTreasury is a paid mutator transaction binding the contract method 0xf0f44260.
//
// Solidity: function setTreasury(address newTreasury) returns()
func (_BridgeContract *BridgeContractTransactor) SetTreasury(opts *bind.TransactOpts, newTreasury common.Address) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "setTreasury", newTreasury)
}

// SetTreasury is a paid mutator transaction binding the contract method 0xf0f44260.
//
// Solidity: function setTreasury(address newTreasury) returns()
func (_BridgeContract *BridgeContractSession) SetTreasury(newTreasury common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.SetTreasury(&_BridgeContract.TransactOpts, newTreasury)
}

// SetTreasury is a paid mutator transaction binding the contract method 0xf0f44260.
//
// Solidity: function setTreasury(address newTreasury) returns()
func (_BridgeContract *BridgeContractTransactorSession) SetTreasury(newTreasury common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.SetTreasury(&_BridgeContract.TransactOpts, newTreasury)
}

// SetTreasuryConfig is a paid mutator transaction binding the contract method 0x71087b69.
//
// Solidity: function setTreasuryConfig(address token, uint256 minReserve, uint256 reserveRatio, bool enabled) returns()
func (_BridgeContract *BridgeContractTransactor) SetTreasuryConfig(opts *bind.TransactOpts, token common.Address, minReserve *big.Int, reserveRatio *big.Int, enabled bool) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "setTreasuryConfig", token, minReserve, reserveRatio, enabled)
}

// SetTreasuryConfig is a paid mutator transaction binding the contract method 0x71087b69.
//
// Solidity: function setTreasuryConfig(address token, uint256 minReserve, uint256 reserveRatio, bool enabled) returns()
func (_BridgeContract *BridgeContractSession) SetTreasuryConfig(token common.Address, minReserve *big.Int, reserveRatio *big.Int, enabled bool) (*types.Transaction, error) {
	return _BridgeContract.Contract.SetTreasuryConfig(&_BridgeContract.TransactOpts, token, minReserve, reserveRatio, enabled)
}

// SetTreasuryConfig is a paid mutator transaction binding the contract method 0x71087b69.
//
// Solidity: function setTreasuryConfig(address token, uint256 minReserve, uint256 reserveRatio, bool enabled) returns()
func (_BridgeContract *BridgeContractTransactorSession) SetTreasuryConfig(token common.Address, minReserve *big.Int, reserveRatio *big.Int, enabled bool) (*types.Transaction, error) {
	return _BridgeContract.Contract.SetTreasuryConfig(&_BridgeContract.TransactOpts, token, minReserve, reserveRatio, enabled)
}

// SubmitInTransfer is a paid mutator transaction binding the contract method 0x4833f3d1.
//
// Solidity: function submitInTransfer((uint256,address,address,uint256,uint256,uint256,address,address,uint256,bytes32) params) returns()
func (_BridgeContract *BridgeContractTransactor) SubmitInTransfer(opts *bind.TransactOpts, params BridgesubmitParams) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "submitInTransfer", params)
}

// SubmitInTransfer is a paid mutator transaction binding the contract method 0x4833f3d1.
//
// Solidity: function submitInTransfer((uint256,address,address,uint256,uint256,uint256,address,address,uint256,bytes32) params) returns()
func (_BridgeContract *BridgeContractSession) SubmitInTransfer(params BridgesubmitParams) (*types.Transaction, error) {
	return _BridgeContract.Contract.SubmitInTransfer(&_BridgeContract.TransactOpts, params)
}

// SubmitInTransfer is a paid mutator transaction binding the contract method 0x4833f3d1.
//
// Solidity: function submitInTransfer((uint256,address,address,uint256,uint256,uint256,address,address,uint256,bytes32) params) returns()
func (_BridgeContract *BridgeContractTransactorSession) SubmitInTransfer(params BridgesubmitParams) (*types.Transaction, error) {
	return _BridgeContract.Contract.SubmitInTransfer(&_BridgeContract.TransactOpts, params)
}

// TransferOwnership is a paid mutator transaction binding the contract method 0xf2fde38b.
//
// Solidity: function transferOwnership(address newOwner) returns()
func (_BridgeContract *BridgeContractTransactor) TransferOwnership(opts *bind.TransactOpts, newOwner common.Address) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "transferOwnership", newOwner)
}

// TransferOwnership is a paid mutator transaction binding the contract method 0xf2fde38b.
//
// Solidity: function transferOwnership(address newOwner) returns()
func (_BridgeContract *BridgeContractSession) TransferOwnership(newOwner common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.TransferOwnership(&_BridgeContract.TransactOpts, newOwner)
}

// TransferOwnership is a paid mutator transaction binding the contract method 0xf2fde38b.
//
// Solidity: function transferOwnership(address newOwner) returns()
func (_BridgeContract *BridgeContractTransactorSession) TransferOwnership(newOwner common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.TransferOwnership(&_BridgeContract.TransactOpts, newOwner)
}

// UpgradeTo is a paid mutator transaction binding the contract method 0x3659cfe6.
//
// Solidity: function upgradeTo(address newImplementation) returns()
func (_BridgeContract *BridgeContractTransactor) UpgradeTo(opts *bind.TransactOpts, newImplementation common.Address) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "upgradeTo", newImplementation)
}

// UpgradeTo is a paid mutator transaction binding the contract method 0x3659cfe6.
//
// Solidity: function upgradeTo(address newImplementation) returns()
func (_BridgeContract *BridgeContractSession) UpgradeTo(newImplementation common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.UpgradeTo(&_BridgeContract.TransactOpts, newImplementation)
}

// UpgradeTo is a paid mutator transaction binding the contract method 0x3659cfe6.
//
// Solidity: function upgradeTo(address newImplementation) returns()
func (_BridgeContract *BridgeContractTransactorSession) UpgradeTo(newImplementation common.Address) (*types.Transaction, error) {
	return _BridgeContract.Contract.UpgradeTo(&_BridgeContract.TransactOpts, newImplementation)
}

// UpgradeToAndCall is a paid mutator transaction binding the contract method 0x4f1ef286.
//
// Solidity: function upgradeToAndCall(address newImplementation, bytes data) payable returns()
func (_BridgeContract *BridgeContractTransactor) UpgradeToAndCall(opts *bind.TransactOpts, newImplementation common.Address, data []byte) (*types.Transaction, error) {
	return _BridgeContract.contract.Transact(opts, "upgradeToAndCall", newImplementation, data)
}

// UpgradeToAndCall is a paid mutator transaction binding the contract method 0x4f1ef286.
//
// Solidity: function upgradeToAndCall(address newImplementation, bytes data) payable returns()
func (_BridgeContract *BridgeContractSession) UpgradeToAndCall(newImplementation common.Address, data []byte) (*types.Transaction, error) {
	return _BridgeContract.Contract.UpgradeToAndCall(&_BridgeContract.TransactOpts, newImplementation, data)
}

// UpgradeToAndCall is a paid mutator transaction binding the contract method 0x4f1ef286.
//
// Solidity: function upgradeToAndCall(address newImplementation, bytes data) payable returns()
func (_BridgeContract *BridgeContractTransactorSession) UpgradeToAndCall(newImplementation common.Address, data []byte) (*types.Transaction, error) {
	return _BridgeContract.Contract.UpgradeToAndCall(&_BridgeContract.TransactOpts, newImplementation, data)
}

// BridgeContractAdminChangedIterator is returned from FilterAdminChanged and is used to iterate over the raw logs and unpacked data for AdminChanged events raised by the BridgeContract contract.
type BridgeContractAdminChangedIterator struct {
	Event *BridgeContractAdminChanged // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractAdminChangedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractAdminChanged)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractAdminChanged)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractAdminChangedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractAdminChangedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractAdminChanged represents a AdminChanged event raised by the BridgeContract contract.
type BridgeContractAdminChanged struct {
	PreviousAdmin common.Address
	NewAdmin      common.Address
	Raw           types.Log // Blockchain specific contextual infos
}

// FilterAdminChanged is a free log retrieval operation binding the contract event 0x7e644d79422f17c01e4894b5f4f588d331ebfa28653d42ae832dc59e38c9798f.
//
// Solidity: event AdminChanged(address previousAdmin, address newAdmin)
func (_BridgeContract *BridgeContractFilterer) FilterAdminChanged(opts *bind.FilterOpts) (*BridgeContractAdminChangedIterator, error) {

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "AdminChanged")
	if err != nil {
		return nil, err
	}
	return &BridgeContractAdminChangedIterator{contract: _BridgeContract.contract, event: "AdminChanged", logs: logs, sub: sub}, nil
}

// WatchAdminChanged is a free log subscription operation binding the contract event 0x7e644d79422f17c01e4894b5f4f588d331ebfa28653d42ae832dc59e38c9798f.
//
// Solidity: event AdminChanged(address previousAdmin, address newAdmin)
func (_BridgeContract *BridgeContractFilterer) WatchAdminChanged(opts *bind.WatchOpts, sink chan<- *BridgeContractAdminChanged) (event.Subscription, error) {

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "AdminChanged")
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractAdminChanged)
				if err := _BridgeContract.contract.UnpackLog(event, "AdminChanged", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseAdminChanged is a log parse operation binding the contract event 0x7e644d79422f17c01e4894b5f4f588d331ebfa28653d42ae832dc59e38c9798f.
//
// Solidity: event AdminChanged(address previousAdmin, address newAdmin)
func (_BridgeContract *BridgeContractFilterer) ParseAdminChanged(log types.Log) (*BridgeContractAdminChanged, error) {
	event := new(BridgeContractAdminChanged)
	if err := _BridgeContract.contract.UnpackLog(event, "AdminChanged", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// BridgeContractBeaconUpgradedIterator is returned from FilterBeaconUpgraded and is used to iterate over the raw logs and unpacked data for BeaconUpgraded events raised by the BridgeContract contract.
type BridgeContractBeaconUpgradedIterator struct {
	Event *BridgeContractBeaconUpgraded // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractBeaconUpgradedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractBeaconUpgraded)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractBeaconUpgraded)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractBeaconUpgradedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractBeaconUpgradedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractBeaconUpgraded represents a BeaconUpgraded event raised by the BridgeContract contract.
type BridgeContractBeaconUpgraded struct {
	Beacon common.Address
	Raw    types.Log // Blockchain specific contextual infos
}

// FilterBeaconUpgraded is a free log retrieval operation binding the contract event 0x1cf3b03a6cf19fa2baba4df148e9dcabedea7f8a5c07840e207e5c089be95d3e.
//
// Solidity: event BeaconUpgraded(address indexed beacon)
func (_BridgeContract *BridgeContractFilterer) FilterBeaconUpgraded(opts *bind.FilterOpts, beacon []common.Address) (*BridgeContractBeaconUpgradedIterator, error) {

	var beaconRule []interface{}
	for _, beaconItem := range beacon {
		beaconRule = append(beaconRule, beaconItem)
	}

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "BeaconUpgraded", beaconRule)
	if err != nil {
		return nil, err
	}
	return &BridgeContractBeaconUpgradedIterator{contract: _BridgeContract.contract, event: "BeaconUpgraded", logs: logs, sub: sub}, nil
}

// WatchBeaconUpgraded is a free log subscription operation binding the contract event 0x1cf3b03a6cf19fa2baba4df148e9dcabedea7f8a5c07840e207e5c089be95d3e.
//
// Solidity: event BeaconUpgraded(address indexed beacon)
func (_BridgeContract *BridgeContractFilterer) WatchBeaconUpgraded(opts *bind.WatchOpts, sink chan<- *BridgeContractBeaconUpgraded, beacon []common.Address) (event.Subscription, error) {

	var beaconRule []interface{}
	for _, beaconItem := range beacon {
		beaconRule = append(beaconRule, beaconItem)
	}

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "BeaconUpgraded", beaconRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractBeaconUpgraded)
				if err := _BridgeContract.contract.UnpackLog(event, "BeaconUpgraded", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseBeaconUpgraded is a log parse operation binding the contract event 0x1cf3b03a6cf19fa2baba4df148e9dcabedea7f8a5c07840e207e5c089be95d3e.
//
// Solidity: event BeaconUpgraded(address indexed beacon)
func (_BridgeContract *BridgeContractFilterer) ParseBeaconUpgraded(log types.Log) (*BridgeContractBeaconUpgraded, error) {
	event := new(BridgeContractBeaconUpgraded)
	if err := _BridgeContract.contract.UnpackLog(event, "BeaconUpgraded", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// BridgeContractFeeReceiverChangedIterator is returned from FilterFeeReceiverChanged and is used to iterate over the raw logs and unpacked data for FeeReceiverChanged events raised by the BridgeContract contract.
type BridgeContractFeeReceiverChangedIterator struct {
	Event *BridgeContractFeeReceiverChanged // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractFeeReceiverChangedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractFeeReceiverChanged)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractFeeReceiverChanged)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractFeeReceiverChangedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractFeeReceiverChangedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractFeeReceiverChanged represents a FeeReceiverChanged event raised by the BridgeContract contract.
type BridgeContractFeeReceiverChanged struct {
	OldReceiver common.Address
	NewReceiver common.Address
	Raw         types.Log // Blockchain specific contextual infos
}

// FilterFeeReceiverChanged is a free log retrieval operation binding the contract event 0xa4b009cc442411b602eaf94bc0579b6abdb8fd90b4ef5b9426e270038906bd03.
//
// Solidity: event FeeReceiverChanged(address indexed oldReceiver, address indexed newReceiver)
func (_BridgeContract *BridgeContractFilterer) FilterFeeReceiverChanged(opts *bind.FilterOpts, oldReceiver []common.Address, newReceiver []common.Address) (*BridgeContractFeeReceiverChangedIterator, error) {

	var oldReceiverRule []interface{}
	for _, oldReceiverItem := range oldReceiver {
		oldReceiverRule = append(oldReceiverRule, oldReceiverItem)
	}
	var newReceiverRule []interface{}
	for _, newReceiverItem := range newReceiver {
		newReceiverRule = append(newReceiverRule, newReceiverItem)
	}

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "FeeReceiverChanged", oldReceiverRule, newReceiverRule)
	if err != nil {
		return nil, err
	}
	return &BridgeContractFeeReceiverChangedIterator{contract: _BridgeContract.contract, event: "FeeReceiverChanged", logs: logs, sub: sub}, nil
}

// WatchFeeReceiverChanged is a free log subscription operation binding the contract event 0xa4b009cc442411b602eaf94bc0579b6abdb8fd90b4ef5b9426e270038906bd03.
//
// Solidity: event FeeReceiverChanged(address indexed oldReceiver, address indexed newReceiver)
func (_BridgeContract *BridgeContractFilterer) WatchFeeReceiverChanged(opts *bind.WatchOpts, sink chan<- *BridgeContractFeeReceiverChanged, oldReceiver []common.Address, newReceiver []common.Address) (event.Subscription, error) {

	var oldReceiverRule []interface{}
	for _, oldReceiverItem := range oldReceiver {
		oldReceiverRule = append(oldReceiverRule, oldReceiverItem)
	}
	var newReceiverRule []interface{}
	for _, newReceiverItem := range newReceiver {
		newReceiverRule = append(newReceiverRule, newReceiverItem)
	}

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "FeeReceiverChanged", oldReceiverRule, newReceiverRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractFeeReceiverChanged)
				if err := _BridgeContract.contract.UnpackLog(event, "FeeReceiverChanged", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseFeeReceiverChanged is a log parse operation binding the contract event 0xa4b009cc442411b602eaf94bc0579b6abdb8fd90b4ef5b9426e270038906bd03.
//
// Solidity: event FeeReceiverChanged(address indexed oldReceiver, address indexed newReceiver)
func (_BridgeContract *BridgeContractFilterer) ParseFeeReceiverChanged(log types.Log) (*BridgeContractFeeReceiverChanged, error) {
	event := new(BridgeContractFeeReceiverChanged)
	if err := _BridgeContract.contract.UnpackLog(event, "FeeReceiverChanged", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// BridgeContractOwnershipTransferredIterator is returned from FilterOwnershipTransferred and is used to iterate over the raw logs and unpacked data for OwnershipTransferred events raised by the BridgeContract contract.
type BridgeContractOwnershipTransferredIterator struct {
	Event *BridgeContractOwnershipTransferred // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractOwnershipTransferredIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractOwnershipTransferred)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractOwnershipTransferred)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractOwnershipTransferredIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractOwnershipTransferredIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractOwnershipTransferred represents a OwnershipTransferred event raised by the BridgeContract contract.
type BridgeContractOwnershipTransferred struct {
	PreviousOwner common.Address
	NewOwner      common.Address
	Raw           types.Log // Blockchain specific contextual infos
}

// FilterOwnershipTransferred is a free log retrieval operation binding the contract event 0x8be0079c531659141344cd1fd0a4f28419497f9722a3daafe3b4186f6b6457e0.
//
// Solidity: event OwnershipTransferred(address indexed previousOwner, address indexed newOwner)
func (_BridgeContract *BridgeContractFilterer) FilterOwnershipTransferred(opts *bind.FilterOpts, previousOwner []common.Address, newOwner []common.Address) (*BridgeContractOwnershipTransferredIterator, error) {

	var previousOwnerRule []interface{}
	for _, previousOwnerItem := range previousOwner {
		previousOwnerRule = append(previousOwnerRule, previousOwnerItem)
	}
	var newOwnerRule []interface{}
	for _, newOwnerItem := range newOwner {
		newOwnerRule = append(newOwnerRule, newOwnerItem)
	}

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "OwnershipTransferred", previousOwnerRule, newOwnerRule)
	if err != nil {
		return nil, err
	}
	return &BridgeContractOwnershipTransferredIterator{contract: _BridgeContract.contract, event: "OwnershipTransferred", logs: logs, sub: sub}, nil
}

// WatchOwnershipTransferred is a free log subscription operation binding the contract event 0x8be0079c531659141344cd1fd0a4f28419497f9722a3daafe3b4186f6b6457e0.
//
// Solidity: event OwnershipTransferred(address indexed previousOwner, address indexed newOwner)
func (_BridgeContract *BridgeContractFilterer) WatchOwnershipTransferred(opts *bind.WatchOpts, sink chan<- *BridgeContractOwnershipTransferred, previousOwner []common.Address, newOwner []common.Address) (event.Subscription, error) {

	var previousOwnerRule []interface{}
	for _, previousOwnerItem := range previousOwner {
		previousOwnerRule = append(previousOwnerRule, previousOwnerItem)
	}
	var newOwnerRule []interface{}
	for _, newOwnerItem := range newOwner {
		newOwnerRule = append(newOwnerRule, newOwnerItem)
	}

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "OwnershipTransferred", previousOwnerRule, newOwnerRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractOwnershipTransferred)
				if err := _BridgeContract.contract.UnpackLog(event, "OwnershipTransferred", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseOwnershipTransferred is a log parse operation binding the contract event 0x8be0079c531659141344cd1fd0a4f28419497f9722a3daafe3b4186f6b6457e0.
//
// Solidity: event OwnershipTransferred(address indexed previousOwner, address indexed newOwner)
func (_BridgeContract *BridgeContractFilterer) ParseOwnershipTransferred(log types.Log) (*BridgeContractOwnershipTransferred, error) {
	event := new(BridgeContractOwnershipTransferred)
	if err := _BridgeContract.contract.UnpackLog(event, "OwnershipTransferred", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// BridgeContractRequirementChangeIterator is returned from FilterRequirementChange and is used to iterate over the raw logs and unpacked data for RequirementChange events raised by the BridgeContract contract.
type BridgeContractRequirementChangeIterator struct {
	Event *BridgeContractRequirementChange // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractRequirementChangeIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractRequirementChange)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractRequirementChange)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractRequirementChangeIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractRequirementChangeIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractRequirementChange represents a RequirementChange event raised by the BridgeContract contract.
type BridgeContractRequirementChange struct {
	Prior   *big.Int
	Present *big.Int
	Raw     types.Log // Blockchain specific contextual infos
}

// FilterRequirementChange is a free log retrieval operation binding the contract event 0xdd7c0dd2de894f9cccfd27f17f4f7390a796fb28e4b1d7317e0e758fff8e672e.
//
// Solidity: event RequirementChange(uint256 prior, uint256 present)
func (_BridgeContract *BridgeContractFilterer) FilterRequirementChange(opts *bind.FilterOpts) (*BridgeContractRequirementChangeIterator, error) {

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "RequirementChange")
	if err != nil {
		return nil, err
	}
	return &BridgeContractRequirementChangeIterator{contract: _BridgeContract.contract, event: "RequirementChange", logs: logs, sub: sub}, nil
}

// WatchRequirementChange is a free log subscription operation binding the contract event 0xdd7c0dd2de894f9cccfd27f17f4f7390a796fb28e4b1d7317e0e758fff8e672e.
//
// Solidity: event RequirementChange(uint256 prior, uint256 present)
func (_BridgeContract *BridgeContractFilterer) WatchRequirementChange(opts *bind.WatchOpts, sink chan<- *BridgeContractRequirementChange) (event.Subscription, error) {

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "RequirementChange")
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractRequirementChange)
				if err := _BridgeContract.contract.UnpackLog(event, "RequirementChange", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseRequirementChange is a log parse operation binding the contract event 0xdd7c0dd2de894f9cccfd27f17f4f7390a796fb28e4b1d7317e0e758fff8e672e.
//
// Solidity: event RequirementChange(uint256 prior, uint256 present)
func (_BridgeContract *BridgeContractFilterer) ParseRequirementChange(log types.Log) (*BridgeContractRequirementChange, error) {
	event := new(BridgeContractRequirementChange)
	if err := _BridgeContract.contract.UnpackLog(event, "RequirementChange", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// BridgeContractSwapConfigChangedIterator is returned from FilterSwapConfigChanged and is used to iterate over the raw logs and unpacked data for SwapConfigChanged events raised by the BridgeContract contract.
type BridgeContractSwapConfigChangedIterator struct {
	Event *BridgeContractSwapConfigChanged // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractSwapConfigChangedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractSwapConfigChanged)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractSwapConfigChanged)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractSwapConfigChangedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractSwapConfigChangedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractSwapConfigChanged represents a SwapConfigChanged event raised by the BridgeContract contract.
type BridgeContractSwapConfigChanged struct {
	FromToken common.Address
	ToToken   common.Address
	Swap      common.Address
	Path      []common.Address
	Raw       types.Log // Blockchain specific contextual infos
}

// FilterSwapConfigChanged is a free log retrieval operation binding the contract event 0x5fef9e8e618fa4e60160d3721f2bae8240bd09ede236e2720aae33ae23ff85d8.
//
// Solidity: event SwapConfigChanged(address indexed fromToken, address indexed toToken, address indexed swap, address[] path)
func (_BridgeContract *BridgeContractFilterer) FilterSwapConfigChanged(opts *bind.FilterOpts, fromToken []common.Address, toToken []common.Address, swap []common.Address) (*BridgeContractSwapConfigChangedIterator, error) {

	var fromTokenRule []interface{}
	for _, fromTokenItem := range fromToken {
		fromTokenRule = append(fromTokenRule, fromTokenItem)
	}
	var toTokenRule []interface{}
	for _, toTokenItem := range toToken {
		toTokenRule = append(toTokenRule, toTokenItem)
	}
	var swapRule []interface{}
	for _, swapItem := range swap {
		swapRule = append(swapRule, swapItem)
	}

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "SwapConfigChanged", fromTokenRule, toTokenRule, swapRule)
	if err != nil {
		return nil, err
	}
	return &BridgeContractSwapConfigChangedIterator{contract: _BridgeContract.contract, event: "SwapConfigChanged", logs: logs, sub: sub}, nil
}

// WatchSwapConfigChanged is a free log subscription operation binding the contract event 0x5fef9e8e618fa4e60160d3721f2bae8240bd09ede236e2720aae33ae23ff85d8.
//
// Solidity: event SwapConfigChanged(address indexed fromToken, address indexed toToken, address indexed swap, address[] path)
func (_BridgeContract *BridgeContractFilterer) WatchSwapConfigChanged(opts *bind.WatchOpts, sink chan<- *BridgeContractSwapConfigChanged, fromToken []common.Address, toToken []common.Address, swap []common.Address) (event.Subscription, error) {

	var fromTokenRule []interface{}
	for _, fromTokenItem := range fromToken {
		fromTokenRule = append(fromTokenRule, fromTokenItem)
	}
	var toTokenRule []interface{}
	for _, toTokenItem := range toToken {
		toTokenRule = append(toTokenRule, toTokenItem)
	}
	var swapRule []interface{}
	for _, swapItem := range swap {
		swapRule = append(swapRule, swapItem)
	}

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "SwapConfigChanged", fromTokenRule, toTokenRule, swapRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractSwapConfigChanged)
				if err := _BridgeContract.contract.UnpackLog(event, "SwapConfigChanged", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseSwapConfigChanged is a log parse operation binding the contract event 0x5fef9e8e618fa4e60160d3721f2bae8240bd09ede236e2720aae33ae23ff85d8.
//
// Solidity: event SwapConfigChanged(address indexed fromToken, address indexed toToken, address indexed swap, address[] path)
func (_BridgeContract *BridgeContractFilterer) ParseSwapConfigChanged(log types.Log) (*BridgeContractSwapConfigChanged, error) {
	event := new(BridgeContractSwapConfigChanged)
	if err := _BridgeContract.contract.UnpackLog(event, "SwapConfigChanged", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// BridgeContractTokenOutConfigChangedIterator is returned from FilterTokenOutConfigChanged and is used to iterate over the raw logs and unpacked data for TokenOutConfigChanged events raised by the BridgeContract contract.
type BridgeContractTokenOutConfigChangedIterator struct {
	Event *BridgeContractTokenOutConfigChanged // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractTokenOutConfigChangedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractTokenOutConfigChanged)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractTokenOutConfigChanged)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractTokenOutConfigChangedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractTokenOutConfigChangedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractTokenOutConfigChanged represents a TokenOutConfigChanged event raised by the BridgeContract contract.
type BridgeContractTokenOutConfigChanged struct {
	Token     common.Address
	ToChainID *big.Int
	Enabled   bool
	Raw       types.Log // Blockchain specific contextual infos
}

// FilterTokenOutConfigChanged is a free log retrieval operation binding the contract event 0x7a89a2a1171b4ec8a8bfb7384ef449a1861191d4c9273a574be616e3b47ea0e1.
//
// Solidity: event TokenOutConfigChanged(address indexed token, uint256 indexed toChainID, bool enabled)
func (_BridgeContract *BridgeContractFilterer) FilterTokenOutConfigChanged(opts *bind.FilterOpts, token []common.Address, toChainID []*big.Int) (*BridgeContractTokenOutConfigChangedIterator, error) {

	var tokenRule []interface{}
	for _, tokenItem := range token {
		tokenRule = append(tokenRule, tokenItem)
	}
	var toChainIDRule []interface{}
	for _, toChainIDItem := range toChainID {
		toChainIDRule = append(toChainIDRule, toChainIDItem)
	}

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "TokenOutConfigChanged", tokenRule, toChainIDRule)
	if err != nil {
		return nil, err
	}
	return &BridgeContractTokenOutConfigChangedIterator{contract: _BridgeContract.contract, event: "TokenOutConfigChanged", logs: logs, sub: sub}, nil
}

// WatchTokenOutConfigChanged is a free log subscription operation binding the contract event 0x7a89a2a1171b4ec8a8bfb7384ef449a1861191d4c9273a574be616e3b47ea0e1.
//
// Solidity: event TokenOutConfigChanged(address indexed token, uint256 indexed toChainID, bool enabled)
func (_BridgeContract *BridgeContractFilterer) WatchTokenOutConfigChanged(opts *bind.WatchOpts, sink chan<- *BridgeContractTokenOutConfigChanged, token []common.Address, toChainID []*big.Int) (event.Subscription, error) {

	var tokenRule []interface{}
	for _, tokenItem := range token {
		tokenRule = append(tokenRule, tokenItem)
	}
	var toChainIDRule []interface{}
	for _, toChainIDItem := range toChainID {
		toChainIDRule = append(toChainIDRule, toChainIDItem)
	}

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "TokenOutConfigChanged", tokenRule, toChainIDRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractTokenOutConfigChanged)
				if err := _BridgeContract.contract.UnpackLog(event, "TokenOutConfigChanged", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseTokenOutConfigChanged is a log parse operation binding the contract event 0x7a89a2a1171b4ec8a8bfb7384ef449a1861191d4c9273a574be616e3b47ea0e1.
//
// Solidity: event TokenOutConfigChanged(address indexed token, uint256 indexed toChainID, bool enabled)
func (_BridgeContract *BridgeContractFilterer) ParseTokenOutConfigChanged(log types.Log) (*BridgeContractTokenOutConfigChanged, error) {
	event := new(BridgeContractTokenOutConfigChanged)
	if err := _BridgeContract.contract.UnpackLog(event, "TokenOutConfigChanged", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// BridgeContractTransferInIterator is returned from FilterTransferIn and is used to iterate over the raw logs and unpacked data for TransferIn events raised by the BridgeContract contract.
type BridgeContractTransferInIterator struct {
	Event *BridgeContractTransferIn // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractTransferInIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractTransferIn)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractTransferIn)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractTransferInIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractTransferInIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractTransferIn represents a TransferIn event raised by the BridgeContract contract.
type BridgeContractTransferIn struct {
	FromChainID *big.Int
	OutId       *big.Int
	InId        *big.Int
	Receiver    common.Address
	Token       common.Address
	Amount      *big.Int
	Raw         types.Log // Blockchain specific contextual infos
}

// FilterTransferIn is a free log retrieval operation binding the contract event 0x4cad99516c397cf67dfa0cdfdfeda8d65ed4a6254e21e1c775f389ae3cd1470d.
//
// Solidity: event TransferIn(uint256 fromChainID, uint256 outId, uint256 inId, address receiver, address token, uint256 amount)
func (_BridgeContract *BridgeContractFilterer) FilterTransferIn(opts *bind.FilterOpts) (*BridgeContractTransferInIterator, error) {

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "TransferIn")
	if err != nil {
		return nil, err
	}
	return &BridgeContractTransferInIterator{contract: _BridgeContract.contract, event: "TransferIn", logs: logs, sub: sub}, nil
}

// WatchTransferIn is a free log subscription operation binding the contract event 0x4cad99516c397cf67dfa0cdfdfeda8d65ed4a6254e21e1c775f389ae3cd1470d.
//
// Solidity: event TransferIn(uint256 fromChainID, uint256 outId, uint256 inId, address receiver, address token, uint256 amount)
func (_BridgeContract *BridgeContractFilterer) WatchTransferIn(opts *bind.WatchOpts, sink chan<- *BridgeContractTransferIn) (event.Subscription, error) {

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "TransferIn")
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractTransferIn)
				if err := _BridgeContract.contract.UnpackLog(event, "TransferIn", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseTransferIn is a log parse operation binding the contract event 0x4cad99516c397cf67dfa0cdfdfeda8d65ed4a6254e21e1c775f389ae3cd1470d.
//
// Solidity: event TransferIn(uint256 fromChainID, uint256 outId, uint256 inId, address receiver, address token, uint256 amount)
func (_BridgeContract *BridgeContractFilterer) ParseTransferIn(log types.Log) (*BridgeContractTransferIn, error) {
	event := new(BridgeContractTransferIn)
	if err := _BridgeContract.contract.UnpackLog(event, "TransferIn", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// BridgeContractTransferInConfirmationIterator is returned from FilterTransferInConfirmation and is used to iterate over the raw logs and unpacked data for TransferInConfirmation events raised by the BridgeContract contract.
type BridgeContractTransferInConfirmationIterator struct {
	Event *BridgeContractTransferInConfirmation // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractTransferInConfirmationIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractTransferInConfirmation)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractTransferInConfirmation)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractTransferInConfirmationIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractTransferInConfirmationIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractTransferInConfirmation represents a TransferInConfirmation event raised by the BridgeContract contract.
type BridgeContractTransferInConfirmation struct {
	InId      *big.Int
	Validator common.Address
	Raw       types.Log // Blockchain specific contextual infos
}

// FilterTransferInConfirmation is a free log retrieval operation binding the contract event 0xe420cc80a898ce7e97248ec8a1dc0a25bbcd41c4ba0c64ce325140a2d8915313.
//
// Solidity: event TransferInConfirmation(uint256 inId, address validator)
func (_BridgeContract *BridgeContractFilterer) FilterTransferInConfirmation(opts *bind.FilterOpts) (*BridgeContractTransferInConfirmationIterator, error) {

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "TransferInConfirmation")
	if err != nil {
		return nil, err
	}
	return &BridgeContractTransferInConfirmationIterator{contract: _BridgeContract.contract, event: "TransferInConfirmation", logs: logs, sub: sub}, nil
}

// WatchTransferInConfirmation is a free log subscription operation binding the contract event 0xe420cc80a898ce7e97248ec8a1dc0a25bbcd41c4ba0c64ce325140a2d8915313.
//
// Solidity: event TransferInConfirmation(uint256 inId, address validator)
func (_BridgeContract *BridgeContractFilterer) WatchTransferInConfirmation(opts *bind.WatchOpts, sink chan<- *BridgeContractTransferInConfirmation) (event.Subscription, error) {

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "TransferInConfirmation")
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractTransferInConfirmation)
				if err := _BridgeContract.contract.UnpackLog(event, "TransferInConfirmation", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseTransferInConfirmation is a log parse operation binding the contract event 0xe420cc80a898ce7e97248ec8a1dc0a25bbcd41c4ba0c64ce325140a2d8915313.
//
// Solidity: event TransferInConfirmation(uint256 inId, address validator)
func (_BridgeContract *BridgeContractFilterer) ParseTransferInConfirmation(log types.Log) (*BridgeContractTransferInConfirmation, error) {
	event := new(BridgeContractTransferInConfirmation)
	if err := _BridgeContract.contract.UnpackLog(event, "TransferInConfirmation", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// BridgeContractTransferInExecutionIterator is returned from FilterTransferInExecution and is used to iterate over the raw logs and unpacked data for TransferInExecution events raised by the BridgeContract contract.
type BridgeContractTransferInExecutionIterator struct {
	Event *BridgeContractTransferInExecution // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractTransferInExecutionIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractTransferInExecution)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractTransferInExecution)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractTransferInExecutionIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractTransferInExecutionIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractTransferInExecution represents a TransferInExecution event raised by the BridgeContract contract.
type BridgeContractTransferInExecution struct {
	InId     *big.Int
	Receiver common.Address
	Token    common.Address
	Amount   *big.Int
	Raw      types.Log // Blockchain specific contextual infos
}

// FilterTransferInExecution is a free log retrieval operation binding the contract event 0x3ebe4c6205b5e0dfebd74abf61991b68b5a9de9e55076525fb702281aba82282.
//
// Solidity: event TransferInExecution(uint256 inId, address receiver, address token, uint256 amount)
func (_BridgeContract *BridgeContractFilterer) FilterTransferInExecution(opts *bind.FilterOpts) (*BridgeContractTransferInExecutionIterator, error) {

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "TransferInExecution")
	if err != nil {
		return nil, err
	}
	return &BridgeContractTransferInExecutionIterator{contract: _BridgeContract.contract, event: "TransferInExecution", logs: logs, sub: sub}, nil
}

// WatchTransferInExecution is a free log subscription operation binding the contract event 0x3ebe4c6205b5e0dfebd74abf61991b68b5a9de9e55076525fb702281aba82282.
//
// Solidity: event TransferInExecution(uint256 inId, address receiver, address token, uint256 amount)
func (_BridgeContract *BridgeContractFilterer) WatchTransferInExecution(opts *bind.WatchOpts, sink chan<- *BridgeContractTransferInExecution) (event.Subscription, error) {

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "TransferInExecution")
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractTransferInExecution)
				if err := _BridgeContract.contract.UnpackLog(event, "TransferInExecution", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseTransferInExecution is a log parse operation binding the contract event 0x3ebe4c6205b5e0dfebd74abf61991b68b5a9de9e55076525fb702281aba82282.
//
// Solidity: event TransferInExecution(uint256 inId, address receiver, address token, uint256 amount)
func (_BridgeContract *BridgeContractFilterer) ParseTransferInExecution(log types.Log) (*BridgeContractTransferInExecution, error) {
	event := new(BridgeContractTransferInExecution)
	if err := _BridgeContract.contract.UnpackLog(event, "TransferInExecution", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// BridgeContractTransferInRejectionIterator is returned from FilterTransferInRejection and is used to iterate over the raw logs and unpacked data for TransferInRejection events raised by the BridgeContract contract.
type BridgeContractTransferInRejectionIterator struct {
	Event *BridgeContractTransferInRejection // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractTransferInRejectionIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractTransferInRejection)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractTransferInRejection)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractTransferInRejectionIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractTransferInRejectionIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractTransferInRejection represents a TransferInRejection event raised by the BridgeContract contract.
type BridgeContractTransferInRejection struct {
	InId      *big.Int
	Validator common.Address
	Raw       types.Log // Blockchain specific contextual infos
}

// FilterTransferInRejection is a free log retrieval operation binding the contract event 0xe3f3baf5b51b3ef5fb211964585a64f5c7ee310261ff813d5a4c6e13cba6726b.
//
// Solidity: event TransferInRejection(uint256 inId, address validator)
func (_BridgeContract *BridgeContractFilterer) FilterTransferInRejection(opts *bind.FilterOpts) (*BridgeContractTransferInRejectionIterator, error) {

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "TransferInRejection")
	if err != nil {
		return nil, err
	}
	return &BridgeContractTransferInRejectionIterator{contract: _BridgeContract.contract, event: "TransferInRejection", logs: logs, sub: sub}, nil
}

// WatchTransferInRejection is a free log subscription operation binding the contract event 0xe3f3baf5b51b3ef5fb211964585a64f5c7ee310261ff813d5a4c6e13cba6726b.
//
// Solidity: event TransferInRejection(uint256 inId, address validator)
func (_BridgeContract *BridgeContractFilterer) WatchTransferInRejection(opts *bind.WatchOpts, sink chan<- *BridgeContractTransferInRejection) (event.Subscription, error) {

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "TransferInRejection")
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractTransferInRejection)
				if err := _BridgeContract.contract.UnpackLog(event, "TransferInRejection", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseTransferInRejection is a log parse operation binding the contract event 0xe3f3baf5b51b3ef5fb211964585a64f5c7ee310261ff813d5a4c6e13cba6726b.
//
// Solidity: event TransferInRejection(uint256 inId, address validator)
func (_BridgeContract *BridgeContractFilterer) ParseTransferInRejection(log types.Log) (*BridgeContractTransferInRejection, error) {
	event := new(BridgeContractTransferInRejection)
	if err := _BridgeContract.contract.UnpackLog(event, "TransferInRejection", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// BridgeContractTransferOutIterator is returned from FilterTransferOut and is used to iterate over the raw logs and unpacked data for TransferOut events raised by the BridgeContract contract.
type BridgeContractTransferOutIterator struct {
	Event *BridgeContractTransferOut // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractTransferOutIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractTransferOut)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractTransferOut)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractTransferOutIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractTransferOutIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractTransferOut represents a TransferOut event raised by the BridgeContract contract.
type BridgeContractTransferOut struct {
	OutId        *big.Int
	FromChainID  *big.Int
	Sender       common.Address
	Token        common.Address
	Amount       *big.Int
	Fee          *big.Int
	ToChainID    *big.Int
	Receiver     common.Address
	ReceiveToken common.Address
	Raw          types.Log // Blockchain specific contextual infos
}

// FilterTransferOut is a free log retrieval operation binding the contract event 0x031758eba572a89e462cda6992d6b6ed8755f4c4d432b242a95cfccc0b38f8e8.
//
// Solidity: event TransferOut(uint256 outId, uint256 fromChainID, address sender, address token, uint256 amount, uint256 fee, uint256 toChainID, address receiver, address receiveToken)
func (_BridgeContract *BridgeContractFilterer) FilterTransferOut(opts *bind.FilterOpts) (*BridgeContractTransferOutIterator, error) {

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "TransferOut")
	if err != nil {
		return nil, err
	}
	return &BridgeContractTransferOutIterator{contract: _BridgeContract.contract, event: "TransferOut", logs: logs, sub: sub}, nil
}

// WatchTransferOut is a free log subscription operation binding the contract event 0x031758eba572a89e462cda6992d6b6ed8755f4c4d432b242a95cfccc0b38f8e8.
//
// Solidity: event TransferOut(uint256 outId, uint256 fromChainID, address sender, address token, uint256 amount, uint256 fee, uint256 toChainID, address receiver, address receiveToken)
func (_BridgeContract *BridgeContractFilterer) WatchTransferOut(opts *bind.WatchOpts, sink chan<- *BridgeContractTransferOut) (event.Subscription, error) {

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "TransferOut")
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractTransferOut)
				if err := _BridgeContract.contract.UnpackLog(event, "TransferOut", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseTransferOut is a log parse operation binding the contract event 0x031758eba572a89e462cda6992d6b6ed8755f4c4d432b242a95cfccc0b38f8e8.
//
// Solidity: event TransferOut(uint256 outId, uint256 fromChainID, address sender, address token, uint256 amount, uint256 fee, uint256 toChainID, address receiver, address receiveToken)
func (_BridgeContract *BridgeContractFilterer) ParseTransferOut(log types.Log) (*BridgeContractTransferOut, error) {
	event := new(BridgeContractTransferOut)
	if err := _BridgeContract.contract.UnpackLog(event, "TransferOut", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// BridgeContractTreasuryChangedIterator is returned from FilterTreasuryChanged and is used to iterate over the raw logs and unpacked data for TreasuryChanged events raised by the BridgeContract contract.
type BridgeContractTreasuryChangedIterator struct {
	Event *BridgeContractTreasuryChanged // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractTreasuryChangedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractTreasuryChanged)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractTreasuryChanged)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractTreasuryChangedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractTreasuryChangedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractTreasuryChanged represents a TreasuryChanged event raised by the BridgeContract contract.
type BridgeContractTreasuryChanged struct {
	OldTreasury common.Address
	NewTreasury common.Address
	Raw         types.Log // Blockchain specific contextual infos
}

// FilterTreasuryChanged is a free log retrieval operation binding the contract event 0x8c3aa5f43a388513435861bf27dfad7829cd248696fed367c62d441f62954496.
//
// Solidity: event TreasuryChanged(address indexed oldTreasury, address indexed newTreasury)
func (_BridgeContract *BridgeContractFilterer) FilterTreasuryChanged(opts *bind.FilterOpts, oldTreasury []common.Address, newTreasury []common.Address) (*BridgeContractTreasuryChangedIterator, error) {

	var oldTreasuryRule []interface{}
	for _, oldTreasuryItem := range oldTreasury {
		oldTreasuryRule = append(oldTreasuryRule, oldTreasuryItem)
	}
	var newTreasuryRule []interface{}
	for _, newTreasuryItem := range newTreasury {
		newTreasuryRule = append(newTreasuryRule, newTreasuryItem)
	}

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "TreasuryChanged", oldTreasuryRule, newTreasuryRule)
	if err != nil {
		return nil, err
	}
	return &BridgeContractTreasuryChangedIterator{contract: _BridgeContract.contract, event: "TreasuryChanged", logs: logs, sub: sub}, nil
}

// WatchTreasuryChanged is a free log subscription operation binding the contract event 0x8c3aa5f43a388513435861bf27dfad7829cd248696fed367c62d441f62954496.
//
// Solidity: event TreasuryChanged(address indexed oldTreasury, address indexed newTreasury)
func (_BridgeContract *BridgeContractFilterer) WatchTreasuryChanged(opts *bind.WatchOpts, sink chan<- *BridgeContractTreasuryChanged, oldTreasury []common.Address, newTreasury []common.Address) (event.Subscription, error) {

	var oldTreasuryRule []interface{}
	for _, oldTreasuryItem := range oldTreasury {
		oldTreasuryRule = append(oldTreasuryRule, oldTreasuryItem)
	}
	var newTreasuryRule []interface{}
	for _, newTreasuryItem := range newTreasury {
		newTreasuryRule = append(newTreasuryRule, newTreasuryItem)
	}

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "TreasuryChanged", oldTreasuryRule, newTreasuryRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractTreasuryChanged)
				if err := _BridgeContract.contract.UnpackLog(event, "TreasuryChanged", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseTreasuryChanged is a log parse operation binding the contract event 0x8c3aa5f43a388513435861bf27dfad7829cd248696fed367c62d441f62954496.
//
// Solidity: event TreasuryChanged(address indexed oldTreasury, address indexed newTreasury)
func (_BridgeContract *BridgeContractFilterer) ParseTreasuryChanged(log types.Log) (*BridgeContractTreasuryChanged, error) {
	event := new(BridgeContractTreasuryChanged)
	if err := _BridgeContract.contract.UnpackLog(event, "TreasuryChanged", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// BridgeContractTreasuryConfigChangedIterator is returned from FilterTreasuryConfigChanged and is used to iterate over the raw logs and unpacked data for TreasuryConfigChanged events raised by the BridgeContract contract.
type BridgeContractTreasuryConfigChangedIterator struct {
	Event *BridgeContractTreasuryConfigChanged // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractTreasuryConfigChangedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractTreasuryConfigChanged)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractTreasuryConfigChanged)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractTreasuryConfigChangedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractTreasuryConfigChangedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractTreasuryConfigChanged represents a TreasuryConfigChanged event raised by the BridgeContract contract.
type BridgeContractTreasuryConfigChanged struct {
	Token        common.Address
	MinReserve   *big.Int
	ReserveRatio *big.Int
	Enabled      bool
	Raw          types.Log // Blockchain specific contextual infos
}

// FilterTreasuryConfigChanged is a free log retrieval operation binding the contract event 0x4bcabce4b0e7246e7b76777e00d27dabe90f522d274671b7eedd331369b66eba.
//
// Solidity: event TreasuryConfigChanged(address indexed token, uint256 minReserve, uint256 reserveRatio, bool enabled)
func (_BridgeContract *BridgeContractFilterer) FilterTreasuryConfigChanged(opts *bind.FilterOpts, token []common.Address) (*BridgeContractTreasuryConfigChangedIterator, error) {

	var tokenRule []interface{}
	for _, tokenItem := range token {
		tokenRule = append(tokenRule, tokenItem)
	}

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "TreasuryConfigChanged", tokenRule)
	if err != nil {
		return nil, err
	}
	return &BridgeContractTreasuryConfigChangedIterator{contract: _BridgeContract.contract, event: "TreasuryConfigChanged", logs: logs, sub: sub}, nil
}

// WatchTreasuryConfigChanged is a free log subscription operation binding the contract event 0x4bcabce4b0e7246e7b76777e00d27dabe90f522d274671b7eedd331369b66eba.
//
// Solidity: event TreasuryConfigChanged(address indexed token, uint256 minReserve, uint256 reserveRatio, bool enabled)
func (_BridgeContract *BridgeContractFilterer) WatchTreasuryConfigChanged(opts *bind.WatchOpts, sink chan<- *BridgeContractTreasuryConfigChanged, token []common.Address) (event.Subscription, error) {

	var tokenRule []interface{}
	for _, tokenItem := range token {
		tokenRule = append(tokenRule, tokenItem)
	}

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "TreasuryConfigChanged", tokenRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractTreasuryConfigChanged)
				if err := _BridgeContract.contract.UnpackLog(event, "TreasuryConfigChanged", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseTreasuryConfigChanged is a log parse operation binding the contract event 0x4bcabce4b0e7246e7b76777e00d27dabe90f522d274671b7eedd331369b66eba.
//
// Solidity: event TreasuryConfigChanged(address indexed token, uint256 minReserve, uint256 reserveRatio, bool enabled)
func (_BridgeContract *BridgeContractFilterer) ParseTreasuryConfigChanged(log types.Log) (*BridgeContractTreasuryConfigChanged, error) {
	event := new(BridgeContractTreasuryConfigChanged)
	if err := _BridgeContract.contract.UnpackLog(event, "TreasuryConfigChanged", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// BridgeContractTreasuryTransferIterator is returned from FilterTreasuryTransfer and is used to iterate over the raw logs and unpacked data for TreasuryTransfer events raised by the BridgeContract contract.
type BridgeContractTreasuryTransferIterator struct {
	Event *BridgeContractTreasuryTransfer // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractTreasuryTransferIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractTreasuryTransfer)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractTreasuryTransfer)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractTreasuryTransferIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractTreasuryTransferIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractTreasuryTransfer represents a TreasuryTransfer event raised by the BridgeContract contract.
type BridgeContractTreasuryTransfer struct {
	Token           common.Address
	Amount          *big.Int
	ContractBalance *big.Int
	TreasuryBalance *big.Int
	Raw             types.Log // Blockchain specific contextual infos
}

// FilterTreasuryTransfer is a free log retrieval operation binding the contract event 0xdfced8b7b9acd48b1b8a9d252e7eecaff4d87f402fce3c66a581ce0eae74a618.
//
// Solidity: event TreasuryTransfer(address indexed token, uint256 amount, uint256 contractBalance, uint256 treasuryBalance)
func (_BridgeContract *BridgeContractFilterer) FilterTreasuryTransfer(opts *bind.FilterOpts, token []common.Address) (*BridgeContractTreasuryTransferIterator, error) {

	var tokenRule []interface{}
	for _, tokenItem := range token {
		tokenRule = append(tokenRule, tokenItem)
	}

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "TreasuryTransfer", tokenRule)
	if err != nil {
		return nil, err
	}
	return &BridgeContractTreasuryTransferIterator{contract: _BridgeContract.contract, event: "TreasuryTransfer", logs: logs, sub: sub}, nil
}

// WatchTreasuryTransfer is a free log subscription operation binding the contract event 0xdfced8b7b9acd48b1b8a9d252e7eecaff4d87f402fce3c66a581ce0eae74a618.
//
// Solidity: event TreasuryTransfer(address indexed token, uint256 amount, uint256 contractBalance, uint256 treasuryBalance)
func (_BridgeContract *BridgeContractFilterer) WatchTreasuryTransfer(opts *bind.WatchOpts, sink chan<- *BridgeContractTreasuryTransfer, token []common.Address) (event.Subscription, error) {

	var tokenRule []interface{}
	for _, tokenItem := range token {
		tokenRule = append(tokenRule, tokenItem)
	}

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "TreasuryTransfer", tokenRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractTreasuryTransfer)
				if err := _BridgeContract.contract.UnpackLog(event, "TreasuryTransfer", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseTreasuryTransfer is a log parse operation binding the contract event 0xdfced8b7b9acd48b1b8a9d252e7eecaff4d87f402fce3c66a581ce0eae74a618.
//
// Solidity: event TreasuryTransfer(address indexed token, uint256 amount, uint256 contractBalance, uint256 treasuryBalance)
func (_BridgeContract *BridgeContractFilterer) ParseTreasuryTransfer(log types.Log) (*BridgeContractTreasuryTransfer, error) {
	event := new(BridgeContractTreasuryTransfer)
	if err := _BridgeContract.contract.UnpackLog(event, "TreasuryTransfer", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// BridgeContractUpgradedIterator is returned from FilterUpgraded and is used to iterate over the raw logs and unpacked data for Upgraded events raised by the BridgeContract contract.
type BridgeContractUpgradedIterator struct {
	Event *BridgeContractUpgraded // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractUpgradedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractUpgraded)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractUpgraded)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractUpgradedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractUpgradedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractUpgraded represents a Upgraded event raised by the BridgeContract contract.
type BridgeContractUpgraded struct {
	Implementation common.Address
	Raw            types.Log // Blockchain specific contextual infos
}

// FilterUpgraded is a free log retrieval operation binding the contract event 0xbc7cd75a20ee27fd9adebab32041f755214dbc6bffa90cc0225b39da2e5c2d3b.
//
// Solidity: event Upgraded(address indexed implementation)
func (_BridgeContract *BridgeContractFilterer) FilterUpgraded(opts *bind.FilterOpts, implementation []common.Address) (*BridgeContractUpgradedIterator, error) {

	var implementationRule []interface{}
	for _, implementationItem := range implementation {
		implementationRule = append(implementationRule, implementationItem)
	}

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "Upgraded", implementationRule)
	if err != nil {
		return nil, err
	}
	return &BridgeContractUpgradedIterator{contract: _BridgeContract.contract, event: "Upgraded", logs: logs, sub: sub}, nil
}

// WatchUpgraded is a free log subscription operation binding the contract event 0xbc7cd75a20ee27fd9adebab32041f755214dbc6bffa90cc0225b39da2e5c2d3b.
//
// Solidity: event Upgraded(address indexed implementation)
func (_BridgeContract *BridgeContractFilterer) WatchUpgraded(opts *bind.WatchOpts, sink chan<- *BridgeContractUpgraded, implementation []common.Address) (event.Subscription, error) {

	var implementationRule []interface{}
	for _, implementationItem := range implementation {
		implementationRule = append(implementationRule, implementationItem)
	}

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "Upgraded", implementationRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractUpgraded)
				if err := _BridgeContract.contract.UnpackLog(event, "Upgraded", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseUpgraded is a log parse operation binding the contract event 0xbc7cd75a20ee27fd9adebab32041f755214dbc6bffa90cc0225b39da2e5c2d3b.
//
// Solidity: event Upgraded(address indexed implementation)
func (_BridgeContract *BridgeContractFilterer) ParseUpgraded(log types.Log) (*BridgeContractUpgraded, error) {
	event := new(BridgeContractUpgraded)
	if err := _BridgeContract.contract.UnpackLog(event, "Upgraded", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// BridgeContractValidatorAdditionIterator is returned from FilterValidatorAddition and is used to iterate over the raw logs and unpacked data for ValidatorAddition events raised by the BridgeContract contract.
type BridgeContractValidatorAdditionIterator struct {
	Event *BridgeContractValidatorAddition // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractValidatorAdditionIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractValidatorAddition)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractValidatorAddition)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractValidatorAdditionIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractValidatorAdditionIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractValidatorAddition represents a ValidatorAddition event raised by the BridgeContract contract.
type BridgeContractValidatorAddition struct {
	Validator common.Address
	Raw       types.Log // Blockchain specific contextual infos
}

// FilterValidatorAddition is a free log retrieval operation binding the contract event 0xd7493443bf98d18c85ad2cefd9efe14e9359eeba751fd045e64efd29896a7002.
//
// Solidity: event ValidatorAddition(address validator)
func (_BridgeContract *BridgeContractFilterer) FilterValidatorAddition(opts *bind.FilterOpts) (*BridgeContractValidatorAdditionIterator, error) {

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "ValidatorAddition")
	if err != nil {
		return nil, err
	}
	return &BridgeContractValidatorAdditionIterator{contract: _BridgeContract.contract, event: "ValidatorAddition", logs: logs, sub: sub}, nil
}

// WatchValidatorAddition is a free log subscription operation binding the contract event 0xd7493443bf98d18c85ad2cefd9efe14e9359eeba751fd045e64efd29896a7002.
//
// Solidity: event ValidatorAddition(address validator)
func (_BridgeContract *BridgeContractFilterer) WatchValidatorAddition(opts *bind.WatchOpts, sink chan<- *BridgeContractValidatorAddition) (event.Subscription, error) {

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "ValidatorAddition")
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractValidatorAddition)
				if err := _BridgeContract.contract.UnpackLog(event, "ValidatorAddition", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseValidatorAddition is a log parse operation binding the contract event 0xd7493443bf98d18c85ad2cefd9efe14e9359eeba751fd045e64efd29896a7002.
//
// Solidity: event ValidatorAddition(address validator)
func (_BridgeContract *BridgeContractFilterer) ParseValidatorAddition(log types.Log) (*BridgeContractValidatorAddition, error) {
	event := new(BridgeContractValidatorAddition)
	if err := _BridgeContract.contract.UnpackLog(event, "ValidatorAddition", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// BridgeContractValidatorRemovalIterator is returned from FilterValidatorRemoval and is used to iterate over the raw logs and unpacked data for ValidatorRemoval events raised by the BridgeContract contract.
type BridgeContractValidatorRemovalIterator struct {
	Event *BridgeContractValidatorRemoval // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *BridgeContractValidatorRemovalIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(BridgeContractValidatorRemoval)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(BridgeContractValidatorRemoval)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *BridgeContractValidatorRemovalIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *BridgeContractValidatorRemovalIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// BridgeContractValidatorRemoval represents a ValidatorRemoval event raised by the BridgeContract contract.
type BridgeContractValidatorRemoval struct {
	Validator common.Address
	Raw       types.Log // Blockchain specific contextual infos
}

// FilterValidatorRemoval is a free log retrieval operation binding the contract event 0x6a3ba09e7ab344aeb6790b83cb8c271b874e78a1f400938c91ae9afdb9d494b3.
//
// Solidity: event ValidatorRemoval(address validator)
func (_BridgeContract *BridgeContractFilterer) FilterValidatorRemoval(opts *bind.FilterOpts) (*BridgeContractValidatorRemovalIterator, error) {

	logs, sub, err := _BridgeContract.contract.FilterLogs(opts, "ValidatorRemoval")
	if err != nil {
		return nil, err
	}
	return &BridgeContractValidatorRemovalIterator{contract: _BridgeContract.contract, event: "ValidatorRemoval", logs: logs, sub: sub}, nil
}

// WatchValidatorRemoval is a free log subscription operation binding the contract event 0x6a3ba09e7ab344aeb6790b83cb8c271b874e78a1f400938c91ae9afdb9d494b3.
//
// Solidity: event ValidatorRemoval(address validator)
func (_BridgeContract *BridgeContractFilterer) WatchValidatorRemoval(opts *bind.WatchOpts, sink chan<- *BridgeContractValidatorRemoval) (event.Subscription, error) {

	logs, sub, err := _BridgeContract.contract.WatchLogs(opts, "ValidatorRemoval")
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(BridgeContractValidatorRemoval)
				if err := _BridgeContract.contract.UnpackLog(event, "ValidatorRemoval", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseValidatorRemoval is a log parse operation binding the contract event 0x6a3ba09e7ab344aeb6790b83cb8c271b874e78a1f400938c91ae9afdb9d494b3.
//
// Solidity: event ValidatorRemoval(address validator)
func (_BridgeContract *BridgeContractFilterer) ParseValidatorRemoval(log types.Log) (*BridgeContractValidatorRemoval, error) {
	event := new(BridgeContractValidatorRemoval)
	if err := _BridgeContract.contract.UnpackLog(event, "ValidatorRemoval", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}
