package server

import (
	"code.wuban.net.cn/movabridge/bridge-backend/config"
	"code.wuban.net.cn/movabridge/bridge-backend/middleware"
	"github.com/gin-gonic/gin"
)

func initRouter(conf *config.Config, e *gin.Engine) {
	e.Use(middleware.PrintRequestResponseBodyMiddleware())
	e.Use(middleware.CheckHeaderMiddleware(conf.Server.InvalidHeaders))

	v1 := e.Group("/api/v1")

	v1.GET("/params", getParam)

	{
		user := v1.Group("/user")
		user.GET("/history", getHistory)
		user.GET("/txstatus", getTxStatus)
	}
	{
		bridge := v1.Group("/bridge")
		bridge.GET("/routers", bridgeRouters)
		bridge.POST("/balance", bridgeBalance)
		bridge.POST("/quote", bridgeQuote)
	}
	{
		swap := v1.Group("/swap")
		swap.GET("/routers", getAllSwapRouters)
		swap.GET("/routers/:chain", getSwapRoutersByChainId)
		swap.POST("/balance", swapBalance)
		swap.POST("/quote", swapQuote)
	}
}
