package constant

const JwtSecret = "uEj7AgDNCREwsvnTaCEtzDXt0I5eFDl8"

const (
	InvalidParam        = "invalid param"
	UnsupportedPlatform = "unsupported platform"
	InternalError       = "internal error"
)

type TransferStatus int

const (
	TransferChainNoProcess   TransferStatus = iota
	TransferChainWaitConfirm TransferStatus = 1
	TransferChainExecuted    TransferStatus = 2
	TransferChainRejected    TransferStatus = 3
)

func (ts TransferStatus) String() string {
	switch ts {
	case TransferChainNoProcess:
		return "NoProcess"
	case TransferChainWaitConfirm:
		return "WaitConfirm"
	case TransferChainExecuted:
		return "Executed"
	case TransferChainRejected:
		return "Rejected"
	default:
		return "Unknown"
	}
}

const (
	ValidatorStatusNoPrecess    = 0
	ValidatorStatusConfirmation = 1
	ValidatorStatusRejection    = 2
	ValidatorStatusFailure      = 3
)

const (
	EVENT_TRANSFER_OUT             = "TransferOut"
	EVENT_TRANSFER_IN              = "TransferIn"
	EVENT_TRANSFER_IN_CONFIRMATION = "TransferInConfirmation"
	EVENT_TRANSFER_IN_REJECTION    = "TransferInRejection"
	EVENT_TRANSFER_IN_EXECUTION    = "TransferInExecution"
	EVENT_TOKENCONFIGCHANGED       = "TokenConfigChanged"
)

type ValidatorOp int

func (op ValidatorOp) String() string {
	switch op {
	case ValidatorStatusConfirmation:
		return "TransferInConfirmation"
	case ValidatorStatusRejection:
		return "TransferInRejection"
	default:
		return "Unknown"
	}
}
