package dao

import (
	"code.wuban.net.cn/movabridge/bridge-backend/contract/bridge"
	"context"
	"fmt"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/ethclient"
	"math/big"
	"testing"
)

func TestGetReceiveToken(t *testing.T) {
	client, _ := ethclient.Dial("http://rpc.hole.bitheart.org")
	ct, _ := bridge.NewBridgeContract(common.HexToAddress("0xceEC8799139C698De532e363DA7395E25F409775"), client)
	latest, _ := client.BlockNumber(context.Background())
	opt := &bind.CallOpts{
		Pending:     false,
		Context:     context.Background(),
		BlockNumber: big.NewInt(int64(latest)),
		From:        common.HexToAddress("0xfeed6dB33622Fb526a89c84A0861C29f483f1d0E"),
	}
	result, err := ct.OutConfiguration(opt, common.HexToAddress("0x9F225b7BCC4697414D4F6aC1CB985D07d34dAe0a"), big.NewInt(8891))
	if err != nil {
		t.Fatal(err)
	}
	fmt.Println(result)
}
