package api

type ToToken struct {
	TokenContract string `bson:"token_contract"`
	ToChainId     int64  `json:"to_chain_id" bson:"to_chain_id"`
	ToToken       string `json:"to_token" bson:"to_token"`
	ToTokenSymbol string `json:"to_token_symbol" bson:"to_token_symbol"`
}
type ChainConfig struct {
	Chain          string             `json:"chain" bson:"chain"`
	ChainId        int64              `json:"chain_id" bson:"chain_id"`
	BridgeContract string             `json:"contract" bson:"contract"`
	SupportTokens  map[string]ToToken `json:"support_tokens" bson:"support_tokens"`
	ExplorerUrl    string             `json:"explorer_url" bson:"explorer_url"`
	RpcUrl         string             `json:"rpc" bson:"rpc"`
}

type BridgeConfig struct {
	Chains map[string]ChainConfig `json:"chains" bson:"chains"`
}

type HistoryInfo struct {
	FromChain   string `json:"from_chain" bson:"from_chain"`
	ToChain     string `json:"to_chain" bson:"to_chain"`
	TxHash      string `json:"tx_hash" bson:"tx_hash"`
	CreateTime  int64  `json:"create_time" bson:"create_time"`
	Amount      string `json:"amount" bson:"amount"`
	Token       string `json:"token" bson:"token"`
	TokenSymbol string `json:"token_symbol" bson:"token_symbol"`
	Status      string `json:"status" bson:"status"`
}

type History struct {
	Pending []*HistoryInfo `json:"pending" bson:"pending"`
	Finish  []*HistoryInfo `json:"finish" bson:"finish"`
}

type Querier interface {
	GetBridgeConfig() (config BridgeConfig, err error)
	GetHistoryInfo(user string) (history History, err error)
}
