package api

type ToBridgeToken struct {
	TokenContract string `json:"token_contract" bson:"token_contract"`
	ToChainId     int64  `json:"to_chain_id" bson:"to_chain_id"`
	ToToken       string `json:"to_token" bson:"to_token"`
	ToTokenSymbol string `json:"to_token_symbol" bson:"to_token_symbol"`
	Fee           string `json:"fee" bson:"fee"`
	MaxLimit      string `json:"max_limit" bson:"max_limit"`
}

type SwapPath struct {
	SwapFromToken   string `json:"swap_from_token" bson:"swap_from_token"`
	BridgeFromToken string `json:"bridge_from_token" bson:"bridge_from_token"`
	BridgeToToken   string `json:"bridge_to_token" bson:"bridge_to_token"`
	SwapToToken     string `json:"swap_to_token" bson:"swap_to_token"`
}

type ToSwapToken struct {
	ToChainId     int64    `json:"to_chain_id" bson:"to_chain_id"`
	ToToken       string   `json:"to_token" bson:"to_token"`
	ToTokenSymbol string   `json:"to_token_symbol" bson:"to_token_symbol"`
	Path          SwapPath `json:"path" bson:"path"`
}

type SupportBridgeTokenInfo struct {
	TokenContract string          `json:"token_contract" bson:"token_contract"`
	TokenSymbol   string          `json:"token_symbol" bson:"token_symbol"`
	BridgeTokens  []ToBridgeToken `json:"bridge_tokens" bson:"bridge_tokens"`
}

type SupportSwapTokenInfo struct {
	TokenContract string                           `json:"token_contract" bson:"token_contract"`
	TokenSymbol   string                           `json:"token_symbol" bson:"token_symbol"`
	SwapTokens    map[int64]map[string]ToSwapToken `json:"swap_tokens" bson:"swap_tokens"`
}

type ChainConfig struct {
	Chain          string                            `json:"chain" bson:"chain"`
	ChainId        int64                             `json:"chain_id" bson:"chain_id"`
	BridgeContract string                            `json:"contract" bson:"contract"`
	SupportTokens  map[string]SupportBridgeTokenInfo `json:"support_tokens" bson:"support_tokens"`
	ExplorerUrl    string                            `json:"explorer_url" bson:"explorer_url"`
	RpcUrl         string                            `json:"rpc" bson:"rpc"`
}

type ChainSwapConfig struct {
	Chain          string                          `json:"chain" bson:"chain"`
	ChainId        int64                           `json:"chain_id" bson:"chain_id"`
	BridgeContract string                          `json:"contract" bson:"contract"`
	SupportTokens  map[string]SupportSwapTokenInfo `json:"support_tokens" bson:"support_tokens"`
	ExplorerUrl    string                          `json:"explorer_url" bson:"explorer_url"`
	RpcUrl         string                          `json:"rpc" bson:"rpc"`
}

type SwapConfigs struct {
	Chains map[string]ChainSwapConfig `json:"chains" bson:"chains"`
}

type BridgeConfig struct {
	Chains map[string]ChainConfig `json:"chains" bson:"chains"`
}

type HistoryInfo struct {
	FromChain    string `json:"from_chain" bson:"from_chain"`
	ToChain      string `json:"to_chain" bson:"to_chain"`
	TxHash       string `json:"tx_hash" bson:"tx_hash"`
	UrlSource    string `json:"url_source" bson:"url_source"`
	CreateTime   int64  `json:"create_time" bson:"create_time"`
	Amount       string `json:"amount" bson:"amount"`
	Token        string `json:"token" bson:"token"`
	TokenSymbol  string `json:"token_symbol" bson:"token_symbol"`
	UrlTarget    string `json:"url_target" bson:"url_target"`
	Status       string `json:"status" bson:"status"`
	FeeAmount    string `json:"fee_amount" bson:"fee_amount"`
	ConfirmCount int    `json:"confirm_count" bson:"confirm_count"`
	RejectCount  int    `json:"reject_count" bson:"reject_count"`
}

type History struct {
	Pending []*HistoryInfo `json:"pending" bson:"pending"`
	Finish  []*HistoryInfo `json:"finish" bson:"finish"`
}

type RouterQuery struct {
	ChainId int64  `json:"chain_id"`
	User    string `json:"user"`
}

type TokenBalanceQuery struct {
	ChainId  int64    `json:"chain_id"`
	User     string   `json:"user"`
	TokeList []string `json:"toke_list"`
}

type QuoteBridgeParam struct {
	FromChainId int64  `json:"from_chain_id"`
	ToChainId   int64  `json:"to_chain_id"`
	FromToken   string `json:"from_token"`
	ToToken     string `json:"to_token"`
	InputAmount string `json:"amount"`
	User        string `json:"user"`
	Receiver    string `json:"receiver"`
}

type QuoteSwapParam struct {
	FromChainId int64    `json:"from_chain_id"`
	ToChainId   int64    `json:"to_chain_id"`
	Path        SwapPath `json:"path"`
	InputAmount string   `json:"amount"`
	User        string   `json:"user"`
	Receiver    string   `json:"receiver"`
}

type TokenBalance struct {
	Name     string `json:"name"`
	Decimals int    `json:"decimals"`
	Balance  string `json:"balance"`
	Contract string `json:"contract"`
}

type TokenBalances struct {
	Balances []TokenBalance `json:"balances"`
}

type QuoteResult struct {
	ToContract string `json:"to_contract"`
	OutAmount  string `json:"out_amount"`
	Payload    string `json:"payload"`
}

type Querier interface {
	GetBridgeConfig() (config BridgeConfig, err error)
	GetAllChainSwapConfig() (map[int64]*ChainSwapConfig, error)
	GetSwapConfig(int64) (*ChainSwapConfig, error)
	GetHistoryInfo(user string) (history History, err error)
	GetTokenBalance(chainId int64, user string, tokens []string) (balances TokenBalances, err error)
	GetBridgeTokenBalance(chainId int64, user string) (balances TokenBalances, err error)
	QuoteBridge(param QuoteBridgeParam) (quote QuoteResult, err error)
	GetSwapTokenBalance(chainId int64, user string) (balances TokenBalances, err error)
	QuoteSwap(param QuoteSwapParam) (quote QuoteResult, err error)
}
