package dao

import (
	"code.wuban.net.cn/movabridge/bridge-backend/contract/bridge"
	"context"
	"fmt"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/ethclient"
	"math/big"
	"testing"
)

func TestParseEvent(t *testing.T) {
	client, err := ethclient.Dial("https://rpc.hole.bitheart.org")
	if err != nil {
		t.Fatal(err)
	}
	receipt, err := client.TransactionReceipt(context.Background(), common.HexToHash("0xe697c2f7f8d2e6083c40730ded79a9a561aecb0d15f87781daa600c6ba4bb62a"))
	if err != nil {
		t.Fatal(err)
	}
	ct, err := bridge.NewBridgeContract(common.HexToAddress("0xceEC8799139C698De532e363DA7395E25F409775"), client)
	if err != nil {
		t.Fatal(err)
	}
	for _, lg := range receipt.Logs {
		if lg.Topics[0].Hex() == "0xe420cc80a898ce7e97248ec8a1dc0a25bbcd41c4ba0c64ce325140a2d8915313" {
			event, err := ct.ParseTransferInConfirmation(*lg)
			if err != nil {
				t.Fatal(err)
			} else {
				fmt.Println(event)
			}
		}
	}
}

func TestGetBlockTime(t *testing.T) {
	client, _ := ethclient.Dial("https://bsctest.bitheart.org")
	height := big.NewInt(65784850)
	block, err := client.HeaderByNumber(context.Background(), height)
	if err != nil {
		t.Fatal(err)
	}
	fmt.Println(block.Time)
}

func TestGetReceiveToken(t *testing.T) {
	client, _ := ethclient.Dial("http://rpc.hole.bitheart.org")
	ct, _ := bridge.NewBridgeContract(common.HexToAddress("0xceEC8799139C698De532e363DA7395E25F409775"), client)
	latest, _ := client.BlockNumber(context.Background())
	opt := &bind.CallOpts{
		Pending:     false,
		Context:     context.Background(),
		BlockNumber: big.NewInt(int64(latest)),
		From:        common.HexToAddress("0xfeed6dB33622Fb526a89c84A0861C29f483f1d0E"),
	}
	result, err := ct.OutConfiguration(opt, common.HexToAddress("0x9F225b7BCC4697414D4F6aC1CB985D07d34dAe0a"), big.NewInt(8891))
	if err != nil {
		t.Fatal(err)
	}
	fmt.Println(result)
}
