package server

import (
	"code.wuban.net.cn/movabridge/bridge-backend/constant"
	"github.com/ethereum/go-ethereum/common"
	log "github.com/sirupsen/logrus"
	"strings"

	"github.com/gin-gonic/gin"
)

func getParam(c *gin.Context) {
	if _querier == nil {
		log.Error("querier is nil")
		c.JSON(500, withError(constant.InternalError))
		return
	}
	config, err := _querier.GetBridgeConfig()
	if err != nil {
		log.Errorf("get bridge config error: %v", err)
		c.JSON(500, withError(constant.InternalError))
		return
	}
	c.JSON(200, withSuccess(config))
}

func getHistory(c *gin.Context) {
	address := c.DefaultQuery("address", "")
	if !common.IsHexAddress(address) {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}

	if _querier == nil {
		log.Error("querier is nil")
		c.JSON(500, withError(constant.InternalError))
		return
	}

	history, err := _querier.GetHistoryInfo(strings.ToLower(common.HexToAddress(address).Hex()))
	if err != nil {
		log.Errorf("get history error: %v", err)
		c.JSON(500, withError(constant.InternalError))
		return
	}
	c.JSON(200, withSuccess(history))
}
