package server

import (
	"code.wuban.net.cn/movabridge/bridge-backend/config"
	"code.wuban.net.cn/movabridge/bridge-backend/middleware"
	"github.com/gin-gonic/gin"
)

func initRouter(conf *config.Config, e *gin.Engine) {
	e.Use(middleware.PrintRequestResponseBodyMiddleware())
	e.Use(middleware.CheckHeaderMiddleware(conf.Server.InvalidHeaders))

	v1 := e.Group("/api/v1")
	{
		user := v1.Group("/user")
		user.GET("/history", getHistory)
	}
	v1.GET("/params", getParam)
}
