package server

import (
	"code.wuban.net.cn/movabridge/bridge-backend/config"
	apiModel "code.wuban.net.cn/movabridge/bridge-backend/model/api"
	"github.com/gin-contrib/cors"
	"github.com/gin-gonic/gin"
	log "github.com/sirupsen/logrus"
)

var (
	_querier apiModel.Querier
)

func StartRestApi(querier apiModel.Querier, _conf *config.Config) error {
	if !_conf.Debug {
		gin.SetMode(gin.ReleaseMode)
	}
	_querier = querier
	
	engine := gin.Default()

	_cors := cors.DefaultConfig()
	_cors.AllowAllOrigins = true
	_cors.AllowHeaders = []string{"*"}

	engine.Use(cors.New(_cors))

	initRouter(_conf, engine)
	log.Infof("start http server listening %s", _conf.Server.Listen)
	return engine.Run(_conf.Server.Listen)
}

func withSuccess(obj interface{}) interface{} {
	return gin.H{
		"code": 0,
		"msg":  "ok",
		"data": obj,
	}
}

func withError(msg string) interface{} {
	return gin.H{
		"code":  1,
		"error": msg,
		"data":  "",
	}
}
