require("@nomicfoundation/hardhat-toolbox");
require("@nomicfoundation/hardhat-ethers");
require("@openzeppelin/hardhat-upgrades");
require("dotenv").config()


// This is a sample Hardhat task. To learn how to create your own go to
// https://hardhat.org/guides/create-task.html
task("accounts", "List of accounts", async (taskArgs, hre) => {
  const accounts = await hre.ethers.getSigners()

  for (const account of accounts) {
	  // dump account address and balance.
	  const balance = await hre.ethers.provider.getBalance(account.address);
	  console.log(`Address: ${account.address}, Balance: ${hre.ethers.formatEther(balance)} ETH`);
  }
})

const privateKeys = [
	process.env.DEPLOY_PRIVATE_KEY
];

module.exports = {
	solidity: {
		evmVersion: "istanbul",
		compilers: [
			{
				version: "0.8.20",
				settings: {
					optimizer: {
						enabled: true,
						runs: 200,
					},
				},
			},
			{
				version: "0.8.10",
				settings: {
					optimizer: {
						enabled: true,
						runs: 200
					}
				}
			}
		]
	},
	etherscan: {
		apiKey: {
			'mars': 'empty',
			'mova': 'empty'
		},
		customChains: [
			{
				network: "mars",
				chainId: 10323,
				urls: {
					apiURL: "https://scan.mars.movachain.com/api",
					browserURL: "https://scan.mars.movachain.com"
				}
			},
			{
				network: "mova",
				chainId: 61900,
				urls: {
					apiURL: "https://scan.movachain.com/api",
					browserURL: "https://scan.movachain.com"
				}
			}
		]
	},
	networks: {
		hardhat: {
			accounts: [
				{ privateKey: privateKeys[0], balance: "10000000000000000000000" }
			]
		},
		mars: {
			url: "https://mars.rpc.movachain.com",
			accounts: privateKeys
		},
		mova: {
			url: "https://rpc.movachain.com",
			accounts: privateKeys
		},
		bsctest: {
			url: "https://bsc-testnet-dataseed.bnbchain.org",
			accounts: privateKeys
		},
		bsc: {
			url: "https://bsc-dataseed.bnbchain.org",
			accounts: privateKeys
		},
		hole: {
			url: "https://rpc.hole.bitheart.org",
			accounts: privateKeys
		}
	}
};
