const { expect } = require("chai");
const { ethers } = require("hardhat");

describe("TestAbi Contract", function () {
    let TestAbi, testAbi, owner;

    beforeEach(async function () {
        // Deploy the TestAbi contract
        [owner] = await ethers.getSigners();
        const TestAbiFactory = await ethers.getContractFactory("TestAbi");
        testAbi = await TestAbiFactory.deploy(owner.address);
        await testAbi.waitForDeployment();
    });

    it("should return the correct keccak256 hash for getSubmitData", async function () {
        // Define the input parameters for getSubmitData
        const params = {
            toChainID: 2,
            receiver: "0x000000000000000000000000000000000000dead",
            token: "0x000000000000000000000000000000000000beef",
            amount: ethers.parseEther("10"),
            outId: 1,
            fromChainID: 1,
            sender: "0x000000000000000000000000000000000000cafe",
            sendToken: "0x000000000000000000000000000000000000babe",
            sendAmount: ethers.parseEther("10"),
            signature: "0x000000000000000000000000000000000000babe000000000000000000000000",
        };

        // Compute the expected hash
        var data = ethers.AbiCoder.defaultAbiCoder().encode(
            [
                "uint256",
                "uint256",
                "address",
                "address",
                "uint256",
                "uint256",
                "address",
                "address",
            ],
            [
                params.outId,
                params.fromChainID,
                params.sender,
                params.sendToken,
                params.sendAmount,
                params.toChainID,
                params.receiver,
                params.token,
            ]
        );
        console.log("Encoded data:", data);
        const expectedHash = ethers.keccak256(data);

        // Call the getSubmitData function
        const result = await testAbi.getSubmitData(params);
        console.log("Computed hash:", result);
        console.log("Expected hash:", expectedHash);

        // Assert that the result matches the expected hash
        expect(result).to.equal(expectedHash);
    });
});