const fs = require("fs");
const path = require("path");
const hre = require("hardhat");
const {ethers} = require("hardhat");

const DEPLOY_FILE = path.join(__dirname, "deploy.json");

async function getDeploy(chainId) {
    if (!fs.existsSync(DEPLOY_FILE)) {
        throw new Error("deploy.json file not found");
    }

    const deployData = JSON.parse(fs.readFileSync(DEPLOY_FILE, "utf8"));
    if (!deployData[chainId]) {
        throw new Error(`No deployment data found for chainId ${chainId}`);
    }

    const addrs = deployData[chainId];
    const tokenA = await hre.ethers.getContractAt("TestToken", addrs.tokenA);
    const tokenB = await hre.ethers.getContractAt("TestToken", addrs.tokenB);
    const bridge = await hre.ethers.getContractAt("Bridge", addrs.bridge);

    return {tokenA, tokenB, bridge}
}

async function submitInTransfer(bridge) {
    // do approve
    var approve = await token.approve(await bridge.getAddress(), amount);
    await approve.wait();
    console.log("Approved token:", await token.getAddress(), "amount:", hre.ethers.formatEther(amount));

    const tx = await bridge.outTransfer(
        await token.getAddress(),
        amount,
        targetChainId,
        receiver
    );
    const receipt = await tx.wait();
    console.log("Bridged token:", await token.getAddress(), "to chain", targetChainId, "tx", receipt.transactionHash);
}

// Define the script
async function main() {
    let TEST_VALIDATOR_KEY = process.env.TEST_VALIDATOR_PRIVATE_KEY;
    if (!TEST_VALIDATOR_KEY) {
        throw new Error("TEST_VALIDATOR_PRIVATE_KEY environment variable is not set");
    }
    const wallet = new hre.ethers.Wallet(TEST_VALIDATOR_KEY, hre.ethers.provider);
    console.log("Using wallet address:", wallet.address);

    const chainId = await hre.ethers.provider.getNetwork().then(network => network.chainId);
    const targetChainId = chainId === 269n ? 10323 : 269;
    console.log("Current chain ID:", chainId, "Target chain ID:", targetChainId);

    const chainDeploy = await getDeploy(chainId);
    // 10323 0x3Ef35d7Db5F2d6A2fe7d16D4C8d4A20e9aD64A6A 0xF5c10392D841d55C41EBf696A4E437b2DC91f5D3
    // 99950000000000000000 1 269 0xfeed6dB33622Fb526a89c84A0861C29f483f1d0E 0xF5c10392D841d55C41EBf696A4E437b2DC91f5D3 100000000000000000000
    // [173 7 190 114 90 113 152 216 28 141 140 44 56 193 112 16 201 218 15 200 10 31 177 5 222 100 31 193 182 38 224 133]}"
    // sign=ad07be725a7198d81c8d8c2c38c17010c9da0fc80a1fb105de641fc1b626e085
    const params = {
        toChainID: 10323,
        receiver: "0x3Ef35d7Db5F2d6A2fe7d16D4C8d4A20e9aD64A6A",
        token: "0xF5c10392D841d55C41EBf696A4E437b2DC91f5D3",
        amount: ethers.parseEther("99.95"),
        outId: 1,
        fromChainID: 269,
        sender: "0xfeed6dB33622Fb526a89c84A0861C29f483f1d0E",
        sendToken: "0xF5c10392D841d55C41EBf696A4E437b2DC91f5D3",
        sendAmount: ethers.parseEther("100"),
        signature: "0xad07be725a7198d81c8d8c2c38c17010c9da0fc80a1fb105de641fc1b626e085",
    };
    const bridge = chainDeploy.bridge;
    var tx = await bridge.connect(wallet).submitInTransfer(params);
    await tx.wait();
    console.log("Submitted tx :", tx.hash);
}

// Run the script
main().catch((error) => {
    console.error("Error:", error);
});